/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.io.scriptio;

import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.io.rowio.RowOutputTextLog;
import com.streamscape.ds.io.scriptio.ScriptWriterBase;
import com.streamscape.ds.lib.FileAccess;
import com.streamscape.ds.persist.LogFileIndex;
import com.streamscape.ds.persist.LogRecordType;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.schema.sequence.NumberSequence;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.GZIPOutputStream;

public class ScriptWriterText
extends ScriptWriterBase {
    RowOutputTextLog rowOut;
    public static final String ISO_8859_1 = "ISO-8859-1";
    public static String LINE_SEP = System.getProperty("line.separator", "\n");
    public static byte[] BYTES_LINE_SEP;
    static byte[] BYTES_COMMIT;
    static byte[] BYTES_PREPARE_COMMIT;
    static byte[] BYTES_INSERT_INTO;
    static byte[] BYTES_VALUES;
    static byte[] BYTES_TERM;
    static byte[] BYTES_DELETE_FROM;
    static byte[] BYTES_WHERE;
    static byte[] BYTES_SEQUENCE;
    static byte[] BYTES_SEQUENCE_MID;
    static byte[] BYTES_C_ID_INIT;
    static byte[] BYTES_C_ID_TERM;
    static byte[] BYTES_DATASPACE;

    public ScriptWriterText(DataspaceStore db, OutputStream outputStream, FileAccess.FileSync descriptor, boolean includeCachedData) {
        super(db, outputStream, descriptor, includeCachedData);
    }

    public ScriptWriterText(DataspaceStore db, String file, boolean includeCachedData, boolean newFile, boolean isDump, boolean append) {
        super(db, file, includeCachedData, newFile, isDump, append);
    }

    public ScriptWriterText(DataspaceStore db, String file, boolean includeCachedData, boolean compressed, boolean append) {
        super(db, file, includeCachedData, true, false, append);
        if (compressed) {
            this.isCompressed = true;
            try {
                this.fileStreamOut = new GZIPOutputStream(this.fileStreamOut);
            }
            catch (IOException e) {
                throw Error.error(e, 452, 26, new Object[]{e.toString(), this.outFile});
            }
        }
    }

    @Override
    protected void initBuffers() {
        this.rowOut = new RowOutputTextLog();
    }

    @Override
    protected void writeDataTerm() throws IOException {
    }

    @Override
    public void writeSessionIdAndSchema(Session session) throws IOException {
        this.writeSessionIdAndSchema(session, session.currentDataspace);
    }

    @Override
    public void writeSessionIdAndSchema(Session session, NameManager.ObjectName schemaName) throws IOException {
        if (session == null) {
            return;
        }
        if (session != this.currentSession || schemaName != null && session.loggedSchema != schemaName && (schemaName.name.equals("SYS_LOBS") || schemaName.name.equals("SYS_FLOBS"))) {
            this.writeSessionIdWithoutChecks(session, schemaName);
            this.currentSession = session;
        }
        if (schemaName != session.loggedSchema) {
            this.rowOut.reset();
            this.writeSchemaStatement(schemaName);
            session.loggedSchema = schemaName;
            this.writeRowOutToFile();
        }
    }

    @Override
    public void writeSessionIdWithoutChecks(Session session, NameManager.ObjectName schemaName) throws IOException {
        if (session == null) {
            return;
        }
        this.rowOut.reset();
        this.rowOut.write(BYTES_C_ID_INIT);
        this.rowOut.writeLong(session.getId());
        this.rowOut.write(BYTES_C_ID_TERM);
        this.currentSession = session;
        this.writeRowOutToFileNoLineIncrement();
    }

    private void writeSchemaStatement(NameManager.ObjectName schema) {
        this.rowOut.write(BYTES_DATASPACE);
        this.rowOut.writeString(schema.statementName);
        this.rowOut.write(BYTES_LINE_SEP);
    }

    @Override
    public void writeLogStatement(Session session, String s) throws IOException {
        this.rowOut.reset();
        this.rowOut.writeString(s);
        this.rowOut.write(BYTES_LINE_SEP);
        this.writeRowOutToFile();
        this.needsSync = true;
    }

    @Override
    protected void writeRow(Session session, Row row, Table table) throws IOException {
        this.rowOut.reset();
        this.rowOut.setMode(0);
        this.rowOut.write(BYTES_INSERT_INTO);
        this.rowOut.writeString(table.getObjectName().statementName);
        this.rowOut.write(BYTES_VALUES);
        this.rowOut.writeData(row, table.getColumnTypes());
        this.rowOut.write(BYTES_TERM);
        this.rowOut.write(BYTES_LINE_SEP);
        this.writeRowOutToFile();
    }

    @Override
    protected void writeTableInit(Session session, Table t, LogFileIndex logIndex) throws IOException {
        if (t.isEmpty(this.currentSession)) {
            return;
        }
        if (this.schemaToLog == this.currentSession.loggedSchema) {
            return;
        }
        long pos = this.byteCount;
        this.rowOut.reset();
        this.writeSchemaStatement(t.getObjectName().schema);
        this.writeRowOutToFileNoLineIncrement();
        int size = (int)(this.byteCount - pos);
        if (this.forLog && logIndex != null) {
            logIndex.indexLogRecord(LogRecordType.SESSION, size, t.getObjectName().schema.getId(), -1, session);
        } else {
            this.database.dataspaceLogger.indexRecoveryLogRecord(session, t.getObjectName().schema, LogRecordType.SESSION, size);
        }
        this.currentSession.loggedSchema = this.schemaToLog;
    }

    @Override
    public void writeOtherStatement(Session session, String s) throws IOException {
        this.writeLogStatement(session, s);
        if (this.writeDelay == 0) {
            this.sync();
        }
    }

    @Override
    public void writeInsertStatement(Session session, Row row, Table table) throws IOException {
        this.writeRow(session, row, table);
    }

    @Override
    public void writeDeleteStatement(Session session, Table table, Object[] data) throws IOException {
        this.rowOut.reset();
        this.rowOut.setMode(1);
        this.rowOut.write(BYTES_DELETE_FROM);
        this.rowOut.writeString(table.getObjectName().statementName);
        this.rowOut.write(BYTES_WHERE);
        this.rowOut.writeData(table.getColumnCount(), table.getColumnTypes(), data, table.columnList, table.getPrimaryKey());
        this.rowOut.write(BYTES_LINE_SEP);
        this.writeRowOutToFile();
    }

    @Override
    public void writeSequenceStatement(Session session, NumberSequence seq) throws IOException {
        this.rowOut.reset();
        this.rowOut.write(BYTES_SEQUENCE);
        this.rowOut.writeString(seq.getSchemaName().statementName);
        this.rowOut.write(46);
        this.rowOut.writeString(seq.getObjectName().statementName);
        this.rowOut.write(BYTES_SEQUENCE_MID);
        this.rowOut.writeLong(seq.peek());
        this.rowOut.write(BYTES_LINE_SEP);
        this.writeRowOutToFile();
        this.needsSync = true;
    }

    @Override
    public void writeCommitStatement(Session session) throws IOException {
        this.rowOut.reset();
        this.rowOut.write(BYTES_COMMIT);
        this.rowOut.write(BYTES_LINE_SEP);
        this.writeRowOutToFile();
        this.needsSync = true;
        if (this.writeDelay == 0) {
            this.sync();
        }
    }

    @Override
    public void writePrepareCommitStatement(Session session) throws IOException {
        this.rowOut.reset();
        this.rowOut.write(BYTES_PREPARE_COMMIT);
        this.rowOut.write(BYTES_LINE_SEP);
        this.writeRowOutToFile();
        this.needsSync = true;
        if (this.writeDelay == 0) {
            this.sync();
        }
    }

    @Override
    protected void finishStream() throws IOException {
        this.fileStreamOutLock.lock();
        try {
            if (this.isCompressed) {
                this.checkNotClosed();
                ((GZIPOutputStream)this.fileStreamOut).finish();
            }
        }
        finally {
            this.fileStreamOutLock.unlock();
        }
    }

    void writeRowOutToFile() throws IOException {
        this.fileStreamOutLock.lock();
        try {
            this.checkNotClosed();
            this.fileStreamOut.write(this.rowOut.getBuffer(), 0, this.rowOut.size());
            this.byteCount += (long)this.rowOut.size();
            ++this.lineCount;
        }
        finally {
            this.fileStreamOutLock.unlock();
        }
    }

    void writeRowOutToFileNoLineIncrement() throws IOException {
        this.fileStreamOutLock.lock();
        try {
            this.checkNotClosed();
            this.fileStreamOut.write(this.rowOut.getBuffer(), 0, this.rowOut.size());
            this.byteCount += (long)this.rowOut.size();
        }
        finally {
            this.fileStreamOutLock.unlock();
        }
    }

    static {
        try {
            BYTES_LINE_SEP = LINE_SEP.getBytes();
            BYTES_COMMIT = "COMMIT".getBytes(ISO_8859_1);
            BYTES_PREPARE_COMMIT = "PREPARECOMMIT".getBytes(ISO_8859_1);
            BYTES_INSERT_INTO = "INSERT INTO ".getBytes(ISO_8859_1);
            BYTES_VALUES = " VALUES(".getBytes(ISO_8859_1);
            BYTES_TERM = ")".getBytes(ISO_8859_1);
            BYTES_DELETE_FROM = "DELETE FROM ".getBytes(ISO_8859_1);
            BYTES_WHERE = " WHERE ".getBytes(ISO_8859_1);
            BYTES_SEQUENCE = "ALTER SEQUENCE ".getBytes(ISO_8859_1);
            BYTES_SEQUENCE_MID = " RESTART WITH ".getBytes(ISO_8859_1);
            BYTES_C_ID_INIT = "/*C".getBytes(ISO_8859_1);
            BYTES_C_ID_TERM = "*/".getBytes(ISO_8859_1);
            BYTES_DATASPACE = "SET DATASPACE ".getBytes(ISO_8859_1);
        }
        catch (UnsupportedEncodingException e) {
            Error.runtimeError(201, "ScriptWriterText");
        }
    }
}

