/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.io.scriptio;

import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.io.scriptio.ScriptWriterText;
import com.streamscape.ds.lib.FileAccess;
import com.streamscape.ds.lib.FileUtil;
import com.streamscape.ds.lib.HsqlByteArrayOutputStream;
import com.streamscape.ds.persist.Crypto;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public class ScriptWriterEncode
extends ScriptWriterText {
    Crypto crypto;
    HsqlByteArrayOutputStream byteOut;
    OutputStream cryptOut;

    public ScriptWriterEncode(DataspaceStore db, OutputStream outputStream, FileAccess.FileSync descriptor, boolean includeCached, Crypto crypto, boolean append) {
        super(db, outputStream, descriptor, includeCached);
        try {
            this.cryptOut = crypto.getOutputStream(this.fileStreamOut);
            this.fileStreamOut = new GZIPOutputStream(this.cryptOut);
            this.isCrypt = true;
        }
        catch (IOException e) {
            throw Error.error(e, 452, 26, new Object[]{e.toString(), this.outFile});
        }
    }

    public ScriptWriterEncode(DataspaceStore db, String file, boolean includeCached, Crypto crypto) {
        super(db, file, includeCached, true, false);
        try {
            this.cryptOut = crypto.getOutputStream(this.fileStreamOut);
            this.fileStreamOut = new GZIPOutputStream(this.cryptOut);
            this.isCrypt = true;
        }
        catch (IOException e) {
            throw Error.error(e, 452, 26, new Object[]{e.toString(), this.outFile});
        }
    }

    public ScriptWriterEncode(DataspaceStore db, String file, Crypto crypto, boolean append) {
        super(db, file, false, false, false, append);
        this.crypto = crypto;
        this.byteOut = new HsqlByteArrayOutputStream();
        this.isCrypt = true;
    }

    protected void openFile() {
        try {
            FileUtil fa = this.isDump ? FileUtil.getFileUtil() : this.database.dataspaceLogger.getFileAccess();
            OutputStream fos = fa.openOutputStreamElement(this.outFile);
            this.outDescriptor = fa.getFileSync(fos);
            this.fileStreamOut = fos;
            this.fileStreamOut = new BufferedOutputStream(fos, 16384);
        }
        catch (IOException e) {
            throw Error.error(e, 452, 26, new Object[]{e.toString(), this.outFile});
        }
    }

    @Override
    protected void finishStream() throws IOException {
        this.fileStreamOutLock.lock();
        try {
            if (this.fileStreamOut instanceof GZIPOutputStream) {
                this.checkNotClosed();
                ((GZIPOutputStream)this.fileStreamOut).finish();
            }
        }
        finally {
            this.fileStreamOutLock.unlock();
        }
    }

    @Override
    void writeRowOutToFile() throws IOException {
        this.fileStreamOutLock.lock();
        try {
            this.checkNotClosed();
            if (this.byteOut == null) {
                this.fileStreamOut.write(this.rowOut.getBuffer(), 0, this.rowOut.size());
                this.byteCount += (long)this.rowOut.size();
                ++this.lineCount;
                return;
            }
            int count = this.crypto.getEncodedSize(this.rowOut.size());
            this.byteOut.ensureRoom(count + 4);
            count = this.crypto.encode(this.rowOut.getBuffer(), 0, this.rowOut.size(), this.byteOut.getBuffer(), 4);
            this.byteOut.setPosition(0);
            this.byteOut.writeInt(count);
            this.fileStreamOut.write(this.byteOut.getBuffer(), 0, count + 4);
            this.byteCount += (long)this.rowOut.size();
            ++this.lineCount;
        }
        finally {
            this.fileStreamOutLock.unlock();
        }
    }
}

