/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.io.scriptio;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.FileAccess;
import com.streamscape.ds.lib.FileUtil;
import com.streamscape.ds.lib.Iterator;
import com.streamscape.ds.navigator.RowIterator;
import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.persist.LogFileIndex;
import com.streamscape.ds.persist.LogRecordType;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.sequence.NumberSequence;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.locks.ReentrantLock;

public abstract class ScriptWriterBase
implements Runnable {
    DataspaceStore database;
    String outFile;
    OutputStream fileStreamOut;
    final ReentrantLock fileStreamOutLock = new ReentrantLock();
    FileAccess.FileSync outDescriptor;
    int tableRowCount;
    NameManager.ObjectName schemaToLog;
    boolean isClosed;
    boolean isCompressed;
    boolean isCrypt;
    boolean forLog;
    boolean isDump;
    boolean includeCachedData;
    long byteCount;
    long lineCount;
    volatile boolean needsSync;
    private int syncCount;
    static final int INSERT = 0;
    static final int INSERT_WITH_SCHEMA = 1;
    Session currentSession;
    public static final String[] LIST_SCRIPT_FORMATS = new String[]{"TEXT", "BINARY", null, "COMPRESSED"};
    protected volatile int writeDelay = 60000;

    ScriptWriterBase(DataspaceStore db, OutputStream outputStream, FileAccess.FileSync descriptor, boolean includeCachedData) {
        this.initBuffers();
        this.database = db;
        this.includeCachedData = includeCachedData;
        this.currentSession = this.database.collectionSessionManager.getSysSession();
        this.schemaToLog = this.currentSession.loggedSchema = this.currentSession.currentDataspace;
        this.fileStreamOut = new BufferedOutputStream(outputStream, 16384);
        this.outDescriptor = descriptor;
    }

    public long getByteCount() {
        return this.byteCount;
    }

    ScriptWriterBase(DataspaceStore db, String file, boolean includeCachedData, boolean isNewFile, boolean isDump, boolean isAppend) {
        this.initBuffers();
        boolean exists = false;
        exists = isDump ? FileUtil.getFileUtil().exists(file) : db.dataspaceLogger.getFileAccess().isStreamElement(file);
        if (exists && isNewFile) {
            throw Error.error(452, file);
        }
        this.database = db;
        this.isDump = isDump;
        this.includeCachedData = includeCachedData;
        this.outFile = file;
        this.currentSession = this.database.collectionSessionManager.getSysSession();
        this.schemaToLog = this.currentSession.loggedSchema = this.currentSession.currentDataspace;
        this.openFile(isAppend);
    }

    protected abstract void initBuffers();

    public void sync() {
        if (this.isClosed) {
            return;
        }
        if (this.needsSync) {
            this.forceSync();
        }
    }

    public void forceSync() {
        this.fileStreamOutLock.lock();
        try {
            if (this.isClosed) {
                return;
            }
            this.needsSync = false;
            this.fileStreamOut.flush();
            this.outDescriptor.sync();
            ++this.syncCount;
        }
        catch (IOException e) {
            Trace.logException(this, e, true);
            this.database.dataspaceLogger.logWarningEvent("ScriptWriter synch error: ", e);
        }
        finally {
            this.fileStreamOutLock.unlock();
        }
    }

    public void close() {
        this.fileStreamOutLock.lock();
        try {
            if (this.isClosed) {
                return;
            }
            this.finishStream();
            this.forceSync();
            this.isClosed = true;
            this.fileStreamOut.close();
            this.fileStreamOut = null;
            this.outDescriptor = null;
        }
        catch (IOException e) {
            Trace.logException(this, e, true);
            throw Error.error(452);
        }
        finally {
            this.fileStreamOutLock.unlock();
        }
        this.byteCount = 0L;
        this.lineCount = 0L;
    }

    public long size() {
        return this.byteCount;
    }

    public void writeAll(LogFileIndex logIndex) {
        try {
            this.writeDDL(logIndex);
            this.writeExistingData(logIndex);
        }
        catch (IOException e) {
            throw Error.error(452);
        }
    }

    protected void openFile(boolean isAppend) {
        try {
            FileUtil fa = this.isDump ? FileUtil.getFileUtil() : this.database.dataspaceLogger.getFileAccess();
            OutputStream fos = fa.openOutputStreamElement(this.outFile, isAppend);
            this.outDescriptor = fa.getFileSync(fos);
            this.fileStreamOut = fos;
            this.fileStreamOut = new BufferedOutputStream(fos, 16384);
        }
        catch (IOException e) {
            throw Error.error(e, 452, 26, new Object[]{e.toString(), this.outFile});
        }
    }

    protected void finishStream() throws IOException {
    }

    protected void writeDDL(LogFileIndex logIndex) throws IOException {
        Result ddlPart = this.database.getScript(!this.includeCachedData);
        this.writeSingleColumnResult(ddlPart, logIndex);
    }

    protected void writeExistingData(LogFileIndex logIndex) throws IOException {
        this.currentSession.loggedSchema = null;
        String[] schemas = this.database.schemaManager.getSchemaNamesArray();
        for (int i = 0; i < schemas.length; ++i) {
            String schema = schemas[i];
            Iterator tables = this.database.schemaManager.dataspaceObjectIterator(schema, 3);
            while (tables.hasNext()) {
                Table t = (Table)tables.next();
                boolean script = false;
                switch (t.getTableType()) {
                    case 4: {
                        break;
                    }
                    case 5: {
                        script = true;
                        break;
                    }
                    case 6: {
                        script = this.includeCachedData;
                        break;
                    }
                    case 8: {
                        script = this.includeCachedData && !t.isReadOnly();
                        break;
                    }
                }
                try {
                    if (!script) continue;
                    this.schemaToLog = t.getObjectName().schema;
                    this.writeTableInit(this.currentSession, t, logIndex);
                    RowIterator it = t.rowIteratorClustered(this.currentSession);
                    while (it.hasNext()) {
                        Row row = it.getNextRow();
                        long pos = this.byteCount;
                        this.writeRow(this.currentSession, row, t);
                        if (!this.database.generateLogIndex || logIndex == null) continue;
                        int size = (int)(this.byteCount - pos);
                        logIndex.indexLogRecord(LogRecordType.INSERT, size, t.getObjectName().schema.getId(), t.getObjectName().getId(), this.currentSession);
                    }
                    this.writeTableTerm(t);
                }
                catch (Exception e) {
                    throw Error.error(452, e.toString());
                }
            }
        }
        this.writeDataTerm();
    }

    protected void writeTableInit(Session session, Table t, LogFileIndex logIndex) throws IOException {
    }

    protected void writeTableTerm(Table t) throws IOException {
    }

    protected void writeSingleColumnResult(Result r, LogFileIndex logIndex) throws IOException {
        RowSetNavigator nav = r.initialiseNavigator();
        int counter = -1;
        while (nav.hasNext()) {
            ++counter;
            Object[] data = nav.getNext();
            long pos = this.byteCount;
            this.writeLogStatement(this.currentSession, (String)data[0]);
            int size = (int)(this.byteCount - pos);
            if (!this.database.generateLogIndex || logIndex == null) continue;
            DataspaceStore.DDLRecordNode node = this.database.logIndexBuilder.get(counter);
            if (node != null) {
                logIndex.indexLogRecord(node.type, size, node.dataspaceId, node.objectId, this.currentSession);
                continue;
            }
            logIndex.indexLogRecord(LogRecordType.OTHER, size, -1, -1, this.currentSession);
        }
    }

    abstract void writeRow(Session var1, Row var2, Table var3) throws IOException;

    protected abstract void writeDataTerm() throws IOException;

    public abstract void writeSessionIdAndSchema(Session var1) throws IOException;

    public abstract void writeSessionIdAndSchema(Session var1, NameManager.ObjectName var2) throws IOException;

    public abstract void writeSessionIdWithoutChecks(Session var1, NameManager.ObjectName var2) throws IOException;

    public abstract void writeLogStatement(Session var1, String var2) throws IOException;

    public abstract void writeOtherStatement(Session var1, String var2) throws IOException;

    public abstract void writeInsertStatement(Session var1, Row var2, Table var3) throws IOException;

    public abstract void writeDeleteStatement(Session var1, Table var2, Object[] var3) throws IOException;

    public abstract void writeSequenceStatement(Session var1, NumberSequence var2) throws IOException;

    public abstract void writeCommitStatement(Session var1) throws IOException;

    public abstract void writePrepareCommitStatement(Session var1) throws IOException;

    @Override
    public void run() {
    }

    public void setWriteDelay(int delay) {
        this.writeDelay = delay;
    }

    public int getWriteDelay() {
        return this.writeDelay;
    }

    public void setForLog() {
        this.forLog = true;
    }

    public boolean isForLog() {
        return this.forLog;
    }

    protected void checkNotClosed() throws IOException {
        if (this.isClosed) {
            throw new IOException("File stream is closed.");
        }
    }
}

