/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.io.scriptio;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.io.rowio.RowInputTextLog;
import com.streamscape.ds.io.scriptio.ScriptReaderBase;
import com.streamscape.ds.io.scriptio.ScriptWriterText;
import com.streamscape.ds.lib.LineReader;
import com.streamscape.ds.lib.StringConverter;
import com.streamscape.ds.lib.store.ValuePool;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.persist.LogRecord;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.Type;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class ScriptReaderText
extends ScriptReaderBase {
    LineReader dataStreamIn;
    InputStream inputStream;
    RowInputTextLog rowIn;
    boolean isInsert;
    byte[] buffer = new byte[1024];
    private long totalRead = 0L;
    private long totalRecordsRead = 0L;
    private boolean needToRemoveIndexIfLogFileIsGreater = false;

    public ScriptReaderText(DataspaceStore db) {
        super(db);
    }

    public ScriptReaderText(DataspaceStore db, String fileName, boolean compressed) throws IOException {
        super(db);
        this.inputStream = this.store.dataspaceLogger.getFileAccess().openInputStreamElement(fileName);
        this.inputStream = new BufferedInputStream(this.inputStream);
        if (compressed) {
            this.inputStream = new GZIPInputStream(this.inputStream);
        }
        this.dataStreamIn = new LineReader(this.inputStream, "ISO-8859-1");
        this.rowIn = new RowInputTextLog();
    }

    public ScriptReaderText(DataspaceStore db, InputStream inputStream) {
        super(db);
        this.dataStreamIn = new LineReader(inputStream, "ISO-8859-1");
        this.rowIn = new RowInputTextLog();
    }

    @Override
    protected void readDDL(Session session) {
        while (this.readLoggedStatement(session)) {
            Statement cs = null;
            Result result = null;
            if (this.rowIn.getStatementType() == 3) {
                this.isInsert = true;
                break;
            }
            try {
                cs = session.compileStatement(this.statement);
                this.store.setInitProperty("Statement Execution", this.statement);
                result = session.executeCompiledStatement(cs, ValuePool.emptyObjectArray);
            }
            catch (DataspaceException e) {
                result = Result.newErrorResult(e);
            }
            if (result.isError() && cs != null && (cs.getType() == 48 || cs.getType() == 14 && result.getMainString().contains("org.hsqldb.Library")) || !result.isError()) continue;
            this.store.dataspaceLogger.logWarningEvent(result.getMainString(), result.getException());
            if (cs != null && cs.getType() == 14) continue;
            this.handleError(session, Error.error(result.getException(), 461, 25, new Object[]{new Integer(this.lineCount), result.getMainString()}), this.statement, this.lineCount);
        }
    }

    @Override
    protected void readExistingData(Session session) {
        try {
            String tablename = null;
            this.store.setReferentialIntegrity(false);
            while (this.isInsert || this.readLoggedStatement(session)) {
                if (this.statementType == 6) {
                    NameManager.ObjectName name = session.dataspaceStore.schemaManager.findSchemaHsqlName(this.currentSchema);
                    if (name != null) {
                        session.setCurrentDataspaceName(name);
                    }
                } else if (this.statementType == 3) {
                    if (!this.rowIn.getTableName().equals(tablename)) {
                        tablename = this.rowIn.getTableName();
                        String schema = session.getSchemaName(this.currentSchema);
                        this.currentTable = this.store.schemaManager.getUserTable(session, tablename, schema);
                        this.currentStore = this.store.persistentStoreCollection.getStore(this.currentTable);
                    }
                    this.currentTable.insertFromScript(session, this.currentStore, this.rowData);
                } else {
                    this.handleError(session, Error.error(461, this.statement), this.statement, this.lineCount);
                }
                this.isInsert = false;
            }
            this.store.setReferentialIntegrity(true);
        }
        catch (Throwable t) {
            this.store.dataspaceLogger.logSevereEvent("readExistingData failed", t);
            this.errorHandler.handle(session, Error.error(t, 461, 25, new Object[]{new Integer(this.lineCount), t.toString()}), this.statement, this.lineCount);
        }
    }

    @Override
    public boolean readLoggedStatement(Session session) {
        if (!this.sessionChanged) {
            String s = null;
            boolean statementRead = false;
            while (!statementRead) {
                block21: {
                    this.record = null;
                    try {
                        block22: {
                            if (this.logRecordIterator == null) {
                                s = this.dataStreamIn.readLine();
                                if (s == null) {
                                    return false;
                                }
                                if (this.needToRemoveIndexIfLogFileIsGreater) {
                                    this.needToRemoveIndexIfLogFileIsGreater = false;
                                    Trace.logError(this, "It seems that index file is corrupted. Log file has more records that index file. Remove index file '" + this.index.getFileName() + "'.");
                                    this.index.close();
                                    this.index.openForWrite(false);
                                }
                                break block21;
                            }
                            this.record = null;
                            while (this.logRecordIterator.hasNext()) {
                                this.record = (LogRecord)this.logRecordIterator.next();
                                ++this.totalRecordsRead;
                                if (this.record.isValid()) {
                                    int actuallyRead;
                                    if (this.buffer.length < this.record.getSize()) {
                                        this.buffer = new byte[this.record.getSize()];
                                    }
                                    int currentlyRead = 0;
                                    for (actuallyRead = 0; actuallyRead < this.record.getSize(); actuallyRead += currentlyRead) {
                                        currentlyRead = this.inputStream.read(this.buffer, actuallyRead, this.record.getSize() - actuallyRead);
                                        if (currentlyRead > 0) {
                                            continue;
                                        }
                                        if (actuallyRead == 0) {
                                            int missingRecords = 1;
                                            long missingRecordsSize = this.record.getSize();
                                            while (this.logRecordIterator.hasNext()) {
                                                LogRecord record1 = (LogRecord)this.logRecordIterator.next();
                                                ++missingRecords;
                                                missingRecordsSize += (long)record1.getSize();
                                            }
                                            Trace.logError(this, "WARNING: It seems that index file is corrupted. {} indexed records of size {} are missing in log file of size {}.", missingRecords, missingRecordsSize, this.totalRead);
                                            if (this.totalRecordsRead > 0L) {
                                                --this.totalRecordsRead;
                                            }
                                            long indexFileSize = 1L + this.totalRecordsRead * 21L;
                                            Trace.logError(this, "WARNING: Trim log file to size {}", indexFileSize);
                                            this.index.trim(indexFileSize);
                                            break;
                                        }
                                        throw new DataspaceException("Unable to read recovery log record of size " + this.record.getSize() + ".");
                                    }
                                    if (actuallyRead != 0) {
                                        this.totalRead += (long)this.record.getSize();
                                        s = new String(this.buffer, 0, this.record.getSize(), "ISO-8859-1");
                                    }
                                    break block22;
                                }
                                long skipped = 0L;
                                long needToSkip = this.record.getSize();
                                while ((skipped = this.inputStream.skip(needToSkip)) > 0L) {
                                    needToSkip -= skipped;
                                }
                                if (needToSkip > 0L) {
                                    throw new EOFException();
                                }
                                ++this.lineCount;
                            }
                            this.logRecordIterator = null;
                            s = null;
                            this.record = null;
                            this.needToRemoveIndexIfLogFileIsGreater = true;
                        }
                        if (s == null) {
                            this.record = null;
                            if (this.logRecordIterator != null) break;
                            continue;
                        }
                        if (this.record != null && !this.record.getCommitted()) {
                            Trace.logError(this, "WARNING: Recovery log statement '" + s.trim() + "' is not committed or rolled back.");
                        }
                    }
                    catch (EOFException e) {
                        return false;
                    }
                    catch (IOException e) {
                        throw Error.error(e, 452, null);
                    }
                }
                ++this.lineCount;
                this.statement = s.trim();
                if (this.statement.length() <= 0) continue;
                statementRead = true;
            }
        }
        this.processStatement(session);
        return true;
    }

    void processStatement(Session session) {
        this.sessionChanged = false;
        try {
            if (this.statement.startsWith("/*C")) {
                int endid = this.statement.indexOf(42, 4);
                this.sessionNumber = Integer.parseInt(this.statement.substring(3, endid));
                this.statement = this.statement.substring(endid + 2);
                if (this.statement.length() > 0) {
                    this.sessionChanged = true;
                }
                this.statementType = 5;
                return;
            }
            int lineSepIndex = this.statement.indexOf(ScriptWriterText.LINE_SEP);
            if (lineSepIndex > -1) {
                this.sessionChanged = true;
                this.rowIn.setSource(StringConverter.unicodeStringToString(this.statement.substring(0, lineSepIndex)).trim());
                this.statement = StringConverter.unicodeStringToString(this.statement.substring(lineSepIndex + 1)).trim();
            } else {
                this.sessionChanged = false;
                this.statement = StringConverter.unicodeStringToString(this.statement).trim();
                this.rowIn.setSource(this.statement);
            }
            this.statementType = this.rowIn.getStatementType();
            if (this.statementType == 1) {
                this.rowData = null;
                this.currentTable = null;
                return;
            }
            if (this.statementType == 4) {
                this.rowData = null;
                this.currentTable = null;
                return;
            }
            if (this.statementType == 7) {
                this.rowData = null;
                this.currentTable = null;
                return;
            }
            if (this.statementType == 6) {
                this.rowData = null;
                this.currentTable = null;
                this.currentSchema = this.rowIn.getSchemaName();
                return;
            }
            String name = this.rowIn.getTableName();
            String schema = session.getCurrentDataspaceName().name;
            this.currentTable = this.store.schemaManager.getUserTable(session, name, schema);
            this.currentStore = this.store.persistentStoreCollection.getStore(this.currentTable);
            Type[] colTypes = this.statementType == 3 ? this.currentTable.getColumnTypes() : (this.currentTable.hasPrimaryKey() ? this.currentTable.getPrimaryKeyTypes() : this.currentTable.getColumnTypes());
            try {
                this.rowData = this.rowIn.readData(colTypes);
            }
            catch (IOException e) {
                throw Error.error(e, 452, null);
            }
            if (name.equals("FLOB_IDS")) {
                if (this.rowData.length > 6 && this.rowData[6] == null) {
                    this.rowData[6] = this.rowData[3] != null && (Boolean)this.rowData[3] == true ? Boolean.valueOf(false) : Boolean.valueOf(true);
                }
                if (this.rowData.length == 8 && this.rowData[7] == null) {
                    this.rowData[7] = true;
                }
            }
        }
        catch (Exception error) {
            this.sessionChanged = false;
            throw new DataspaceException(error);
        }
    }

    @Override
    public void close() {
        super.close();
        try {
            if (this.dataStreamIn != null) {
                this.dataStreamIn.close();
                this.dataStreamIn = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

