/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.io.scriptio;

import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.io.rowio.RowInputTextLog;
import com.streamscape.ds.io.scriptio.ScriptReaderText;
import com.streamscape.ds.lib.LineReader;
import com.streamscape.ds.persist.Crypto;
import com.streamscape.ds.session.Session;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.GZIPInputStream;

public class ScriptReaderDecode
extends ScriptReaderText {
    DataInputStream dataInput;
    Crypto crypto;
    byte[] buffer = new byte[256];

    public ScriptReaderDecode(DataspaceStore db, String fileName, Crypto crypto, boolean forLog) throws IOException {
        this(db, db.dataspaceLogger.getFileAccess().openInputStreamElement(fileName), crypto, forLog);
    }

    public ScriptReaderDecode(DataspaceStore db, InputStream inputStream, Crypto crypto, boolean forLog) throws IOException {
        super(db);
        this.crypto = crypto;
        this.rowIn = new RowInputTextLog();
        if (forLog) {
            this.dataInput = new DataInputStream(new BufferedInputStream(inputStream));
        } else {
            InputStream stream = crypto.getInputStream(new BufferedInputStream(inputStream));
            stream = new GZIPInputStream(stream);
            this.dataStreamIn = new LineReader(stream, "ISO-8859-1");
        }
    }

    @Override
    public boolean readLoggedStatement(Session session) {
        int count;
        if (this.dataInput == null) {
            return super.readLoggedStatement(session);
        }
        try {
            count = this.dataInput.readInt();
            if (count * 2 > this.buffer.length) {
                this.buffer = new byte[count * 2];
            }
            this.dataInput.readFully(this.buffer, 0, count);
        }
        catch (Throwable t) {
            return false;
        }
        count = this.crypto.decode(this.buffer, 0, count, this.buffer, 0);
        try {
            String s = new String(this.buffer, 0, count, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw Error.error(e, 452, null);
        }
        ++this.lineCount;
        if (this.statement == null) {
            return false;
        }
        this.processStatement(session);
        return true;
    }

    @Override
    public void close() {
        super.close();
        try {
            if (this.dataInput != null) {
                this.dataInput.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

