/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.io.scriptio;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.persist.LogFileIndex;
import com.streamscape.ds.persist.LogRecord;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.schema.sequence.NumberSequence;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Iterator;

public abstract class ScriptReaderBase {
    public static final int ANY_STATEMENT = 1;
    public static final int DELETE_STATEMENT = 2;
    public static final int INSERT_STATEMENT = 3;
    public static final int COMMIT_STATEMENT = 4;
    public static final int SESSION_ID = 5;
    public static final int SET_SCHEMA_STATEMENT = 6;
    public static final int PREPARE_COMMIT_STATEMENT = 7;
    DataspaceStore store;
    int lineCount;
    protected LogFileIndex index = null;
    protected Iterator<LogRecord> logRecordIterator;
    protected ScriptErrorHandler errorHandler = null;
    boolean forLog = false;
    int statementType;
    int sessionNumber;
    boolean sessionChanged;
    Object[] rowData;
    long sequenceValue;
    LogRecord record;
    String statement;
    Table currentTable;
    PersistentStore currentStore;
    NumberSequence currentSequence;
    String currentSchema;
    public static final String RECOVERY_ERRORS_FILE_FS = ",";
    static int recoveryErrorsSequenceId = 0;

    ScriptReaderBase(DataspaceStore db) {
        this.store = db;
        this.errorHandler = new ScriptErrorHandler();
    }

    public void readAll(Session session) {
        this.readDDL(session);
        this.readExistingData(session);
    }

    protected abstract void readDDL(Session var1);

    protected abstract void readExistingData(Session var1);

    public abstract boolean readLoggedStatement(Session var1);

    public void handleError(Session currentSession, DataspaceException error, String sql, int line) {
        if (this.errorHandler != null) {
            this.errorHandler.handle(currentSession, error, sql, line);
        }
    }

    public int getStatementType() {
        return this.statementType;
    }

    public int getSessionNumber() {
        return this.sessionNumber;
    }

    public Object[] getData() {
        return this.rowData;
    }

    public String getLoggedStatement() {
        return this.statement;
    }

    public NumberSequence getCurrentSequence() {
        return this.currentSequence;
    }

    public void resetSessionChanged() {
        this.sessionChanged = false;
    }

    public long getSequenceValue() {
        return this.sequenceValue;
    }

    public Table getCurrentTable() {
        return this.currentTable;
    }

    public String getCurrentSchema() {
        return this.currentSchema;
    }

    public int getLineNumber() {
        return this.lineCount;
    }

    public void setIndex(LogFileIndex index) {
        this.index = index;
        this.logRecordIterator = index.getIterator();
    }

    public void close() {
        if (this.errorHandler != null) {
            this.errorHandler.close();
            this.errorHandler = null;
        }
    }

    public void setForLog() {
        this.forLog = true;
    }

    public boolean isForLog() {
        return this.forLog;
    }

    public LogRecord getLogRecord() {
        return this.record;
    }

    class ScriptErrorHandler {
        OutputStream output = null;
        boolean ignoreErrors = false;

        ScriptErrorHandler() {
            this.ignoreErrors = !ScriptReaderBase.this.store.getURLProperties().isPropertyTrue("dtspace.exception_log_processing");
        }

        private void initialize() {
            try {
                String fileName = ScriptReaderBase.this.store.getPath() + ".err";
                File recoveryErrorsFile = new File(fileName);
                this.output = new FileOutputStream(recoveryErrorsFile, true);
            }
            catch (Exception error) {
                throw new DataspaceException("Unable to initialize log recovery mechanism. " + error.getMessage());
            }
        }

        public void handle(Session currentSession, DataspaceException error, String statement, int recordId) {
            if (!this.ignoreErrors) {
                throw error;
            }
            if (this.output == null) {
                this.initialize();
            }
            if (this.output != null) {
                try {
                    StringBuilder buffer = new StringBuilder();
                    buffer.append(++recoveryErrorsSequenceId);
                    buffer.append(ScriptReaderBase.RECOVERY_ERRORS_FILE_FS);
                    buffer.append(currentSession.getId());
                    buffer.append(ScriptReaderBase.RECOVERY_ERRORS_FILE_FS);
                    String dataspaceName = currentSession.getCurrentDataspaceName() != null ? currentSession.getCurrentDataspaceName().name : "MODULE";
                    buffer.append(dataspaceName);
                    buffer.append(ScriptReaderBase.RECOVERY_ERRORS_FILE_FS);
                    buffer.append(recordId);
                    buffer.append(ScriptReaderBase.RECOVERY_ERRORS_FILE_FS);
                    statement = statement.replaceAll("\"", "\"\"");
                    buffer.append('\"').append(statement).append('\"');
                    buffer.append(ScriptReaderBase.RECOVERY_ERRORS_FILE_FS);
                    buffer.append(ScriptReaderBase.this.forLog);
                    buffer.append('\n');
                    this.output.write(buffer.toString().getBytes());
                }
                catch (Exception ex) {
                    Trace.logError(this, "Unable to write failed sql into log. " + ex.getMessage());
                    Trace.logError(this, "LOG FILE SQL FAILED (line " + recordId + ") : " + statement);
                    Trace.logError(this, error.getMessage());
                }
            } else {
                Trace.logError(this, "Unable to write failed sql into log. " + error.getMessage());
                Trace.logError(this, "LOG FILE SQL FAILED (line " + recordId + ") : " + statement);
            }
        }

        public void close() {
            if (this.output != null) {
                try {
                    this.output.close();
                    this.output = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

