/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.io.rowio;

import com.streamscape.ds.error.Error;
import com.streamscape.ds.io.rowio.RowOutputBase;
import com.streamscape.ds.io.rowio.RowOutputInterface;
import com.streamscape.ds.lib.StringConverter;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.types.BinaryData;
import com.streamscape.ds.types.BlobData;
import com.streamscape.ds.types.ClobData;
import com.streamscape.ds.types.FlobData;
import com.streamscape.ds.types.IntervalMonthData;
import com.streamscape.ds.types.IntervalSecondData;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.TimeData;
import com.streamscape.ds.types.TimestampData;
import com.streamscape.ds.types.Type;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;

public class RowOutputTextLog
extends RowOutputBase {
    static byte[] BYTES_NULL;
    static byte[] BYTES_TRUE;
    static byte[] BYTES_FALSE;
    static byte[] BYTES_AND;
    static byte[] BYTES_IS;
    static byte[] BYTES_ARRAY;
    public static final int MODE_DELETE = 1;
    public static final int MODE_INSERT = 0;
    private boolean isWritten;
    private int logMode;
    private boolean noSeparators;

    public void setMode(int mode) {
        this.logMode = mode;
    }

    @Override
    protected void writeFieldPrefix() {
        if (!this.noSeparators && this.logMode == 1 && this.isWritten) {
            this.write(BYTES_AND);
        }
    }

    @Override
    protected void writeChar(String s, Type t) {
        this.write(39);
        StringConverter.stringToUnicodeBytes(this, s, true);
        this.write(39);
    }

    @Override
    protected void writeReal(Double o) {
        this.writeBytes(Type.SQL_DOUBLE.convertToSQLString(o));
    }

    @Override
    protected void writeSmallint(Number o) {
        this.writeBytes(o.toString());
    }

    @Override
    public void writeEnd() {
    }

    @Override
    protected void writeBit(BinaryData o) {
        this.ensureRoom((int)(o.length(null) * 8L + 2L));
        this.write(39);
        String s = StringConverter.byteArrayToBitString(o.getBytes(), (int)o.bitLength(null));
        this.writeBytes(s);
        this.write(39);
    }

    @Override
    protected void writeBinary(BinaryData o) {
        this.ensureRoom((int)(o.length(null) * 2L + 2L));
        this.write(39);
        StringConverter.writeHexBytes(this.getBuffer(), this.count, o.getBytes());
        this.count = (int)((long)this.count + o.length(null) * 2L);
        this.write(39);
    }

    @Override
    protected void writeClob(ClobData o, Type type) {
        this.writeBytes(Long.toString(o.getId()));
    }

    @Override
    protected void writeBlob(BlobData o, Type type) {
        this.writeBytes(Long.toString(o.getId()));
    }

    @Override
    protected void writeFlob(FlobData o, Type type) {
        this.writeBytes(Long.toString(o.getId()));
    }

    @Override
    protected void writeArray(Object[] o, Type type) {
        type = type.collectionBaseType();
        this.noSeparators = true;
        this.write(BYTES_ARRAY);
        for (int i = 0; i < o.length; ++i) {
            if (i > 0) {
                this.write(44);
            }
            this.writeData(type, o[i]);
        }
        this.write(93);
        this.noSeparators = false;
    }

    @Override
    public void writeType(int type) {
    }

    @Override
    public void writeSize(int size) {
    }

    @Override
    public int getSize(Row row) {
        return 0;
    }

    @Override
    public int getStorageSize(int size) {
        return size;
    }

    @Override
    protected void writeInteger(Number o) {
        this.writeBytes(o.toString());
    }

    @Override
    protected void writeBigint(Number o) {
        this.writeBytes(o.toString());
    }

    @Override
    protected void writeNull(Type type) {
        if (!this.noSeparators) {
            if (this.logMode == 1) {
                this.write(BYTES_IS);
            } else if (this.isWritten) {
                this.write(44);
            }
            this.isWritten = true;
        }
        this.write(BYTES_NULL);
    }

    @Override
    protected void writeOther(OtherTypeWrapper o) {
        byte[] bytes = o.getBytes();
        int length = bytes == null ? 0 : bytes.length;
        this.ensureRoom(length * 2 + 2);
        this.write(39);
        StringConverter.writeHexBytes(this.getBuffer(), this.count, bytes);
        this.count += length * 2;
        this.write(39);
    }

    @Override
    protected void writeFacets(OtherTypeWrapper o) {
        byte[] bytes = o.getBytes();
        int length = bytes == null ? 0 : bytes.length;
        this.ensureRoom(length * 2 + 2);
        this.write(39);
        StringConverter.writeHexBytes(this.getBuffer(), this.count, bytes);
        this.count += length * 2;
        this.write(39);
    }

    @Override
    protected void writeAspects(OtherTypeWrapper o) {
        byte[] bytes = o.getBytes();
        int length = bytes == null ? 0 : bytes.length;
        this.ensureRoom(length * 2 + 2);
        this.write(39);
        StringConverter.writeHexBytes(this.getBuffer(), this.count, bytes);
        this.count += length * 2;
        this.write(39);
    }

    @Override
    public void writeString(String value) {
        StringConverter.stringToUnicodeBytes(this, value, false);
    }

    @Override
    protected void writeBoolean(Boolean o) {
        this.write(o != false ? BYTES_TRUE : BYTES_FALSE);
    }

    @Override
    protected void writeDecimal(BigDecimal o, Type type) {
        this.writeBytes(type.convertToSQLString(o));
    }

    @Override
    protected void writeFieldType(Type type) {
        if (!this.noSeparators) {
            if (this.logMode == 1) {
                this.write(61);
            } else if (this.isWritten) {
                this.write(44);
            }
            this.isWritten = true;
        }
    }

    @Override
    public void writeLong(long value) {
        this.writeBytes(Long.toString(value));
    }

    @Override
    public void writeIntData(int i, int position) {
    }

    @Override
    protected void writeTime(TimeData o, Type type) {
        this.write(39);
        this.writeBytes(type.convertToString(o));
        this.write(39);
    }

    @Override
    protected void writeDate(TimestampData o, Type type) {
        this.write(39);
        this.writeBytes(type.convertToString(o));
        this.write(39);
    }

    @Override
    protected void writeTimestamp(TimestampData o, Type type) {
        this.write(39);
        this.writeBytes(type.convertToString(o));
        this.write(39);
    }

    @Override
    protected void writeYearMonthInterval(IntervalMonthData o, Type type) {
        this.write(39);
        this.writeBytes(type.convertToString(o));
        this.write(39);
    }

    @Override
    protected void writeDaySecondInterval(IntervalSecondData o, Type type) {
        this.write(39);
        this.writeBytes(type.convertToString(o));
        this.write(39);
    }

    @Override
    public void writeShort(int i) {
        this.writeBytes(Integer.toString(i));
    }

    @Override
    public void writeInt(int i) {
        this.writeBytes(Integer.toString(i));
    }

    @Override
    public void reset() {
        super.reset();
        this.isWritten = false;
    }

    @Override
    public RowOutputInterface duplicate() {
        throw Error.runtimeError(201, "RowOutputText");
    }

    static {
        try {
            BYTES_NULL = "NULL".getBytes("ISO-8859-1");
            BYTES_TRUE = "TRUE".getBytes("ISO-8859-1");
            BYTES_FALSE = "FALSE".getBytes("ISO-8859-1");
            BYTES_AND = " AND ".getBytes("ISO-8859-1");
            BYTES_IS = " IS ".getBytes("ISO-8859-1");
            BYTES_ARRAY = " ARRAY[".getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            Error.runtimeError(201, "RowOutputTextLog");
        }
    }
}

