/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.io.rowio;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.io.rowio.RowOutputBase;
import com.streamscape.ds.io.rowio.RowOutputInterface;
import com.streamscape.ds.persist.FileTableSettings;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.types.BinaryData;
import com.streamscape.ds.types.BlobData;
import com.streamscape.ds.types.ClobData;
import com.streamscape.ds.types.FlobData;
import com.streamscape.ds.types.IntervalMonthData;
import com.streamscape.ds.types.IntervalSecondData;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.TimeData;
import com.streamscape.ds.types.TimestampData;
import com.streamscape.ds.types.Type;
import com.streamscape.lib.file.FileDescriptorFactory;
import com.streamscape.lib.file.OneRecordWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;

public class RowOutputTextFileDescriptorTypesOnly
extends RowOutputBase {
    private OneRecordWriter oneRecordWriter;
    private String charset;
    private String linesDelimiter = FileTableSettings.NL;

    public RowOutputTextFileDescriptorTypesOnly(OneRecordWriter oneRecordWriter, String charset, String linesDelimiter) {
        this.oneRecordWriter = oneRecordWriter;
        this.charset = charset;
        if (linesDelimiter != null && linesDelimiter.length() > 0) {
            this.linesDelimiter = linesDelimiter;
        }
    }

    @Override
    public int getSize(Row row) {
        this.reset();
        try {
            this.writeSize(0);
            this.writeData(row, row.getTable().getColumnTypes());
            this.writeEnd();
        }
        catch (Exception exception) {
            this.reset();
            throw new DataspaceException(exception);
        }
        try {
            int n = this.size();
            return n;
        }
        finally {
            this.reset();
        }
    }

    @Override
    public void writeData(Row row, Type[] types) {
        try {
            if (types.length > 1) {
                this.writeString(this.oneRecordWriter.writeRecord((String)row.getData()[0], OtherTypeWrapper.unwrap(row.getData()[1])));
            } else {
                this.writeString(this.oneRecordWriter.writeRecord(null, OtherTypeWrapper.unwrap(row.getData()[0])));
            }
        }
        catch (FileDescriptorFactory.FileDescriptorProcessingException exception) {
            throw new DataspaceException(exception.getMessage());
        }
    }

    @Override
    public void writeString(String s) {
        if (s == null) {
            return;
        }
        byte[] bytes = this.getBytes(s);
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void writeEnd() {
        this.writeBytes(this.linesDelimiter);
    }

    private byte[] getBytes(String s) {
        byte[] bytes = null;
        try {
            bytes = s.getBytes(this.charset);
        }
        catch (UnsupportedEncodingException e) {
            bytes = s.getBytes();
        }
        return bytes;
    }

    @Override
    public int getStorageSize(int size) {
        return size;
    }

    @Override
    public RowOutputInterface duplicate() {
        throw Error.runtimeError(201, "RowOutputText");
    }

    @Override
    public void writeSize(int size) {
    }

    @Override
    public void writeType(int type) {
    }

    @Override
    public void writeIntData(int i, int position) {
    }

    @Override
    protected void writeFieldType(Type type) {
    }

    @Override
    protected void writeNull(Type type) {
    }

    @Override
    protected void writeChar(String s, Type t) {
    }

    @Override
    protected void writeSmallint(Number o) {
    }

    @Override
    protected void writeInteger(Number o) {
    }

    @Override
    protected void writeBigint(Number o) {
    }

    @Override
    protected void writeReal(Double o) {
    }

    @Override
    protected void writeDecimal(BigDecimal o, Type type) {
    }

    @Override
    protected void writeBoolean(Boolean o) {
    }

    @Override
    protected void writeDate(TimestampData o, Type type) {
    }

    @Override
    protected void writeTime(TimeData o, Type type) {
    }

    @Override
    protected void writeTimestamp(TimestampData o, Type type) {
    }

    @Override
    protected void writeYearMonthInterval(IntervalMonthData o, Type type) {
    }

    @Override
    protected void writeDaySecondInterval(IntervalSecondData o, Type type) {
    }

    @Override
    protected void writeOther(OtherTypeWrapper o) {
    }

    @Override
    protected void writeFacets(OtherTypeWrapper o) {
    }

    @Override
    protected void writeAspects(OtherTypeWrapper o) {
    }

    @Override
    protected void writeBit(BinaryData o) {
    }

    @Override
    protected void writeBinary(BinaryData o) {
    }

    @Override
    protected void writeClob(ClobData o, Type type) {
    }

    @Override
    protected void writeBlob(BlobData o, Type type) {
    }

    @Override
    protected void writeFlob(FlobData o, Type type) {
    }

    @Override
    protected void writeArray(Object[] o, Type type) {
    }
}

