/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.io.rowio;

import com.streamscape.ds.error.Error;
import com.streamscape.ds.io.rowio.RowOutputBase;
import com.streamscape.ds.io.rowio.RowOutputInterface;
import com.streamscape.ds.lib.StringConverter;
import com.streamscape.ds.persist.FileTableSettings;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.types.BinaryData;
import com.streamscape.ds.types.BlobData;
import com.streamscape.ds.types.ClobData;
import com.streamscape.ds.types.FlobData;
import com.streamscape.ds.types.IntervalMonthData;
import com.streamscape.ds.types.IntervalSecondData;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.TimeData;
import com.streamscape.ds.types.TimestampData;
import com.streamscape.ds.types.Type;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;

public class RowOutputText
extends RowOutputBase {
    protected String fieldSep;
    protected String varSep;
    protected String longvarSep;
    private boolean fieldSepEnd;
    private boolean varSepEnd;
    private boolean longvarSepEnd;
    private String nextSep = "";
    private boolean nextSepEnd;
    protected boolean allQuoted;
    private String encoding;

    public RowOutputText(String fieldSep, String varSep, String longvarSep, boolean allQuoted, String encoding) {
        this.initTextDatabaseRowOutput(fieldSep, varSep, longvarSep, allQuoted, encoding);
    }

    private void initTextDatabaseRowOutput(String fieldSep, String varSep, String longvarSep, boolean allQuoted, String encoding) {
        if (fieldSep.endsWith("\n")) {
            this.fieldSepEnd = true;
            fieldSep = fieldSep.substring(0, fieldSep.length() - 1);
        }
        if (varSep.endsWith("\n")) {
            this.varSepEnd = true;
            varSep = varSep.substring(0, varSep.length() - 1);
        }
        if (longvarSep.endsWith("\n")) {
            this.longvarSepEnd = true;
            longvarSep = longvarSep.substring(0, longvarSep.length() - 1);
        }
        this.fieldSep = fieldSep;
        this.varSep = varSep;
        this.longvarSep = longvarSep;
        this.allQuoted = allQuoted;
        this.encoding = encoding;
    }

    @Override
    public void writeEnd() {
        if (this.nextSepEnd) {
            this.writeBytes(this.nextSep);
        }
        this.writeBytes(FileTableSettings.NL);
    }

    @Override
    public void writeSize(int size) {
        this.nextSep = "";
        this.nextSepEnd = false;
    }

    @Override
    public void writeType(int type) {
    }

    @Override
    public void writeString(String s) {
        if ((s = this.checkConvertString(s, this.fieldSep)) == null) {
            return;
        }
        byte[] bytes = this.getBytes(s);
        this.write(bytes, 0, bytes.length);
        this.nextSep = this.fieldSep;
        this.nextSepEnd = this.fieldSepEnd;
    }

    protected void writeVarString(String s) {
        if ((s = this.checkConvertString(s, this.varSep)) == null) {
            return;
        }
        byte[] bytes = this.getBytes(s);
        this.write(bytes, 0, bytes.length);
        this.nextSep = this.varSep;
        this.nextSepEnd = this.varSepEnd;
    }

    protected void writeLongVarString(String s) {
        if ((s = this.checkConvertString(s, this.longvarSep)) == null) {
            return;
        }
        byte[] bytes = this.getBytes(s);
        this.write(bytes, 0, bytes.length);
        this.nextSep = this.longvarSep;
        this.nextSepEnd = this.longvarSepEnd;
    }

    protected String checkConvertString(String s, String sep) {
        if (s.indexOf(10) != -1 || s.indexOf(13) != -1) {
            throw new IllegalArgumentException(Error.getMessage(485));
        }
        if (s.indexOf(sep) != -1) {
            return null;
        }
        return s;
    }

    private byte[] getBytes(String s) {
        byte[] bytes = null;
        try {
            bytes = s.getBytes(this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            bytes = s.getBytes();
        }
        return bytes;
    }

    protected void writeByteArray(byte[] b) {
        this.ensureRoom(b.length * 2);
        StringConverter.writeHexBytes(this.getBuffer(), this.count, b);
        this.count += b.length * 2;
    }

    @Override
    public void writeShort(int i) {
        this.writeInt(i);
    }

    @Override
    public void writeInt(int i) {
        this.writeBytes(Integer.toString(i));
        this.nextSep = this.fieldSep;
        this.nextSepEnd = this.fieldSepEnd;
    }

    @Override
    public void writeIntData(int i, int position) {
        throw Error.runtimeError(201, "RowOutputText");
    }

    @Override
    public void writeLong(long i) {
        this.writeString(Long.valueOf(i).toString());
    }

    @Override
    protected void writeFieldType(Type type) {
        this.writeBytes(this.nextSep);
        switch (type.typeCode) {
            case 12: 
            case 100: {
                this.nextSep = this.varSep;
                this.nextSepEnd = this.varSepEnd;
                break;
            }
            default: {
                this.nextSep = this.fieldSep;
                this.nextSepEnd = this.fieldSepEnd;
            }
        }
    }

    @Override
    protected void writeNull(Type type) {
        this.writeFieldType(type);
    }

    @Override
    protected void writeChar(String s, Type t) {
        switch (t.typeCode) {
            case 1: {
                this.writeString(s);
                return;
            }
            case 12: 
            case 100: {
                this.writeVarString(s);
                return;
            }
        }
        this.writeLongVarString(s);
    }

    @Override
    protected void writeSmallint(Number o) {
        this.writeString(o.toString());
    }

    @Override
    protected void writeInteger(Number o) {
        this.writeString(o.toString());
    }

    @Override
    protected void writeBigint(Number o) {
        this.writeString(o.toString());
    }

    @Override
    protected void writeReal(Double o) {
        this.writeString(o.toString());
    }

    @Override
    protected void writeDecimal(BigDecimal o, Type type) {
        this.writeString(type.convertToString(o));
    }

    @Override
    protected void writeBoolean(Boolean o) {
        this.writeString(o.toString());
    }

    @Override
    protected void writeDate(TimestampData o, Type type) {
        this.writeString(type.convertToString(o));
    }

    @Override
    protected void writeTime(TimeData o, Type type) {
        this.writeString(type.convertToString(o));
    }

    @Override
    protected void writeTimestamp(TimestampData o, Type type) {
        this.writeString(type.convertToString(o));
    }

    @Override
    protected void writeYearMonthInterval(IntervalMonthData o, Type type) {
        this.writeBytes(type.convertToString(o));
    }

    @Override
    protected void writeDaySecondInterval(IntervalSecondData o, Type type) {
        this.writeBytes(type.convertToString(o));
    }

    @Override
    protected void writeOther(OtherTypeWrapper o) {
        this.writeByteArray(o.getBytes());
    }

    @Override
    protected void writeFacets(OtherTypeWrapper o) {
        this.writeByteArray(o.getBytes());
    }

    @Override
    protected void writeAspects(OtherTypeWrapper o) {
        this.writeByteArray(o.getBytes());
    }

    @Override
    protected void writeBit(BinaryData o) {
        String s = StringConverter.byteArrayToBitString(o.getBytes(), (int)o.bitLength(null));
        this.writeString(s);
    }

    @Override
    protected void writeBinary(BinaryData o) {
        this.writeByteArray(o.getBytes());
    }

    @Override
    protected void writeClob(ClobData o, Type type) {
        this.writeString(Long.toString(o.getId()));
    }

    @Override
    protected void writeBlob(BlobData o, Type type) {
        this.writeString(Long.toString(o.getId()));
    }

    @Override
    protected void writeFlob(FlobData o, Type type) {
        this.writeString(Long.toString(o.getId()));
    }

    @Override
    protected void writeArray(Object[] o, Type type) {
        throw Error.runtimeError(201, "RowOutputText");
    }

    @Override
    public int getSize(Row row) {
        this.reset();
        try {
            this.writeSize(0);
            this.writeData(row, row.getTable().getColumnTypes());
            this.writeEnd();
        }
        catch (Exception e) {
            this.reset();
        }
        int rowsize = this.size();
        this.reset();
        return rowsize;
    }

    @Override
    public int getStorageSize(int size) {
        return size;
    }

    @Override
    public RowOutputInterface duplicate() {
        throw Error.runtimeError(201, "RowOutputText");
    }
}

