/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.io.rowio;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.io.rowio.RowInputBase;
import com.streamscape.ds.io.rowio.RowInputInterface;
import com.streamscape.ds.lib.HsqlArrayList;
import com.streamscape.ds.lib.store.ValuePool;
import com.streamscape.ds.parser.Scanner;
import com.streamscape.ds.types.BinaryData;
import com.streamscape.ds.types.BlobData;
import com.streamscape.ds.types.BlobDataID;
import com.streamscape.ds.types.ClobData;
import com.streamscape.ds.types.ClobDataID;
import com.streamscape.ds.types.FlobData;
import com.streamscape.ds.types.FlobDataID;
import com.streamscape.ds.types.IntervalMonthData;
import com.streamscape.ds.types.IntervalSecondData;
import com.streamscape.ds.types.IntervalType;
import com.streamscape.ds.types.NumberType;
import com.streamscape.ds.types.OtherTypeBytesWrapper;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.TimeData;
import com.streamscape.ds.types.TimestampData;
import com.streamscape.ds.types.Type;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class RowInputTextLog
extends RowInputBase
implements RowInputInterface {
    Scanner scanner = new Scanner(true);
    String tableName = null;
    String schemaName = null;
    int statementType;
    Object value;
    boolean noSeparators;

    public RowInputTextLog() {
        super(new byte[0]);
    }

    public void setSource(String text) {
        this.scanner.reset(text);
        this.statementType = 1;
        this.scanner.scanNext();
        String s = this.scanner.getString();
        if (s.equals("INSERT")) {
            this.statementType = 3;
            this.scanner.scanNext();
            this.scanner.scanNext();
            this.tableName = this.scanner.getString();
            this.scanner.scanNext();
        } else if (s.equals("DELETE")) {
            this.statementType = 2;
            this.scanner.scanNext();
            this.scanner.scanNext();
            this.tableName = this.scanner.getString();
        } else if (s.equals("COMMIT")) {
            this.statementType = 4;
        } else if (s.equals("PREPARECOMMIT")) {
            this.statementType = 7;
        } else if (s.equals("SET")) {
            this.scanner.scanNext();
            if ("DATASPACE".equals(this.scanner.getString()) || "SCHEMA".equals(this.scanner.getString())) {
                this.scanner.scanNext();
                this.schemaName = this.scanner.getString();
                this.statementType = 6;
            }
        }
    }

    public int getStatementType() {
        return this.statementType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    protected void readField() {
        this.readFieldPrefix();
        this.scanner.scanNext();
        this.value = this.scanner.getValue();
    }

    protected void readNumberField(Type type) {
        boolean minus;
        this.readFieldPrefix();
        this.scanner.scanNext();
        boolean bl = minus = this.scanner.getTokenType() == 784;
        if (minus) {
            this.scanner.scanNext();
        }
        this.value = this.scanner.getValue();
        if (minus) {
            try {
                this.value = ((NumberType)this.scanner.getDataType()).negate(this.value);
            }
            catch (DataspaceException dataspaceException) {
                // empty catch block
            }
        }
    }

    protected void readFieldPrefix() {
        if (!this.noSeparators) {
            this.scanner.scanNext();
            if (this.statementType == 2) {
                this.scanner.scanNext();
                this.scanner.scanNext();
            }
        }
    }

    @Override
    public String readString() throws IOException {
        this.readField();
        return (String)this.value;
    }

    @Override
    public short readShort() throws IOException {
        throw Error.runtimeError(201, "");
    }

    @Override
    public int readInt() throws IOException {
        throw Error.runtimeError(201, "");
    }

    @Override
    public long readLong() throws IOException {
        this.readNumberField(Type.LONG);
        if (this.value == null) {
            return 0L;
        }
        if (this.value instanceof Number) {
            return ((Number)this.value).longValue();
        }
        throw Error.error(5585);
    }

    @Override
    public int readType() throws IOException {
        return 0;
    }

    @Override
    protected boolean readNull() {
        return false;
    }

    @Override
    protected String readChar(Type type) throws IOException {
        this.readField();
        return (String)this.value;
    }

    @Override
    protected Integer readSmallint() throws IOException {
        this.readNumberField(Type.SQL_SMALLINT);
        return (Integer)this.value;
    }

    @Override
    protected Integer readInteger() throws IOException {
        this.readNumberField(Type.SQL_INTEGER);
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof Long) {
            this.value = Type.SQL_INTEGER.convertToDefaultType(null, this.value);
        }
        return (Integer)this.value;
    }

    @Override
    protected Long readLongO() throws IOException {
        this.readNumberField(Type.LONG);
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof Number) {
            return ((Number)this.value).longValue();
        }
        throw Error.error(5585);
    }

    @Override
    protected BigInteger readBigint() throws IOException {
        this.readNumberField(Type.SQL_BIGINT);
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof BigDecimal) {
            return (BigInteger)Type.SQL_BIGINT.convertToDefaultType(null, this.value);
        }
        return ValuePool.getBigInteger(new BigInteger(((Number)this.value).toString()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Double readReal() throws IOException {
        this.readNumberField(Type.SQL_DOUBLE);
        if (this.value == null) {
            return null;
        }
        if (!this.scanner.scanSpecialIdentifier("/")) return (Double)this.value;
        this.scanner.scanNext();
        Object divisor = this.scanner.getValue();
        double i = ((Number)divisor).doubleValue();
        if (i != 0.0) throw Error.error(5584);
        if (((Number)this.value).doubleValue() == 1.0) {
            i = Double.NEGATIVE_INFINITY;
        } else if (((Number)this.value).doubleValue() == -1.0) {
            i = Double.POSITIVE_INFINITY;
        } else {
            if (((Number)this.value).doubleValue() != 0.0) throw Error.error(5584);
            i = Double.NaN;
        }
        this.value = i;
        return (Double)this.value;
    }

    @Override
    protected BigDecimal readDecimal(Type type) throws IOException {
        this.readNumberField(type);
        if (this.value == null) {
            return null;
        }
        BigDecimal bd = (BigDecimal)type.convertToDefaultType(null, this.value);
        return (BigDecimal)type.convertToTypeLimits(null, bd);
    }

    @Override
    protected TimeData readTime(Type type) throws IOException {
        this.readField();
        if (this.value == null) {
            return null;
        }
        return this.scanner.newTime((String)this.value);
    }

    @Override
    protected TimestampData readDate(Type type) throws IOException {
        this.readField();
        if (this.value == null) {
            return null;
        }
        return this.scanner.newDate((String)this.value);
    }

    @Override
    protected TimestampData readTimestamp(Type type) throws IOException {
        this.readField();
        if (this.value == null) {
            return null;
        }
        return this.scanner.newTimestamp((String)this.value);
    }

    @Override
    protected IntervalMonthData readYearMonthInterval(Type type) throws IOException {
        this.readField();
        if (this.value == null) {
            return null;
        }
        return (IntervalMonthData)this.scanner.newInterval((String)this.value, (IntervalType)type);
    }

    @Override
    protected IntervalSecondData readDaySecondInterval(Type type) throws IOException {
        this.readField();
        if (this.value == null) {
            return null;
        }
        return (IntervalSecondData)this.scanner.newInterval((String)this.value, (IntervalType)type);
    }

    @Override
    protected Boolean readBoole() throws IOException {
        this.readFieldPrefix();
        this.scanner.scanNext();
        String token = this.scanner.getString();
        this.value = null;
        if (token.equalsIgnoreCase("TRUE")) {
            this.value = Boolean.TRUE;
        } else if (token.equalsIgnoreCase("FALSE")) {
            this.value = Boolean.FALSE;
        }
        return (Boolean)this.value;
    }

    @Override
    protected Object readOther() throws IOException {
        this.readFieldPrefix();
        if (this.scanner.scanNull()) {
            return null;
        }
        this.scanner.scanBinaryStringWithQuote();
        if (this.scanner.getTokenType() == 856) {
            throw Error.error(5587);
        }
        this.value = this.scanner.getValue();
        if (this.isTypesCheck) {
            return new OtherTypeBytesWrapper(((BinaryData)this.value).getBytes());
        }
        return new OtherTypeWrapper(((BinaryData)this.value).getBytes(), false);
    }

    @Override
    protected Object readFacets() throws IOException {
        this.readFieldPrefix();
        if (this.scanner.scanNull()) {
            return null;
        }
        this.scanner.scanBinaryStringWithQuote();
        if (this.scanner.getTokenType() == 856) {
            throw Error.error(5587);
        }
        this.value = this.scanner.getValue();
        if (this.isTypesCheck) {
            return new OtherTypeBytesWrapper(((BinaryData)this.value).getBytes());
        }
        return new OtherTypeWrapper(((BinaryData)this.value).getBytes(), false);
    }

    @Override
    protected Object readAspects() throws IOException {
        this.readFieldPrefix();
        if (this.scanner.scanNull()) {
            return null;
        }
        this.scanner.scanBinaryStringWithQuote();
        if (this.scanner.getTokenType() == 856) {
            throw Error.error(5587);
        }
        this.value = this.scanner.getValue();
        if (this.isTypesCheck) {
            return new OtherTypeBytesWrapper(((BinaryData)this.value).getBytes());
        }
        return new OtherTypeWrapper(((BinaryData)this.value).getBytes(), false);
    }

    @Override
    protected BinaryData readBit() throws IOException {
        this.readFieldPrefix();
        if (this.scanner.scanNull()) {
            return null;
        }
        this.scanner.scanBitStringWithQuote();
        if (this.scanner.getTokenType() == 855) {
            throw Error.error(5587);
        }
        this.value = this.scanner.getValue();
        return (BinaryData)this.value;
    }

    @Override
    protected BinaryData readBinary() throws IOException {
        this.readFieldPrefix();
        if (this.scanner.scanNull()) {
            return null;
        }
        this.scanner.scanBinaryStringWithQuote();
        if (this.scanner.getTokenType() == 856) {
            throw Error.error(5587);
        }
        this.value = this.scanner.getValue();
        return (BinaryData)this.value;
    }

    @Override
    protected ClobData readClob() throws IOException {
        this.readNumberField(Type.SQL_BIGINT);
        if (this.value == null) {
            return null;
        }
        long id = ((Number)this.value).longValue();
        return new ClobDataID(id);
    }

    @Override
    protected BlobData readBlob() throws IOException {
        this.readNumberField(Type.SQL_BIGINT);
        if (this.value == null) {
            return null;
        }
        long id = ((Number)this.value).longValue();
        return new BlobDataID(id);
    }

    @Override
    protected FlobData readFlob(Type type) throws IOException {
        this.readNumberField(Type.SQL_BIGINT);
        if (this.value == null) {
            return null;
        }
        long id = ((Number)this.value).longValue();
        return new FlobDataID(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object[] readArray(Type type) throws IOException {
        type = type.collectionBaseType();
        this.readFieldPrefix();
        this.scanner.scanNext();
        String token = this.scanner.getString();
        this.value = null;
        if (token.equalsIgnoreCase("NULL")) {
            return null;
        }
        if (!token.equalsIgnoreCase("ARRAY")) {
            throw Error.error(5584);
        }
        try {
            this.scanner.mightExpectBracket = true;
            this.scanner.scanNext();
        }
        finally {
            this.scanner.mightExpectBracket = false;
        }
        token = this.scanner.getString();
        if (!token.equalsIgnoreCase("[")) {
            throw Error.error(5584);
        }
        HsqlArrayList list = new HsqlArrayList();
        this.noSeparators = true;
        int i = 0;
        while (true) {
            try {
                this.scanner.mightExpectBracket = true;
                if (this.scanner.scanSpecialIdentifier("]")) {
                    break;
                }
            }
            finally {
                this.scanner.mightExpectBracket = false;
            }
            if (i > 0 && !this.scanner.scanSpecialIdentifier(",")) {
                throw Error.error(5584);
            }
            Object value = this.readData(type);
            list.add(value);
            ++i;
        }
        this.noSeparators = false;
        Object[] data = new Object[list.size()];
        list.toArray(data);
        return data;
    }
}

