/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.io.rowio;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.io.rowio.AbstractRowInputText;
import com.streamscape.ds.persist.FileTableSettings;
import com.streamscape.ds.types.BinaryData;
import com.streamscape.ds.types.BlobData;
import com.streamscape.ds.types.ClobData;
import com.streamscape.ds.types.FlobData;
import com.streamscape.ds.types.IntervalMonthData;
import com.streamscape.ds.types.IntervalSecondData;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.TimeData;
import com.streamscape.ds.types.TimestampData;
import com.streamscape.ds.types.Type;
import com.streamscape.lib.file.AbstractRecordTypeDefinition;
import com.streamscape.lib.file.FileDescriptorFactory;
import com.streamscape.lib.file.OneRecordReader;
import com.streamscape.lib.file.RecordTypeDefinition;
import com.streamscape.lib.file.UntypedRecordTypeDefinition;
import com.streamscape.lib.utils.Pair;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class RowInputTextFileDescriptorTypesOnly
extends AbstractRowInputText {
    private FileDescriptorFactory fileDescriptorFactory;
    private OneRecordReader oneRecordReader;
    private FileTableSettings settings;
    private AbstractRecordTypeDefinition lastRecordTypeDefinition;

    public RowInputTextFileDescriptorTypesOnly(FileDescriptorFactory fileDescriptorFactory, FileTableSettings settings) {
        this.fileDescriptorFactory = fileDescriptorFactory;
        this.oneRecordReader = fileDescriptorFactory.createOneRecordReader();
        this.settings = settings;
        if (fileDescriptorFactory.getFileDescriptor().getRecords().stream().filter(r -> r instanceof UntypedRecordTypeDefinition).count() > 0L) {
            throw new DataspaceException("Types only file table can be created for typed record only.");
        }
    }

    @Override
    public void setSource(String text, int pos, int byteSize) {
        super.setSource(text, pos, byteSize);
        this.lastRecordTypeDefinition = null;
    }

    @Override
    public boolean accepts(String recordLine) {
        try {
            if (this.fileDescriptorFactory.getObservableRecordTypes().size() == 0) {
                return true;
            }
            if (this.fileDescriptorFactory.getFileDescriptor().hasKey()) {
                String key = this.oneRecordReader.readKey(recordLine);
                return key != null && this.fileDescriptorFactory.getObservableRecordTypes().contains(key);
            }
            return true;
        }
        catch (FileDescriptorFactory.FileDescriptorProcessingException exception) {
            return true;
        }
    }

    public RecordTypeDefinition getLastRecordTypeDefinition() {
        return (RecordTypeDefinition)this.lastRecordTypeDefinition;
    }

    @Override
    protected Object readOther() throws IOException {
        try {
            Pair<Object, AbstractRecordTypeDefinition> pair = this.oneRecordReader.readRecord(this.text);
            this.lastRecordTypeDefinition = (AbstractRecordTypeDefinition)pair.second;
            return new OtherTypeWrapper(pair.first);
        }
        catch (FileDescriptorFactory.FileDescriptorProcessingException exception) {
            if (exception.getAction() != FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.SKIPPED || !this.settings.ignoreUnknownRecords) {
                throw new DataspaceException(exception.getMessage());
            }
            Trace.logDebug(this, exception.getMessage());
            return null;
        }
    }

    @Override
    protected Object readFacets() throws IOException {
        try {
            Pair<Object, AbstractRecordTypeDefinition> pair = this.oneRecordReader.readRecord(this.text);
            this.lastRecordTypeDefinition = (AbstractRecordTypeDefinition)pair.second;
            return new OtherTypeWrapper(pair.first);
        }
        catch (FileDescriptorFactory.FileDescriptorProcessingException exception) {
            if (exception.getAction() != FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.SKIPPED || !this.settings.ignoreUnknownRecords) {
                throw new DataspaceException(exception.getMessage());
            }
            Trace.logDebug(this, exception.getMessage());
            return null;
        }
    }

    @Override
    protected Object readAspects() throws IOException {
        try {
            Pair<Object, AbstractRecordTypeDefinition> pair = this.oneRecordReader.readRecord(this.text);
            this.lastRecordTypeDefinition = (AbstractRecordTypeDefinition)pair.second;
            return new OtherTypeWrapper(pair.first);
        }
        catch (FileDescriptorFactory.FileDescriptorProcessingException exception) {
            if (exception.getAction() != FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.SKIPPED || !this.settings.ignoreUnknownRecords) {
                throw new DataspaceException(exception.getMessage());
            }
            Trace.logDebug(this, exception.getMessage());
            return null;
        }
    }

    @Override
    public String readString() throws IOException {
        try {
            return this.oneRecordReader.readKey(this.text);
        }
        catch (FileDescriptorFactory.FileDescriptorProcessingException exception) {
            throw new DataspaceException(exception.getMessage());
        }
    }

    @Override
    protected String readChar(Type type) throws IOException {
        switch (type.typeCode) {
            default: 
        }
        return this.readString();
    }

    @Override
    public int readType() throws IOException {
        return 0;
    }

    @Override
    protected boolean readNull() throws IOException {
        return false;
    }

    @Override
    protected Integer readSmallint() throws IOException {
        return null;
    }

    @Override
    protected Integer readInteger() throws IOException {
        return null;
    }

    @Override
    protected Long readLongO() throws IOException {
        return null;
    }

    @Override
    protected BigInteger readBigint() throws IOException {
        return null;
    }

    @Override
    protected Double readReal() throws IOException {
        return null;
    }

    @Override
    protected BigDecimal readDecimal(Type type) throws IOException {
        return null;
    }

    @Override
    protected Boolean readBoole() throws IOException {
        return null;
    }

    @Override
    protected TimeData readTime(Type type) throws IOException {
        return null;
    }

    @Override
    protected TimestampData readDate(Type type) throws IOException {
        return null;
    }

    @Override
    protected TimestampData readTimestamp(Type type) throws IOException {
        return null;
    }

    @Override
    protected IntervalMonthData readYearMonthInterval(Type type) throws IOException {
        return null;
    }

    @Override
    protected IntervalSecondData readDaySecondInterval(Type type) throws IOException {
        return null;
    }

    @Override
    protected BinaryData readBinary() throws IOException, DataspaceException {
        return null;
    }

    @Override
    protected BinaryData readBit() throws IOException {
        return null;
    }

    @Override
    protected ClobData readClob() throws IOException {
        return null;
    }

    @Override
    protected BlobData readBlob() throws IOException {
        return null;
    }

    @Override
    protected FlobData readFlob(Type type) throws IOException {
        return null;
    }

    @Override
    protected Object[] readArray(Type type) throws IOException {
        return null;
    }
}

