/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.io.rowio;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.io.rowio.AbstractRowInputText;
import com.streamscape.ds.lib.DataspaceDateTime;
import com.streamscape.ds.parser.Scanner;
import com.streamscape.ds.persist.FileTableSettings;
import com.streamscape.ds.types.BinaryData;
import com.streamscape.ds.types.BlobData;
import com.streamscape.ds.types.ClobData;
import com.streamscape.ds.types.FlobData;
import com.streamscape.ds.types.IntervalMonthData;
import com.streamscape.ds.types.IntervalSecondData;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.TimeData;
import com.streamscape.ds.types.TimestampData;
import com.streamscape.ds.types.Type;
import com.streamscape.lib.file.AbstractRecordTypeDefinition;
import com.streamscape.lib.file.FileDescriptorFactory;
import com.streamscape.lib.file.OneRecordReader;
import com.streamscape.lib.file.RecordField;
import com.streamscape.lib.file.RecordTypeDefinition;
import com.streamscape.lib.file.UntypedRecordTypeDefinition;
import com.streamscape.sdo.sdrpath.ReferencePathException;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;

public class RowInputTextFileDescriptor
extends AbstractRowInputText {
    private FileDescriptorFactory fileDescriptorFactory;
    private OneRecordReader oneRecordReader;
    private AbstractRecordTypeDefinition recordTypeDefinition;
    private Object recordObject;
    private FileTableSettings settings;
    private final Scanner scanner;

    public RowInputTextFileDescriptor(FileDescriptorFactory fileDescriptorFactory, FileTableSettings settings) {
        this.fileDescriptorFactory = fileDescriptorFactory;
        this.oneRecordReader = fileDescriptorFactory.createOneRecordReader();
        this.recordTypeDefinition = (AbstractRecordTypeDefinition)fileDescriptorFactory.getFileDescriptor().getRecord(fileDescriptorFactory.getObservableRecordTypes().stream().findFirst().orElse(null));
        this.settings = settings;
        this.scanner = new Scanner();
    }

    @Override
    public boolean accepts(String recordLine) {
        try {
            if (this.fileDescriptorFactory.getObservableRecordTypes().size() == 0) {
                return true;
            }
            if (this.fileDescriptorFactory.getFileDescriptor().hasKey()) {
                String key = this.oneRecordReader.readKey(recordLine);
                return key != null && this.fileDescriptorFactory.getObservableRecordTypes().contains(key);
            }
            return true;
        }
        catch (FileDescriptorFactory.FileDescriptorProcessingException exception) {
            return true;
        }
    }

    @Override
    public void setSource(String text, int pos, int byteSize) {
        super.setSource(text, pos, byteSize);
        this.recordObject = null;
    }

    @Override
    public void reset() {
        this.recordObject = null;
    }

    private Object getField() {
        ++this.field;
        try {
            if (this.recordObject == null) {
                this.recordObject = this.oneRecordReader.readRecord((String)this.text).first;
            }
            if (this.recordObject == null) {
                return null;
            }
        }
        catch (FileDescriptorFactory.FileDescriptorProcessingException exception) {
            if (exception.getAction() == FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.SKIPPED && this.settings.ignoreUnknownRecords) {
                Trace.logDebug(this, exception.getMessage());
                return null;
            }
            throw new DataspaceException(exception.getMessage(), exception);
        }
        RecordField recordField = this.recordTypeDefinition.getFields().get(this.field - 1);
        if (this.recordTypeDefinition instanceof RecordTypeDefinition) {
            if (recordField.getSpaths() == null && recordField.getSpaths().length == 0) {
                throw new DataspaceException("No spaths defined for field " + recordField.getFieldName() + ".");
            }
            try {
                return this.fileDescriptorFactory.getSdrManager().getValueAtPath(recordField.getSpaths()[0], this.recordObject);
            }
            catch (ReferencePathException exception) {
                throw new DataspaceException("Field to read filed '" + recordField.getFieldName() + "' value.");
            }
        }
        if (this.recordTypeDefinition instanceof UntypedRecordTypeDefinition) {
            if (recordField.getDataType() == null && recordField.getDataType().length() == 0) {
                throw new DataspaceException("No data type defined for field " + recordField.getFieldName() + ".");
            }
            if (!(this.recordObject instanceof List)) {
                throw new DataspaceException("Invalid record object, should be of type List.");
            }
            if (((List)this.recordObject).size() != this.recordTypeDefinition.getFields().size()) {
                throw new DataspaceException("Invalid record object size, should be " + this.recordTypeDefinition.getFields().size() + ", but passed " + ((List)this.recordObject).size() + ".");
            }
            return ((List)this.recordObject).get(this.field - 1);
        }
        throw new DataspaceException("Unsupported record type definition type '" + String.valueOf(this.recordTypeDefinition.getClass()) + "'.");
    }

    @Override
    public String readString() throws IOException {
        Object value = this.getField();
        return value == null || value instanceof String ? (String)value : value.toString();
    }

    @Override
    protected String readChar(Type type) throws IOException {
        return this.readString();
    }

    @Override
    protected Integer readSmallint() throws IOException {
        Object value = this.getField();
        return (value = this.convertEmptyStringValueToNull(value)) == null || value instanceof Integer ? (Integer)value : Integer.valueOf(value.toString());
    }

    @Override
    protected Integer readInteger() throws IOException {
        Object value = this.getField();
        return (value = this.convertEmptyStringValueToNull(value)) == null || value instanceof Integer ? (Integer)value : Integer.valueOf(value.toString().trim());
    }

    @Override
    public Long readLongO() throws IOException {
        Object value = this.getField();
        return (value = this.convertEmptyStringValueToNull(value)) == null || value instanceof Long ? (Long)value : Long.valueOf(value.toString().trim());
    }

    @Override
    protected BigInteger readBigint() throws IOException {
        Object value = this.getField();
        return (value = this.convertEmptyStringValueToNull(value)) == null || value instanceof BigInteger ? (BigInteger)value : new BigInteger(value.toString().trim());
    }

    @Override
    protected Double readReal() throws IOException {
        Object value = this.getField();
        return (value = this.convertEmptyStringValueToNull(value)) == null || value instanceof Double ? (Double)value : Double.valueOf(value.toString().trim());
    }

    @Override
    protected BigDecimal readDecimal(Type type) throws IOException {
        Object value = this.getField();
        value = this.convertEmptyStringValueToNull(value);
        BigDecimal bd = (BigDecimal)type.convertToDefaultType(null, value);
        return (BigDecimal)type.convertToTypeLimits(null, bd);
    }

    @Override
    protected Boolean readBoole() throws IOException {
        Object value = this.getField();
        return (value = this.convertEmptyStringValueToNull(value)) == null || value instanceof Boolean ? (Boolean)value : Boolean.valueOf(value.toString().trim());
    }

    @Override
    protected Object readOther() throws IOException {
        return new OtherTypeWrapper(this.getField());
    }

    @Override
    protected Object readFacets() throws IOException {
        return new OtherTypeWrapper(this.getField());
    }

    @Override
    protected Object readAspects() throws IOException {
        return new OtherTypeWrapper(this.getField());
    }

    @Override
    protected BinaryData readBinary() throws IOException {
        Object value = this.getField();
        if (value == null) {
            return null;
        }
        if (!(value instanceof byte[])) {
            if (this.recordTypeDefinition instanceof RecordTypeDefinition) {
                throw new DataspaceException("Invalid value type for field '" + this.recordTypeDefinition.getFields().get(this.field - 1).getFieldName() + "'. Expected binary.");
            }
            if (value instanceof String) {
                return this.scanner.convertToBinary((String)value);
            }
            throw new DataspaceException("Invalid value type for field '" + this.recordTypeDefinition.getFields().get(this.field - 1).getFieldName() + "'. Expected binary or string.");
        }
        return new BinaryData((byte[])value, ((byte[])value).length);
    }

    @Override
    protected TimestampData readDate(Type type) throws IOException {
        Object value = this.getField();
        if ((value = this.convertEmptyStringValueToNull(value)) == null) {
            return null;
        }
        if (value instanceof Date) {
            long millis = DataspaceDateTime.convertMillisFromCalendar(DataspaceDateTime.getCalendar(), ((Date)value).getTime());
            return new TimestampData(millis);
        }
        String s = String.valueOf(value).trim();
        if (s.length() == 0) {
            return null;
        }
        return this.scanner.newDate(s);
    }

    @Override
    protected TimestampData readTimestamp(Type type) throws IOException {
        Object value = this.getField();
        if ((value = this.convertEmptyStringValueToNull(value)) == null) {
            return null;
        }
        if (value instanceof Timestamp) {
            long millis = DataspaceDateTime.convertMillisFromCalendar(DataspaceDateTime.getCalendar(), ((Date)value).getTime());
            return new TimestampData(millis, ((Timestamp)value).getNanos(), 0);
        }
        if (value instanceof Date) {
            long millis = DataspaceDateTime.convertMillisFromCalendar(DataspaceDateTime.getCalendar(), ((Date)value).getTime());
            return new TimestampData(millis, (int)(millis % 1000L), 0);
        }
        String s = String.valueOf(value).trim();
        if (s.length() == 0) {
            return null;
        }
        return this.scanner.newTimestamp(s);
    }

    @Override
    protected TimeData readTime(Type type) throws IOException {
        Object value = this.getField();
        if ((value = this.convertEmptyStringValueToNull(value)) == null) {
            return null;
        }
        if (value instanceof Date) {
            long millis = DataspaceDateTime.convertMillisFromCalendar(DataspaceDateTime.getCalendar(), ((Date)value).getTime());
            return new TimeData((int)(millis / 1000L), (int)(1000L * (millis % 1000L)), 0);
        }
        String s = String.valueOf(value).trim();
        if (s.length() == 0) {
            return null;
        }
        return this.scanner.newTime(s);
    }

    @Override
    protected BinaryData readBit() throws IOException {
        return this.readBinary();
    }

    @Override
    protected boolean readNull() throws IOException {
        return false;
    }

    @Override
    protected IntervalMonthData readYearMonthInterval(Type type) throws IOException {
        Object value = this.getField();
        if ((value = this.convertEmptyStringValueToNull(value)) == null) {
            return null;
        }
        return null;
    }

    @Override
    protected IntervalSecondData readDaySecondInterval(Type type) throws IOException {
        Object value = this.getField();
        if ((value = this.convertEmptyStringValueToNull(value)) == null) {
            return null;
        }
        return null;
    }

    @Override
    public int readType() throws IOException {
        return 0;
    }

    @Override
    protected ClobData readClob() throws IOException {
        Object value = this.getField();
        if (value == null) {
            return null;
        }
        return null;
    }

    @Override
    protected BlobData readBlob() throws IOException {
        Object value = this.getField();
        if (value == null) {
            return null;
        }
        return null;
    }

    @Override
    protected FlobData readFlob(Type type) throws IOException {
        Object value = this.getField();
        if (value == null) {
            return null;
        }
        return null;
    }

    @Override
    protected Object[] readArray(Type type) throws IOException {
        Object value = this.getField();
        if (value == null) {
            return null;
        }
        return null;
    }

    private Object convertEmptyStringValueToNull(Object value) {
        if (value instanceof String && ((String)value).trim().length() == 0) {
            value = null;
        }
        return value;
    }

    public Object getRecordObject() {
        return this.recordObject;
    }
}

