/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.io.rowio;

import com.streamscape.ds.error.Error;
import com.streamscape.ds.io.rowio.AbstractRowInputText;
import com.streamscape.ds.lib.store.ValuePool;
import com.streamscape.ds.parser.Scanner;
import com.streamscape.ds.types.BinaryData;
import com.streamscape.ds.types.BlobData;
import com.streamscape.ds.types.BlobDataID;
import com.streamscape.ds.types.ClobData;
import com.streamscape.ds.types.ClobDataID;
import com.streamscape.ds.types.FlobData;
import com.streamscape.ds.types.FlobDataID;
import com.streamscape.ds.types.IntervalMonthData;
import com.streamscape.ds.types.IntervalSecondData;
import com.streamscape.ds.types.IntervalType;
import com.streamscape.ds.types.OtherTypeBytesWrapper;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.TimeData;
import com.streamscape.ds.types.TimestampData;
import com.streamscape.ds.types.Type;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class RowInputText
extends AbstractRowInputText {
    private String fieldSep;
    private String varSep;
    private String longvarSep;
    private int fieldSepLen;
    private int varSepLen;
    private int longvarSepLen;
    private boolean fieldSepEnd;
    private boolean varSepEnd;
    private boolean longvarSepEnd;
    protected int next = 0;
    protected boolean allQuoted;
    protected Scanner scanner;
    protected int block = -1;
    private int maxPooledStringLength = ValuePool.getMaxStringLength();

    public RowInputText(String fieldSep, String varSep, String longvarSep, boolean allQuoted) {
        this.scanner = new Scanner();
        if (fieldSep.endsWith("\n")) {
            this.fieldSepEnd = true;
            fieldSep = fieldSep.substring(0, fieldSep.length() - 1);
        }
        if (varSep.endsWith("\n")) {
            this.varSepEnd = true;
            varSep = varSep.substring(0, varSep.length() - 1);
        }
        if (longvarSep.endsWith("\n")) {
            this.longvarSepEnd = true;
            longvarSep = longvarSep.substring(0, longvarSep.length() - 1);
        }
        this.allQuoted = allQuoted;
        this.fieldSep = fieldSep;
        this.varSep = varSep;
        this.longvarSep = longvarSep;
        this.fieldSepLen = fieldSep.length();
        this.varSepLen = varSep.length();
        this.longvarSepLen = longvarSep.length();
    }

    @Override
    public void setSource(String text, int pos, int byteSize) {
        super.setSource(text, pos, byteSize);
        this.next = 0;
    }

    @Override
    public int getBlock() {
        return this.block;
    }

    @Override
    public void setBlock(int block) {
        this.block = block;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getField(String sep, int sepLen, boolean isEnd) throws IOException {
        String s = null;
        try {
            int start = this.next;
            ++this.field;
            if (isEnd) {
                if (this.next >= this.text.length() && sepLen > 0) {
                    throw Error.error(488);
                }
                if (!this.text.endsWith(sep)) throw Error.error(488);
                this.next = this.text.length() - sepLen;
            } else {
                this.next = this.text.indexOf(sep, start);
                if (this.next == -1) {
                    this.next = this.text.length();
                }
            }
            if (start > this.next) {
                start = this.next;
            }
            s = this.text.substring(start, this.next).trim();
            this.next += sepLen;
            if (s.length() != 0) return s;
            return null;
        }
        catch (Exception e) {
            Object[] messages = new Object[]{new Integer(this.field), e.toString()};
            throw new IOException(Error.getMessage(41, 0, messages));
        }
    }

    @Override
    public String readString() throws IOException {
        return this.getField(this.fieldSep, this.fieldSepLen, this.fieldSepEnd);
    }

    private String readVarString() throws IOException {
        return this.getField(this.varSep, this.varSepLen, this.varSepEnd);
    }

    private String readLongVarString() throws IOException {
        return this.getField(this.longvarSep, this.longvarSepLen, this.longvarSepEnd);
    }

    @Override
    public short readShort() throws IOException {
        return (short)this.readInt();
    }

    @Override
    public int readInt() throws IOException {
        String s = this.readString();
        if (s == null) {
            return 0;
        }
        if ((s = s.trim()).length() == 0) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    @Override
    public long readLong() throws IOException {
        String s = this.readString();
        if (s == null) {
            return 0L;
        }
        if ((s = s.trim()).length() == 0) {
            return 0L;
        }
        return ValuePool.getLong(Long.parseLong(s));
    }

    @Override
    public int readType() throws IOException {
        return 0;
    }

    @Override
    protected boolean readNull() {
        return false;
    }

    @Override
    protected String readChar(Type type) throws IOException {
        String s = null;
        switch (type.typeCode) {
            case 1: {
                s = this.readString();
                break;
            }
            case 12: 
            case 100: {
                s = this.readVarString();
                break;
            }
            default: {
                s = this.readLongVarString();
            }
        }
        if (s == null) {
            return null;
        }
        if (s.length() > this.maxPooledStringLength) {
            return s;
        }
        return ValuePool.getString(s);
    }

    @Override
    protected Integer readSmallint() throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return ValuePool.getInt(Integer.parseInt(s));
    }

    @Override
    protected Integer readInteger() throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return ValuePool.getInt(Integer.parseInt(s));
    }

    @Override
    protected Long readLongO() throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return ValuePool.getLong(Long.parseLong(s));
    }

    @Override
    protected BigInteger readBigint() throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return ValuePool.getBigInteger(new BigInteger(s));
    }

    @Override
    protected Double readReal() throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return Double.valueOf(s);
    }

    @Override
    protected BigDecimal readDecimal(Type type) throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return new BigDecimal(s);
    }

    @Override
    protected TimeData readTime(Type type) throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return this.scanner.newTime(s);
    }

    @Override
    protected TimestampData readDate(Type type) throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return this.scanner.newDate(s);
    }

    @Override
    protected TimestampData readTimestamp(Type type) throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return this.scanner.newTimestamp(s);
    }

    @Override
    protected IntervalMonthData readYearMonthInterval(Type type) throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return (IntervalMonthData)this.scanner.newInterval(s, (IntervalType)type);
    }

    @Override
    protected IntervalSecondData readDaySecondInterval(Type type) throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return (IntervalSecondData)this.scanner.newInterval(s, (IntervalType)type);
    }

    @Override
    protected Boolean readBoole() throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return s.equalsIgnoreCase("TRUE") ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    protected Object readOther() throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        BinaryData data = this.scanner.convertToBinary(s);
        if (data.length(null) == 0L) {
            return null;
        }
        if (this.isTypesCheck) {
            return new OtherTypeBytesWrapper(data.getBytes());
        }
        return new OtherTypeWrapper(data.getBytes(), false);
    }

    @Override
    protected Object readFacets() throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        BinaryData data = this.scanner.convertToBinary(s);
        if (data.length(null) == 0L) {
            return null;
        }
        if (this.isTypesCheck) {
            return new OtherTypeBytesWrapper(data.getBytes());
        }
        return new OtherTypeWrapper(data.getBytes(), false);
    }

    @Override
    protected Object readAspects() throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        BinaryData data = this.scanner.convertToBinary(s);
        if (data.length(null) == 0L) {
            return null;
        }
        if (this.isTypesCheck) {
            return new OtherTypeBytesWrapper(data.getBytes());
        }
        return new OtherTypeWrapper(data.getBytes(), false);
    }

    @Override
    protected BinaryData readBit() throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        return this.scanner.convertToBit(s);
    }

    @Override
    protected BinaryData readBinary() throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        return this.scanner.convertToBinary(s);
    }

    @Override
    protected ClobData readClob() throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return new ClobDataID(Long.parseLong(s));
    }

    @Override
    protected BlobData readBlob() throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return new BlobDataID(Long.parseLong(s));
    }

    @Override
    protected FlobData readFlob(Type type) throws IOException {
        Long id = this.readLongId();
        if (id != null) {
            return new FlobDataID(id);
        }
        return null;
    }

    private Long readLongId() throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return Long.parseLong(s);
    }

    @Override
    protected Object[] readArray(Type type) {
        throw Error.runtimeError(201, "RowInputText");
    }

    @Override
    public void reset() {
        super.reset();
        this.next = 0;
    }
}

