/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.io.rowio;

import com.streamscape.Trace;
import com.streamscape.ds.io.rowio.RowInputBase;
import com.streamscape.ds.io.rowio.RowInputInterface;
import com.streamscape.ds.io.rowio.RowOutputBinary;
import com.streamscape.ds.lib.StringConverter;
import com.streamscape.ds.lib.store.ValuePool;
import com.streamscape.ds.types.BinaryData;
import com.streamscape.ds.types.BlobData;
import com.streamscape.ds.types.BlobDataID;
import com.streamscape.ds.types.ClobData;
import com.streamscape.ds.types.ClobDataID;
import com.streamscape.ds.types.FlobData;
import com.streamscape.ds.types.FlobDataID;
import com.streamscape.ds.types.IntervalMonthData;
import com.streamscape.ds.types.IntervalSecondData;
import com.streamscape.ds.types.IntervalType;
import com.streamscape.ds.types.OtherTypeBytesWrapper;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.TimeData;
import com.streamscape.ds.types.TimestampData;
import com.streamscape.ds.types.Type;
import java.io.EOFException;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class RowInputBinary
extends RowInputBase
implements RowInputInterface {
    private RowOutputBinary out;

    public RowInputBinary(byte[] buf) {
        super(buf);
    }

    public RowInputBinary(RowOutputBinary out) {
        super(out.getBuffer());
        this.out = out;
    }

    @Override
    public int readType() throws IOException {
        return this.readShort();
    }

    @Override
    public String readString() throws IOException {
        int length = this.readInt();
        String s = StringConverter.readUTF(this.buffer, this.pos, length);
        s = ValuePool.getString(s);
        this.pos += length;
        return s;
    }

    @Override
    public boolean readNull() throws IOException {
        byte b = this.readByte();
        return b == 0;
    }

    @Override
    protected String readChar(Type type) throws IOException {
        return this.readString();
    }

    @Override
    protected Integer readSmallint() throws IOException {
        return ValuePool.getInt(this.readShort());
    }

    @Override
    protected Integer readInteger() throws IOException {
        return ValuePool.getInt(this.readInt());
    }

    @Override
    protected Long readLongO() throws IOException {
        return ValuePool.getLong(this.readLong());
    }

    @Override
    protected BigInteger readBigint() throws IOException {
        byte[] bytes = this.readByteArray();
        BigInteger bigint = new BigInteger(bytes);
        return ValuePool.getBigInteger(bigint);
    }

    @Override
    protected Double readReal() throws IOException {
        return ValuePool.getDouble(this.readLong());
    }

    @Override
    protected BigDecimal readDecimal(Type type) throws IOException {
        byte[] bytes = this.readByteArray();
        int scale = this.readInt();
        BigInteger bigint = new BigInteger(bytes);
        return ValuePool.getBigDecimal(new BigDecimal(bigint, scale));
    }

    @Override
    protected Boolean readBoole() throws IOException {
        return this.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    protected TimeData readTime(Type type) throws IOException {
        if (type.typeCode == 92) {
            return new TimeData(this.readInt(), this.readInt(), 0);
        }
        return new TimeData(this.readInt(), this.readInt(), this.readInt());
    }

    @Override
    protected TimestampData readDate(Type type) throws IOException {
        long date = this.readLong();
        return new TimestampData(date);
    }

    @Override
    protected TimestampData readTimestamp(Type type) throws IOException {
        if (type.typeCode == 93) {
            return new TimestampData(this.readLong(), this.readInt());
        }
        return new TimestampData(this.readLong(), this.readInt(), this.readInt());
    }

    @Override
    protected IntervalMonthData readYearMonthInterval(Type type) throws IOException {
        long months = this.readLong();
        return new IntervalMonthData(months, (IntervalType)type);
    }

    @Override
    protected IntervalSecondData readDaySecondInterval(Type type) throws IOException {
        long seconds = this.readLong();
        int nanos = this.readInt();
        return new IntervalSecondData(seconds, nanos, (IntervalType)type);
    }

    @Override
    protected Object readOther() throws IOException {
        try {
            if (this.isTypesCheck) {
                return new OtherTypeBytesWrapper(this.readByteArray());
            }
            return new OtherTypeWrapper(this.readByteArray(), false);
        }
        catch (Throwable error) {
            Trace.logError(this, "Unable to read OBJECT for persistent collection. " + error.getMessage());
            return null;
        }
    }

    @Override
    protected Object readFacets() throws IOException {
        try {
            if (this.isTypesCheck) {
                return new OtherTypeBytesWrapper(this.readByteArray());
            }
            return new OtherTypeWrapper(this.readByteArray(), false);
        }
        catch (Throwable error) {
            Trace.logError(this, "Unable to read FACETS for persistent collection. " + error.getMessage());
            return null;
        }
    }

    @Override
    protected Object readAspects() throws IOException {
        try {
            if (this.isTypesCheck) {
                return new OtherTypeBytesWrapper(this.readByteArray());
            }
            return new OtherTypeWrapper(this.readByteArray(), false);
        }
        catch (Throwable error) {
            Trace.logError(this, "Unable to read ASPECTS for persistent collection. " + error.getMessage());
            return null;
        }
    }

    @Override
    protected BinaryData readBit() throws IOException {
        int length = this.readInt();
        byte[] b = new byte[(length + 7) / 8];
        this.readFully(b);
        return BinaryData.getBitData(b, length);
    }

    @Override
    protected BinaryData readBinary() throws IOException {
        return new BinaryData(this.readByteArray(), false);
    }

    @Override
    protected ClobData readClob() throws IOException {
        long id = super.readLong();
        return new ClobDataID(id);
    }

    @Override
    protected BlobData readBlob() throws IOException {
        long id = super.readLong();
        return new BlobDataID(id);
    }

    @Override
    protected FlobData readFlob(Type type) throws IOException {
        long id = super.readLong();
        return new FlobDataID(id);
    }

    @Override
    protected Object[] readArray(Type type) throws IOException {
        type = type.collectionBaseType();
        int size = this.readInt();
        Object[] data = new Object[size];
        for (int i = 0; i < size; ++i) {
            data[i] = this.readData(type);
        }
        return data;
    }

    public int[] readIntArray() throws IOException {
        int size = this.readInt();
        int[] data = new int[size];
        for (int i = 0; i < size; ++i) {
            if (this.readNull()) continue;
            data[i] = this.readInt();
        }
        return data;
    }

    @Override
    public Object[] readData(Type[] colTypes) throws IOException {
        return super.readData(colTypes);
    }

    public byte[] readByteArray() throws IOException {
        byte[] b = new byte[this.readInt()];
        this.readFully(b);
        return b;
    }

    public char[] readCharArray() throws IOException {
        char[] c = new char[this.readInt()];
        if (this.count - this.pos < c.length) {
            this.pos = this.count;
            throw new EOFException();
        }
        for (int i = 0; i < c.length; ++i) {
            int ch1 = this.buffer[this.pos++] & 0xFF;
            int ch2 = this.buffer[this.pos++] & 0xFF;
            c[i] = (char)((ch1 << 8) + ch2);
        }
        return c;
    }

    public void resetRow(int rowsize) {
        if (this.out != null) {
            this.out.reset(rowsize);
            this.buffer = this.out.getBuffer();
        }
        super.reset();
    }

    @Override
    public void resetRow(int filepos, int rowsize) throws IOException {
        if (this.out != null) {
            this.out.reset(rowsize);
            this.buffer = this.out.getBuffer();
        }
        super.resetRow(filepos, rowsize);
    }
}

