/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.io.rowio;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.io.rowio.RowInputBinary;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.BlobData;
import com.streamscape.ds.types.BlobDataID;
import com.streamscape.ds.types.ClobData;
import com.streamscape.ds.types.ClobDataID;
import com.streamscape.ds.types.FlobData;
import com.streamscape.ds.types.FlobType;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.utils.SqlUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Objects;

public class LoaderRowInputBinary
extends RowInputBinary {
    private Session session;
    private boolean ignoreFlobs;

    public LoaderRowInputBinary(Session session, byte[] buf) {
        super(buf);
        this.session = session;
    }

    @Override
    protected ClobData readClob() throws IOException {
        try {
            this.readLong();
            ClobDataID newClobDataId = SqlUtils.allocateClob(this.session, new String(this.readByteArray(), this.session.getSessionCCSID()).toCharArray());
            return new ClobDataID(newClobDataId.getId());
        }
        catch (SQLException e) {
            throw new DataspaceException(e);
        }
    }

    @Override
    protected BlobData readBlob() throws IOException {
        try {
            this.readLong();
            BlobDataID newBlobId = SqlUtils.allocateBlob(this.session, this.readByteArray());
            return new BlobDataID(newBlobId.getId());
        }
        catch (SQLException e) {
            throw new DataspaceException(e);
        }
    }

    @Override
    protected FlobData readFlob(Type type) throws IOException {
        this.readLong();
        String location = (String)this.readData(Type.STRING);
        String fileName = (String)this.readData(Type.STRING);
        if (type instanceof FlobType && Objects.equals(((FlobType)type).getLocation(), location)) {
            type = new FlobType((FlobType)type);
            ((FlobType)type).setLocation(location);
        }
        FlobData flob = this.session.createFlob(type, fileName, null, true, true, true);
        boolean containsFlobData = this.readBoolean();
        if (containsFlobData) {
            byte[] bt = this.readByteArray();
            if (!this.ignoreFlobs) {
                this.session.dataspaceStore.flobManager.setBytes(flob, new ByteArrayInputStream(bt), bt.length);
            }
        }
        return flob;
    }

    public void setIgnoreFlobs(boolean ignoreFlobs) {
        this.ignoreFlobs = ignoreFlobs;
    }
}

