/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.io.rowio;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.io.rowio.RowOutputBinary;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.BlobData;
import com.streamscape.ds.types.ClobData;
import com.streamscape.ds.types.FlobData;
import com.streamscape.ds.types.FlobType;
import com.streamscape.ds.types.Type;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Objects;
import org.apache.commons.io.IOUtils;

public class DumperRowOutputBinary
extends RowOutputBinary {
    private Session session;
    private boolean ignoreFlobs;

    public DumperRowOutputBinary(Session session, int initialSize, int scale) {
        super(initialSize, scale);
        this.session = session;
    }

    @Override
    protected void writeBlob(BlobData o, Type type) {
        this.writeLong(o.getId());
        try (InputStream input = o.getBinaryStream(this.session);){
            this.writeByteArray(IOUtils.toByteArray(input));
        }
        catch (IOException e) {
            throw new DataspaceException(e);
        }
    }

    @Override
    protected void writeClob(ClobData o, Type type) {
        this.writeLong(o.getId());
        try (Reader reader = o.getCharacterStream(this.session);){
            this.writeByteArray(IOUtils.toByteArray(reader));
        }
        catch (IOException e) {
            throw new DataspaceException(e);
        }
    }

    @Override
    protected void writeFlob(FlobData o, Type type) {
        this.writeLong(o.getId());
        FlobData flobData = this.session.dataspaceStore.flobManager.getFlobData(o.getId());
        this.writeData(Type.STRING, type instanceof FlobType && Objects.equals(((FlobType)type).getLocation(), flobData.getLocation()) ? null : flobData.getLocation());
        this.writeData(Type.STRING, flobData.getFilename());
        try {
            if (!this.ignoreFlobs) {
                this.writeBoolean(true);
                this.writeByteArray(this.session.dataspaceStore.flobManager.getFlobFileManager().getBytes(flobData.getFilename(), flobData.getLocation(), 0L, (int)flobData.length(this.session)));
            } else {
                this.writeBoolean(false);
            }
        }
        catch (IOException e) {
            throw new DataspaceException(e);
        }
    }

    public void setIgnoreFlobs(boolean ignoreFlobs) {
        this.ignoreFlobs = ignoreFlobs;
    }
}

