/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.io.rowio;

import com.streamscape.ds.io.rowio.RowInputBase;
import com.streamscape.ds.io.rowio.RowInputInterface;
import java.io.IOException;

public abstract class AbstractRowInputText
extends RowInputBase
implements RowInputInterface {
    protected String text;
    protected int line;
    protected int field;
    protected final String LINE_SEPARATOR_N = "\n";
    protected final String LINE_SEPARATOR_RN = "\r\n";
    protected final String LINE_SEPARATOR_R = "\r";
    protected final byte[] LINE_SEPARATOR_N_BYTES = "\n".getBytes();
    protected final byte[] LINE_SEPARATOR_RN_BYTES = "\r\n".getBytes();
    protected final byte[] LINE_SEPARATOR_R_BYTES = "\r".getBytes();

    public AbstractRowInputText() {
        super(new byte[0]);
    }

    public void setSource(String text, int pos, int byteSize) {
        this.size = byteSize;
        this.filePos = pos;
        this.text = text;
        this.field = 0;
    }

    public int getLineNumber() {
        return this.line;
    }

    public void increaseLine() {
        ++this.line;
    }

    public void skippedLine() {
        this.skippedLines(1);
    }

    public void skippedLines(int skippedLines) {
        this.line += skippedLines;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public void reset() {
        this.text = "";
        this.filePos = 0;
        this.field = 0;
        this.line = 0;
    }

    public boolean accepts(String rowString) {
        return true;
    }

    public String getLineSeparator() {
        if (this.text != null) {
            if (this.text.endsWith("\r\n")) {
                return "\r\n";
            }
            if (this.text.endsWith("\n")) {
                return "\n";
            }
            if (this.text.endsWith("\r")) {
                return "\r";
            }
        }
        return null;
    }

    public byte[] getLineSeparatorBytes() {
        if (this.text != null) {
            if (this.text.endsWith("\r\n")) {
                return this.LINE_SEPARATOR_RN_BYTES;
            }
            if (this.text.endsWith("\n")) {
                return this.LINE_SEPARATOR_N_BYTES;
            }
            if (this.text.endsWith("\r")) {
                return this.LINE_SEPARATOR_R_BYTES;
            }
        }
        return null;
    }

    public byte[] getLineSeparatorBytes(String lineDelimiter) {
        if (lineDelimiter != null) {
            if (lineDelimiter == "\r\n") {
                return this.LINE_SEPARATOR_RN_BYTES;
            }
            if (lineDelimiter == "\n") {
                return this.LINE_SEPARATOR_N_BYTES;
            }
            if (lineDelimiter == "\r") {
                return this.LINE_SEPARATOR_R_BYTES;
            }
            if (lineDelimiter.equals("\r\n")) {
                return this.LINE_SEPARATOR_RN_BYTES;
            }
            if (lineDelimiter.equals("\n")) {
                return this.LINE_SEPARATOR_N_BYTES;
            }
            if (lineDelimiter.equals("\r")) {
                return this.LINE_SEPARATOR_R_BYTES;
            }
        }
        return null;
    }

    @Override
    public abstract String readString() throws IOException;
}

