/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.info;

import com.streamscape.Trace;
import com.streamscape.cli.ds.CollectionType;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.SqlInvariants;
import com.streamscape.ds.TypeInvariants;
import com.streamscape.ds.info.DITableInfo;
import com.streamscape.ds.info.SysSchema;
import com.streamscape.ds.lib.HashSet;
import com.streamscape.ds.lib.HsqlArrayList;
import com.streamscape.ds.lib.Iterator;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.lib.WrapperIterator;
import com.streamscape.ds.lib.store.ValuePool;
import com.streamscape.ds.persist.DataspaceStoreProperties;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.index.Index;
import com.streamscape.ds.rights.Grantee;
import com.streamscape.ds.rights.GranteeManager;
import com.streamscape.ds.rights.Right;
import com.streamscape.ds.rights.UserWrapper;
import com.streamscape.ds.schema.DataspaceSchema;
import com.streamscape.ds.schema.collection.AbstractCollection;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.collection.stream.SourceStreamCollection;
import com.streamscape.ds.schema.collection.tspace.vtable.VirtualTableCollection;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.constraint.Constraint;
import com.streamscape.ds.schema.constraint.ReferenceLink;
import com.streamscape.ds.schema.event.Actor;
import com.streamscape.ds.schema.procedure.RoutineSchema;
import com.streamscape.ds.schema.procedure.RplScript;
import com.streamscape.ds.schema.sequence.NumberSequence;
import com.streamscape.ds.schema.server.ServerObject;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.schema.table.VirtualTable;
import com.streamscape.ds.schema.timer.TimerObject;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.ArrayType;
import com.streamscape.ds.types.DateTimeType;
import com.streamscape.ds.types.IntervalType;
import com.streamscape.ds.types.NumberType;
import com.streamscape.ds.types.Type;
import com.streamscape.lib.dispatcher.ConsumerState;
import com.streamscape.lib.timer.FabricTimer;
import com.streamscape.lib.timer.FabricTimerManager;
import com.streamscape.lib.timer.FabricTimerState;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.omf.odata.v4.server.jdbc.model.JdbcModel;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.ConsumerReference;
import com.streamscape.sef.moderator.EventConsumerReference;
import com.streamscape.sef.moderator.Moderator;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.sef.moderator.RequestConsumerReference;
import java.util.ArrayList;
import java.util.List;

class SysSchemaMain
extends SysSchema {
    static Type CARDINAL_NUMBER = TypeInvariants.CARDINAL_NUMBER;
    static Type YES_OR_NO = TypeInvariants.YES_OR_NO;
    static Type CHARACTER_DATA = TypeInvariants.CHARACTER_DATA;
    static Type SQL_IDENTIFIER = TypeInvariants.SQL_IDENTIFIER;
    static Type TIME_STAMP = TypeInvariants.TIME_STAMP;
    protected static final NameManager.ObjectName[] sysTableHsqlNames;
    protected static final boolean[] sysTableSessionDependent;
    protected static final HashSet nonCachedTablesSet;
    protected static final String[] tableTypes;
    protected final Table[] sysTables = new Table[sysTableNames.length];

    SysSchemaMain(DataspaceStore db) {
        super(db);
        Session session = db.collectionSessionManager.getSysSession();
        this.init(session);
    }

    protected final void addColumn(Table t, String name, Type type) {
        NameManager cfr_ignored_0 = this.database.nameManager;
        NameManager.ObjectName cn = NameManager.newInfoSchemaColumnName(name, t.getObjectName());
        ColumnSchema c = new ColumnSchema(cn, type, true, false, null);
        t.addColumn(c);
    }

    protected final Iterator allTables() {
        return new WrapperIterator(this.database.schemaManager.databaseObjectIterator(3), new WrapperIterator(this.sysTables, true));
    }

    protected final Iterator allCollections() {
        return this.database.schemaManager.databaseObjectIterator(4);
    }

    protected final void cacheClear(Session session) {
        int i = this.sysTables.length;
        while (i-- > 0) {
            Table t = this.sysTables[i];
            if (t == null) continue;
            t.clearAllData(session);
        }
    }

    protected Table generateTable(Session session, PersistentStore store, int tableIndex) {
        switch (tableIndex) {
            case 0: {
                return this.SYSTEM_BESTROWIDENTIFIER(session, store);
            }
            case 1: {
                return this.SYSTEM_COLUMNS(session, store);
            }
            case 18: {
                return this.SYSTEM_CONNECTION_PROPERTIES(session, store);
            }
            case 2: {
                return this.SYSTEM_CROSSREFERENCE(session, store);
            }
            case 3: {
                return this.SYSTEM_INDEXINFO(session, store);
            }
            case 4: {
                return this.SYSTEM_PRIMARYKEYS(session, store);
            }
            case 5: {
                return this.SYSTEM_PROCEDURECOLUMNS(session, store);
            }
            case 6: {
                return this.SYSTEM_PROCEDURES(session, store);
            }
            case 7: {
                return this.SYSTEM_SCHEMAS(session, store);
            }
            case 14: {
                return this.SYSTEM_SEQUENCES(session, store);
            }
            case 8: {
                return this.SYSTEM_TABLES(session, store);
            }
            case 9: {
                return this.SYSTEM_TABLETYPES(session, store);
            }
            case 10: {
                return this.SYSTEM_TYPEINFO(session, store);
            }
            case 12: {
                return this.SYSTEM_USERS(session, store);
            }
            case 11: {
                return this.SYSTEM_UDTS(session, store);
            }
            case 13: {
                return this.SYSTEM_VERSIONCOLUMNS(session, store);
            }
            case 33: {
                return this.COLUMN_PRIVILEGES(session, store);
            }
            case 69: {
                return this.SEQUENCES(session, store);
            }
            case 77: {
                return this.TABLE_PRIVILEGES(session, store);
            }
            case 43: {
                return this.INFORMATION_SCHEMA_CATALOG_NAME(session, store);
            }
        }
        return null;
    }

    protected final void init(Session session) {
        for (int i = 0; i < this.sysTables.length; ++i) {
            this.sysTables[i] = this.generateTable(session, null, i);
            Table t = this.sysTables[i];
            if (t == null) continue;
            t.setDataReadOnly(true);
        }
        GranteeManager gm = this.database.getGranteeManager();
        Right right = new Right();
        right.set(1, null);
        for (int i = 0; i < sysTableHsqlNames.length; ++i) {
            if (this.sysTables[i] == null) continue;
            gm.grantSystemToPublic(this.sysTables[i], right);
        }
        right = Right.fullRights;
        gm.grantSystemToPublic(SqlInvariants.SQL_CHARACTER, right);
        gm.grantSystemToPublic(SqlInvariants.SQL_IDENTIFIER_CHARSET, right);
        gm.grantSystemToPublic(SqlInvariants.SQL_TEXT, right);
        Iterator it = session.dataspaceStore.schemaManager.dataspaceObjectIterator("SYS", 14);
        while (it.hasNext()) {
            gm.grantSystemToPublic((Type)it.next(), right);
        }
        it = session.dataspaceStore.schemaManager.dataspaceObjectIterator("SYS", 13);
        while (it.hasNext()) {
            gm.grantSystemToPublic((Type)it.next(), right);
        }
    }

    protected final boolean isAccessibleTable(Session session, Table table) {
        return session.getGrantee().isAccessible(table);
    }

    protected final boolean isAccessibleCollection(Session session, AbstractCollection collection) {
        return session.getGrantee().isAccessible(collection.getBaseTable());
    }

    protected final boolean isAccessibleDataspace(Session session, String name) {
        return session.getGrantee().canAccessDataspace(session.dataspaceStore.schemaManager.findSchema(name));
    }

    protected final Table createBlankTable(NameManager.ObjectName name) {
        Table table = new Table(this.database, name, 1);
        return table;
    }

    @Override
    public final Table getSystemTable(Session session, String name) {
        if (!this.isSystemTable(name)) {
            return null;
        }
        int tableIndex = SysSchemaMain.getSysTableID(name);
        Table t = this.sysTables[tableIndex];
        if (t == null) {
            return t;
        }
        if (!this.withContent) {
            return t;
        }
        return t;
    }

    public boolean isNonCachedTable(String name) {
        return nonCachedTablesSet.contains(name);
    }

    @Override
    public final void setStore(Session session, Table table, PersistentStore store) {
        long dbscts = this.database.schemaManager.getSchemaChangeTimestamp();
        if (store.getTimestamp() == dbscts && !this.isNonCachedTable(table.getObjectName().name)) {
            return;
        }
        store.removeAll();
        store.setTimestamp(dbscts);
        int tableIndex = SysSchemaMain.getSysTableID(table.getObjectName().name);
        this.generateTable(session, store, tableIndex);
    }

    final Table SYSTEM_BESTROWIDENTIFIER(Session session, PersistentStore store) {
        Table t = this.sysTables[0];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[0]);
            this.addColumn(t, "SCOPE", Type.SQL_SMALLINT);
            this.addColumn(t, "COLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "DATA_TYPE", Type.SQL_SMALLINT);
            this.addColumn(t, "TYPE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "COLUMN_SIZE", Type.SQL_INTEGER);
            this.addColumn(t, "BUFFER_LENGTH", Type.SQL_INTEGER);
            this.addColumn(t, "DECIMAL_DIGITS", Type.SQL_SMALLINT);
            this.addColumn(t, "PSEUDO_COLUMN", Type.SQL_SMALLINT);
            this.addColumn(t, "TABLE_CAT", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_SCHEM", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "NULLABLE", Type.SQL_SMALLINT);
            this.addColumn(t, "IN_KEY", Type.SQL_BOOLEAN);
            NameManager.ObjectName name = NameManager.newInfoSchemaObjectName(SysSchemaMain.sysTableHsqlNames[0].name, false, 21);
            t.createPrimaryKeyConstraint(name, new int[]{0, 8, 9, 10, 1}, false);
            return t;
        }
        boolean iscope = false;
        boolean icolumn_name = true;
        int idata_type = 2;
        int itype_name = 3;
        int icolumn_size = 4;
        int ibuffer_length = 5;
        int idecimal_digits = 6;
        int ipseudo_column = 7;
        int itable_cat = 8;
        int itable_schem = 9;
        int itable_name = 10;
        int inullable = 11;
        int iinKey = 12;
        DITableInfo ti = new DITableInfo();
        Iterator tables = this.database.schemaManager.databaseObjectIterator(3);
        boolean translateTTI = this.database.sqlTranslateTTI;
        while (tables.hasNext()) {
            int[] cols;
            Table table = (Table)tables.next();
            if (table.isView() || !this.isAccessibleTable(session, table) || (cols = table.getBestRowIdentifiers()) == null) continue;
            ti.setTable(table);
            Boolean inKey = ValuePool.getBoolean(table.isBestRowIdentifiersStrict());
            String tableCatalog = table.getCatalogName().name;
            String tableSchema = table.getSchemaName().name;
            String tableName = table.getObjectName().name;
            Type[] types = table.getColumnTypes();
            Integer scope = ti.getBRIScope();
            Integer pseudo = ti.getBRIPseudo();
            for (int i = 0; i < cols.length; ++i) {
                ColumnSchema column = table.getColumn(i);
                Type type = types[i];
                if (translateTTI) {
                    if (type.isIntervalType()) {
                        type = ((IntervalType)type).getCharacterType();
                    } else if (type.isDateTimeTypeWithZone()) {
                        type = ((DateTimeType)type).getDateTimeTypeWithoutZone();
                    }
                }
                Object[] row = t.getEmptyRowData();
                row[0] = scope;
                row[1] = column.getObjectName().name;
                row[2] = ValuePool.getInt(type.getJDBCTypeCode());
                row[3] = type.getNameString();
                row[4] = ValuePool.getInt(type.getJDBCPrecision());
                row[5] = null;
                row[6] = type.acceptsScale() ? ValuePool.getInt(type.getJDBCScale()) : null;
                row[7] = pseudo;
                row[8] = tableCatalog;
                row[9] = tableSchema;
                row[10] = tableName;
                row[11] = ValuePool.getInt(column.getNullability());
                row[12] = inKey;
                t.insertSys(session, store, row);
            }
        }
        return t;
    }

    final Table SYSTEM_COLUMNS(Session session, PersistentStore store) {
        Table t = this.sysTables[1];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[1]);
            this.addColumn(t, "TABLE_CAT", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_SCHEM", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "COLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "DATA_TYPE", Type.SQL_SMALLINT);
            this.addColumn(t, "TYPE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "COLUMN_SIZE", Type.SQL_INTEGER);
            this.addColumn(t, "BUFFER_LENGTH", Type.SQL_INTEGER);
            this.addColumn(t, "DECIMAL_DIGITS", Type.SQL_INTEGER);
            this.addColumn(t, "NUM_PREC_RADIX", Type.SQL_INTEGER);
            this.addColumn(t, "NULLABLE", Type.SQL_INTEGER);
            this.addColumn(t, "REMARKS", CHARACTER_DATA);
            this.addColumn(t, "COLUMN_DEF", CHARACTER_DATA);
            this.addColumn(t, "SQL_DATA_TYPE", Type.SQL_INTEGER);
            this.addColumn(t, "SQL_DATETIME_SUB", Type.SQL_INTEGER);
            this.addColumn(t, "CHAR_OCTET_LENGTH", Type.SQL_INTEGER);
            this.addColumn(t, "ORDINAL_POSITION", Type.SQL_INTEGER);
            this.addColumn(t, "IS_NULLABLE", YES_OR_NO);
            this.addColumn(t, "SCOPE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "SCOPE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "SCOPE_TABLE", SQL_IDENTIFIER);
            this.addColumn(t, "SOURCE_DATA_TYPE", SQL_IDENTIFIER);
            this.addColumn(t, "IS_AUTOINCREMENT", YES_OR_NO);
            this.addColumn(t, "IS_GENERATEDCOLUMN", YES_OR_NO);
            NameManager.ObjectName name = NameManager.newInfoSchemaObjectName(SysSchemaMain.sysTableHsqlNames[1].name, false, 21);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 16}, false);
            return t;
        }
        boolean itable_cat = false;
        boolean itable_schem = true;
        int itable_name = 2;
        int icolumn_name = 3;
        int idata_type = 4;
        int itype_name = 5;
        int icolumn_size = 6;
        int ibuffer_length = 7;
        int idecimal_digits = 8;
        int inum_prec_radix = 9;
        int inullable = 10;
        int iremark = 11;
        int icolumn_def = 12;
        int isql_data_type = 13;
        int isql_datetime_sub = 14;
        int ichar_octet_length = 15;
        int iordinal_position = 16;
        int iis_nullable = 17;
        int iscope_cat = 18;
        int iscope_schem = 19;
        int iscope_table = 20;
        int isource_data_type = 21;
        int iis_autoinc = 22;
        int iis_generated = 23;
        Iterator tables = this.allTables();
        DITableInfo ti = new DITableInfo();
        boolean translateTTI = this.database.sqlTranslateTTI;
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            if (!this.isAccessibleTable(session, table)) continue;
            ti.setTable(table);
            String tableCatalog = table.getCatalogName().name;
            String tableSchema = table.getSchemaName().name;
            String tableName = table.getObjectName().name;
            int columnCount = table.getColumnCount();
            for (int i = 0; i < columnCount; ++i) {
                ColumnSchema column = table.getColumn(i);
                if (!session.getGrantee().isDisclosableField(table, column)) continue;
                Type type = column.getDataType();
                if (translateTTI) {
                    if (type.isIntervalType()) {
                        type = ((IntervalType)type).getCharacterType();
                    } else if (type.isDateTimeTypeWithZone()) {
                        type = ((DateTimeType)type).getDateTimeTypeWithoutZone();
                    }
                }
                Object[] row = t.getEmptyRowData();
                row[0] = tableCatalog;
                row[1] = tableSchema;
                row[2] = tableName;
                row[3] = column.getObjectName().name;
                row[4] = ValuePool.getInt(type.getJDBCTypeCode());
                row[5] = type.typeCode == 1119 ? type.getFullNameString() : type.getNameString();
                row[6] = ValuePool.INTEGER_0;
                row[15] = ValuePool.INTEGER_0;
                if (type.isArrayType()) {
                    row[5] = type.getDefinition();
                }
                if (type.isCharacterType()) {
                    row[6] = ValuePool.getInt(type.getJDBCPrecision());
                    row[15] = ValuePool.getInt(type.getJDBCPrecision());
                }
                if (type.isBinaryType()) {
                    row[6] = ValuePool.getInt(type.getJDBCPrecision());
                    row[15] = ValuePool.getInt(type.getJDBCPrecision());
                }
                if (type.isNumberType()) {
                    row[6] = ValuePool.getInt(((NumberType)type).getNumericPrecisionInRadix());
                    row[9] = ValuePool.getInt(type.getPrecisionRadix());
                    if (type.isExactNumberType()) {
                        row[8] = ValuePool.getLong(type.scale);
                    }
                }
                if (type.isDateTimeType()) {
                    int size = column.getDataType().displaySize();
                    row[6] = ValuePool.getInt(size);
                    row[14] = ValuePool.getInt(((DateTimeType)type).getSqlDateTimeSub());
                }
                row[10] = ValuePool.getInt(column.getNullability());
                row[11] = ti.getColRemarks(i);
                row[12] = column.getDefaultSQL();
                row[13] = ValuePool.getInt(type.typeCode);
                row[16] = ValuePool.getInt(i + 1);
                Object object = row[17] = column.isNullable() ? "YES" : "NO";
                if (type.isDistinctType()) {
                    row[21] = type.getObjectName().getSchemaQualifiedStatementName();
                }
                row[22] = column.isIdentity() ? "YES" : "NO";
                row[23] = column.isGenerated() ? "YES" : "NO";
                t.insertSys(session, store, row);
            }
        }
        return t;
    }

    final Table SYSTEM_CROSSREFERENCE(Session session, PersistentStore store) {
        Object[] row;
        Constraint constraint;
        int i;
        Table t = this.sysTables[2];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[2]);
            this.addColumn(t, "PKTABLE_CAT", SQL_IDENTIFIER);
            this.addColumn(t, "PKTABLE_SCHEM", SQL_IDENTIFIER);
            this.addColumn(t, "PKTABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "PKCOLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "FKTABLE_CAT", SQL_IDENTIFIER);
            this.addColumn(t, "FKTABLE_SCHEM", SQL_IDENTIFIER);
            this.addColumn(t, "FKTABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "FKCOLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "KEY_SEQ", Type.SQL_SMALLINT);
            this.addColumn(t, "UPDATE_RULE", Type.SQL_SMALLINT);
            this.addColumn(t, "DELETE_RULE", Type.SQL_SMALLINT);
            this.addColumn(t, "FK_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "PK_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "DEFERRABILITY", Type.SQL_SMALLINT);
            NameManager.ObjectName name = NameManager.newInfoSchemaObjectName(SysSchemaMain.sysTableHsqlNames[2].name, false, 21);
            t.createPrimaryKeyConstraint(name, new int[]{4, 5, 6, 8, 11}, false);
            return t;
        }
        boolean ipk_table_cat = false;
        boolean ipk_table_schem = true;
        int ipk_table_name = 2;
        int ipk_column_name = 3;
        int ifk_table_cat = 4;
        int ifk_table_schem = 5;
        int ifk_table_name = 6;
        int ifk_column_name = 7;
        int ikey_seq = 8;
        int iupdate_rule = 9;
        int idelete_rule = 10;
        int ifk_name = 11;
        int ipk_name = 12;
        int ideferrability = 13;
        Iterator tables = this.database.schemaManager.databaseObjectIterator(3);
        HsqlArrayList fkConstraintsList = new HsqlArrayList();
        ArrayList<VirtualTableCollection> vtables = new ArrayList<VirtualTableCollection>();
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            if (table instanceof VirtualTable && ((VirtualTable)table).helper instanceof VirtualTableCollection) {
                vtables.add((VirtualTableCollection)((VirtualTable)table).helper);
            }
            if (table.isView() || !this.isAccessibleTable(session, table)) continue;
            Constraint[] constraints = table.getConstraints();
            int constraintCount = constraints.length;
            for (i = 0; i < constraintCount; ++i) {
                constraint = constraints[i];
                if (constraint.getConstraintType() != 0 || !this.isAccessibleTable(session, constraint.getRef())) continue;
                fkConstraintsList.add(constraint);
            }
        }
        for (i = 0; i < fkConstraintsList.size(); ++i) {
            constraint = (Constraint)fkConstraintsList.get(i);
            Table pkTable = constraint.getMain();
            String pkTableName = pkTable.getObjectName().name;
            Table fkTable = constraint.getRef();
            String fkTableName = fkTable.getObjectName().name;
            String pkTableCatalog = pkTable.getCatalogName().name;
            String pkTableSchema = pkTable.getSchemaName().name;
            String fkTableCatalog = fkTable.getCatalogName().name;
            String fkTableSchema = fkTable.getSchemaName().name;
            int[] mainCols = constraint.getMainColumns();
            int[] refCols = constraint.getRefColumns();
            int columnCount = refCols.length;
            String fkName = constraint.getRefName().name;
            String pkName = constraint.getUniqueName().name;
            Integer deferrability = ValuePool.getInt(constraint.getDeferability());
            Integer deleteRule = ValuePool.getInt(constraint.getDeleteAction());
            Integer updateRule = ValuePool.getInt(constraint.getUpdateAction());
            for (int j = 0; j < columnCount; ++j) {
                Integer keySequence = ValuePool.getInt(j + 1);
                String pkColumnName = pkTable.getColumn(mainCols[j]).getNameString();
                String fkColumnName = fkTable.getColumn(refCols[j]).getNameString();
                row = t.getEmptyRowData();
                row[0] = pkTableCatalog;
                row[1] = pkTableSchema;
                row[2] = pkTableName;
                row[3] = pkColumnName;
                row[4] = fkTableCatalog;
                row[5] = fkTableSchema;
                row[6] = fkTableName;
                row[7] = fkColumnName;
                row[8] = keySequence;
                row[9] = updateRule;
                row[10] = deleteRule;
                row[11] = fkName;
                row[12] = pkName;
                row[13] = deferrability;
                t.insertSys(session, store, row);
            }
        }
        for (VirtualTableCollection vtable : vtables) {
            int i2;
            if (vtable.getSourceForeignKeys() != null) {
                for (JdbcModel.JdbcForeignKey sourceForeignKey : vtable.getSourceForeignKeys()) {
                    AbstractCollection targetvtable = null;
                    for (i2 = 0; i2 < vtables.size(); ++i2) {
                        if (vtable == vtables.get(i2) || ((VirtualTableCollection)vtables.get(i2)).getExternalSchema() != null && (sourceForeignKey.pkSchemaName == null || !sourceForeignKey.pkSchemaName.equals(((VirtualTableCollection)vtables.get(i2)).getExternalSchema())) || sourceForeignKey.pkTableName == null || !sourceForeignKey.pkTableName.equals(((VirtualTableCollection)vtables.get(i2)).getExternalName())) continue;
                        targetvtable = (VirtualTableCollection)vtables.get(i2);
                        break;
                    }
                    if (targetvtable == null) continue;
                    row = t.getEmptyRowData();
                    row[0] = targetvtable.getCatalogName().getNameString();
                    row[1] = targetvtable.getObjectName().schema.getNameString();
                    row[2] = targetvtable.getObjectName().getNameString();
                    row[3] = sourceForeignKey.pkColumnName;
                    row[4] = vtable.getCatalogName().getNameString();
                    row[5] = vtable.getObjectName().schema.getNameString();
                    row[6] = vtable.getObjectName().getNameString();
                    row[7] = sourceForeignKey.fkColumnName;
                    row[8] = sourceForeignKey.sequenceNumber;
                    row[9] = sourceForeignKey.updateRule;
                    row[10] = sourceForeignKey.deleteRule;
                    row[11] = sourceForeignKey.fkName;
                    row[12] = sourceForeignKey.pkName;
                    row[13] = sourceForeignKey.deferrability;
                    t.insertSys(session, store, row);
                }
            }
            if (vtable.getTargetForeignKeys() == null) continue;
            for (JdbcModel.JdbcForeignKey targetForeignKey : vtable.getTargetForeignKeys()) {
                VirtualTableCollection sourcevtable = null;
                for (i2 = 0; i2 < vtables.size(); ++i2) {
                    if (vtable == vtables.get(i2) || ((VirtualTableCollection)vtables.get(i2)).getExternalSchema() != null && (targetForeignKey.fkSchemaName == null || !targetForeignKey.fkSchemaName.equals(((VirtualTableCollection)vtables.get(i2)).getExternalSchema())) || targetForeignKey.fkTableName == null || !targetForeignKey.fkTableName.equals(((VirtualTableCollection)vtables.get(i2)).getExternalName())) continue;
                    sourcevtable = (VirtualTableCollection)vtables.get(i2);
                    break;
                }
                if (sourcevtable == null) continue;
                row = t.getEmptyRowData();
                row[0] = vtable.getCatalogName().getNameString();
                row[1] = vtable.getObjectName().schema.getNameString();
                row[2] = vtable.getObjectName().getNameString();
                row[3] = targetForeignKey.pkColumnName;
                row[4] = sourcevtable.getCatalogName().getNameString();
                row[5] = sourcevtable.getObjectName().schema.getNameString();
                row[6] = sourcevtable.getObjectName().getNameString();
                row[7] = targetForeignKey.fkColumnName;
                row[8] = targetForeignKey.sequenceNumber;
                row[9] = targetForeignKey.updateRule;
                row[10] = targetForeignKey.deleteRule;
                row[11] = targetForeignKey.fkName;
                row[12] = targetForeignKey.pkName;
                row[13] = targetForeignKey.deferrability;
                t.insertSys(session, store, row);
            }
        }
        return t;
    }

    final Table SYSTEM_INDEXINFO(Session session, PersistentStore store) {
        Table t = this.sysTables[3];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[3]);
            this.addColumn(t, "TABLE_CAT", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_SCHEM", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "NON_UNIQUE", Type.SQL_BOOLEAN);
            this.addColumn(t, "INDEX_QUALIFIER", SQL_IDENTIFIER);
            this.addColumn(t, "INDEX_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "TYPE", Type.SQL_SMALLINT);
            this.addColumn(t, "ORDINAL_POSITION", Type.SQL_SMALLINT);
            this.addColumn(t, "COLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "ASC_OR_DESC", CHARACTER_DATA);
            this.addColumn(t, "CARDINALITY", Type.SQL_INTEGER);
            this.addColumn(t, "PAGES", Type.SQL_INTEGER);
            this.addColumn(t, "FILTER_CONDITION", CHARACTER_DATA);
            this.addColumn(t, "ROW_CARDINALITY", Type.SQL_INTEGER);
            NameManager.ObjectName name = NameManager.newInfoSchemaObjectName(SysSchemaMain.sysTableHsqlNames[3].name, false, 21);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 3, 4, 5, 7}, false);
            return t;
        }
        boolean itable_cat = false;
        boolean itable_schem = true;
        int itable_name = 2;
        int inon_unique = 3;
        int iindex_qualifier = 4;
        int iindex_name = 5;
        int itype = 6;
        int iordinal_position = 7;
        int icolumn_name = 8;
        int iasc_or_desc = 9;
        int icardinality = 10;
        int ipages = 11;
        int ifilter_condition = 12;
        int irow_cardinality = 13;
        Iterator tables = this.database.schemaManager.databaseObjectIterator(3);
        while (tables.hasNext()) {
            Object[] row;
            Table table = (Table)tables.next();
            if (table.isView() || !this.isAccessibleTable(session, table)) continue;
            String tableCatalog = table.getCatalogName().name;
            String tableSchema = table.getSchemaName().name;
            String tableName = table.getObjectName().name;
            Object filterCondition = null;
            if (table instanceof VirtualTable && ((VirtualTable)table).helper instanceof VirtualTableCollection) {
                VirtualTableCollection vtable = (VirtualTableCollection)((VirtualTable)table).helper;
                for (JdbcModel.JdbcIndex index : vtable.getIndexes()) {
                    int k = 0;
                    for (JdbcModel.JdbcIndex.JdbcIndexColumn indexColumn : index.indexColumns) {
                        row = t.getEmptyRowData();
                        row[0] = tableCatalog;
                        row[1] = tableSchema;
                        row[2] = tableName;
                        row[3] = !index.isUnique;
                        row[4] = tableCatalog;
                        row[5] = index.indexName;
                        row[6] = indexColumn.type;
                        row[7] = ValuePool.getInt(++k);
                        row[8] = indexColumn.columnName;
                        row[9] = indexColumn.isAsc ? "A" : "D";
                        row[10] = indexColumn.cardinality;
                        row[11] = indexColumn.pages;
                        row[13] = 0;
                        row[12] = filterCondition;
                        t.insertSys(session, store, row);
                    }
                }
                continue;
            }
            for (int i = 0; i < table.getIndexCount(); ++i) {
                Index index = table.getIndex(i);
                int colCount = table.getIndex(i).getColumnCount();
                if (colCount < 1) continue;
                String indexName = index.getObjectName().name;
                Boolean nonUnique = index.isUnique() ? Boolean.FALSE : Boolean.TRUE;
                Object cardinality = null;
                Integer pages = ValuePool.INTEGER_0;
                Object rowCardinality = null;
                int[] cols = index.getColumns();
                Integer indexType = ValuePool.getInt(3);
                for (int k = 0; k < colCount; ++k) {
                    int col = cols[k];
                    row = t.getEmptyRowData();
                    row[0] = tableCatalog;
                    row[1] = tableSchema;
                    row[2] = tableName;
                    row[3] = nonUnique;
                    row[4] = tableCatalog;
                    row[5] = indexName;
                    row[6] = indexType;
                    row[7] = ValuePool.getInt(k + 1);
                    row[8] = table.getColumn((int)cols[k]).getObjectName().name;
                    row[9] = "A";
                    row[10] = cardinality;
                    row[11] = pages;
                    row[13] = rowCardinality;
                    row[12] = filterCondition;
                    t.insertSys(session, store, row);
                }
            }
        }
        return t;
    }

    final Table SYSTEM_PRIMARYKEYS(Session session, PersistentStore store) {
        Table t = this.sysTables[4];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[4]);
            this.addColumn(t, "TABLE_CAT", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_SCHEM", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "COLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "KEY_SEQ", Type.SQL_SMALLINT);
            this.addColumn(t, "PK_NAME", SQL_IDENTIFIER);
            NameManager.ObjectName name = NameManager.newInfoSchemaObjectName(SysSchemaMain.sysTableHsqlNames[4].name, false, 21);
            t.createPrimaryKeyConstraint(name, new int[]{3, 2, 1, 0}, false);
            return t;
        }
        boolean itable_cat = false;
        boolean itable_schem = true;
        int itable_name = 2;
        int icolumn_name = 3;
        int ikey_seq = 4;
        int ipk_name = 5;
        DataspaceStoreProperties p = this.database.getDataspaceStoreProperties();
        Iterator tables = this.database.schemaManager.databaseObjectIterator(3);
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            if (table.isView() || !this.isAccessibleTable(session, table) || !table.hasPrimaryKey()) continue;
            Constraint constraint = table.getPrimaryConstraint();
            String tableCatalog = table.getCatalogName().name;
            String tableSchema = table.getSchemaName().name;
            String tableName = table.getObjectName().name;
            String primaryKeyName = constraint.getObjectName().name;
            int[] cols = constraint.getMainColumns();
            int colCount = cols.length;
            for (int j = 0; j < colCount; ++j) {
                Object[] row = t.getEmptyRowData();
                row[0] = tableCatalog;
                row[1] = tableSchema;
                row[2] = tableName;
                row[3] = table.getColumn((int)cols[j]).getObjectName().name;
                row[4] = ValuePool.getInt(j + 1);
                row[5] = primaryKeyName;
                t.insertSys(session, store, row);
            }
        }
        return t;
    }

    Table SYSTEM_PROCEDURECOLUMNS(Session session, PersistentStore store) {
        Table t = this.sysTables[5];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[5]);
            this.addColumn(t, "PROCEDURE_CAT", SQL_IDENTIFIER);
            this.addColumn(t, "PROCEDURE_SCHEM", SQL_IDENTIFIER);
            this.addColumn(t, "PROCEDURE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "COLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "COLUMN_TYPE", Type.SQL_SMALLINT);
            this.addColumn(t, "DATA_TYPE", Type.SQL_SMALLINT);
            this.addColumn(t, "TYPE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "PRECISION", Type.SQL_INTEGER);
            this.addColumn(t, "LENGTH", Type.SQL_INTEGER);
            this.addColumn(t, "SCALE", Type.SQL_SMALLINT);
            this.addColumn(t, "RADIX", Type.SQL_SMALLINT);
            this.addColumn(t, "NULLABLE", Type.SQL_SMALLINT);
            this.addColumn(t, "REMARKS", CHARACTER_DATA);
            this.addColumn(t, "COLUMN_DEF", CHARACTER_DATA);
            this.addColumn(t, "SQL_DATA_TYPE", Type.SQL_INTEGER);
            this.addColumn(t, "SQL_DATETIME_SUB", Type.SQL_INTEGER);
            this.addColumn(t, "CHAR_OCTET_LENGTH", Type.SQL_INTEGER);
            this.addColumn(t, "ORDINAL_POSITION", Type.SQL_INTEGER);
            this.addColumn(t, "IS_NULLABLE", CHARACTER_DATA);
            this.addColumn(t, "SPECIFIC_NAME", SQL_IDENTIFIER);
            NameManager.ObjectName name = NameManager.newInfoSchemaObjectName(SysSchemaMain.sysTableHsqlNames[5].name, false, 21);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 19, 17, 4}, false);
            return t;
        }
        Iterator routines = this.database.schemaManager.databaseObjectIterator(19);
        while (routines.hasNext()) {
            RoutineSchema routineSchema = (RoutineSchema)routines.next();
            if (!session.getGrantee().isAccessible(routineSchema)) continue;
            RplScript[] specifics = routineSchema.getSpecificRoutines();
            for (int i = 0; i < specifics.length; ++i) {
                RplScript routine = specifics[i];
                for (int j = 0; j < routine.getParameterCount(); ++j) {
                    ColumnSchema column = routine.getParameter(j);
                    Object[] row = this.createFunctionColumn(t, routine, column.getDataType(), column.getObjectName().name, j + 1, column.getParameterMode(), column.getNullability(), column.isNullable());
                    t.insertSys(session, store, row);
                }
                if (routine.returnsCollection) {
                    Table baseTable = routine.returnCollection.getBaseTable();
                    for (int j = 0; j < baseTable.getColumnCount(); ++j) {
                        ColumnSchema column = baseTable.getColumn(j);
                        Object[] row = this.createFunctionColumn(t, routine, column.getDataType(), column.getObjectName().name, j + 1, 3, column.getNullability(), column.isNullable());
                        t.insertSys(session, store, row);
                    }
                    continue;
                }
                if (routine.getReturnType() == null) continue;
                Object[] row = this.createFunctionColumn(t, routine, routine.getReturnType(), "return", 0, 5, 0, true);
                t.insertSys(session, store, row);
            }
        }
        return t;
    }

    private Object[] createFunctionColumn(Table t, RplScript routine, Type type, String columnName, int ordinal, int mode, int nullability, boolean nullable) {
        boolean specific_cat = false;
        boolean specific_schem = true;
        int procedure_name = 2;
        int parameter_name = 3;
        int parameter_mode = 4;
        int data_type_sql_id = 5;
        int data_type = 6;
        int numeric_precision = 7;
        int byte_length = 8;
        int numeric_scale = 9;
        int numeric_precision_radix = 10;
        int nullable_ = 11;
        int remark = 12;
        int default_val = 13;
        int sql_data_type = 14;
        int sql_datetime_sub = 15;
        int character_octet_length = 16;
        int ordinal_position = 17;
        int is_nullable = 18;
        int specific_name = 19;
        Object[] row = t.getEmptyRowData();
        if (this.database.sqlTranslateTTI) {
            if (type.isIntervalType()) {
                type = ((IntervalType)type).getCharacterType();
            } else if (type.isDateTimeTypeWithZone()) {
                type = ((DateTimeType)type).getDateTimeTypeWithoutZone();
            }
        }
        row[0] = this.database.getCatalogName().name;
        row[1] = routine.getSchemaName().name;
        row[19] = routine.getSpecificName().name;
        row[2] = routine.getObjectName().name;
        row[3] = columnName;
        row[17] = ValuePool.getInt(ordinal);
        row[4] = ValuePool.getInt(mode);
        row[6] = type.getFullNameString();
        row[5] = ValuePool.getInt(type.getJDBCTypeCode());
        row[7] = ValuePool.INTEGER_0;
        row[16] = ValuePool.INTEGER_0;
        if (type.isCharacterType()) {
            row[7] = ValuePool.getInt(type.getJDBCPrecision());
            row[16] = ValuePool.getInt(type.getJDBCPrecision());
        }
        if (type.isBinaryType()) {
            row[7] = ValuePool.getInt(type.getJDBCPrecision());
            row[16] = ValuePool.getInt(type.getJDBCPrecision());
        }
        if (type.isNumberType()) {
            row[7] = ValuePool.getInt(((NumberType)type).getNumericPrecisionInRadix());
            row[10] = ValuePool.getLong(type.getPrecisionRadix());
            if (type.isExactNumberType()) {
                row[9] = ValuePool.getLong(type.scale);
            }
        }
        if (type.isDateTimeType()) {
            row[7] = ValuePool.getInt(type.displaySize());
        }
        row[14] = ValuePool.getInt(type.typeCode);
        row[11] = ValuePool.getInt(nullability);
        row[18] = nullable ? "YES" : "NO";
        return row;
    }

    Table SYSTEM_PROCEDURES(Session session, PersistentStore store) {
        Table t = this.sysTables[6];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[6]);
            this.addColumn(t, "PROCEDURE_CAT", SQL_IDENTIFIER);
            this.addColumn(t, "PROCEDURE_SCHEM", SQL_IDENTIFIER);
            this.addColumn(t, "PROCEDURE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "COL_4", Type.SQL_INTEGER);
            this.addColumn(t, "COL_5", Type.SQL_INTEGER);
            this.addColumn(t, "COL_6", Type.SQL_INTEGER);
            this.addColumn(t, "REMARKS", CHARACTER_DATA);
            this.addColumn(t, "PROCEDURE_TYPE", Type.SQL_SMALLINT);
            this.addColumn(t, "SPECIFIC_NAME", SQL_IDENTIFIER);
            NameManager.ObjectName name = NameManager.newInfoSchemaObjectName(SysSchemaMain.sysTableHsqlNames[6].name, false, 21);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 8}, false);
            return t;
        }
        boolean procedure_catalog = false;
        boolean procedure_schema = true;
        int procedure_name = 2;
        int col_4 = 3;
        int col_5 = 4;
        int col_6 = 5;
        int remarks = 6;
        int procedure_type = 7;
        int specific_name = 8;
        Iterator it = this.database.schemaManager.databaseObjectIterator(25);
        while (it.hasNext()) {
            RplScript routine = (RplScript)it.next();
            Object[] row = t.getEmptyRowData();
            row[0] = this.database.getCatalogName().name;
            row[1] = routine.getSchemaName().name;
            row[2] = routine.getObjectName().name;
            row[6] = routine.getObjectName().comment;
            row[7] = routine.isProcedure() ? ValuePool.INTEGER_1 : ValuePool.INTEGER_2;
            row[8] = routine.getSpecificName().name;
            t.insertSys(session, store, row);
        }
        return t;
    }

    final Table SYSTEM_CONNECTION_PROPERTIES(Session session, PersistentStore store) {
        Table t = this.sysTables[18];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[18]);
            this.addColumn(t, "NAME", SQL_IDENTIFIER);
            this.addColumn(t, "MAX_LEN", Type.SQL_INTEGER);
            this.addColumn(t, "DEFAULT_VALUE", SQL_IDENTIFIER);
            this.addColumn(t, "DESCRIPTION", SQL_IDENTIFIER);
            NameManager.ObjectName name = NameManager.newInfoSchemaObjectName(SysSchemaMain.sysTableHsqlNames[4].name, false, 21);
            t.createPrimaryKeyConstraint(name, new int[]{0}, true);
            return t;
        }
        boolean iname = false;
        boolean imax_len = true;
        int idefault_value = 2;
        int idescription = 3;
        Iterator it = DataspaceStoreProperties.getPropertiesMetaIterator();
        while (it.hasNext()) {
            Object[] meta = (Object[])it.next();
            int propType = (Integer)meta[1];
            if (propType == 1) {
                if (!"dtspace.readonly".equals(meta[0]) && !"dtspace.files_readonly".equals(meta[0])) continue;
            } else if (propType != 2) continue;
            Object[] row = t.getEmptyRowData();
            Object def = meta[4];
            row[0] = meta[0];
            row[1] = ValuePool.getInt(8);
            row[2] = def == null ? null : def.toString();
            row[3] = "see HyperSQL guide";
            t.insertSys(session, store, row);
        }
        return t;
    }

    protected void addProcRows(Session session, Table t, HsqlArrayList l, String cat, String schem, String pName, Integer ip, Integer op, Integer rs, String remark, Integer pType, String specificName, String origin) {
        PersistentStore store = t.getRowStore(session);
        boolean icat = false;
        boolean ischem = true;
        int ipname = 2;
        int iinput_parms = 3;
        int ioutput_parms = 4;
        int iresult_sets = 5;
        int iremark = 6;
        int iptype = 7;
        int isn = 8;
        int iporigin = 9;
        Object[] row = t.getEmptyRowData();
        row[0] = cat;
        row[1] = schem;
        row[2] = pName;
        row[3] = ip;
        row[4] = op;
        row[5] = rs;
        row[6] = remark;
        row[7] = pType;
        row[9] = origin;
        row[8] = specificName;
        t.insertSys(session, store, row);
        if (l != null) {
            int size = l.size();
            for (int i = 0; i < size; ++i) {
                row = t.getEmptyRowData();
                pName = (String)l.get(i);
                row[0] = cat;
                row[1] = schem;
                row[2] = pName;
                row[3] = ip;
                row[4] = op;
                row[5] = rs;
                row[6] = remark;
                row[7] = pType;
                row[9] = "ALIAS";
                row[8] = specificName;
                t.insertSys(session, store, row);
            }
        }
    }

    protected void addPColRows(Session session, Table t, HsqlArrayList l, String cat, String schem, String pName, String cName, Integer cType, Integer dType, String tName, Integer prec, Integer len, Integer scale, Integer radix, Integer nullability, String remark, String colDefault, Integer sqlDataType, Integer sqlDateTimeSub, Integer charOctetLength, Integer ordinalPosition, String isNullable, String specificName) {
        PersistentStore store = t.getRowStore(session);
        boolean icat = false;
        boolean ischem = true;
        int iname = 2;
        int icol_name = 3;
        int icol_type = 4;
        int idata_type = 5;
        int itype_name = 6;
        int iprec = 7;
        int ilength = 8;
        int iscale = 9;
        int iradix = 10;
        int inullable = 11;
        int iremark = 12;
        int icol_default = 13;
        int isql_data_type = 14;
        int isql_datetime_sub = 15;
        int ichar_octet_len = 16;
        int iordinal_position = 17;
        int iis_nullable = 18;
        int ispecific_name = 19;
        Object[] row = t.getEmptyRowData();
        row[0] = cat;
        row[1] = schem;
        row[2] = pName;
        row[3] = cName;
        row[4] = cType;
        row[5] = dType;
        row[6] = tName;
        row[7] = prec;
        row[8] = len;
        row[9] = scale;
        row[10] = radix;
        row[11] = nullability;
        row[12] = remark;
        row[13] = colDefault;
        row[14] = sqlDataType;
        row[15] = sqlDateTimeSub;
        row[16] = charOctetLength;
        row[17] = ordinalPosition;
        row[18] = isNullable;
        row[19] = specificName;
        t.insertSys(session, store, row);
        if (l != null) {
            int size = l.size();
            for (int i = 0; i < size; ++i) {
                row = t.getEmptyRowData();
                pName = (String)l.get(i);
                row[0] = cat;
                row[1] = schem;
                row[2] = pName;
                row[3] = cName;
                row[4] = cType;
                row[5] = dType;
                row[6] = tName;
                row[7] = prec;
                row[8] = len;
                row[9] = scale;
                row[10] = radix;
                row[11] = nullability;
                row[12] = remark;
                row[13] = colDefault;
                row[14] = sqlDataType;
                row[15] = sqlDateTimeSub;
                row[16] = charOctetLength;
                row[17] = ordinalPosition;
                row[18] = isNullable;
                row[19] = specificName;
                t.insertSys(session, store, row);
            }
        }
    }

    final Table SYSTEM_SCHEMAS(Session session, PersistentStore store) {
        Table t = this.sysTables[7];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[7]);
            this.addColumn(t, "TABLE_SCHEM", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "IS_DEFAULT", Type.SQL_BOOLEAN);
            NameManager.ObjectName name = NameManager.newInfoSchemaObjectName(SysSchemaMain.sysTableHsqlNames[7].name, false, 21);
            t.createPrimaryKeyConstraint(name, new int[]{0}, true);
            return t;
        }
        String[] schemas = this.database.schemaManager.getSchemaNamesArray();
        String defschema = this.database.schemaManager.getDefaultSchemaHsqlName().name;
        for (int i = 0; i < schemas.length; ++i) {
            String schema = schemas[i];
            if (!this.isAccessibleDataspace(session, schema)) continue;
            Object[] row = t.getEmptyRowData();
            row[0] = schema;
            row[1] = this.database.getCatalogName().name;
            row[2] = schema.equals(defschema) ? Boolean.TRUE : Boolean.FALSE;
            t.insertSys(session, store, row);
        }
        return t;
    }

    final Table SYSTEM_TABLES(Session session, PersistentStore store) {
        Table t = this.sysTables[8];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[8]);
            this.addColumn(t, "TABLE_CAT", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_SCHEM", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_TYPE", CHARACTER_DATA);
            this.addColumn(t, "REMARKS", CHARACTER_DATA);
            this.addColumn(t, "TYPE_CAT", SQL_IDENTIFIER);
            this.addColumn(t, "TYPE_SCHEM", SQL_IDENTIFIER);
            this.addColumn(t, "TYPE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "SELF_REFERENCING_COL_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "REF_GENERATION", CHARACTER_DATA);
            this.addColumn(t, "HSQLDB_TYPE", SQL_IDENTIFIER);
            this.addColumn(t, "READ_ONLY", Type.SQL_BOOLEAN);
            this.addColumn(t, "COMMIT_ACTION", CHARACTER_DATA);
            NameManager.ObjectName name = NameManager.newInfoSchemaObjectName(SysSchemaMain.sysTableHsqlNames[8].name, false, 21);
            t.createPrimaryKeyConstraint(name, new int[]{3, 1, 2, 0}, false);
            return t;
        }
        boolean itable_cat = false;
        boolean itable_schem = true;
        int itable_name = 2;
        int itable_type = 3;
        int iremark = 4;
        int itype_cat = 5;
        int itype_schem = 6;
        int itype_name = 7;
        int isref_cname = 8;
        int iref_gen = 9;
        int ihsqldb_type = 10;
        int iread_only = 11;
        int icommit_action = 12;
        Iterator tables = this.allTables();
        DITableInfo ti = new DITableInfo();
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            if (!this.isAccessibleTable(session, table)) continue;
            ti.setTable(table);
            Object[] row = t.getEmptyRowData();
            row[0] = this.database.getCatalogName().name;
            row[1] = table.getSchemaName().name;
            row[2] = table.getObjectName().name;
            row[3] = ti.getJDBCStandardType();
            row[4] = ti.getRemark();
            row[10] = ti.getHsqlType();
            Object object = row[11] = table.isDataReadOnly() ? Boolean.TRUE : Boolean.FALSE;
            row[12] = table.isTemp() ? (table.onCommitPreserve() ? "PRESERVE" : "DELETE") : null;
            t.insertSys(session, store, row);
        }
        return t;
    }

    Table SYSTEM_TABLETYPES(Session session, PersistentStore store) {
        Table t = this.sysTables[9];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[9]);
            this.addColumn(t, "TABLE_TYPE", SQL_IDENTIFIER);
            NameManager.ObjectName name = NameManager.newInfoSchemaObjectName(SysSchemaMain.sysTableHsqlNames[9].name, false, 21);
            t.createPrimaryKeyConstraint(name, new int[]{0}, true);
            return t;
        }
        for (int i = 0; i < tableTypes.length; ++i) {
            Object[] row = t.getEmptyRowData();
            row[0] = tableTypes[i];
            t.insertSys(session, store, row);
        }
        return t;
    }

    final Table SYSTEM_TYPEINFO(Session session, PersistentStore store) {
        Object[] row;
        Table t = this.sysTables[10];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[10]);
            this.addColumn(t, "TYPE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "DATA_TYPE", Type.SQL_SMALLINT);
            this.addColumn(t, "PRECISION", Type.SQL_INTEGER);
            this.addColumn(t, "LITERAL_PREFIX", CHARACTER_DATA);
            this.addColumn(t, "LITERAL_SUFFIX", CHARACTER_DATA);
            this.addColumn(t, "CREATE_PARAMS", CHARACTER_DATA);
            this.addColumn(t, "NULLABLE", Type.SQL_SMALLINT);
            this.addColumn(t, "CASE_SENSITIVE", Type.SQL_BOOLEAN);
            this.addColumn(t, "SEARCHABLE", Type.SQL_INTEGER);
            this.addColumn(t, "UNSIGNED_ATTRIBUTE", Type.SQL_BOOLEAN);
            this.addColumn(t, "FIXED_PREC_SCALE", Type.SQL_BOOLEAN);
            this.addColumn(t, "AUTO_INCREMENT", Type.SQL_BOOLEAN);
            this.addColumn(t, "LOCAL_TYPE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "MINIMUM_SCALE", Type.SQL_SMALLINT);
            this.addColumn(t, "MAXIMUM_SCALE", Type.SQL_SMALLINT);
            this.addColumn(t, "SQL_DATA_TYPE", Type.SQL_INTEGER);
            this.addColumn(t, "SQL_DATETIME_SUB", Type.SQL_INTEGER);
            this.addColumn(t, "NUM_PREC_RADIX", Type.SQL_INTEGER);
            this.addColumn(t, "INTERVAL_PRECISION", Type.SQL_INTEGER);
            NameManager.ObjectName name = NameManager.newInfoSchemaObjectName(SysSchemaMain.sysTableHsqlNames[10].name, false, 21);
            t.createPrimaryKeyConstraint(name, new int[]{1, 0}, true);
            return t;
        }
        boolean itype_name = false;
        boolean idata_type = true;
        int iprecision = 2;
        int iliteral_prefix = 3;
        int iliteral_suffix = 4;
        int icreate_params = 5;
        int inullable = 6;
        int icase_sensitive = 7;
        int isearchable = 8;
        int iunsigned_attribute = 9;
        int ifixed_prec_scale = 10;
        int iauto_increment = 11;
        int ilocal_type_name = 12;
        int iminimum_scale = 13;
        int imaximum_scale = 14;
        int isql_data_type = 15;
        int isql_datetime_sub = 16;
        int inum_prec_radix = 17;
        int iinterval_precision = 18;
        Iterator it = Type.typeNames.keySet().iterator();
        boolean translateTTI = this.database.sqlTranslateTTI;
        while (it.hasNext()) {
            String typeName = (String)it.next();
            int typeCode = Type.typeNames.get(typeName);
            Type type = Type.getDefaultType(typeCode);
            if (type == null) continue;
            if (translateTTI) {
                if (type.isIntervalType()) {
                    type = ((IntervalType)type).getCharacterType();
                } else if (type.isDateTimeTypeWithZone()) {
                    type = ((DateTimeType)type).getDateTimeTypeWithoutZone();
                }
            }
            row = t.getEmptyRowData();
            row[0] = typeName;
            row[1] = ValuePool.getInt(type.getJDBCTypeCode());
            long maxPrecision = type.getMaxPrecision();
            Object object = row[2] = maxPrecision > Integer.MAX_VALUE ? ValuePool.INTEGER_MAX : ValuePool.getInt((int)maxPrecision);
            if (type.isBinaryType() || type.isCharacterType() || type.isDateTimeType() || type.isIntervalType()) {
                row[3] = "'";
                row[4] = "'";
            }
            if (type.acceptsPrecision() && type.acceptsScale()) {
                row[5] = "PRECISION,SCALE";
            } else if (type.acceptsPrecision()) {
                row[5] = type.isNumberType() ? "PRECISION" : "LENGTH";
            } else if (type.acceptsScale()) {
                row[5] = "SCALE";
            }
            row[6] = ValuePool.INTEGER_1;
            Object object2 = row[7] = type.isCharacterType() && type.typeCode != 100 ? Boolean.TRUE : Boolean.FALSE;
            row[8] = type.isLobType() ? ValuePool.INTEGER_0 : (type.isCharacterType() || type.isBinaryType() && !type.isBitType() ? ValuePool.getInt(3) : ValuePool.getInt(2));
            row[9] = Boolean.FALSE;
            row[10] = type.typeCode == 2 || type.typeCode == 3 ? Boolean.TRUE : Boolean.FALSE;
            row[11] = type.isIntegralType() ? Boolean.TRUE : Boolean.FALSE;
            row[12] = null;
            row[13] = ValuePool.INTEGER_0;
            row[14] = ValuePool.getInt(type.getMaxScale());
            row[15] = null;
            row[16] = null;
            row[17] = ValuePool.getInt(type.getPrecisionRadix());
            if (type.isIntervalType()) {
                row[18] = null;
            }
            t.insertSys(session, store, row);
        }
        row = t.getEmptyRowData();
        row[0] = "DISTINCT";
        row[1] = ValuePool.getInt(2001);
        return t;
    }

    Table SYSTEM_UDTS(Session session, PersistentStore store) {
        Table t = this.sysTables[11];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[11]);
            this.addColumn(t, "TYPE_CAT", SQL_IDENTIFIER);
            this.addColumn(t, "TYPE_SCHEM", SQL_IDENTIFIER);
            this.addColumn(t, "TYPE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "CLASS_NAME", CHARACTER_DATA);
            this.addColumn(t, "DATA_TYPE", Type.SQL_INTEGER);
            this.addColumn(t, "REMARKS", CHARACTER_DATA);
            this.addColumn(t, "BASE_TYPE", Type.SQL_SMALLINT);
            NameManager.ObjectName name = NameManager.newInfoSchemaObjectName(SysSchemaMain.sysTableHsqlNames[11].name, false, 21);
            t.createPrimaryKeyConstraint(name, null, false);
            return t;
        }
        boolean translateTTI = this.database.sqlTranslateTTI;
        boolean type_catalog = false;
        boolean type_schema = true;
        int type_name = 2;
        int class_name = 3;
        int data_type = 4;
        int remarks = 5;
        int base_type = 6;
        Iterator it = this.database.schemaManager.databaseObjectIterator(13);
        while (it.hasNext()) {
            Type distinct = (Type)it.next();
            if (!distinct.isDistinctType()) continue;
            Object[] data = t.getEmptyRowData();
            Type type = distinct;
            if (translateTTI) {
                if (type.isIntervalType()) {
                    type = ((IntervalType)type).getCharacterType();
                } else if (type.isDateTimeTypeWithZone()) {
                    type = ((DateTimeType)type).getDateTimeTypeWithoutZone();
                }
            }
            data[0] = this.database.getCatalogName().name;
            data[1] = distinct.getSchemaName().name;
            data[2] = distinct.getObjectName().name;
            data[3] = type.getJDBCClassName();
            data[4] = ValuePool.getInt(2001);
            data[5] = null;
            data[6] = ValuePool.getInt(type.getJDBCTypeCode());
            t.insertSys(session, store, data);
        }
        return t;
    }

    Table SYSTEM_VERSIONCOLUMNS(Session session, PersistentStore store) {
        Table t = this.sysTables[13];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[13]);
            this.addColumn(t, "SCOPE", Type.SQL_INTEGER);
            this.addColumn(t, "COLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "DATA_TYPE", Type.SQL_SMALLINT);
            this.addColumn(t, "TYPE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "COLUMN_SIZE", Type.SQL_SMALLINT);
            this.addColumn(t, "BUFFER_LENGTH", Type.SQL_INTEGER);
            this.addColumn(t, "DECIMAL_DIGITS", Type.SQL_SMALLINT);
            this.addColumn(t, "PSEUDO_COLUMN", Type.SQL_SMALLINT);
            this.addColumn(t, "TABLE_CAT", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_SCHEM", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_NAME", SQL_IDENTIFIER);
            NameManager.ObjectName name = NameManager.newInfoSchemaObjectName(SysSchemaMain.sysTableHsqlNames[13].name, false, 21);
            t.createPrimaryKeyConstraint(name, null, false);
            return t;
        }
        return t;
    }

    Table SYSTEM_USERS(Session session, PersistentStore store) {
        Table t = this.sysTables[12];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[12]);
            this.addColumn(t, "USER_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "ADMIN", Type.SQL_BOOLEAN);
            this.addColumn(t, "INITIAL_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "AUTHENTICATION", SQL_IDENTIFIER);
            this.addColumn(t, "PASSWORD_DIGEST", SQL_IDENTIFIER);
            NameManager.ObjectName name = NameManager.newInfoSchemaObjectName(SysSchemaMain.sysTableHsqlNames[12].name, false, 21);
            t.createPrimaryKeyConstraint(name, new int[]{0}, true);
            return t;
        }
        HsqlArrayList users = this.database.getUserManager().listVisibleUsers(session);
        for (int i = 0; i < users.size(); ++i) {
            Object[] row = t.getEmptyRowData();
            UserWrapper user = (UserWrapper)users.get(i);
            NameManager.ObjectName initialSchema = user.getInitialSchema();
            row[0] = user.getObjectName().getNameString();
            row[1] = ValuePool.getBoolean(user.isAdmin());
            row[2] = initialSchema == null ? null : initialSchema.name;
            row[3] = "ANY";
            row[4] = "***";
            t.insertSys(session, store, row);
        }
        return t;
    }

    final Table COLUMN_PRIVILEGES(Session session, PersistentStore store) {
        Table t = this.sysTables[33];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[33]);
            this.addColumn(t, "GRANTOR", SQL_IDENTIFIER);
            this.addColumn(t, "GRANTEE", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "COLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "PRIVILEGE_TYPE", CHARACTER_DATA);
            this.addColumn(t, "IS_GRANTABLE", YES_OR_NO);
            NameManager.ObjectName name = NameManager.newInfoSchemaObjectName(SysSchemaMain.sysTableHsqlNames[33].name, false, 21);
            t.createPrimaryKeyConstraint(name, new int[]{2, 3, 4, 5, 6, 1, 0}, false);
            return t;
        }
        boolean grantor = false;
        boolean grantee = true;
        int table_catalog = 2;
        int table_schema = 3;
        int table_name = 4;
        int column_name = 5;
        int privilege_type = 6;
        int is_grantable = 7;
        OrderedHashSet grantees = session.getGrantee().getGranteeAndAllRolesWithPublic();
        Iterator tables = this.allTables();
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            String tableName = table.getObjectName().name;
            String tableCatalog = this.database.getCatalogName().name;
            String tableSchema = table.getSchemaName().name;
            for (int i = 0; i < grantees.size(); ++i) {
                Grantee granteeObject = (Grantee)grantees.get(i);
                OrderedHashSet rights = granteeObject.getAllDirectPrivileges(table);
                OrderedHashSet grants = granteeObject.getAllGrantedPrivileges(table);
                if (!grants.isEmpty()) {
                    grants.addAll(rights);
                    rights = grants;
                }
                for (int j = 0; j < rights.size(); ++j) {
                    Right right = (Right)rights.get(j);
                    Right grantableRight = right.getGrantableRights();
                    for (int k = 0; k < Right.privilegeTypes.length; ++k) {
                        OrderedHashSet columnList = right.getColumnsForPrivilege(table, Right.privilegeTypes[k]);
                        OrderedHashSet grantableList = grantableRight.getColumnsForPrivilege(table, Right.privilegeTypes[k]);
                        for (int l = 0; l < columnList.size(); ++l) {
                            NameManager.ObjectName fullName = (NameManager.ObjectName)columnList.get(l);
                            Object[] row = t.getEmptyRowData();
                            row[0] = right.getGrantor().getObjectName().name;
                            row[1] = right.getGrantee().getObjectName().name;
                            row[2] = tableCatalog;
                            row[3] = tableSchema;
                            row[4] = tableName;
                            row[5] = fullName.name;
                            row[6] = Right.privilegeNames[k];
                            row[7] = right.getGrantee() == table.getOwner() || grantableList.contains(fullName) ? "YES" : "NO";
                            try {
                                t.insertSys(session, store, row);
                                continue;
                            }
                            catch (DataspaceException dataspaceException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        }
        return t;
    }

    final Table SEQUENCES(Session session, PersistentStore store) {
        Table t = this.sysTables[69];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[69]);
            this.addColumn(t, "SEQUENCE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "SEQUENCE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "SEQUENCE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "DATA_TYPE", CHARACTER_DATA);
            this.addColumn(t, "NUMERIC_PRECISION", CARDINAL_NUMBER);
            this.addColumn(t, "NUMERIC_PRECISION_RADIX", CARDINAL_NUMBER);
            this.addColumn(t, "NUMERIC_SCALE", CARDINAL_NUMBER);
            this.addColumn(t, "MAXIMUM_VALUE", CHARACTER_DATA);
            this.addColumn(t, "MINIMUM_VALUE", CHARACTER_DATA);
            this.addColumn(t, "INCREMENT", CHARACTER_DATA);
            this.addColumn(t, "CYCLE_OPTION", YES_OR_NO);
            this.addColumn(t, "DECLARED_DATA_TYPE", CHARACTER_DATA);
            this.addColumn(t, "DECLARED_NUMERIC_PRECISION", CARDINAL_NUMBER);
            this.addColumn(t, "DECLARED_NUMERIC_SCALE", CARDINAL_NUMBER);
            this.addColumn(t, "START_WITH", CHARACTER_DATA);
            this.addColumn(t, "NEXT_VALUE", CHARACTER_DATA);
            NameManager.ObjectName name = NameManager.newInfoSchemaObjectName(SysSchemaMain.sysTableHsqlNames[69].name, false, 21);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2}, false);
            return t;
        }
        boolean sequence_catalog = false;
        boolean sequence_schema = true;
        int sequence_name = 2;
        int data_type = 3;
        int numeric_precision = 4;
        int numeric_precision_radix = 5;
        int numeric_scale = 6;
        int maximum_value = 7;
        int minimum_value = 8;
        int increment = 9;
        int cycle_option = 10;
        int declared_data_type = 11;
        int declared_numeric_precision = 12;
        int declared_numeric_scale = 13;
        int start_with = 14;
        int next_value = 15;
        Iterator it = this.database.schemaManager.databaseObjectIterator(8);
        while (it.hasNext()) {
            NumberSequence sequence = (NumberSequence)it.next();
            if (!session.getGrantee().isAccessible(sequence)) continue;
            Object[] row = t.getEmptyRowData();
            NumberType type = (NumberType)sequence.getDataType();
            int radix = type.typeCode == 2 || type.typeCode == 3 ? 10 : 2;
            row[0] = this.database.getCatalogName().name;
            row[1] = sequence.getSchemaName().name;
            row[2] = sequence.getObjectName().name;
            row[3] = sequence.getDataType().getFullNameString();
            row[4] = ValuePool.getInt(type.getPrecision());
            row[5] = ValuePool.getInt(radix);
            row[6] = ValuePool.INTEGER_0;
            row[7] = String.valueOf(sequence.getMaxValue());
            row[8] = String.valueOf(sequence.getMinValue());
            row[9] = String.valueOf(sequence.getIncrement());
            row[10] = sequence.isCycle() ? "YES" : "NO";
            row[11] = row[3];
            row[12] = row[4];
            row[13] = row[13];
            row[14] = String.valueOf(sequence.getStartValue());
            row[15] = String.valueOf(sequence.peek());
            t.insertSys(session, store, row);
        }
        return t;
    }

    final Table SYSTEM_SEQUENCES(Session session, PersistentStore store) {
        Table t = this.sysTables[14];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[14]);
            this.addColumn(t, "SEQUENCE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "SEQUENCE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "SEQUENCE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "DATA_TYPE", CHARACTER_DATA);
            this.addColumn(t, "NUMERIC_PRECISION", CARDINAL_NUMBER);
            this.addColumn(t, "NUMERIC_PRECISION_RADIX", CARDINAL_NUMBER);
            this.addColumn(t, "NUMERIC_SCALE", CARDINAL_NUMBER);
            this.addColumn(t, "MAXIMUM_VALUE", CHARACTER_DATA);
            this.addColumn(t, "MINIMUM_VALUE", CHARACTER_DATA);
            this.addColumn(t, "INCREMENT", CHARACTER_DATA);
            this.addColumn(t, "CYCLE_OPTION", YES_OR_NO);
            this.addColumn(t, "DECLARED_DATA_TYPE", CHARACTER_DATA);
            this.addColumn(t, "DECLARED_NUMERIC_PRECISION", CARDINAL_NUMBER);
            this.addColumn(t, "DECLARED_NUMERIC_SCALE", CARDINAL_NUMBER);
            this.addColumn(t, "START_WITH", CHARACTER_DATA);
            this.addColumn(t, "NEXT_VALUE", CHARACTER_DATA);
            NameManager.ObjectName name = NameManager.newInfoSchemaObjectName(SysSchemaMain.sysTableHsqlNames[14].name, false, 21);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2}, false);
            return t;
        }
        boolean sequence_catalog = false;
        boolean sequence_schema = true;
        int sequence_name = 2;
        int data_type = 3;
        int numeric_precision = 4;
        int numeric_precision_radix = 5;
        int numeric_scale = 6;
        int maximum_value = 7;
        int minimum_value = 8;
        int increment = 9;
        int cycle_option = 10;
        int declared_data_type = 11;
        int declared_numeric_precision = 12;
        int declared_numeric_scale = 13;
        int start_with = 14;
        int next_value = 15;
        Iterator it = this.database.schemaManager.databaseObjectIterator(8);
        while (it.hasNext()) {
            NumberSequence sequence = (NumberSequence)it.next();
            if (!session.getGrantee().isAccessible(sequence)) continue;
            Object[] row = t.getEmptyRowData();
            NumberType type = (NumberType)sequence.getDataType();
            int radix = type.typeCode == 2 || type.typeCode == 3 ? 10 : 2;
            row[0] = this.database.getCatalogName().name;
            row[1] = sequence.getSchemaName().name;
            row[2] = sequence.getObjectName().name;
            row[3] = sequence.getDataType().getFullNameString();
            row[4] = ValuePool.getInt(type.getPrecision());
            row[5] = ValuePool.getInt(radix);
            row[6] = ValuePool.INTEGER_0;
            row[7] = String.valueOf(sequence.getMaxValue());
            row[8] = String.valueOf(sequence.getMinValue());
            row[9] = String.valueOf(sequence.getIncrement());
            row[10] = sequence.isCycle() ? "YES" : "NO";
            row[11] = row[3];
            row[12] = row[4];
            row[13] = row[13];
            row[14] = String.valueOf(sequence.getStartValue());
            row[15] = String.valueOf(sequence.peek());
            t.insertSys(session, store, row);
        }
        return t;
    }

    final Table TABLE_PRIVILEGES(Session session, PersistentStore store) {
        Table t = this.sysTables[77];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[77]);
            this.addColumn(t, "GRANTOR", SQL_IDENTIFIER);
            this.addColumn(t, "GRANTEE", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "PRIVILEGE_TYPE", CHARACTER_DATA);
            this.addColumn(t, "IS_GRANTABLE", YES_OR_NO);
            this.addColumn(t, "WITH_HIERARCHY", YES_OR_NO);
            NameManager.ObjectName name = NameManager.newInfoSchemaObjectName(SysSchemaMain.sysTableHsqlNames[69].name, false, 21);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 3, 4, 5, 6}, false);
            return t;
        }
        boolean grantor = false;
        boolean grantee = true;
        int table_catalog = 2;
        int table_schema = 3;
        int table_name = 4;
        int privilege_type = 5;
        int is_grantable = 6;
        int with_hierarchy = 7;
        OrderedHashSet grantees = session.getGrantee().getGranteeAndAllRolesWithPublic();
        Iterator tables = this.allTables();
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            String tableName = table.getObjectName().name;
            String tableCatalog = table.getCatalogName().name;
            String tableSchema = table.getSchemaName().name;
            for (int i = 0; i < grantees.size(); ++i) {
                Grantee granteeObject = (Grantee)grantees.get(i);
                OrderedHashSet rights = granteeObject.getAllDirectPrivileges(table);
                OrderedHashSet grants = granteeObject.getAllGrantedPrivileges(table);
                if (!grants.isEmpty()) {
                    grants.addAll(rights);
                    rights = grants;
                }
                for (int j = 0; j < rights.size(); ++j) {
                    Right right = (Right)rights.get(j);
                    Right grantableRight = right.getGrantableRights();
                    for (int k = 0; k < Right.privilegeTypes.length; ++k) {
                        if (!right.canAccessFully(Right.privilegeTypes[k])) continue;
                        String privilege = Right.privilegeNames[k];
                        Object[] row = t.getEmptyRowData();
                        row[0] = right.getGrantor().getObjectName().name;
                        row[1] = right.getGrantee().getObjectName().name;
                        row[2] = tableCatalog;
                        row[3] = tableSchema;
                        row[4] = tableName;
                        row[5] = privilege;
                        row[6] = right.getGrantee() == table.getOwner() || grantableRight.canAccessFully(Right.privilegeTypes[k]) ? "YES" : "NO";
                        row[7] = "NO";
                        try {
                            t.insertSys(session, store, row);
                            continue;
                        }
                        catch (DataspaceException dataspaceException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return t;
    }

    Table TABLES(Session session, PersistentStore store) {
        Table t = this.sysTables[78];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[78]);
            this.addColumn(t, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_TYPE", CHARACTER_DATA);
            this.addColumn(t, "SELF_REFERENCING_COLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "REFERENCE_GENERATION", CHARACTER_DATA);
            this.addColumn(t, "USER_DEFINED_TYPE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "USER_DEFINED_TYPE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "USER_DEFINED_TYPE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "IS_INSERTABLE_INTO", YES_OR_NO);
            this.addColumn(t, "IS_TYPED", YES_OR_NO);
            this.addColumn(t, "COMMIT_ACTION", CHARACTER_DATA);
            NameManager.ObjectName name = NameManager.newInfoSchemaObjectName(SysSchemaMain.sysTableHsqlNames[78].name, false, 21);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2}, false);
            return t;
        }
        boolean table_catalog = false;
        boolean table_schema = true;
        int table_name = 2;
        int table_type = 3;
        int self_referencing_column_name = 4;
        int reference_generation = 5;
        int user_defined_type_catalog = 6;
        int user_defined_type_schema = 7;
        int user_defined_type_name = 8;
        int is_insertable_into = 9;
        int is_typed = 10;
        int commit_action = 11;
        Iterator tables = this.allTables();
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            if (!this.isAccessibleTable(session, table)) continue;
            Object[] row = t.getEmptyRowData();
            row[0] = this.database.getCatalogName().name;
            row[1] = table.getSchemaName().name;
            row[2] = table.getObjectName().name;
            switch (table.getTableType()) {
                case 1: 
                case 9: {
                    row[3] = "VIEW";
                    row[9] = table.isInsertable() ? "YES" : "NO";
                    break;
                }
                case 3: 
                case 7: {
                    row[3] = "GLOBAL TEMPORARY";
                    row[9] = "YES";
                    break;
                }
                default: {
                    row[3] = "BASE TABLE";
                    row[9] = table.isInsertable() ? "YES" : "NO";
                }
            }
            row[4] = null;
            row[5] = null;
            row[6] = null;
            row[7] = null;
            row[8] = null;
            row[10] = "NO";
            row[11] = table.isTemp() ? (table.onCommitPreserve() ? "PRESERVE" : "DELETE") : null;
            t.insertSys(session, store, row);
        }
        return t;
    }

    Table COLLECTIONS(Session session, PersistentStore store) {
        Table t = this.sysTables[94];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[94]);
            this.addColumn(t, "COLLECTION_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "COLLECTION_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "COLLECTION_TYPE", CHARACTER_DATA);
            this.addColumn(t, "SAMPLE_COUNT", CARDINAL_NUMBER);
            NameManager.ObjectName name = NameManager.newInfoSchemaObjectName(SysSchemaMain.sysTableHsqlNames[94].name, false, 21);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2}, false);
            return t;
        }
        boolean schema = false;
        boolean name = true;
        int type = 2;
        int sampleCOunt = 3;
        Iterator collections = this.allCollections();
        while (collections.hasNext()) {
            AbstractCollection collection = (AbstractCollection)collections.next();
            if (!this.isAccessibleCollection(session, collection) && !session.isAdmin()) continue;
            Object[] row = t.getEmptyRowData();
            row[0] = collection.getSchemaName().name;
            row[1] = collection.getObjectName().name;
            row[2] = AbstractCollection.getCollectionTypeName(collection.getCollectionType());
            row[3] = collection.getBaseTable() != null && collection.getBaseTable().store != null ? collection.getBaseTable().store.elementCountGetOnly() : -1L;
            t.insertSys(session, store, row);
        }
        return t;
    }

    Table CONSUMERS(Session session, PersistentStore store) {
        Table t = this.sysTables[95];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[95]);
            this.addColumn(t, "NODE", CHARACTER_DATA);
            this.addColumn(t, "COMPONENT_TYPE", CHARACTER_DATA);
            this.addColumn(t, "COMPONENT_NAME", CHARACTER_DATA);
            this.addColumn(t, "NAME", CHARACTER_DATA);
            this.addColumn(t, "MODE", CHARACTER_DATA);
            this.addColumn(t, "SCOPE", CHARACTER_DATA);
            this.addColumn(t, "EVENT_ID", CHARACTER_DATA);
            this.addColumn(t, "SELECTOR", CHARACTER_DATA);
            this.addColumn(t, "STATE", CHARACTER_DATA);
            this.addColumn(t, "TIME", CHARACTER_DATA);
            NameManager.ObjectName name = NameManager.newInfoSchemaObjectName(SysSchemaMain.sysTableHsqlNames[95].name, false, 21);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 3}, false);
            return t;
        }
        boolean node = false;
        boolean component_type = true;
        int component_name = 2;
        int name = 3;
        int mode = 4;
        int scope = 5;
        int event_id = 6;
        int selector = 7;
        int state = 8;
        int time = 9;
        Moderator moderator = DataspaceStoreManager.getRuntimeContext().getModerator();
        List<ConsumerReference> consumers = moderator.getConsumers(EventScope.INHERITED);
        for (ConsumerReference consumer : consumers) {
            List<String> nameTokens = null;
            try {
                nameTokens = ModeratorUtils.splitConsumerFullName(consumer.getName());
            }
            catch (Exception ex) {
                Trace.logError(SysSchemaMain.class, "Wrong consumer name format. " + ex.getMessage());
                continue;
            }
            Object[] row = t.getEmptyRowData();
            row[0] = nameTokens.get(0);
            row[1] = nameTokens.get(1);
            row[2] = nameTokens.get(2);
            row[3] = nameTokens.get(3);
            switch (consumer.getExchangeRole()) {
                case ASYNC_CONSUMER: {
                    row[4] = "ASYNC";
                    break;
                }
                case DIRECT_CONSUMER: {
                    row[4] = "DIRECT";
                    break;
                }
                case RECEIVER: {
                    row[4] = "RECEIVER";
                    break;
                }
                case REQUEST_CONSUMER: {
                    row[4] = "REQUEST_CONSUMER";
                }
            }
            row[5] = consumer.getEventScope().name();
            if (consumer instanceof EventConsumerReference) {
                EventConsumerReference eventConsumer = (EventConsumerReference)consumer;
                row[6] = eventConsumer.getEventFilter();
                row[7] = eventConsumer.getEventSelector() != null ? "true" : "false";
            } else if (consumer instanceof RequestConsumerReference) {
                row[6] = "#";
                row[7] = "false";
            } else {
                row[6] = "";
                row[7] = "";
            }
            ConsumerState consumerState = consumer.getCurrentState();
            if (consumerState != null) {
                row[8] = consumerState.getWorkingState().toString();
                row[9] = consumerState.getWorkingState() == ConsumerState.WorkingState.BUSY ? Long.toString(System.currentTimeMillis() - consumerState.getStartTime()) : "";
            } else {
                row[8] = "";
                row[9] = "";
            }
            t.insertSys(session, store, row);
        }
        return t;
    }

    Table TIMERS(Session session, PersistentStore store) {
        Table t = this.sysTables[96];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[96]);
            this.addColumn(t, "DATASPACE_NAME", CHARACTER_DATA);
            this.addColumn(t, "TIMER_NAME", CHARACTER_DATA);
            this.addColumn(t, "TIMER_GROUP", CHARACTER_DATA);
            this.addColumn(t, "STATE", CHARACTER_DATA);
            this.addColumn(t, "INTERVAL", Type.SQL_BIGINT);
            this.addColumn(t, "REPEAT_COUNT", Type.SQL_INTEGER);
            this.addColumn(t, "DURATION", Type.SQL_BIGINT);
            this.addColumn(t, "REMAINING_TIME", Type.SQL_BIGINT);
            this.addColumn(t, "REMAINING_REPEAT_COUNT", Type.SQL_INTEGER);
            NameManager.ObjectName name = NameManager.newInfoSchemaObjectName(SysSchemaMain.sysTableHsqlNames[96].name, false, 21);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1}, false);
            return t;
        }
        boolean dataspace_name = false;
        boolean timer_name = true;
        int group = 2;
        int state = 3;
        int interval = 4;
        int repeat_count = 5;
        int duration = 6;
        int remaining_time = 7;
        int remaining_repeat_count = 8;
        FabricTimerManager manager = FabricTimerManager.getInstance();
        for (DataspaceSchema schema : this.database.schemaManager.getAllSchemas()) {
            Iterator iter = session.dataspaceStore.schemaManager.dataspaceObjectIterator(schema.getObjectName().name, 30);
            while (iter.hasNext()) {
                TimerObject schemaObject = (TimerObject)iter.next();
                FabricTimer timer = manager.getTimer(schemaObject.getTimerGroup(), schemaObject.getObjectName().name);
                Object[] row = t.getEmptyRowData();
                row[0] = schema.getObjectName().name;
                row[1] = schemaObject.getObjectName().name;
                row[2] = schemaObject.getTimerGroup();
                if (timer != null) {
                    row[3] = timer.getState().name();
                    row[4] = timer.getInterval();
                    row[5] = timer.getRepeatCount();
                    row[6] = timer.getDuration();
                    row[7] = timer.getRemainingTime();
                    row[8] = timer.getRemainingRepeatCount();
                } else {
                    row[3] = FabricTimerState.EXPIRED.name();
                    row[4] = schemaObject.getInterval();
                    row[5] = schemaObject.getRepeatCount();
                    row[6] = 0;
                    row[7] = 0;
                    row[8] = 0;
                }
                t.insertSys(session, store, row);
            }
        }
        return t;
    }

    Table SOURCE_STREAMS(Session session, PersistentStore store) {
        Table t = this.sysTables[97];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[97]);
            this.addColumn(t, "DATASPACE_NAME", CHARACTER_DATA);
            this.addColumn(t, "STREAM_NAME", CHARACTER_DATA);
            this.addColumn(t, "STATE", CHARACTER_DATA);
            this.addColumn(t, "INTERVAL", Type.SQL_BIGINT);
            this.addColumn(t, "EVENT_ID", CHARACTER_DATA);
            this.addColumn(t, "PROCESSED_EVENTS", Type.SQL_BIGINT);
            this.addColumn(t, "ELAPSED_TIME", Type.SQL_BIGINT);
            this.addColumn(t, "LAST_ERROR", CHARACTER_DATA);
            NameManager.ObjectName name = NameManager.newInfoSchemaObjectName(SysSchemaMain.sysTableHsqlNames[97].name, false, 21);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1}, false);
            return t;
        }
        boolean dataspace_name = false;
        boolean stream_name = true;
        int state = 2;
        int interval = 3;
        int event_id = 4;
        int processed_rows = 5;
        int elapsed_time = 6;
        int last_error = 7;
        for (DataspaceSchema schema : this.database.schemaManager.getAllSchemas()) {
            Iterator iter = session.dataspaceStore.schemaManager.dataspaceObjectIterator(schema.getObjectName().name, 4);
            while (iter.hasNext()) {
                Collection schemaObject = (Collection)iter.next();
                if (schemaObject.getCollectionType() != CollectionType.SOURCE_STREAM) continue;
                SourceStreamCollection sourceStream = (SourceStreamCollection)schemaObject;
                Object[] row = t.getEmptyRowData();
                row[0] = schema.getObjectName().name;
                row[1] = sourceStream.getObjectName().name;
                row[2] = sourceStream.getState();
                row[3] = sourceStream.getInterval();
                row[4] = sourceStream.getEventId();
                row[5] = sourceStream.getNumberOfProcessedEvents();
                row[6] = sourceStream.getElapsedTime();
                row[7] = sourceStream.getLastError();
                t.insertSys(session, store, row);
            }
        }
        return t;
    }

    Table ACTORS(Session session, PersistentStore store) {
        Table t = this.sysTables[98];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[98]);
            this.addColumn(t, "DATASPACE_NAME", CHARACTER_DATA);
            this.addColumn(t, "ACTOR_NAME", CHARACTER_DATA);
            this.addColumn(t, "ENABLED", Type.SQL_BOOLEAN);
            this.addColumn(t, "EVENTS", new ArrayType(CHARACTER_DATA, 0));
            this.addColumn(t, "EVENT_SET_TYPE", CHARACTER_DATA);
            NameManager.ObjectName name = NameManager.newInfoSchemaObjectName(SysSchemaMain.sysTableHsqlNames[98].name, false, 21);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1}, false);
            return t;
        }
        boolean dataspace_name = false;
        boolean actor_name = true;
        int enabled = 2;
        int events = 3;
        int event_set_type = 4;
        for (DataspaceSchema schema : this.database.schemaManager.getAllSchemas()) {
            Iterator iter = session.dataspaceStore.schemaManager.dataspaceObjectIterator(schema.getObjectName().name, 32);
            while (iter.hasNext()) {
                Actor eventActor = (Actor)iter.next();
                Object[] row = t.getEmptyRowData();
                row[0] = schema.getObjectName().name;
                row[1] = eventActor.getObjectName().name;
                row[2] = eventActor.isEnabled();
                String[] eventsArr = new String[eventActor.getActorEntries().size()];
                int counter = -1;
                for (Actor.ActorEntry entry : eventActor.getActorEntries()) {
                    Object eventInfo = StringUtils.wrapEventId(entry.getEventId());
                    if (entry.getSelector() != null) {
                        eventInfo = (String)eventInfo + " when (" + entry.getSelector() + ")";
                    }
                    eventsArr[++counter] = eventInfo;
                }
                row[3] = eventsArr;
                row[4] = eventActor.getEventSetType() == null ? "-" : eventActor.getEventSetType().name();
                t.insertSys(session, store, row);
            }
        }
        return t;
    }

    Table REFERENCE_LINKS(Session session, PersistentStore store) {
        Table t = this.sysTables[100];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[100]);
            this.addColumn(t, "DATASPACE_NAME", CHARACTER_DATA);
            this.addColumn(t, "REFERENCE_LINK_NAME", CHARACTER_DATA);
            this.addColumn(t, "SOURCE_DATASPACE_NAME", CHARACTER_DATA);
            this.addColumn(t, "SOURCE_TABLE_NAME", CHARACTER_DATA);
            this.addColumn(t, "SOURCE_COLUMN_NAME", CHARACTER_DATA);
            this.addColumn(t, "SOURCE_COLUMN_SPATH", CHARACTER_DATA);
            this.addColumn(t, "TARGET_DATASPACE_NAME", CHARACTER_DATA);
            this.addColumn(t, "TARGET_TABLE_NAME", CHARACTER_DATA);
            this.addColumn(t, "TARGET_COLUMN_NAME", CHARACTER_DATA);
            this.addColumn(t, "TARGET_COLUMN_SPATH", CHARACTER_DATA);
            this.addColumn(t, "NULLABLE", Type.SQL_BOOLEAN);
            this.addColumn(t, "DESCRIPTION", CHARACTER_DATA);
            this.addColumn(t, "FACETS_JOIN", CHARACTER_DATA);
            this.addColumn(t, "ASPECTS_JOIN", CHARACTER_DATA);
            NameManager.ObjectName name = NameManager.newInfoSchemaObjectName(SysSchemaMain.sysTableHsqlNames[100].name, false, 21);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1}, false);
            return t;
        }
        boolean dataspace_name = false;
        boolean reference_link_name = true;
        int source_dataspace_name = 2;
        int source_table_name = 3;
        int source_column_name = 4;
        int source_column_spath = 5;
        int target_dataspace_name = 6;
        int target_table_name = 7;
        int target_column_name = 8;
        int target_column_spath = 9;
        int nullable = 10;
        int description = 11;
        int facets_join = 12;
        int aspects_join = 13;
        for (DataspaceSchema schema : this.database.schemaManager.getAllSchemas()) {
            Iterator iter = session.dataspaceStore.schemaManager.dataspaceObjectIterator(schema.getObjectName().name, 37);
            while (iter.hasNext()) {
                ReferenceLink referenceLink = (ReferenceLink)iter.next();
                Object[] row = t.getEmptyRowData();
                row[0] = schema.getObjectName().name;
                row[1] = referenceLink.getObjectName().name;
                row[2] = referenceLink.getSourceColumnObjectName().schema != null ? referenceLink.getSourceColumnObjectName().schema.name : schema.getObjectName().name;
                row[3] = referenceLink.getSourceColumnObjectName().parent.name;
                row[4] = referenceLink.getSourceColumnObjectName().name;
                row[5] = referenceLink.getSourceSpath();
                row[6] = referenceLink.getSourceColumnObjectName().schema != null ? referenceLink.getTargetColumnObjectName().schema.name : schema.getObjectName().name;
                row[7] = referenceLink.getTargetColumnObjectName().parent.name;
                row[8] = referenceLink.getTargetColumnObjectName().name;
                row[9] = referenceLink.getTargetSpath();
                row[10] = referenceLink.isNullable();
                row[11] = referenceLink.getDescription();
                row[12] = referenceLink.getFacetsJoin() != null ? referenceLink.getFacetsJoin().getSQL() : null;
                row[13] = referenceLink.getAspectsJoin() != null ? referenceLink.getAspectsJoin().getSQL() : null;
                t.insertSys(session, store, row);
            }
        }
        return t;
    }

    Table SERVERS(Session session, PersistentStore store) {
        Table t = this.sysTables[99];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[99]);
            this.addColumn(t, "DATASPACE_NAME", CHARACTER_DATA);
            this.addColumn(t, "SERVER_NAME", CHARACTER_DATA);
            this.addColumn(t, "FACTORY_TYPE", CHARACTER_DATA);
            this.addColumn(t, "FACTORY_NAME", CHARACTER_DATA);
            this.addColumn(t, "STARTED", Type.SQL_BOOLEAN);
            this.addColumn(t, "SERVER_ROLE", CHARACTER_DATA);
            this.addColumn(t, "SERVER_TYPE", CHARACTER_DATA);
            this.addColumn(t, "INVALID", Type.SQL_BOOLEAN);
            NameManager.ObjectName name = NameManager.newInfoSchemaObjectName(SysSchemaMain.sysTableHsqlNames[99].name, false, 21);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1}, false);
            return t;
        }
        boolean dataspace_name = false;
        boolean server_name = true;
        int factory_type = 2;
        int factory_name = 3;
        int started = 4;
        int server_role = 5;
        int server_type = 6;
        int invalid = 7;
        for (DataspaceSchema schema : this.database.schemaManager.getAllSchemas()) {
            Iterator iter = session.dataspaceStore.schemaManager.dataspaceObjectIterator(schema.getObjectName().name, 27);
            while (iter.hasNext()) {
                ServerObject server = (ServerObject)iter.next();
                Object[] row = t.getEmptyRowData();
                row[0] = schema.getObjectName().name;
                row[1] = server.getObjectName().name;
                row[2] = server.getFactoryType();
                row[3] = server.getFactoryName();
                row[4] = server.isRunning();
                row[5] = server.getServerRole().name();
                row[6] = server.getServerType();
                row[7] = server.isInvalid();
                t.insertSys(session, store, row);
            }
        }
        return t;
    }

    final Table INFORMATION_SCHEMA_CATALOG_NAME(Session session, PersistentStore store) {
        Table t = this.sysTables[43];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[43]);
            this.addColumn(t, "CATALOG_NAME", SQL_IDENTIFIER);
            NameManager.ObjectName name = NameManager.newInfoSchemaObjectName(SysSchemaMain.sysTableHsqlNames[43].name, false, 21);
            t.createPrimaryKeyConstraint(name, new int[]{0}, true);
            return t;
        }
        Object[] row = t.getEmptyRowData();
        row[0] = this.database.getCatalogName().name;
        t.insertSys(session, store, row);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        sysTableSessionDependent = new boolean[sysTableNames.length];
        tableTypes = new String[]{"GLOBAL TEMPORARY", "SYSTEM TABLE", "TABLE", "VIEW"};
        Class<SysSchemaMain> clazz = SysSchemaMain.class;
        synchronized (SysSchemaMain.class) {
            nonCachedTablesSet = new HashSet();
            sysTableHsqlNames = new NameManager.ObjectName[sysTableNames.length];
            for (int i = 0; i < sysTableNames.length; ++i) {
                SysSchemaMain.sysTableHsqlNames[i] = NameManager.newInfoSchemaTableName(sysTableNames[i]);
                SysSchemaMain.sysTableHsqlNames[i].schema = SqlInvariants.SYS_SCHEMA_NAME;
                SysSchemaMain.sysTableSessionDependent[i] = true;
            }
            nonCachedTablesSet.add("SYSTEM_CACHEINFO");
            nonCachedTablesSet.add("SYSTEM_SESSIONINFO");
            nonCachedTablesSet.add("SYSTEM_SESSIONS");
            nonCachedTablesSet.add("SYSTEM_PROPERTIES");
            nonCachedTablesSet.add("SYSTEM_SEQUENCES");
            nonCachedTablesSet.add("TIMERS");
            nonCachedTablesSet.add("SOURCE_STREAMS");
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

