/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.info;

import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.ds.mf.OperationVisibleCondition;
import com.streamscape.ds.mf.OperationVisibleConditionByClassName;
import com.streamscape.ds.schema.collection.qspace.pqueue.ProcessQueueCollection;
import com.streamscape.sef.factory.connection.AbstractSetFetchSizeOperation;
import com.streamscape.slex.SetTransferBufferSizeOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;

public class HelpRegistry {
    public static final String ALL_DATASPACE_TYPES = "ALL";
    private static String SOURCE_NAME_DESCRIPTION = "Parameter <Source Name> must have the following format: <NodeName>://<DataspaceType>.<DataspaceName>:<CollectionName> and must be concluded in square brackets.\nNodeName can be omitted if operation is executed in node that owns the dataspace with replication source.\nNodeName, DataspaceType and DataspaceName can be omitted if operation is executed in dataspace that owns the source.\nIf CollectionName or DataspaceName contain special symbols like dot(.) or dollar sign($) then names should be concluded in square brackets.";
    private static String REPLICATION_QUEUE_NAME_DESCRIPTION = "Parameter <Queue Name> must have the following format: <NodeName>://<QueueName> and must be concluded in square brackets.\nQueueName has the following format rsq.<ReplicationSourceDataspaceType>.<ReplicationSourceDataspaceName>.<ReplicationSourceName>.\nNodeName and ReplicationSourceDataspaceType can be omitted if operation is executed in node that owns the replication queue.";
    private static String REPLICA_NAME_DESCRIPTION = "Replica Name must have the following format: <NodeName>://<DataspaceType>.<DataspaceName>:<ReplicaName> and\nmust be enclosed in square brackets.\nNode Name can be omitted if operation is executed in a node that owns the replica dataspace.\nNode Name, Dataspace Type and Dataspace Name can be omitted if operation is executed in dataspace that owns the replica.\nIf Replica Name or Dataspace Name contain special symbols like dot(.) or dollar sign($) then names\nshould also be enclosed in square brackets.";
    private static final String LOG_RECORD_PATTERN_SYNTAX = "Streamscape filter can be specified using the following placeholders:\n   - N  - number\n   - d  - digit\n   - W  - word including digits\n   - CN - class name\n   - IP - IP address\n   - QS - quoted string\n   - all other symbols - delimiters stay as they are\n   - there can be zero or more whitespaces between delimiter and others\n   - space in the filter means one or more spaces\n\nStreamscape log records start filter can be described as following:\n   [N/N/N N:N:N.N] [W] [W] [CN] W W W...\nTimestamp filter can be defined as:\n   N/N/N N:N:N.N\nTimestamp format can defined as:\n   MM/dd/yy HH:mm:ss.SSS\n";
    public static final String JAVA_DATE_FORMAT_SYNTAX = "Timestamp format should be specified using Java date format syntax:\n\n  Letter   Date or Time Component            Presentation         Examples\n  G        Era designator                    Text                 AD\n  y        Year                              Year                 1996; 96\n  Y        Week year                         Year                 2009; 09\n  M        Month in year (context sensitive) Month                July; Jul; 07\n  L        Month in year (standalone form)   Month                July; Jul; 07\n  w        Week in year                      Number               27\n  W        Week in month                     Number               2\n  D        Day in year                       Number               189\n  d        Day in month                      Number               10\n  F        Day of week in month              Number               2\n  E        Day name in week                  Text                 Tuesday; Tue\n  u        Day number of week (1 = Monday, ) Number               1\n  a        Am/pm marker                      Text                 PM\n  H        Hour in day (0-23)                Number               0\n  k        Hour in day (1-24)                Number               24\n  K        Hour in am/pm (0-11)              Number               0\n  h        Hour in am/pm (1-12)              Number               12\n  m        Minute in hour                    Number               30\n  s        Second in minute                  Number               55\n  S        Millisecond                       Number               978\n  z        Time zone                         General time zone    Pacific Standard Time; PST; GMT-08:00\n  Z        Time zone                         RFC 822 time zone    -0800; +0800\n  X        Time zone                         ISO 8601 time zone   -08; +08; Z\n  XX       Time zone                         ISO 8601 time zone   -0800; +0800\n  XXX      Time zone                         ISO 8601 time zone   -08:00; +08:00\n\n\nBy default date and timestamp are serialized in local timezone. To append timezone name/value use z,Z or X placeholders.\nTo serialize date or timestamp in UTC timezone, append 'Z' placeholder to the end: yyyy-MM-dd'T'HH:mm:ss'Z'\n\nThe following date/timestamp formats are also used as default during date/timestamp deserialization:\n   yyyy-MM-dd'T'HH:mm:ss\n   yyyy-MM-dd'T'HH:mm:ss.SSS\n   yyyy-MM-dd'T'HH:mm:ssX\n   yyyy-MM-dd'T'HH:mm:ss.SSSX\n   yyyy-MM-dd'T'HH:mm:ssXX\n   yyyy-MM-dd'T'HH:mm:ss.SSSXX\n   yyyy-MM-dd'T'HH:mm:ssXXX\n   yyyy-MM-dd'T'HH:mm:ss.SSSXXX\n   yyyy-MM-dd'T'HH:mm:ss z\n   yyyy-MM-dd'T'HH:mm:ss.SSS z\n\nDefault Dataspace formats (used in dataspace queries, and displayed in console):\n   yyyy-MM-dd HH:mm:ss - date\n   MM-yyyy-dd - sqldate\n   ss:HH:mm - sqltime\n   MM-yyyy-dd HH:mm:ss.SSS - sqltimestamp\n\nOther formats:\n\n   MM/dd/yy HH:mm:ss.SSS\n   yyyy-MM-dd'T'HH:mm:ssX\n   yyyy-MM-dd'T'HH:mm:ss'Z'\n\nDate unit samples:\n    date.toString(now(), 'yyyy-MM-dd HH:mm:ss.SSS')\n    date.toString(now(), 'yyyy-MM-dd''T''HH:mm:ss.SSSXXX')\n    date.toString(now(), 'yyyy-MM-dd HH:mm:ss.SSS z')\n    date.toString(now(), 'yyyy-MM-dd''T''HH:mm:ss.SSS''Z''')\n\n    date.fromString('2024-03-22T06:44:56.156Z')\n    date.fromString('2024-03-22T06:44:56.156+03')\n    date.fromString('2024-03-22T06:44:56.156 PST')\n\n";
    public static String SNAPSHOT_INDEX_HELP = "Additionally, there are two index types supported by SNAPSHOT table:\n\n- AVL INDEX\n \n    This index is based on AVL tree and automatically rebuilt during row insert/update/delete).\n    This index is useful when a SNAPSHOT TABLE is in read-write mode or being updated by an\n    active event stream.  It improves random access and range search at the expense of gradually\n    declining performance in logarithmic fashion.  Large tables will impact modification performance\n    and 'push back' on any data producing streams. A Primary Key (if defined) is based on AVL index.\n\n    Index memory consumption is approximately 16*(rows count)*1.5 bytes. Use DESCRIBE COLLECTION\n    with STATISTICS option to see how much resources a SNAPSHOT TABLE consumes.\n\n- READ-ONLY INDEX\n\n    This index can only be created or re-built on SNAPSHOT TABLES with data in READ-ONLY mode. Once\n    such a SNAPSHOT is modified, a READ-ONLY index needs to be rebuilt using BUILD SNAPSHOT INDEX.\n\n    If a READ-ONLY index is not re-built it will not be used in conditional expressions. The DESCRIBE\n    command will show whether an index is Valid or not. A READ-ONLY index cannot be unique.  A re-build\n    operation duration increases exponentially as the number of rows increases.  However, if multiple\n    indices are defined, they will be re-built in parallel, resulting in very fast execution.  SNAPSHOT\n    TABLES may therefore be re-indexed on the fly as their content changes, providing for adequate\n    trade-off between performance and occasional, bulk data modification.\n\n    Memory consumption for READ-ONLY INDEX is 4*(rows count) bytes.\n";
    public static String ANALYZE_COMMAND_DESC = "Analyzes specified %s and returns list of dependencies or references from/to this %s.\nBy default only external references and dependencies are analyzed.\nBy default only non-system dependencies/references are displayed. Specify ALL to include system dependencies/references.\nDefault depth is 1 for dependencies and infinity for references.";
    public static String ANALYZE_COMMAND_SYNTAX = "analyze %s [<name>]\n     { dependencies | references } [ all ]\n     [ with local ] [ with external ] [ depth <depth> ]";
    public static String ANALYZE_MODULE_SLANG_HELP = "Analyzes various resources depending on context and type. This tool is intended for Impact Analysis, Semantics,\nLanguage Search and Dependency tracking of all Dataspace and Runtime objects. Some analysis operations can take\nsignificant time. The command is context sensitive based on service, dataspace or runtime.\n\nUse targeted help for specific functionality on the following modules:";
    public static String APECTS_FACETS_SUPPORTED_TYPES = "List of supported types:\n\n   boolean\n   char\n   varchar\n   string\n   smallint\n   tinyint\n   integer\n   numeric\n   long\n   bigint\n   decimal\n   float\n   real\n   double\n   sqldate\n   sqltime\n   sqltimestamp\n";
    public static String FLOB_TYPE_DOC = "FLOB Type\n\nDataspace Collections support a specialized type called FLOB (File Large Object). This is a data type\nthat is a reference to an actual file in an underlying storage file. Unlike a BLOB (Binary Large Object)\nwhich is stored in a dataspace as binary bits, the FLOB is simply a pointer the actual file in a directory\nor folder. The FLOB object contains meta-data and a FLOB ID that keeps track of the file and programmatic\nreferences to it. This allows applications to read, download and work with the file without using the\ndataspace client or programming interface, while also allowing the dataspace to perform Relational Algebra\noperations on the file and its contents. FLOBS implement a form of Managed Storage as part of the dataspace\ncapabilities.\n\nAdditional FLOB information can be found in references to Directory Tables, File Tables, DropBox and\nfunctions such as toFlob() and readFile() which allow users to directly manipulate the underlying files\nwhile maintaining some locks on the entities, protecting them source data from being randomly overwritten.\nThe function toURL() can also return an Acceptor-specific URL that can allow the underlying FLOB file to\nbe downloaded in a secure and controlled fashion, over HTTPS secured, managed channels with permissions.\n\n    a FLOB can be defined like this:\n\n              FLOB[([autotag] [location '<path>'] [charset '<charset>'])]\n\n       where\n\n              location '<path>'   - defines a path(relative to node's working directory) where FLOB files will be\n                                    stored. The deafult location is .dscache/flobs\n\n              autotag             - if set then FLOB file name is tagged with a unique ID, and the file is renamed.\n                                    Otherwise the FLOB referenced file name be the same as original file.\n\n              charset '<charset>' - defines the charset that will be used to convert FLOB content to string or CLOB.\n                                    The default is UTF-8. Charset can be overridden by readFile() function.";
    public static final OperationVisibleCondition semagraphOperationsVisibleChecker = new OperationVisibleConditionByClassName("com.streamscape.nlp.service.word2vector.TXSemagraph");
    public static final OperationVisibleCondition awsOperationsVisibleChecker = new OperationVisibleConditionByClassName("com.streamscape.aws.client.AwsClientConnection");
    public static HelpEntry[] entries = new HelpEntry[]{new HelpEntry("call").setAvailableInRuntime(true).setDesc("Calls function with specified name and parameters.").setSyntax("call <Function Name>([<Function Parameters>])").setExamples("call getAveragePrice()"), new HelpEntry("select").setAvailableInRuntime(true).setDesc("Queries data from the specified collection.\n\nANSII SQL:\n\n   Standard Join Syntax including LEFT, RIGHT, OUTER JOIN. \n\n   Expressions that include a complete array of Scalar Functions.\n\n   Expressions that include Aggregate Functions. See aggregate function\n   syntax documentation for details.\n\n   Array Functions that can use ARRAY data types based on Simple Types,\n   such as STRING o DATE as well as SQL Types.\n\nDSQL:\n\n   UNNEST\n   EXPAND\n   UNFOLD\n   ASPECT JOIN\n   FACET JOIN\n   SPATH Equality\n   RPATH Equality\n   User Defined Functions (RPL)").setSyntax("select <Tuple List> from <Table Name> [ where <RPL Expression> ]").setExamples("select Fname,Sname from Employees where Dept = 'Ops'"), new HelpEntry("insert").setAvailableInRuntime(true).setDesc("Inserts new data into the specified table collection.").setSyntax("insert into <Table Name> ( <Tuple List> ) values ( <Values List> )").setExamples("insert into Employees ( Fname,Sname ) values( 'John', 'Smith' )"), new HelpEntry("update").setAvailableInRuntime(true).setDesc("Updates existing data in the specified table collection.\n\nUpdate on snapshot can be performed in usual way or\ncan be performed in specific way when the whole column is updated or added and initialized from provided expression.\nIn this case expression should return array, list or table with one column and size equal to size of the snap table.").setSyntax("update <Table Name> set <Updated Tuples List> [where <RPL Expression>]\nupdate <Snap Table Name> set  [ new column ] <Column Name> [ type <Type>  [ { before | after } <Other Column Name> ] ]  = <Expression>").setExamples("update Employees set Dept='HR' where EmpId=1234"), new HelpEntry("delete").setAvailableInRuntime(true).setDesc("Deletes existing data element or row from a specified dataspace collection.\nThis operation allows random removal of collection data based on a WHERE clause.\n").setSyntax("delete from <Collection Name> [where <Expression>]").setExamples("delete from Employees where EmpId=1234"), new HelpEntry("create table").setAvailableInRuntime(true).setScope(DataspaceType.TSPACE).setDesc("Creates new table collection. Dataspaces allow complex types and multi-dimensional elements to be declared as table columns. \nStreamScape uses the term TUPLE instead of COLUMN to distinguish this capability from standard Relational Databases. These \nterms are used interchangeably.\n\n" + FLOB_TYPE_DOC).setSyntax("create { memory | logged | persistent } table <Table Name> [ if not exists ] ( <Tuple Definition> [, ...] [, <CONSTRAINT Definition>...] [, <LIKE Definition>])\n\nTuple Definition:\n\n<Tuple Name> <Data Type> [(size[,precision])]\n    [ {\n        default <defaultValue> |\n        generated { by default | always } as identity [ (start with <n>[ increment by <m>])] |\n        identity\n      }\n    ]\n    [[not] null] [primary key]\n\nDefault values that are allowed are constant values or certain SQL datetime functions.\n\nAllowed Default Values in Column Definitions\n\n\tFor character column, a single-quoted string or NULL. The only SQL function that can be used is CURRENT_USER.\n\n\tFor datetime columns, a single-quoted DATE, TIME or TIMESTAMP value or NULL. Or a datetime SQL function such as \n\tCURRENT_DATE, CURRENT_TIME, CURRENT_TIMESTAMP, TODAY, NOW. Each function is allowed for a certain datetime type.\n\n\tFor BOOLEAN columns, the literals FALSE, TRUE, NULL.\n\n\tFor numeric columns, any valid number or NULL.\n\n\tFor binary columns, any valid hex string or NULL.\n\nIdentity Tuple Definition:\n\nNOTE: IDENTITY syntax is for backward compatibility with SQL syntax. Identity column defined using this syntax is primary key.\n\nAn identity tuple (or column) is an auto-incremented field managed by the Dataspace engine. Identity column is compatible\nwith general SQL 200n syntax and standards in functionality.\n\nOnly one identity column is allowed in each table. Identity columns are autoincrement columns. They must be of INTEGER \nor BIGINT type. Using the long SQL syntax the (START WITH <n>) clause specifies the first value that will be used.\nThe last inserted value into an identity column for a connection is available using the function IDENTITY(), \nfor example (where Id is the identity column):\n\ninsert into test (id, name) values (null,'test');\n    call identity();\n\nGENERATED BY DEFAULT AS IDENTITY allows insert other values to this column\nGENERATED ALWAYS AS IDENTITY doesn't allow insert any values to this column, values are always generated. DEFAULT keyword can be used as values.\n\nLIKE Definition:\n\nDataspace tables may be declared by combining definitions from other, existing tables by using the LIKE clause that specifies \ndata structure inheritance. \n\nlike < Table Name > \n    [ \n    { including identity | excluding identity } | \n    { including defaults | excluding defaults } | \n    { including generated | excluding generated } \n    ]\n\nConstraint Definition:\n\n[constraint <name>]\n    unique ( <column> [,<column>...] ) |\n    primary key ( <column> [,<column>...] ) |\n    foreign key ( <column> [,<column>...] )\n    references <refTable> ( <column> [,<column>...]) \n    [on {delete | update}\n    {cascade | set default | set null}] |\n    check(<search condition>)\n\nA search condition is similar to the set of conditions in a WHERE clause. In dataspaces, the conditions for a CHECK constraint \ncan only reference the current row, meaning there should be no SELECT statement, for example:\n\ncreate table tc1(a string, b string, c string, check(a in (b,c, 'sunday', 'monday')))").setExamples("create logged table [Test] ( Col1 int, Col2 string, Col3 sqltimestamp default now() not null, Col4 string default 'initial' )\ncreate persistent table [Employees] ( EmpId int, like Users including defaults excluding identity )\ncreate table [Employees] ( EmpId int identity, name string)\ncreate table table [Employees] ( EmpId int, age int, check(age > 18)\ncreate table [Employees] ( EmpId int generated by default as identity )\ncreate table [Employees] ( EmpId int generated by default as identity (start with 100 increment by 11) primary key)\n"), new HelpEntry("create table as").setAvailableInRuntime(false).setScope(DataspaceType.TSPACE).setDesc("Creates a table collection based on the meta-data of a query that returns a result.").setSyntax("create { memory | logged | persistent } table <Table Name> [ if not exists ] [ ( <Column List> ) ] \n as ( <SubQuery> ) { with no data | with data } ").setExamples("create table MyEmployees as (select * from Employees) with data\ncreate table MyEmployees (id, myName, myDesc) as (select * from Employees) with data"), new HelpEntry("drop table").setAvailableInRuntime(true).setScope(DataspaceType.TSPACE).setDesc("Drops specified table.").setSyntax("drop table <Table Name> [cascade | restrict] [if exists]").addTag(Tag.DROP).setExamples("drop table [Employees]"), new HelpEntry("create view").setAvailableInRuntime(true).setScope(DataspaceType.TSPACE).setDesc("Creates new view.").setSyntax("create view <View Name> [ if not exists ] as <Statement>").setExamples("create view OpsEmployees as select * from Employees where Dept = 'Ops'"), new HelpEntry("drop view").setAvailableInRuntime(true).setScope(DataspaceType.TSPACE).setDesc("Drops view.").setSyntax("drop view <View Name> [cascade | restrict] [if exists]").addTag(Tag.DROP).setExamples("drop view [OpsEmployees]"), new HelpEntry("create map").setAvailableInRuntime(true).setScope(DataspaceType.TSPACE).setDesc("Creates new map collection.").setExamples("create logged map Tickers ( string, decimal(10,4) )").setSyntax("create { memory | logged | persistent } map <Map Name> [ if not exists ] ( <Key Type>, <Value Type> )"), new HelpEntry("drop map").setAvailableInRuntime(true).setScope(DataspaceType.TSPACE).setDesc("Drops specified map.").setExamples("drop map Tickers").addTag(Tag.DROP).setSyntax("drop map <Map Name> [ cascade | restrict ] [ if exists ]"), new HelpEntry("put").setAvailableInRuntime(true).setScope(DataspaceType.TSPACE).setDesc("Puts new key,value pair into map.").setExamples("put into Tickers values ( 'ACME', 123.123 )").setSyntax("put into <Map Name> values ( <Key>, <Value> )"), new HelpEntry("get").setAvailableInRuntime(true).setScope(DataspaceType.TSPACE).setDesc("Retrieves value from map by the key.").setExamples("get Value from Tickers where Key='ACME'").setSyntax("get Value from <Map Name> where Key = <Key>"), new HelpEntry("create event table").setAvailableInRuntime(true).setScope(DataspaceType.TSPACE).setDesc("Creates new event table collection.\nBy default all event properties are included. ").setExamples("create memory event table Tickers constrained by [event.acme.ticker]\n   primary key ( TickerSymbol ) with source event as blob consumer\n\ncreate logged event queue Quotes constrained by [event.quote] consumer with source event\n   sliding time window 5 min check interval 30 sec\n\ncreate memory event queue TopHundredPrices constrained by [event.price]\n   consumer with source event sliding size window 100").setSyntax("create { memory | logged | persistent } event table <Table Name> [ if not exists ] [ constrained by <Event Id> ]\n   [{ include | exclude } properties ( * | { <Prop 1, Prop 2,... } )] [primary key ( <Column 1>[,<Column 2>] )]\n   [with source event [as blob]] [[async] consumer [(<Consumer Max Depth>)] [event scope { inherited | local | observable | global }] [when ( <Event Selector> )]]\n   [ {sliding | batch} {size | time} window <Window Size> [ <Time Unit> ] \n     [ check interval <Interval> [ <Time Unit> ] ]\n     [ add columns( <Column Name> <Type> [default <default expression>] [ ,... ] ) ]"), new HelpEntry("alter event table").setAvailableInRuntime(true).setScope(DataspaceType.TSPACE).setDesc("Alters existing event table collection.").setExamples("alter event table Tickers set sliding time window 5 min check interval 30 sec\nalter event table Tickers remove window").setSyntax("alter event table <Table Name> \n  { set | remove } [ { sliding | batch } { size | time } ] window [ <Window Size> [ <Time Unit> ] ]\n     [ check interval <Interval> [<Time Unit>] ] [event scope { inherited | local | observable | global }]\n  [ set primary key ( <Column 1>[,<Column 2>] ) ]"), new HelpEntry("query").setAvailableInRuntime(true).setScope(DataspaceType.TSPACE).setDesc("Queries some information from the specified collection. E.g. size of the collection.").setSyntax("query <Data> from <Collection Name>"), new HelpEntry("invoke").setAvailableInRuntime(true).setScope(DataspaceType.TSPACE).setDesc("Invokes some specific operation on the specified collection. E.g. collection clear.").setSyntax("invoke <Operation> on <Collection Name>"), new HelpEntry("create event trigger").setAvailableInRuntime(true).setScope(DataspaceType.TSPACE).setDesc("Creates new event trigger on the specified collection.\n\nJavadoc can be defined anywhere in command, preferable at the beginning and should be enclosed in /** and */.\nJavadoc extends standard html tags with the following tags:\n\n   Links:\n      {@link type#<typename>}                                               - Link to semantic type with specified name.\n      {@link prototype#<eventId>}                                           - Link to event prototype with specified eventId.\n      {@link service#<ServiceType>.<ServiceName>}                           - Link to service with specified type and name.\n      {@link handler#<ServiceType>.<ServiceName>.<HandlerName>}             - Link to service event handler with specified type and name.\n      {@link collection#[<DataspaceType>].<DataspaceName>.<CollectionName>} - Link to collection in specified dataspace. Default dataspace type is TSPACE.\n      {@link function#[<DataspaceType>].<DataspaceName>.<FunctionName>}     - Link to function in specified dataspace. Default dataspace type is TSPACE.\n\n   Code tag:\n      {@code <some code>} - Formats specified code with specific font.\n\n   Tags, in order they will be in result html:\n      @author <authors>              - Authors in javadoc style.\n      @version <version>             - Version in javadoc style.\n      @copyright <copyright>         - Copyright in javadoc style.\n      @since <since version or date> - Since in javadoc style.\n      @see <link>                    - See also in javadoc style.\n      @anytag <any text>             - Any tag.\n      @raises <events>               - Raises events.\n      @todo <what todo>              - Todo.\n\n    NOTE: Tags should be located at the end of javadoc. One tag ends where another tag starts.\n").setExamples("create event trigger ChangesPublisher on Tickers event scope global after insert \n   new data as newData when (newData.Symbol = 'ACME') as { raise event this.getCurrentEvent(); }\n\ncreate event trigger ChangesLogger on Tickers event scope observable before delete \n   actionable event as RemovedRowEvent when (RemovedRowEvent.getEventGroupId() = 'IBM') \nas \n{\n   log.info('Data to be removed from Tickers ', RemovedRowEvent.rowAfter.data);\n}\n\ncreate event trigger cw_WorkSet on [watch.aws.s3.AWSLog.S3.Pershing]\n      event scope observable after put new data as nEvent\n      as {\n         event Event = nEvent.Event;\n         boolean isMatch = exec immediate('Event.data.detail.get(''object'').get(''size'') == 1');\n         if (isMath == true) {\n            log.debug('match');\n         }\n      }").setSyntax("create event trigger <Trigger Name> [ if not exists ] on { <Data Collection Name> | materialize | persist } \n   [event scope { inherited | local | observable | global | cluster }]\n   [ { { before | after | after commit | instead of } { insert | update | delete | put | remove } | on truncate }]\n   [ for each statement ]\n   [ {\n      new collection as <Identifier> | old collection as <Identifier> | \n      new data as <Identifier>   | old data as <Identifier> | \n      actionable event as <Identifier>\n   } ]\n   [ when (<RPL expression>) ]\n   [ order <1,2... | first | last> ]\nas\n   {\n       <RPL Script>\n   }\n   [ enable ]"), new HelpEntry("alter event trigger").setAvailableInRuntime(true).setScope(DataspaceType.TSPACE).setDesc("Alters existing event trigger on the specified collection.").setExamples("alter event trigger ChangesPublisher on Tickers event scope observable before insert \n   new data as newData when (newData.Symbol = 'ACME') as { raise event this.getCurrentEvent(); }\n\nalter event trigger ChangesLogger on Tickers event scope global before delete \n   actionable event as RemovedRowEvent when (RemovedRowEvent.getEventGroupId() = 'IBM') \nas \n{\n   log.info('Data to be removed from Tickers ', RemovedRowEvent.row.data);\n}").setSyntax("alter event trigger <Trigger Name> on <Data Collection Name>  \n   [event scope { inherited | local | observable | global | cluster }]\n   [ { { before | after | after commit | instead of } { insert | update | delete | put | remove } | on truncate }]\n   [ for each statement ]\n   [ {\n      new collection as <Identifier> | old collection as <Identifier> | \n      new data as <Identifier>   | old data as <Identifier> | \n      actionable event as <Identifier>\n   } ]\n   [ when (<RPL expression>) ]\n   [ order <1,2... | first | last> ]\nas\n   {\n       <RPL Script>\n   }"), new HelpEntry("create event trigger").setAvailableInRuntime(true).setScope(DataspaceType.FSPACE).setDesc("Creates new event trigger on the specified collection.").setExamples("create event trigger ChangesPublisher on Tickers event scope global after insert\n   new data as newData\n   when (newData.Symbol = 'ACME')\n as\n {\n   raise event this.getCurrentEvent();\n }\n\ncreate event trigger ChangesLogger on Tickers event scope observable before delete\n   actionable event as RemovedRowEvent when (RemovedRowEvent.getEventGroupId() = 'IBM')\n as\n {\n   log.info('Data to be removed from Tickers ', RemovedRowEvent.rowAfter.data);\n }\n\ncreate event trigger TickersOnMalformedData on Tickers event scope global after malformed data\n   new data as newData actionable event as e\n   when(newData.id != null)\n as\n {\n   log.debug('malformed row line: ' + e.getData());\n   log.debug('id of malformed row: ' + newData.id);\n }\n").setSyntax("create event trigger <Trigger Name> [ if not exists ] on { <Data Collection Name> | materialize | persist } \n   [event scope { inherited | local | observable | global | cluster }]\n   [ { { before | after | after commit | instead of } { insert | update | delete | put | remove } | on truncate | after malformed data } ]\n   [ for each statement ]\n   [ {\n      new collection as <Identifier> | old collection as <Identifier> | \n      new data as <Identifier>   | old data as <Identifier> | \n      actionable event as <Identifier>\n   } ]\n   [ when (<RPL expression>) ]\n   [ order <1,2... | first | last> ]\nas\n   {\n       <RPL Script>\n   }\n   [ enable ]"), new HelpEntry("alter event trigger").setAvailableInRuntime(true).setScope(DataspaceType.FSPACE).setDesc("Alters existing event trigger on the specified collection.").setExamples("alter event trigger ChangesPublisher on Tickers event scope observable before insert \n   new data as newData when (newData.Symbol = 'ACME') as { raise event this.getCurrentEvent(); }\n\nalter event trigger ChangesLogger on Tickers event scope global before delete \n   actionable event as RemovedRowEvent when (RemovedRowEvent.getEventGroupId() = 'IBM') \nas \n{\n   log.info('Data to be removed from Tickers ', RemovedRowEvent.row.data);\n}").setSyntax("alter event trigger <Trigger Name> on <Data Collection Name>  \n   [event scope { inherited | local | observable | global | cluster }]\n   [ { { before | after | after commit | instead of } { insert | update | delete | put | remove } | on truncate | after malformed data } ]\n   [ for each statement ]\n   [ {\n      new collection as <Identifier> | old collection as <Identifier> | \n      new data as <Identifier>   | old data as <Identifier> | \n      actionable event as <Identifier>\n   } ]\n   [ when (<RPL expression>) ]\n   [ order <1,2... | first | last> ]\nas\n   {\n       <RPL Script>\n   }"), new HelpEntry("start table").setAvailableInRuntime(true).setScope(DataspaceType.TSPACE).setDesc("Starts specified event table that subscribes to events it is constrained by.").setSyntax("start table <Event Table Name>"), new HelpEntry("stop table").setAvailableInRuntime(true).setScope(DataspaceType.TSPACE).setDesc("Stops specified event table that unsubscribes from events it is constrained by.").setSyntax("stop table <Event Table Name>"), new HelpEntry("truncate").setAvailableInRuntime(true).setScope(DataspaceType.TSPACE).setDesc("Truncates specified table, queue or schema. \nNOTE: if on commit option is specified, truncate works the same way as DELETE which \nmeans that it can be rolled back. But if this option is not specified, all data is \nremoved  immediately with no possibility to recover it.\nForce option can be specified for JFT or appendable file tables and means to truncate even if there are some unprocessed rows in the source file.\nNOTE: Truncate on JFT or appendable tables should be executed when there are no writes to source file, otherwise written data can be lost.").setSyntax("truncate { collection | schema } <Collection Name> [ { continue | restart } identity] \n   [ on commit [ no check ] ] [ force ]"), new HelpEntry("create snapshot table").setAvailableInRuntime(true).setScope(DataspaceType.TSPACE, DataspaceType.FSPACE).setDesc("Creates new snapshot table collection. Snapshots are columnar data collections for fast in-memory access to SQL compatible data \ntypes. They support natural compression and fast disk dump operations ideal for data science and statistical calculations.\n\nSnapshot Tables may be defined as MEMORY or PERSISTENT, similar to other collections.  There is no concept of a logged collection\nas it pertains to a SNAPSHOT.  The entire collection is written to disk in a fast optimized operation, without impacting readers when\na snapshot is taken.  A snapshot can then be loaded to another location or saved for historical purposes as a GENERATION.\n\nSnapshot Tables declared as MEMORY will lose all content upon node restart.  PERSISTENT collections will automatically load contents\nfrom the default location when a Dataspace comes on-line, if a saved snapshot is available.  Snapshots may be created by user actions,\nas part of RPL script in Triggers, Functions or Actors and may be generated automatically by setting the AUTOSAVE interval, to mimic\ntransaction logging behavior.  Note that a SNAPSHOT is a complete image of the collection and not a log of changes.\n\nMEMORY snapshots do not require that users specify the location to save data.  If a default location is specified using SNAPSHOT AT,\nthen users can automatically direct any save operations to use this directory without specifying it in the SNAPSHOT command. Meaning\nthat if a default SNAPSHOT AT is specified, the user does not need to explicitly specify the location when a SNAPSHOT is taken.\n\nPERSISTENT collections are initialized from the most recent, non-generation snapshot image.  GENERATION may be used to create\nhistorical images of the collection.  The number after the generation is an Increment Interval.  When GENERATION is specified, the\nSNASHOT operation or the AUTOSAVE action will automatically rename the existing active save directory by adding a generation data\nnumber to the directory name, and then writing out the latest image to the default location.  Users can then initialize snapshots from\nhistorical images as opposed to the most recent snapshot.\n\nFor example, consider a snapshot collection called intl_Markets.Prices which holds financial market data, such as stock prices.  If a\nsnapshot is declared AUTOSAVE 10 MINS and GENERATION 1, then every 10 minutes a snapshot will be generated and the prior\ncurrent image\u2019 will be saved in a directory with an auto-incremented number. For example:\n\nintl_Markets.Prices\nintl_Markets.Prices.1\nintl_Markets.Prices.2\n..\n \nIf this collection is created as PERSISTENT, then upon dataspace initialization the snapshot contents will load from intl_Markets.Prices\n\nAutomatically saving large volumes of data can slow down machine performance or impact other disk operations. Users should\nexperiment with the tradeoffs in performance and reliability based on size of data.  Snapshot tables may also be saved to mounted\ndrives that are high performance, backed by Cache FS or shared across machines.  SNAPSHOT collections compress data in memory,\nespecially if CATEGORY types are declared.  Compression may be in excess of 15:1 depending on data cardinality.  As a result, the\nsize of data when written to disk may be significantly larger than in memory.  Use DESCRIBE COLLECTION .. INDEX to get a better\nidea of the amount of resources used by SNAPSHOT collections.\n\nSnapshot tables can be created in several ways:\n\n   - defined using a CREATE operation like a standard table\n   - loaded from an existing .SNAP file on disk or imported from another node\n   - generated from another table and filled with data using standard SQL commands\n   - generated from a file descriptor and loaded from a positional or delimited file\n   - generated from RowEvent prototype using the CONSTRAINED BY clause\n\nCONSTRAINED BY\n\n   This clause can be used with MapEvent and RowEvent prototypes only. In case of a MapEvent \n   the table definition should be specified as well, using standard DDL syntax.\n\n   When a MapEvent is inserted into a SNAP table, the system makes a best-guess based on column\n   names to match them to MapEvent entries. Properties are not considered or used. Columns that\n   do not have a match in MapEvent entries will be filled as NULLs.\n\n   In case of RowEvents, the table definition can be omitted and will be generated automatically\n   from RowEvent prototype. For example:\n\n      CREATE SNAPSHOT TABLE MYSNAP1 CONSTRAINED BY [my.row.event] ..\n\n   If a table definition is specified with a RowEvent constraint and corresponding column names or\n   types do not match, an error is thrown. Typically there is no need to explicitly define columns\n   when constraining the collection by a RowEvent.\n\nFile descriptors with multiple record types are not supported.\n\nSnapshot tables support only primitive data types that are SQL compatible. And they support a\nlimited set of CRUD operations, intentionally designed as read-mostly data collections.\n\nList of supported types:\n\n   boolean\n   char\n   varchar\n   string\n   category\n   smallint\n   tinyint\n   integer\n   numeric\n   long\n   bigint\n   decimal\n   float\n   real\n   double\n   sqldate\n   sqltime\n   sqltimestamp\n\nCATEGORY data type can be used for columns with a limited set of distinct values (up to 256).\nCompared to STRING types a CATEGORY column reduces memory consumption by a factor of 50 or more.\n\nSELECT operations are significantly faster for read-only snapshot tables. General indexes greatly\nimprove queries with a WHERE clause that uses range checks. Indexes on read-only SNAPSHOTS also\nbenefit conditional aggregate operations such as SUM or COUNT.\n\nSee SNAPSHOT command for additional information on how to work with these collections.\n\nASYNC CONSUMER\n\n   This option ensures that the SNAPSHOT consumes event stream data asynchronously by buffering the\n   events and not impacting the sender.\n\nWHEN\n\n   This clause allows users to filter inbound events using a complex SELECTOR clause, further narrowing\n   the scope of data received into a SNAPSHOT. This can be used to route events to specific SNAPSHOTS or\n   as a Reducer in Map/Reduce scenarios where streams of data may be coming from big data sources or \n   messaging systems.\n\n" + SNAPSHOT_INDEX_HELP).addTag(Tag.SNAPSHOT).setSyntax("create [ { memory | persistent } ] snapshot table <Table Name> [ if not exists ]\n   { ( <Table Definition> ) | \n          from table <Table Name> | \n          from snapshot <snapshot> |\n          from data frame <data frame> | \n          from file descriptor '<File Descriptor Name>'\n   }\n   [ snapshot { at | @ } '<directory>' [ autosave nnn { hr | min | sec }  [ generation n ] ] ]\n   [ constrained by <Event Id> [ [async consumer] [event scope { inherited | local | observable | global }]\n      [ when ( <Event Selector> ) ] [ start ] [ primary key ( <Column 1>[,<Column 2>] )] ]").setExamples("create snapshot table [Employees] ( EmpId int, Fname string, Sname string, Dept string )\ncreate snapshot table [MyTable] from table YourTable\ncreate snapshot table [MyTable] from file descriptor 'MyDescriptor'\ncreate snapshot table [MyTable] from snapshort mysnapshotvar\ncreate snapshot table [MyTable] from data frame mydataframevariable\ncreate snapshot table [MyTable] constrained by [my.row.event] async consumer primary key(id)\ncreate snapshot table [MyTable] (id int primary key, name string) constrained by [my.map.event]"), new HelpEntry("start snapshot").setAvailableInRuntime(true).setScope(DataspaceType.TSPACE, DataspaceType.FSPACE).setDesc("Starts specified snapshot table that subscribes to events it is constrained by.").addTag(Tag.SNAPSHOT).setSyntax("start snapshot <Snapshot Table Name>"), new HelpEntry("stop snapshot").setAvailableInRuntime(true).setScope(DataspaceType.TSPACE, DataspaceType.FSPACE).setDesc("Stops specified snapshot table that unsubscribes from events it is constrained by.").addTag(Tag.SNAPSHOT).setSyntax("stop snapshot <Snapshot Table Name>"), new HelpEntry("snapshot").setAvailableInRuntime(true).setScope(DataspaceType.TSPACE, DataspaceType.FSPACE).setDesc("Loads or Saves a SNAPSHOT TABLE from/to disk, source file or another TABLE collection.\nSNAPSHOT tables are special, high performance columnar stores especial designed for\nuse by analytical applications such as Data Science, AI or Machine Learning.\n\nThe SNAPSHOT command lets users load the table from a source file, a File Table, a\nVirtual Table, View or any Table Collection in a Dataspace. Loading is optimized\nbased on the type of data source and may be performed in parallel on sets of columns\nto improve performance. SNAPSHOT tables loaded from files or collections are not\nindexed. Indexing must be performed as a separate operation and may also be done in\nparallel to improve index creation speed.\n\nA SNAPSHOT command also lets users save the data in a Snapshot Table using a special\nSNAP format to persist the data.  When saved in SNAP format the data are compressed\nand the index information is also written to disk to ensure that a Snap Table can \nbe quickly materialized when a node re-starts. Snap tables can only be saved in \nSNAP format.  \n\nGiven the large amounts of data (often millions of rows) stored in a Snap Table, \nexporting data to a non-Snap formatted file (i.e. a delimited file) is not recommended.\nHowever it is possible by declaring a STREAM on the Snap Table and streaming the contents\nto a target file to avoid selecting the entire row set.\n\nSnapshot Tables may be created from File Descriptors that describe a file structure.\nA SNAPSHOT that is created from file descriptor can be loaded from a SNAP directory,\npositional or delimited file that is based on the file descriptor and mapping rules.\n\nIf READ ONLY option is specified the resulting Snap Table will be set to READ ONLY mode\nafter loading.  Users can then create high-performance indexes on the table.  READ \nindexes are very fast to create and they take up minimal memory.  However, changing a \nREAD ONLY Snap Table to WRITE mode will invalidate any indexes and put the table and \nit's container Dataspace into SUSPECT mode.  \n\nIf WITH DEFRAG option is specified table defragmentation will be done before/after write/read\ntable data to/from SNAP file. Defragmentation makes sense if there are removed row in the table.\nRemoved rows from SNAP table are only marked as deleted, but memory occupied by removed rows\nis not freed up. Defragmentation releases memory occupied by removed rows and updates AVL indexes.").addTag(Tag.SNAPSHOT).setSyntax("snapshot [table] <Table Name> { { from | to } [snap] [ '<dirpath>' ] [ force ] | from table <Table Name> | from delimited file } '<filepath>'[ with defrag ] [ read only ]").setExamples("snapshot [Employees] to snap file\nsnapshot [Employees] to './employees'\nsnapshot [Employees] to 'dropbox://mydropbox/employees'\nsnapshot table [EmployeesSnapshot] from table [Employees]\nsnapshot table [EmployeesSnapshot] from snap '/my/snap/dir'\nsnapshot table [EmployeesSnapshot] from snap '/my/snap/dir' force\nsnapshot table [EmployeesSnapshot] from snap 'dropbox://mydropbox/my/snap/dir'\nsnapshot table [EmployeesSnapshot] from delimited file '/my/delimited/file/path'\n"), new HelpEntry("alter snapshot").setAvailableInRuntime(true).setScope(DataspaceType.TSPACE, DataspaceType.FSPACE).setDesc("Alters existing snapshot collection.").addTag(Tag.SNAPSHOT).setSyntax("alter snapshot <Snapshot Name>\n   [ add [ tuple] <Tuple Definition> [ before <Other Tuple> ] ]\n   [ drop [ tuple ] <Tuple Name>]\n   [ set snapshot { at | @ } '<directory'> ]\n   [ set autosave nnn { hour | min | sec } ]\n   [ set generation n ]\n   [ drop no consumer ]\n   [ set constrained by <Event Id> [ [async consumer] [event scope { inherited | local | observable | global }]\n      [ when ( <Event Selector> ) ] [ start ] ]\n   [ set when ( <Event Selector> ) ]").setExamples("alter snapshot [Employees] add tuple Name\nalter snapshot [Employees] add tuple Name before Age\nalter snapshot [Employees] drop tuple Name\n"), new HelpEntry("defrag snapshot table").setAvailableInRuntime(true).setScope(DataspaceType.TSPACE, DataspaceType.FSPACE).setDesc("Defragments snapshot table.\nRemoved rows from SNAP table are only marked as deleted, but memory occupied by removed rows\nis not freed up. Defragmentation releases memory occupied by removed rows and updates AVL indexes.\nIf COMPACT option is specified the memory allocated for SNAP storage will be trimmed to only fit real data.").addTag(Tag.SNAPSHOT).setSyntax("defrag snapshot table <Table Name> [ compact ]").setExamples("defrag snapshot table MyTable"), new HelpEntry("build snapshot index").setAvailableInRuntime(true).setScope(DataspaceType.TSPACE, DataspaceType.FSPACE).setDesc("Builds snapshot table indexes. If several indexes are specified they will be build in parallel.\nForce means to rebuild the index. Read only means to set table read only after build.").addTag(Tag.SNAPSHOT).setSyntax("build snapshot index <index name1> [force] [read only] [, <index name1> [force] [read only]] [...]").setExamples("build snapshot index MyIndex1 read only, MyIndex2 read only"), new HelpEntry("create virtual sql server").setAvailableInRuntime(true).setScope(DataspaceType.TSPACE).addTag(Tag.VIRTUAL).setDesc("Creates new reference to external database SQL server.\nIf any properties are specified, they overwrite existing properties from the JDBC factory. By default connections pool size equals to 1.\nIf creation of server is failed error will be saved to last error. Use describe server to check status and last error.\n\nService type will be determined automatically from JDBC once server is in connected state.").setSyntax("create virtual sql server <Server Name> [ if not exists ] using <JDBC Factory Type>.<Factory Name>\n   [ properties (<Prop 1> = <Value 1>, <Prop 2> = '<Value 2>', ...)] [connections pool size <size>]"), new HelpEntry("alter virtual sql server").setAvailableInRuntime(true).setScope(DataspaceType.TSPACE).addTag(Tag.VIRTUAL).setDesc("Alters existing virtual sql server.").setSyntax("alter virtual sql server <Server Name> [using <JDBC Factory Type>.<Factory Name>] \n   [ properties (<Prop 1> = <Value 1>, <Prop 2> = '<Value 2>', ...)] [connections pool size <Size>]"), new HelpEntry("start server").setAvailableInRuntime(true).addTag(Tag.VIRTUAL).setDesc("Starts specified server. If starting of server is failed error will be saved to last error.\nUse describe server to check status and last error.").setSyntax("start server <Server Name>"), new HelpEntry("stop server").setAvailableInRuntime(true).addTag(Tag.VIRTUAL).setDesc("Stops specified server. If stopping of server is failed error will be saved to last error.\nUse describe server to check status and last error.").setSyntax("stop server <Server Name>"), new HelpEntry("create virtual table").setAvailableInRuntime(true).setAlias("create vtable").addTag(Tag.VIRTUAL).setScope(DataspaceType.TSPACE).setDesc("Creates new virtual table pointing to the table or query on external server.\nColumns list should be specified in the following cases:\n  - virtual table should contains only specified subset of columns\n  - need to rename columns or change their type\n  - it is not possible to determine column type, a.e. we have ExternalQuery that selects columns from different tables or calls a procedure\n  - in case when external query is specified, need columns list to determine column types\nColumn types will be resolved from ExternalName table. So if ExternalName is not specified columns list should contain column types.\nIf columns list or external query are specified then vtable will be accessed in read-only mode.\nExternalQuery can contain parameters ${ParamName} that will be replaced with values from values clause\nduring query execution. If external query parameters specified then values should be specified with default\nparameter values for first execution to fetch column types.\n").setSyntax("create vtable <Table Name> [ if not exists ] at <Server Name> \n   [ columns({ <vcolum name> [as <external column name>] [vcolumn type], ... | * }) ]\n   [as '<External Query>'] [values (<Value 1>,...)]\n   [ external name '<External Name>' ] [ schema '<Schema>' ] \n   [ with [ { memory | logged | persistent } ] cache ]").setExamples("create vtable RemoteTable at OracleServer with persistent cache external name 'TABLE1' schema 'TEST'\ncreate vtable RemoteTable at SybaseServer(c1 int, c2 string) as 'call storedProc(${param1})' values('')\ncreate vtable RemoteTable at SybaseServer(c1, c2) external name 'TABLE1' schema 'TEST'\ncreate vtable RemoteTable at SybaseServer(c1_v as c1, c2_v as c2) external name 'TABLE1' schema 'TEST'\ncreate vtable RemoteTable at SybaseServer(c1, c2) as 'select c1, c2 from TABLE1' external name 'TABLE1' schema 'TEST'\ncreate vtable RemoteTable at SybaseServer(c1 int, c2 string) as 'select c1, c2 from TABLE1'\ncreate vtable RemoteTable at SybaseServer(c1max int, c2 string) as 'select max(c1), c2 from TABLE1 order by c2'\n"), new HelpEntry("rebuild vtable").setAvailableInRuntime(true).setScope(DataspaceType.TSPACE).addTag(Tag.VIRTUAL).setDesc("Rebuilds vtable metadata from remote server.").setSyntax("rebuild vtable <Table Name>").setExamples("rebuild vtable RemoteTable"), new HelpEntry("recache vtable").setAvailableInRuntime(true).setScope(DataspaceType.TSPACE).addTag(Tag.VIRTUAL).setDesc("Invalidates cache for virtual table collection thus forcing it to refresh data from remote server.").setSyntax("recache vtable <Table Name>").setExamples("recache vtable RemoteTable"), new HelpEntry("create window trigger").setAvailableInRuntime(true).setScope(DataspaceType.TSPACE).setDesc("Creates a new window trigger on an event queue, event table, audit or process \nqueue (other collection types are not supported).  Syntax may be space-specific.\n\nWindow triggers allow users to process data removal events that occur as result \nof a WINDOW declaration.  Event tables and certain queues may be defined using \na WINDOW clause allowing the collection to only retain data that fits a certain\ncriteria such as age or collection size. Data that do not fit  the defined criteria\nare automatically discarded.  \n\nThe criteria are checked at specific intervals. If it is determined that one or\nmore collection elements do not fit the criteria for retention, they are removed\nand passed to the Window Trigger. Changes are passed as lists of rows or events \nand can be assigned to variables by using the 'referencing' clause. \n").setExamples("create window trigger ChangesPublisher on Tickers event scope global\n   referencing new as NewEvents old as OldEvents\nas\n{\n   DeltaEvent windowChange = new [event.window.list.change];\n   windowChange.setBeforeImage(OldEvents);\n   if (NewEvents != null)\n      windowChange.setAfterImage(NewEvents);\n    raise event windowChange;\n}").setSyntax("create window trigger <Trigger Name> [ if not exists ] on <Data Collection Name>  \n   [event scope { local | observable | global }]\n   [ referencing new as <Identifier> | old as <Identifier> ]\n   [ order <1,2... | first | last> ]\nas\n{\n    <RPL Script>\n}\n[enable]"), new HelpEntry("alter window trigger").setAvailableInRuntime(true).setScope(DataspaceType.TSPACE).setDesc("Alters existing window trigger.").setExamples("alter window trigger ChangesPublisher on Tickers event scope global\n   referencing new as NewEvents old as OldEvents\nas\n{\n   DeltaEvent windowChange = new [event.window.list.change];\n   windowChange.setBeforeImage(OldEvents);\n   if (NewEvents != null)\n      windowChange.setAfterImage(NewEvents);\n    raise event windowChange;\n}").setSyntax("alter window trigger <Trigger Name> on <Data Collection Name>  \n   [event scope { local | observable | global }]\n   [ referencing new as <Identifier> | old as <Identifier> ]\nas\n{\n    <RPL Script>\n}\n[enable]"), new HelpEntry("drop window trigger").setAvailableInRuntime(true).setScope(DataspaceType.TSPACE).setDesc("Drops window trigger.").addTag(Tag.DROP).setSyntax("drop window trigger <TriggerName> [ if exists ]"), new HelpEntry("create virtual nosql server").setAvailableInRuntime(true).setScope(DataspaceType.TSPACE).addTag(Tag.VIRTUAL).setDesc("Creates new reference to external nosql server.\nIf any properties are specified, they overwrite existing properties from the client factory.\nIf creation of server is failed error will be saved to last error.\nUse describe server to check status and last error.\n\nSupported server types: MONGO, SALESFORCE, AWS, DYNAMODB. If not specified it will be determined from connection factory.").setSyntax("create virtual nosql server <Server Name> [ type( { MONGO | SALESFORCE | AWS | DYNAMODB } ) ] [ if not exists ] using <Client Factory Type>.<Factory Name>\n   [ properties (<Prop 1> = <Value 1>, <Prop 2> = '<Value 2>', ...)]"), new HelpEntry("alter virtual nosql server").setAvailableInRuntime(true).setScope(DataspaceType.TSPACE).addTag(Tag.VIRTUAL).setDesc("Alters existing virtual nosql server.").setSyntax("alter virtual nosql server <Server Name> using <Client Factory Type>.<Factory Name>\n   [ properties (<Prop 1> = <Value 1>, <Prop 2> = '<Value 2>', ...)]"), new HelpEntry("create virtual web server").setAvailableInRuntime(true).setScope(DataspaceType.TSPACE).addTag(Tag.VIRTUAL).setDesc("Creates new reference to web server.\nIf any properties are specified, they overwrite existing properties from the client factory.\nIf creation of server is failed error will be saved to last error.\nUse describe server to check status and last error.\n\nPredefined server types: HTTP, OAPI, JIRA, any other user-defined type can be specified.\nIf type is not specified it will be taken from 'ServerType' connection factory property or default type HTTP will be used. ").setSyntax("create virtual web server <Server Name> [ type( { HTTP | OAPI | JIRA } ) ] [ if not exists ] using <Client Factory Type>.<Factory Name>\n   [ properties (<Prop 1> = <Value 1>, <Prop 2> = '<Value 2>', ...)]"), new HelpEntry("alter virtual web server").setAvailableInRuntime(true).setScope(DataspaceType.TSPACE).addTag(Tag.VIRTUAL).setDesc("Alters existing virtual web server.").setSyntax("alter virtual web server <Server Name> [ using <Client Factory Type>.<Factory Name> ]\n   [ properties (<Prop 1> = <Value 1>, <Prop 2> = '<Value 2>', ...)]"), new HelpEntry("create queue").setAvailableInRuntime(true).addTag(Tag.QUEUE).setScope(DataspaceType.QSPACE).setDesc("Creates new blocking queue collection.\n\n" + FLOB_TYPE_DOC).setExamples("create persistent queue Tickers constrained by Ticker").setSyntax("create { memory | logged | persistent } queue <Queue Name> [ if not exists ] { constrained by <Semantic Type> | (Semantic Type) }[max depth <Max Depth>]"), new HelpEntry("drop queue").setAvailableInRuntime(true).addTag(Tag.QUEUE).setScope(DataspaceType.QSPACE).setDesc("Drops specified queue.").addTag(Tag.DROP).setSyntax("drop queue <Queue Name> [ cascade | restrict ] [ if exists ]"), new HelpEntry("create process queue").setAvailableInRuntime(true).addTag(Tag.PROCESS_QUEUE).setScope(DataspaceType.QSPACE).setDesc("Creates new process queue collection.\nBy default all event properties are included.\nProcess queue created in suspended mode. To resume use command resume process queue.\nBy default max attempts = " + new ProcessQueueCollection.PollerConfiguration().maxAttempts + ", offer interval = " + new ProcessQueueCollection.PollerConfiguration().offerInterval + " ms\nrecipient timeout = " + new ProcessQueueCollection.PollerConfiguration().recipientTimeout + " ms, suspend on fail = " + new ProcessQueueCollection.PollerConfiguration().suspendOnFailure + "\nparallel degree = " + new ProcessQueueCollection.PollerConfiguration().parallelDegree + "\nIf parallel degree is 0 then now poller will be launched and suspend/resume queue will not have any effect.\nBy default process queue is always created with source event as BLOB. Optional modifier 'with source event' can\nbe specified to store source event as an object.").setExamples("create process queue TickersProcessor constrained by [event.acme.ticker] consumer when (Symbol='AA')").setSyntax("create { memory | logged | persistent } process queue <Queue Name> [ if not exists ] constrained by <Event Id>\n   [max depth <Max Depth>] [with source event [as blob]] \n   [[async] consumer [event scope { inherited | local | observable | global }] ][when ( <Event Selector> )]] \n   [initial process state { enqueued | pending }] [with metaset <Meta Table Name>]\n   [ {sliding | batch} {size | time} window <Window Size> [ <Time Unit> ] \n     [ check interval <Interval> [ <Time Unit> ] ]\n   [max attempts <max_attempts>] [offer interval <Milliseconds>] [recipient timeout <Milliseconds>]\n   [ suspend on fail { true | false } ] [ parallel degree <Threads Count> ]"), new HelpEntry("alter process queue").setAvailableInRuntime(true).addTag(Tag.PROCESS_QUEUE).setScope(DataspaceType.QSPACE).setDesc("Alters existing process queue collection. Parallel degree can be modified on stopped queue only.").setExamples("alter process queue TickersProcessor set sliding time window 5 min check interval 30 sec\nalter event table TickersProcessor remove window").setSyntax("alter process queue <Queue Name> \n  { set | remove } [ {sliding | batch} {size | time} ] window [ <Window Size> [<Time Unit>] ]\n     [ check interval <Interval> [<Time Unit>] ] [event scope { inherited | local | observable | global }] \n   [ max attempts <Max Attempts> ] [offer interval <Milliseconds>] [recipient timeout <Milliseconds>]\n   [ suspend on fail { true | false } ] [ parallel degree <Threads Count> ]"), new HelpEntry("create audit queue").setAvailableInRuntime(true).addTag(Tag.QUEUE).setScope(DataspaceType.QSPACE).setDesc("Creates new audit queue collection.").setExamples("create persistent audit queue UserActionsAudit constrained by [event.audit.user] async consumer").setSyntax("create { memory | logged | persistent } audit queue <QueueName> [ if not exists ] constrained by <EventId>\n   [ max depth <Max Depth> ] [ [ async ] consumer [event scope { inherited | local | observable | global }] [ when ( <Event Selector> ) ] ]\n   [ {sliding | batch} {size | time} window <Window Size> [ <Time Unit> ] \n     [ check interval <Interval> [ <Time Unit> ] ]"), new HelpEntry("alter audit queue").setAvailableInRuntime(true).addTag(Tag.QUEUE).setScope(DataspaceType.QSPACE).setDesc("Alters existing audit queue collection.").setExamples("alter audit queue TickersProcessor set sliding time window 5 min check interval 30 sec\nalter audit table TickersProcessor remove window").setSyntax("alter audit queue <Queue Name> \n  { set | remove } [ {sliding | batch} {size | time} ] window [ <Window Size> [ <Time Unit> ] ]\n     [ check interval <Interval> [ <Time Unit> ] ] [event scope { inherited | local | observable | global }]"), new HelpEntry("create event queue").setAvailableInRuntime(true).addTag(Tag.QUEUE).setScope(DataspaceType.QSPACE).setDesc("Creates new event queue collection. \nBy default all event properties are included. \nTime unit for window size can only be specified for 'time' window type\nand can be one of the following:\n   ms, sec, min, hr, days").setExamples("create persistent event queue Prices constrained by [event.price]\n   primary key (Vendor) with source event consumer when ( Price > 10000.00 )\n\ncreate logged event queue Quotes constrained by [event.quote] consumer with source event\n   sliding time window 5 min check interval 30 sec\n\ncreate memory event queue TopHundredPrices constrained by [event.price]\n   consumer with source event sliding size window 100").setSyntax("create { memory | logged | persistent } event queue <QueueName> [ if not exists ] [ constrained by <EventId> ]\n   [ max depth <Max Depth> ] [ { include | exclude } properties ( * | {<Prop 1, Prop 2,...} )]\n   [ with source event [as blob] ] [ [async] consumer [(<Consumer Max Depth>)] [event scope { inherited | local | observable | global }] [ when ( <Event Selector> ) ] ]\n   [ { sliding | batch } { size | time } window <Window Size> [ <Time Unit> ] \n     [ check interval <Interval> [ <Time Unit> ] ]"), new HelpEntry("alter event queue").setAvailableInRuntime(true).addTag(Tag.QUEUE).setScope(DataspaceType.QSPACE).setDesc("Alters existing event queue collection.").setExamples("alter event queue Prices set sliding time window 5 min check interval 30 sec\nalter event table Prices remove window").setSyntax("alter event queue <Queue Name> \n  { set | remove } [ {sliding | batch} {size | time} ] window [ <Window Size> [<Time Unit>] ]\n     [ check interval <Interval> [ <Time Unit> ] ] [event scope { inherited | local | observable | global }]"), new HelpEntry("create virtual message server").setAvailableInRuntime(true).setScope(DataspaceType.QSPACE).addTag(Tag.VIRTUAL).setDesc("Creates a new reference to message server.\nIf any properties are specified, they overwrite existing properties from the client factory.\nIf creation of server is failed error will be saved to last error.\nUse command 'describe server' to check status and last error.\n\nSupported server types: KAFKA. If not specified it will be determited from connection factory.").setSyntax("create virtual message server <Server Name> [ type(KAFKA) ] [ if not exists ] using <Client Factory Type>.<Factory Name>\n   [ properties (<Prop 1> = <Value 1>, <Prop 2> = '<Value 2>', ...)]"), new HelpEntry("suspend queue").setAvailableInRuntime(true).addTag(Tag.QUEUE).addTag(Tag.PROCESS_QUEUE).setScope(DataspaceType.QSPACE).setDesc("Suspends specified process queue.").setSyntax("suspend queue <Process Queue Name>"), new HelpEntry("resume queue").setAvailableInRuntime(true).addTag(Tag.QUEUE).addTag(Tag.PROCESS_QUEUE).setScope(DataspaceType.QSPACE).setDesc("Resumes specified process queue.").setSyntax("resume queue <Process Queue Name>"), new HelpEntry("start queue").setAvailableInRuntime(true).addTag(Tag.QUEUE).addTag(Tag.PROCESS_QUEUE).setScope(DataspaceType.QSPACE).setDesc("Starts specified queue (event, process or audit) that subscribes to events it is constrained by.").setSyntax("start queue <Queue Name>"), new HelpEntry("stop queue").setAvailableInRuntime(true).addTag(Tag.QUEUE).addTag(Tag.PROCESS_QUEUE).setScope(DataspaceType.QSPACE).setDesc("Stops specified event queue (event, process or audit) that unsubscribes from events it is constrained by.").setSyntax("stop queue <Queue Name>"), new HelpEntry("put").setAvailableInRuntime(true).addTag(Tag.QUEUE).addTag(Tag.PROCESS_QUEUE).setScope(DataspaceType.QSPACE).setDesc("Puts object/event to the top of the specified queue.").setExamples("put employeeObject into employees").setSyntax("put <object/event> into <Queue Name>"), new HelpEntry("drain").setAvailableInRuntime(true).addTag(Tag.QUEUE).addTag(Tag.PROCESS_QUEUE).setScope(DataspaceType.QSPACE).setDesc("Removes all elements from source queue and adds them into target queue.\nSelector can be specified for Event, Process and Audit queues only.").setExamples("drain employees to employeesCopy max elements 10").setSyntax("drain <SourceQueue> to <TargetQueue> [ max elements <Max Elements Count> ] [ where <RPL expression>]"), new HelpEntry("read").setAvailableInRuntime(true).addTag(Tag.QUEUE).addTag(Tag.PROCESS_QUEUE).setScope(DataspaceType.QSPACE).setDesc("Retrieves and doesn't remove the head element from the queue.\nIf LAST modifier specified the  last added element is retrieved.\nIf no timeout specified operation is not blocking. Timeout 0 means wait until element is available.\nTimeout cannot be specified for read operation in blocking queue.\nSelector can be specified for Event,Process and Audit queues only.\nIf no selector specified for Process Queue top element in 'ENQUEUED' state is retrieved.").setExamples("read from employees where State='EXPIRED' wait 1000 ms").setSyntax("read [last] from <Queue Name> [ where <RPL expression> ] [wait <Timeout> { ms | sec | min | hs | day } ]"), new HelpEntry("take").setAvailableInRuntime(true).addTag(Tag.QUEUE).addTag(Tag.PROCESS_QUEUE).setScope(DataspaceType.QSPACE).setDesc("Retrieves and removes the head element from the queue.\nIf LAST modifier specified the  last added element is retrieved.\nIf no timeout specified operation is not blocking. Timeout 0 means wait until element is available.\nSelector can be specified for Event,Process and Audit queues only.\nIf no selector specified for Process Queue top element in 'ENQUEUED' state is retrieved.").setExamples("take from employees where State='EXPIRED' wait 1000 ms").setSyntax("take [last] from <Queue Name> [ where <RPL expression> ] [wait <Timeout> { ms | sec | min | hs | day } ]"), new HelpEntry("query event").setAvailableInRuntime(true).addTag(Tag.QUEUE).addTag(Tag.PROCESS_QUEUE).setScope(DataspaceType.QSPACE).setDesc("Queries source event from the specified collection.").setSyntax("query event <SeqId> from ( <Process Queue Name> | <Event Queue Name> | <Event Table Name> )"), new HelpEntry("purge queue").setAvailableInRuntime(true).addTag(Tag.QUEUE).addTag(Tag.PROCESS_QUEUE).setScope(DataspaceType.QSPACE).setDesc("Purges specified queue.").setSyntax("purge queue <Queue Name> [ { continue | restart } identity ] [ last | first <Number Of Rows>]"), new HelpEntry("purge replication queue").setAvailableInRuntime(true).setDesc("purges data from replication queue.\n\n" + REPLICATION_QUEUE_NAME_DESCRIPTION).setSyntax("purge replication queue <Replication Queue Name>"), new HelpEntry("take for lock").setAvailableInRuntime(true).addTag(Tag.PROCESS_QUEUE).setScope(DataspaceType.QSPACE).setDesc("Similar to take operation but applicable for Process Queue, \ntakes top element in 'ENQUEUED' state and doesn't remove event but changes status of retrieved event to 'LOCKED'.\nIf LAST modifier specified the  last added element is retrieved.\n").setExamples("take for lock from employees where ProcessId='myprocess' timeout 1000").setSyntax("take [last] for lock from <Process Queue Name> [ where <RPL expression>] [ wait <Timeout> { ms | sec | min | hs | day } ]"), new HelpEntry("take for offer").setAvailableInRuntime(true).addTag(Tag.PROCESS_QUEUE).setScope(DataspaceType.QSPACE).setDesc("Similar to take operation but applicable for Process Queue, \ntakes top element in 'ENQUEUED' state and doesn't remove event but changes status of retrieved event to 'LOCKED_FOR_OFFER'\nIf LAST modifier specified the  last added element is retrieved.\n").setExamples("take for offer from employees where ProcessId='myprocess' timeout 1000").setSyntax("take [last] for offer from <Process Queue Name> [ where <RPL expression>] [ wait <Timeout> { ms | sec | min | hs | day } ]"), new HelpEntry("take for batch").setAvailableInRuntime(true).addTag(Tag.PROCESS_QUEUE).setScope(DataspaceType.QSPACE).setDesc("Similar to take operation but applicable for Process Queue, \ntakes top element in 'ENQUEUED' state and doesn't remove event but changes status of retrieved event to 'IN_TRANSACTION'.\nIf LAST modifier specified the  last added element is retrieved.\n").setExamples("take for batch 'mybatch' from employees where ProcessId='myprocess' timeout 1000").setSyntax("take [last] for batch '<Batch Id>' from <Process Queue Name> [ where <RPL expression>] [ wait <Timeout> { ms | sec | min | hs | day } ]"), new HelpEntry("retry process").setAvailableInRuntime(true).addTag(Tag.PROCESS_QUEUE).setScope(DataspaceType.QSPACE).setDesc("Resets process state to ENQUEUED state for reprocessing.").setSyntax("retry process <Process Id> on [ queue ] <Queue Name>"), new HelpEntry("reoffer process").setAvailableInRuntime(true).addTag(Tag.PROCESS_QUEUE).setScope(DataspaceType.QSPACE).setDesc("Resets successfully process state to ENQUEUED state for reprocessing.").setSyntax("reoffer process <Process Id> on [ queue ] <Queue Name>"), new HelpEntry("discard process").setAvailableInRuntime(true).addTag(Tag.PROCESS_QUEUE).setScope(DataspaceType.QSPACE).setDesc("Discards specified process and puts event to the target queue if specified.").setSyntax("discard process <Process Id> on [ queue ] <Queue Name> [ to [ queue ] <Target Queue Name>]"), new HelpEntry("acknowledge process").setAvailableInRuntime(true).addTag(Tag.PROCESS_QUEUE).setScope(DataspaceType.QSPACE).setDesc("Changes process state to 'ACKNOWLEDGED'.").setSyntax("acknowledge process <Process Id> on [ queue ] <Queue Name>"), new HelpEntry("fail process").setAvailableInRuntime(true).addTag(Tag.PROCESS_QUEUE).setScope(DataspaceType.QSPACE).setDesc("Changes process state to 'UNDELIVERED'.").setSyntax("fail process <ProcessId> on [ queue ] <Queue Name>"), new HelpEntry("unacknowledge process").setAvailableInRuntime(true).addTag(Tag.PROCESS_QUEUE).setScope(DataspaceType.QSPACE).setDesc("Changes process state to 'UNACKNOWLEDGED'.").setSyntax("unacknowledge process <Process Id> on [ queue ] <Queue Name>"), new HelpEntry("skip process").setAvailableInRuntime(true).addTag(Tag.PROCESS_QUEUE).setScope(DataspaceType.QSPACE).setDesc("Changes process state to 'SKIPPED'.").setSyntax("skip process <Process Id> on [ queue ] <Queue Name>"), new HelpEntry("pend process").setAvailableInRuntime(true).addTag(Tag.PROCESS_QUEUE).setScope(DataspaceType.QSPACE).setDesc("Changes process state to 'PENDING'.").setSyntax("pend process <Process Id> on [ queue ] <Queue Name>"), new HelpEntry("expire process").setAvailableInRuntime(true).addTag(Tag.PROCESS_QUEUE).setScope(DataspaceType.QSPACE).setDesc("Changes process state to 'EXPIRED' and puts event to the target queue if specified.").setSyntax("expire process <Process Id> on [ queue ] <Queue Name> [ to [ queue ] <Target Queue Name> ]"), new HelpEntry("get process state").setAvailableInRuntime(true).addTag(Tag.PROCESS_QUEUE).setScope(DataspaceType.QSPACE).setDesc("Returns process state.").setSyntax("get process state <Process Id> on [ queue ] <Queue Name>"), new HelpEntry("set process state").setAvailableInRuntime(true).addTag(Tag.PROCESS_QUEUE).setScope(DataspaceType.QSPACE).setDesc("Set process state to the specified one.").setSyntax("set process <Process Id> state <Process State> on [ queue ] <Process Queue Name>"), new HelpEntry("set process metaset").setAvailableInRuntime(true).addTag(Tag.PROCESS_QUEUE).setScope(DataspaceType.QSPACE).setDesc("Set process metaset.").setSyntax("set process metaset <Key> = <Value> on <Process Queue Name> where ProcessId = <Process Id Value>"), new HelpEntry("get process metaset").setAvailableInRuntime(true).addTag(Tag.PROCESS_QUEUE).setScope(DataspaceType.QSPACE).setDesc("Gets process metaset.").setSyntax("get process metaset <Key> on <Process Queue Name> where ProcessId = <Process Id Value>"), new HelpEntry("list process metaset").setAvailableInRuntime(true).addTag(Tag.PROCESS_QUEUE).setScope(DataspaceType.QSPACE).setDesc("Lists process metaset values.").setSyntax("list process metaset on <Process Queue Name> where ProcessId = <Process Id Value>"), new HelpEntry("list recipients").setAvailableInRuntime(true).addTag(Tag.PROCESS_QUEUE).setScope(DataspaceType.QSPACE).setDesc("List recipients of the specified process queue.").setSyntax("list recipients for <Process Queue Name>"), new HelpEntry("create recipient").setAvailableInRuntime(true).addTag(Tag.PROCESS_QUEUE).setScope(DataspaceType.QSPACE).setDesc("Creates new recipient for the specified process queue.").setExamples("create recipient TickerRecipient on queue TickersProcessor raise event on [event.ticker.recipient1]").setSyntax("create [ certified ] recipient <Recipient Name> [ if not exists ] [ crtoken = <Token> ] on [ queue ] <Process Queue Name> \n   [when ( <Event Selector> )] raise event on <Event Id>"), new HelpEntry("drop recipient").setAvailableInRuntime(true).addTag(Tag.PROCESS_QUEUE).setScope(DataspaceType.QSPACE).setDesc("Drops specified recipient from the specified process queue.").addTag(Tag.DROP).setSyntax("drop recipient <Recipient Name> on [ queue ] <Queue Name> [ if exists ]"), new HelpEntry("export view").setAvailableInRuntime(true).setScope(DataspaceType.QSPACE).setDesc("Exports queue collection as a view to specified Table Space.").setExamples("export view ExampleView for queue Prices to PricesStore exclude properties ( SeqId )").setSyntax("export view <View Name> for [queue] <Queue Name> to <TSpace Name>\n   [ { include | exclude } properties ( * | {<Prop 1>,<Prop 2>,...} ) ]"), new HelpEntry("create event trigger").setAvailableInRuntime(true).setScope(DataspaceType.QSPACE).setDesc("Creates new event trigger on the specified collection.").setExamples("create event trigger StatePublisher on PricesQueue event scope global on event update \n   as { raise event this.getCurrentEvent() on [event.state.change]; }").setSyntax("create event trigger <Trigger Name> [ if not exists ] on { <Data Collection Name> | materialize | persist } \n   [event scope { inherited | local | observable | global | cluster } ]\n   [ { { before | after | after commit } { put | take | add | remove | update } | on truncate } ]\n   [ for each statement ]\n   [ {\n      new collection as <Identifier> | old collection as <Identifier> | \n      new data as <Identifier>   | old data as <Identifier> | \n      actionable event as <Identifier>\n   } ]\n   [ when (<RPL expression>) ]\n   [ order <1,2... | first | last> ]\nas\n   {\n       <RPL Script>\n   }\n   [ enable ]"), new HelpEntry("alter event trigger").setAvailableInRuntime(true).setScope(DataspaceType.QSPACE).setDesc("Alters existing event trigger on the specified collection.").setExamples("alter event trigger StatePublisher on PricesQueue event scope observable on event update \n   as { raise event this.getCurrentEvent() on [event.state.change]; }").setSyntax("alter event trigger <Trigger Name> on <Data Collection Name>  \n   [event scope { inherited | local | observable | global | cluster } ]\n   { { before | after } { put | take } | on update | truncate}\n   [ for each statement ]\n   [ {\n      new collection as <Identifier> | old collection as <Identifier> | \n      new data as <Identifier>   | old data as <Identifier> | \n      actionable event as <Identifier>\n   } ]\n   [ when (<RPL expression>) ]\n   [ order <1,2... | first | last> ]\nas\n   {\n       <RPL Script>\n   }"), new HelpEntry("create window trigger").setAvailableInRuntime(true).setScope(DataspaceType.QSPACE).setDesc("Creates new window trigger on an event, audit or process queue (other \ncollection types are not supported). Window trigger allows to process \nchanges coming from collection window. Changes are passed as lists of \nevents and can be accessed using 'referencing' clause.").setExamples("create window trigger ChangesPublisher on Tickers event scope global\n   referencing new as NewRowSet old as OldRowSet\nas\n{\n   DeltaEvent windowChange = new [event.window.rowset.change];\n   windowChange.setBeforeImage(OldRowSet);\n   if (NewRowSet != null)\n      windowChange.setAfterImage(NewRowSet);\n    raise event windowChange;\n}").setSyntax("create window trigger <Trigger Name> [ if not exists ] on <Data Collection Name>  \n   [event scope { local | observable | global }]\n   [ referencing new as <Identifier> | old as <Identifier> ]\nas\n{\n   <RPL script>\n} "), new HelpEntry("drop window trigger").setAvailableInRuntime(true).setScope(DataspaceType.QSPACE).setDesc("Drops window trigger.").addTag(Tag.DROP).setSyntax("drop window trigger <Trigger Name> [ if exists ]"), new HelpEntry("create file table").setAvailableInRuntime(true).addTag(Tag.FILE).setScope(DataspaceType.FSPACE).setScope(DataspaceType.FSPACE).setDesc("Creates new file table collection.\nFile table structure can be defined by columns list like common table and then linked to delimited file or\ncan be generated from file descriptor and then linked to positional file. There are the following options when constrained by file descriptor\n - if 'types only' specified table will contain two columns (Type String, Record Other). Each record from source file will be mapped to one row.\n - if no 'types only' specified file descriptor should contain only one record or 'for record <record key>' should be specified.\n   Table will contain one column for each field for specified record. Each record from source file with specified type will be mapped to one row.\n - if 'for record <record key>' specified only records that match the specified key will be read into file table.\nServer Name can specify file server for external file system which should be used to access the file.").setSyntax("create file table <Table Name> [ if not exists ] [ at <Server Name> ]    {( <Table Definition> ) | [{types only | for record types ('<record key>',...)}] constrained by '<File Descriptor Name>'}"), new HelpEntry("alter file table").setAvailableInRuntime(true).addTag(Tag.FILE).setScope(DataspaceType.FSPACE).setDesc("Alters file table collection based on file descriptor.\n\nSee description of modifier in 'create file table command'.").setSyntax("alter file table <Table Name> set [{types only | for record types ('<record key>',...)}] constrained by '<File Descriptor Name>'}"), new HelpEntry("drop table").setAvailableInRuntime(true).setScope(DataspaceType.FSPACE).setDesc("Drops specified table.").addTag(Tag.DROP).setSyntax("drop table <Table Name> [ cascade | restrict ] [ if exists ]"), new HelpEntry("link file table").setAvailableInRuntime(true).addTag(Tag.FILE).setScope(DataspaceType.FSPACE).setDesc("Links existing file table with its source delimited CSV or positional file. String literal with source file name\nand file table parameters such as 'fs', 'vs' and 'lvs' may be specified.\n\nWhen 'for stream' option is specified, file table is prepared for streaming by \nsource stream and is not available for general CRUD and query operations.\n\nWhen 'for append' option is specified, file table is linked to source file in read only mode and\nnew rows added to the end of source file will be seen and indexed by file table.\nIf source file truncated or removed file table cache and indexes will be cleared and new source file will be reload.\n'check interval' parameter specifies interval in milliseconds between source file check for new rows. Default check interval is 500 ms.\n'for stream' and 'for append' options cannot be specified together.\n\nSource file path should be a relative path to the node working folder unless absolute\npath is permitted by dataspace properties, in this case it can also be an absolute path\nto the file table data.\n\nFile parameters are listed below:\n\n Positional and delimited files:\n   encoding = <encoding name> character encoding for text and character fields.\n   ignore_first       = { true | false } default is false. If true ignores the first line of the file. Overrides skipFirstLine property of file descriptor.\n   ignore_first_lines = <Number>. Specifies how many first lines of the file have to be ignored. Overrides startAtLine property of file descriptor.\n   cache_rows         = <numeric value> rows of the text file in the cache. Default is 1000 rows.\n   cache_size         = <numeric value in KB> total size of the rows in the cache. Default is 100 KB.\n   read_buffer_size   = <numeric value in bytes> buffer size in bytes used to read data from external servers. Default is 4096 bytes.\n   compression_block_size = <numeric value in bytes> compression block size. Default value 4096 bytes.\n\n Delimited files:\n   quoted = { true | false } default is true. If false, treats double quotes as normal characters. Ignored if file tabled created from file descriptor.\n   all_quoted = { true | false } default is false. If true, adds double quotes around all fields. Ignored if file tabled created from file descriptor.\n   fs = <unquoted character> field separator. Ignored if file tabled created from file descriptor.\n   vs = <unquoted character> varchar separator. Ignored if file tabled created from file descriptor.\n   lvs = <unquoted character> long varchar separator. Ignored if file tabled created from file descriptor.\n\nThe following special separators can be used:\n   \\semi\tsemicolon\n   \\quote\tsingle-quote\n   \\space\tspace character\n   \\apos\tapostrophe\n   \\n   \tnewline - Used as an end anchor (like $ in regular expressions)\n   \\r   \tcarriage return\n   \\t   \ttab\n   \\\\   \tbackslash\n   \\u####\ta Unicode character specified in hexadecimal\n\n Positional files:\n   file_table_ignore_unknown_records = <true|false> ignore or not unknown records.").setExamples("link file table TestTable source 'tesfile.csv;fs=\\semi;vs=\\semi'\nlink file table TestTable2 source 'tesfile2.csv;fs=|;vs=|;lvs=|;encoding=UTF-8'\nlink file table TestTable3 source 'tesfile3.csv;ignore_first=true' for stream\nlink file table TestTable4 source 'tesfile4.csv;ignore_first_lines=3;fs=\\t;vs=\\space;lvs=\\space'\nlink file table TestTable5 source 'tesfile4.csv;fs=|' for append with check interval 500").setSyntax("link file table <Table Name> [ source '<Source File Path> [ ; <Table Parameters> ]' [read only] [ for stream ] [ for append [with check interval <interval in ms>] ]"), new HelpEntry("unlink file table").setAvailableInRuntime(true).addTag(Tag.FILE).setScope(DataspaceType.FSPACE).setDesc("Unlinks (disconnects) existing file table from its source CSV file.").setSyntax("unlink file table <Table Name>"), new HelpEntry("compress file table").setAvailableInRuntime(true).addTag(Tag.FILE).setScope(DataspaceType.FSPACE).setDesc("Compresses existing file table source file.").setExamples("compress file table TestTable").setSyntax("compress file table <Table Name>"), new HelpEntry("decompress file table").setAvailableInRuntime(true).addTag(Tag.FILE).setScope(DataspaceType.FSPACE).setDesc("Decompresses file table source file to its original plain text state.").setExamples("decompress file table TestTable").setSyntax("decompress file table <Table Name>"), new HelpEntry("create journal file table").setAvailableInRuntime(true).addTag(Tag.JFT).addTag(Tag.REPLICATION).addTag(Tag.FILE).addTag(Tag.VIRTUAL).setScope(DataspaceType.FSPACE, DataspaceType.TSPACE).setDesc("Creates new Journal File Table collection that is used to hold transaction data (journals)\nfrom external systems or relational, ACID-compliant databases.\n\nJournal File Tables (JFT) can be user-defined, created based on an existing table, virtual \ntable, collection or File Descriptor. They can be declared as Replication Source tables by \nthe Change Capture and Data Replication system, allowing users to inject transactions from \nany external system into the data fabric's replication environment.\n\nJFT must have an associate File Descriptor that tells the data engine how to process the \nunderlying journal file and handle special data types such as Date, Time or Timestamp. This\nprovides the greatest flexibility, making it easy to ingest data from any external system.\n\nWhen a JFT is created and a file descriptor name is not specified, the system will generated\nthe descriptor automatically in format JFT_<table name>. \n\nFile descriptor defaults: \n\n   delimiter = |\n   quote symbol = '\n\nIf a JFT source file does not exist the system tries to create it as a zero size file. If the\noperation fails an error is returned.\n\nIf a JFT file already exists the 'no create' option may be specified to leave the existing \nfile as is without altering.  This can be useful when moving or re-hosting JFT and replication\nsystems.\n\nIf the 'init' option is specified and the underlying JFT already exists, it will be zero-outed.\nIf this is not successful, for example due to permissions issues, an error will be returned.\nIgnore malformed seqid means not to replicate rows with malformed sequence id and pass them to malformed trigger.").setAlias("create jft").setSyntax("create journal file table <Table Name> [ if not exists ]\n  { { ( <Table Definition> ) | from table <Source Table Name> }\n       [file descriptor name '<name>' [delimiter '<delimiter>']\n          [quote symbol '<quote symbol>'] [escape quote symbol '<escape quote symbol>']\n          [ {date | sqldate | sqltime | sqltimestamp} format '<format like in Java SimpleDateFormat or long>']\n          [ {date | sqldate | sqltime | sqltimestamp} type as {date | sqldate | sqltime | sqltimestamp | string | long}] ] |\n    from file descriptor '<name>'\n  }\n  source file '<source file name'> [ no create ] [ init ]\n  [journal read interval <read interval in milliseconds>]\n  [ignore malformed seqid on {insert | delete | update}]"), new HelpEntry("alter journal file table").setAvailableInRuntime(true).addTag(Tag.JFT).setScope(DataspaceType.FSPACE, DataspaceType.TSPACE).setDesc("Alter journal file table collection.").setAlias("alter jft").setSyntax("alter journal file table <Table Name> \n  [ set source file '<source file name'> [ no create ] ]\n  [ set journal read interval <read interval in milliseconds> ]\n  [ set [not] ignore malformed seqid on {insert | delete | update}]"), new HelpEntry("start journal file table").setAvailableInRuntime(true).addTag(Tag.JFT).setScope(DataspaceType.FSPACE, DataspaceType.TSPACE).setDesc("Starts journal file table collection. [advisory.journal.file.table.StateChange] event will be raised on each JFT state change.\n - Start jft without options reads source file from the begin and fires triggers for each not processed row.\n   If triggers were fired without errors then SeqId and Timestamp of this row are stored in dataspace as identity of last processed row.\n   Row is considered to be processed if its Timestamp greater than stored Timestamp of last processed row.\n - Start jft with no recovery resets stored SeqId and Timestamp of last processed row, reads source file from the begin but fires triggers from the end.\n - Start jft with recovery resets stored SeqId and Timestamp of last processed row, reads source file from the begin and fires triggers from the begin.\n - Start jft with suspend on fail will stop reading of source file and throw [advisory.journal.file.table.StateChange] if indexing of new row failed or some trigger throws error.\n   To resume jft use 'resume jft' command. Suspend state is not persistent, so after node restart JFT becomes resumed(started) state.\n - Start jft from the specified sequence id and timestamp reads source file from the begin and fires triggers for each row which sequence id and timestamp are at least specified ones.\n").setAlias("start jft").setSyntax("start journal file table <Journal File Table Name> \n   [ { with recovery | with no recovery | from [ seqid <seq id> ] [ timestamp '<timestamp>' ] } ] \n   [ suspend on fail ]"), new HelpEntry("stop journal file table").setAvailableInRuntime(true).addTag(Tag.JFT).setScope(DataspaceType.FSPACE, DataspaceType.TSPACE).setDesc("Stops journal file table collection.").setAlias("stop jft").setSyntax("stop journal file table <Journal File Table Name>"), new HelpEntry("resume journal file table").setAvailableInRuntime(true).addTag(Tag.JFT).setScope(DataspaceType.FSPACE, DataspaceType.TSPACE).setDesc("Resumes journal file table collection.").setAlias("resume jft").setSyntax("resume journal file table <Journal File Table Name>"), new HelpEntry("create log file table").setAvailableInRuntime(true).addTag(Tag.FILE).setScope(DataspaceType.FSPACE, DataspaceType.TSPACE).setDesc("Creates new Log File Table collection that is used to hold log records.\n\nIf a LFT source file does not exist the system tries to create it as a zero size file. If the\noperation fails an error is returned.\n\nIf a LFT file already exists the 'no create' option may be specified to leave the existing\nfile as is without altering.  This can be useful when moving or re-hosting JFT and replication\nsystems.\n\nIf the 'init' option is specified and the underlying JFT already exists, it will be zero-outed.\nIf this is not successful, for example due to permissions issues, an error will be returned.\n\nTo separate adjacent log records and handle multiline records it is needed to know log records formats, at least its unique prefix format.\nFor example StreamScape log record looks like:\n\n    [01/18/19 14:41:54.120] [TRACE] [INFO ] [com.streamscape.runtime.RuntimeContext] Opening Dataspace Manager...\n\nStreamScape log record starts with timestamp, trace word and trace level.\nLog file table provides two ways to specify format of the log record prefix:\n   - using simple streamscape filter\n   - using regexp\n\nThe idea of two ways is to specify log record prefix filter, specify the position/filter of timestamp in the record and\nspecify timestamp format to parse it from string.\n\nStreamscape filter can be specified using the following placeholders:\n   - N  - number\n   - d  - digit\n   - W  - word including digits\n   - CN - class name\n   - IP - IP address\n   - QS - quoted string\n   - all other symbols - delimiters stay as they are\n   - there can be zero or more whitespaces between delimiter and others\n   - space in the filter means one or more spaces\n\nStreamscape log records start filter can be described as following:\n   [N/N/N N:N:N.N] [W] [W] [CN] W W W...\nTimestamp filter can be defined as:\n   N/N/N N:N:N.N\nTimestamp format can defined as:\n   MM/dd/yy HH:mm:ss.SSS\n\nStreamscape filter can be automatically build using 'analyze log file' command.\n\nTimestamp format should be specified using Java date format syntax:\n\n  Letter   Date or Time Component            Presentation         Examples\n  G        Era designator                    Text                 AD\n  y        Year                              Year                 1996; 96\n  Y        Week year                         Year                 2009; 09\n  M        Month in year (context sensitive) Month                July; Jul; 07\n  L        Month in year (standalone form)   Month                July; Jul; 07\n  w        Week in year                      Number               27\n  W        Week in month                     Number               2\n  D        Day in year                       Number               189\n  d        Day in month                      Number               10\n  F        Day of week in month              Number               2\n  E        Day name in week                  Text                 Tuesday; Tue\n  u        Day number of week (1 = Monday, ) Number               1\n  a        Am/pm marker                      Text                 PM\n  H        Hour in day (0-23)                Number               0\n  k        Hour in day (1-24)                Number               24\n  K        Hour in am/pm (0-11)              Number               0\n  h        Hour in am/pm (1-12)              Number               12\n  m        Minute in hour                    Number               30\n  s        Second in minute                  Number               55\n  S        Millisecond                       Number               978\n  z        Time zone                         General time zone    Pacific Standard Time; PST; GMT-08:00\n  Z        Time zone                         RFC 822 time zone    -0800; +0800\n  X        Time zone                         ISO 8601 time zone   -08; +08; Z\n  XX       Time zone                         ISO 8601 time zone   -0800; +0800\n  XXX      Time zone                         ISO 8601 time zone   -08:00; +08:00\n\n\nBy default date and timestamp are serialized in local timezone. To append timezone name/value use z,Z or X placeholders.\nTo serialize date or timestamp in UTC timezone, append 'Z' placeholder to the end: yyyy-MM-dd'T'HH:mm:ss'Z'\n\nThe following date/timestamp formats are also used as default during date/timestamp deserialization:\n   yyyy-MM-dd'T'HH:mm:ss\n   yyyy-MM-dd'T'HH:mm:ss.SSS\n   yyyy-MM-dd'T'HH:mm:ssX\n   yyyy-MM-dd'T'HH:mm:ss.SSSX\n   yyyy-MM-dd'T'HH:mm:ssXX\n   yyyy-MM-dd'T'HH:mm:ss.SSSXX\n   yyyy-MM-dd'T'HH:mm:ssXXX\n   yyyy-MM-dd'T'HH:mm:ss.SSSXXX\n   yyyy-MM-dd'T'HH:mm:ss z\n   yyyy-MM-dd'T'HH:mm:ss.SSS z\n\nDefault Dataspace formats (used in dataspace queries, and displayed in console):\n   yyyy-MM-dd HH:mm:ss - date\n   MM-yyyy-dd - sqldate\n   ss:HH:mm - sqltime\n   MM-yyyy-dd HH:mm:ss.SSS - sqltimestamp\n\nOther formats:\n\n   MM/dd/yy HH:mm:ss.SSS\n   yyyy-MM-dd'T'HH:mm:ssX\n   yyyy-MM-dd'T'HH:mm:ss'Z'\n\nDate unit samples:\n    date.toString(now(), 'yyyy-MM-dd HH:mm:ss.SSS')\n    date.toString(now(), 'yyyy-MM-dd''T''HH:mm:ss.SSSXXX')\n    date.toString(now(), 'yyyy-MM-dd HH:mm:ss.SSS z')\n    date.toString(now(), 'yyyy-MM-dd''T''HH:mm:ss.SSS''Z''')\n\n    date.fromString('2024-03-22T06:44:56.156Z')\n    date.fromString('2024-03-22T06:44:56.156+03')\n    date.fromString('2024-03-22T06:44:56.156 PST')\n\n\nAnother way to specify log record prefix is regular expression. Regular expression should contain\nat least one group with timestamp. Timestamp group index should be specified as well.\nStreamscape log record regexp can be look like the following:\n  \\[(.*)\\]\\s*\\[.*\\]\\s*\\[.*\\]\\s*\\[.*\\]\\s*(.*)\nTimestamp group index is 1.\n\nLog truncation is handled by default. If log file rotated, it will be read from the begin.\nTo support log rotation rotated file regexp should be specified. This regexp should match any log file rotation, but doesn't match main log file. Rotated files are ordered by last modification timestamp.\n\n[advisory.log.file.table.StateChange] event is be raised on each LFT state change.\nMapper function is a function that accepts and returns specified event. Mapper function can do any changes to event and is applied right before the event is raised.").setAlias("create lft").setSyntax("create log file table <Table Name> [ if not exists ]\n  source file '<source file name'> [ no create ] [ init ] [ max depth <count> ]\n  [ rotation file regexp '<regexp>' ] [ read interval <milliseconds> ]\n  { using filter record start (<filter>)  timestamp(<filter>) timestamp format(<java date format>) |\n    using regexp record start (<regular expression>)  timestamp regexp group index <index> timestamp format(<java date format>)\n  }\n  [ constrained by [log.event.id] [ mapper function <function name> ] ]").setExamples("create log file table MyStreamScapeLog\n   source file mylog.log no create rotation file regexp 'mylog_(\\d+)\\.log' read interval 1000\n   using filter record start([ N/N/N N:N:N.N ] [ W ] ) timestamp(N/N/N N:N:N.N) timestamp format(MM/dd/yy HH:mm:ss.SSS)\n   constrained by [my.log.event.id] mapper function myMapFunction\ncreate log file table MyStreamScapeLog\n   source file mylog.log no create read interval 1000\n   using regexp record start (\\[(.*)\\]\\s*\\[.*\\]\\s*\\[.*\\]\\s*\\[.*\\]\\s*(.*)) timestamp regexp group index 1 timestamp format(MM/dd/yy HH:mm:ss.SSS)\n"), new HelpEntry("alter log file table").setAvailableInRuntime(true).addTag(Tag.FILE).setScope(DataspaceType.FSPACE, DataspaceType.TSPACE).setDesc("Alters log file table collection.\n - set rotation file regexp to ''(empty string) to unset.\n - set constrained event ID to none to unset.\n - set mapper function to none to unset.").setAlias("alter lft").setSyntax("alter log file table <Table Name> \n  [ set source file '<source file name'> ] [ set no create ] [ set init ] [ set max depth <count> ]\n  [ set rotation file regexp '<regexp>' ] [ set read interval <milliseconds> ]\n  { set using filter record start (<filter>)  timestamp(<filter>) timestamp format(<java date format>) |\n    set using regexp record start (<regular expression>)  timestamp regexp group index <index> timestamp format(<java date format>)\n  }\n  [ set constrained by [<log event id>] | none [ set mapper function <function name> | none ] ]"), new HelpEntry("start log file table").setAvailableInRuntime(true).addTag(Tag.FILE).setScope(DataspaceType.FSPACE, DataspaceType.TSPACE).setDesc("Starts log file table collection. [advisory.log.file.table.StateChange] event will be raised on each LFT state change.\n - Start LFT without options reads source file from the last processed record and fires triggers and raises event for each not processed record.\n   If triggers were fired without errors then Record Offset and Timestamp of this record are stored in dataspace as identity of last processed record.\n   Record is considered to be processed if its Offset and Timestamp greater than stored Offset and Timestamp of last processed record.\n - Start LFT with no recovery resets stored Offset and Timestamp of last processed record, reads source file from the end and fires triggers from the end.\n - Start LFT with recovery resets stored Offset and Timestamp of last processed record, reads source file from the begin and fires triggers from the begin.\n - Start JFT with suspend on fail will stop reading of source file and throw [advisory.log.file.table.StateChange] if indexing of new records failed or some trigger throws error.\n   To resume LFT use 'resume lft' command. Suspend state is not persistent, so after node restart LFT becomes resumed(started) state.\n - Start LFT from the specified Offset and Timestamp reads source file from the specified offset and fires triggers for each read row.\n").setAlias("start lft").setSyntax("start log file table <Log File Table Name> \n   [ on source file '<source file name>' ]  [ rotation file regexp '<regexp>' ] [ with read interval <milliseconds> ]\n   [ { with recovery | with no recovery | from record offset <offset> } ] \n   [ suspend on fail ]"), new HelpEntry("stop log file table").setAvailableInRuntime(true).addTag(Tag.FILE).setScope(DataspaceType.FSPACE, DataspaceType.TSPACE).setDesc("Stops log file table collection.").setAlias("stop lft").setSyntax("stop log file table <Log File Table Name>"), new HelpEntry("resume log file table").setAvailableInRuntime(true).addTag(Tag.FILE).setScope(DataspaceType.FSPACE, DataspaceType.TSPACE).setDesc("Resumes log file table collection.").setAlias("resume lft").setSyntax("resume log file table <Log File Table Name>"), new HelpEntry("truncate collection").setAvailableInRuntime(true).setDesc("Truncates specified collection.").setSyntax("truncate collection <Collection Name> [ { continue | restart } identity ]"), new HelpEntry("create file server").setAvailableInRuntime(true).addTag(Tag.FILE).setScope(DataspaceType.FSPACE).setDesc("Creates new reference to file server for specified file system.\n\nThe following file system types are supported:\n\n   fs      - to local file system\n   dropbox - to dropbox file system\n   s3      - to S3 file system\n   nvfs    - to SAE repository\n   hdfs    - to external Hadoop file system\n\nFor S3 file system AWS connection factory should be specified.\nFor HDFS file system client factory should be specified.").setSyntax("create file server <Server Name> type({ fs | nvfs | hdfs | dropbox | s3 }) [ if not exists ] [using <Client Factory Type>.<Factory Name>]").setExamples("create file server LocalTestServer type(fs)\ncreate file server DropboxTestServer type(dropbox)\ncreate file server S3TestServer type(s3) using AWS.Default\ncreate file server RepositoyTestServer type(nvfs)\ncreate file server RepositoyTestServer type(hdfs) using Hadoop.Server1"), new HelpEntry("create directory table").setAvailableInRuntime(true).addTag(Tag.FILE).setScope(DataspaceType.FSPACE).setDesc("Creates new directory table collection.\n\nIf 'recursive' option is specified, all sub-directories under the specified directory\nwill also be made part of the table and flattened with file names referring to full paths.\nIndividual directories will also be represented as rows (files) of type directory.").setSyntax("create directory table <Directory Name> [ if not exists ] at <File Server Name> path '<Fs Path>'").setExamples("create directory table TestDir at LocalServer path 'c:/testdir'\ncreate directory table TestDir at LocalServer path 'c:/testdir' recursive\ncreate directory table t1 at DropboxTestServer path 'dropbox://mydropbox'\ncreate directory table s3table at S3TestServer path 's3://mybycketname>/<mypah>'"), new HelpEntry("alter directory table").setAvailableInRuntime(true).addTag(Tag.FILE).setScope(DataspaceType.FSPACE).setDesc("Alters specified directory table collection.").setSyntax("alter directory table <Directory Name> path '<Fs Path>'").setExamples("alter directory table TestDir path 'c:/testdir'"), new HelpEntry("insert").setAvailableInRuntime(true).setScope(DataspaceType.FSPACE).setDesc("Inserts new data into the specified table collection.\nInsert operation can be executed on directory table.\nIn that case new file will created in the target directory table and underlying file system.\nThe following column can be specified:\n  - Name        - filename, mandatory\n  - Data        - file content, can be string or binary data, blob, clob, flob or\n                  call of readFile function\n  - Permissions - permissions for new file, should be in format rwxrwxrwx\n  - BlockSize   - block size in format <number>{B|K|M|G}, if supported by target filesystem\n  - Replication - replications count, if supported by target file systemIf Data not specified or null emtpy file will be created.\n\nNote: FLOB types are currently not supported for Remote File Systems such as HDFS.\n      Use get_file() or getFile() functions to return complete file content.").setSyntax("insert into <Table Name> ( <Tuple List> ) values ( <Values List> )").setExamples("insert into HaddopFiles columns ( Name, Data, Replications ) values( 'file1.txt', readFile('mylocalfile.txt'), 2 )"), new HelpEntry("update").setAvailableInRuntime(true).setScope(DataspaceType.FSPACE).setDesc("Updates existing data in the specified table collection.\nUpdate can be executed on directory table.\nIn that case corresponding file on directory table will be updated.\nThe following column can be updated:\n  - Name        - filename\n  - Data        - file content, can be string or binary data, blob, clob, flob or\n                  call of readFile function\n  - Permissions - permissions for new file, should be in format -rwxrwxrwx\nFor Data column replace or append allowed only. Data = Data + <lob | string | binary | readFile> means append.\n\nNote: FLOB types are currently not supported for Remote File Systems such as HDFS.\n      Use get_file() or getFile() functions to return complete file content.").setSyntax("update <Table Name> set <Updated Tuples List> [where <RPL Expression>]").setExamples("update HadoopFile set Name='file2.txt', Data = Data + readFile('part2.txt') where Name = 'file2.txt'"), new HelpEntry("delete").setAvailableInRuntime(true).setScope(DataspaceType.FSPACE).setDesc("Deletes existing data element or row from a specified dataspace collection.\nThis operation allows random removal of collection data based on a WHERE clause.\nDelete can be executed on directory table.\nIn that case corresponding file(s) will be removed from directory table and underlying file system.").setSyntax("delete from <Collection Name> [where <Expression>]").setExamples("delete from HadoopFile where Name = 'file2.txt'"), new HelpEntry("create hadoop job").setAvailableInRuntime(true).addTag(Tag.HADOOP).setScope(DataspaceType.FSPACE).setDesc("Creates new hadoop job. Created job is actually map task on hadoop map directory. Once job is started Hadoop split files to lines and passes lines to map task.\nMap task parses lines using specified 'file descriptor' and raises events using tlp connection created using specified 'tlp client factory'.\nInput/output collections should be created with 'create directory table' command and reference to the directories on specified HDFS server.\nOutput directory will be cleaned up before job is launched. Runtime path should reference to the directory with tnode.jar.\nDirectory can be located on specified HDFS server or locally where node is launched. If directory is on HDFS it should start with hdfs:/// prefix.\nIf runtime path not specified it will be assigned to $STROOT/platform/lib. If 'raise job event' specified [event.ds.hdfs.job]\nevent will be raised when job started/stopped.\nProperties can specify any hadoop specific properties or 'streamscape.log.level' or 'streamscape.log.parameters'. Log file will be located at <HadoopApplicationDir>/struntime.log.\n  'streamscape.log.level' - defines trace level of com.streamscape.* package, default level info\n  'streamscape.log.parameters' - defines trace config, should be in format of '(<package or class>) <level>'").setSyntax("create hadoop job <Job Name> at <HDFS Server Name>\n  input collection <Input Directory Table>\n  output collection <Output Directory Table>\n  file descriptor <File Descriptor Name>\n  tlp client factory <TLP Client Factory>\n  [input file match '<Regular Expression>']\n  [runtime path '<tnode.jar path>']\n  [properties(<PropertyName>='<PropertyValue>',...)]\n  [raise job event]").setExamples("create hadoop job job1 at air\n  input collection inputDir\n  output collection outputDir\n  file descriptor Test\n  tlp client factory TLPClient.consumer\n  input file match '.*txt'\n  runtime path 'hdfs:///libs'\n  properties(streamscape.log.level='DEBUG',mapreduce.job.inputformat.class='org.apache.hadoop.mapreduce.lib.input.TextInputFormat')\n  raise job event"), new HelpEntry("list hadoop jobs").setAvailableInRuntime(true).addTag(Tag.HADOOP).setScope(DataspaceType.FSPACE).setDesc("Lists all jobs in current or specified dataspace.").setSyntax("list jobs [ {at | @} [<DataspaceType>.]<DataspaceName> ]").setExamples("list jobs"), new HelpEntry("describe hadoop job").setAvailableInRuntime(true).addTag(Tag.HADOOP).setScope(DataspaceType.FSPACE).setDesc("Shows job properties.").setSyntax("describe job <Job Name").setExamples("describe job MyJob"), new HelpEntry("start hadoop job").setAvailableInRuntime(true).addTag(Tag.HADOOP).setScope(DataspaceType.FSPACE).setDesc("Starts the job.").setSyntax("start job <Job Name>").setExamples("start job MyJob"), new HelpEntry("stop hadoop job").setAvailableInRuntime(true).addTag(Tag.HADOOP).setScope(DataspaceType.FSPACE).setDesc("Stops the job.").setSyntax("stop job <Job Name>").setExamples("stop job MyJob"), new HelpEntry("drop hadoop job").setAvailableInRuntime(true).addTag(Tag.HADOOP).setScope(DataspaceType.FSPACE).setDesc("Drops the job.").setSyntax("drop job <Job Name> [ if exists ]").addTag(Tag.DROP).setExamples("drop job MyJob"), new HelpEntry("grant").addTag(Tag.SECURITY).addTag(Tag.GRANT).setDesc("Grant specified rights on certain dataspace objects to specified user or group.\n\nNote: Granting ALL privileges\u00a0confers object visibility rights that can \nonly be removed by revoking ALL rights from a user or group. If you don't \nwant JDBC drivers or other clients to see protected objects grant \nindividual operation rights.\n\nWarning: Granting DELETE privileges confers complete rights to remove all \nentries (rows) from data collections, even  though a user may not have \nvisibility or update rights to certain elements or columns.").setSyntax("grant { all | select[(<Col1>,...)] | insert[(<Col1>,...)] | update[(<Col1>,...)] | delete | execute | usage }\non { \n      [<Object Type>] <Object Name>\n     | all collections \n     | [ all { process | event | audit } queues \n     | [ all { event | function | virtual } ] tables \n     | all views \n     | all maps \n     | all servers \n}  \nto { <User Name> | <Group Name> }").setExamples("grant rights on all currently existing objects in current dataspace:\n\n   grant all on all collections to User1\n   grant all on all process queues to User1 \n   grant select on all collections to User1 \n   grant all on all maps to User1\n   grant usage on all servers to User1\n\ngrant rights on specific object in current dataspace:\n\n   grant all on MyTable to User1\n   grant select on MyTable to User1\n   grant execute on all functions to User1\n   grant execute on MyFunction to User1\n   grant usage on MyMongoDB to User1\n   grant select(col1, col3) on MyTable to User1\n   grant update(col1, col3) on MyTable to User1\n   grant delete on MyTable to User1\n\ngrant rights on dataspace(for currently existing objects and newly created) in current dataspace:\n\n   grant execute to user1\n   grant select to user1").setAdmin(true), new HelpEntry("revoke").addTag(Tag.SECURITY).setDesc("Revoke specified rights on certain dataspace objects from specified user or group.").setSyntax("revoke { all | select[(<Col1>,...)] | insert[(<Col1>,...)] | update[(<Col1>,...)] | delete | execute | usage }\non { \n      [<Object Type>] <Object Name>\n     | all collections \n     | [ all { process | event | audit } queues \n     | [ all { event | function | virtual } ] tables \n     | all views \n     | all maps \n     | all servers \n}  \nfrom { <User Name> | <Group Name> }").setExamples("revoke rights on all currently existing objects in current dataspace(will no have effect if rights were granted to dataspace):\n\n    revoke all on all collections from User1 \n    revoke all on all process queues from User1\n    revoke select on all collections from User1\n    revoke all on all maps from User1\n\n    revoke execute on all functions from User1\n    revoke usage on all servers from User1\nrevoke rights on specific object in current dataspace(will no have effect if rights were granted to dataspace):\n\n    revoke select on MyTable from User1\n    revoke execute on MyFunction from User1\n    revoke usage on MyMongoDB from User1\n    revoke select(col1, col3) on MyTable from User1\n\nrevoke rights on dataspace(for currently existing objects and newly created) in current dataspace(will no have effect if rights were granted specific objects):\n\n    revoke execute to user1\n    revoke select to user1").setAdmin(true), new HelpEntry("describe user acl").addTag(Tag.SECURITY).setAvailableInRuntime(true).setDesc("Describes user Access Control List (ACL). \n\nPermissions string represents the following rights (left to right):\n  'x' - Execute\n  's' - Select\n  'i' - Insert\n  'u' - Update\n  'd' - Delete\n  'g' - Usage\n\nNOTE: Minus sign '-' in place of any of these permissions means corresponding\npermission revoked from the user (or never granted).").setAlias("describe user").setSyntax("describe user [ { <UserName> | all } ] acl [<Object Name>,...]").setAdmin(true), new HelpEntry("current user").addTag(Tag.SECURITY).setAvailableInRuntime(true).setDesc("Returns current session authorization (user).").setSyntax("current user"), new HelpEntry("list collections").setAvailableInRuntime(true).setDesc("Returns list of collections in the current or specified dataspace.").setSyntax("list collections [ {at | @} [<DataspaceType>.]<DataspaceName> ] [with system]"), new HelpEntry("drop collection").setAvailableInRuntime(true).setDesc("Drops specified collection.").addTag(Tag.DROP).setSyntax("drop collection <Collection Name> [cascade | restrict] [ if exists ]"), new HelpEntry("list users").addTag(Tag.SECURITY).setDesc("Returns list of all users.").setSyntax("list users"), new HelpEntry("list groups").addTag(Tag.SECURITY).setDesc("Returns list of all groups.").setSyntax("list groups"), new HelpEntry("enable event trigger").setAvailableInRuntime(true).setDesc("Enables event trigger.").setSyntax("enable event trigger <Trigger Name>"), new HelpEntry("list functions").setAvailableInRuntime(true).setDesc("List all custom functions of the current or specified dataspace.\nIf 'all' modifier is specified, then all system functions are returned as well.\nIf 'lib' modifier is specified then available function units are returned.").setExamples("list functions all\nlist functions attributes").setSyntax("list functions [ { all | attributes | lib } ] [ {at | @} [<DataspaceType>.]<DataspaceName> ]"), new HelpEntry("check collection").setAvailableInRuntime(true).setDesc("Performs consistency check of collection and returns info about rows count, broken LOBs, FLOBs and missing/unsynched types if any.\n\nNote: Normalization repairs obsolete objects and removes suspect elements. To\n      save the suspect objects users may CHECK for unique Identity column(s) of an entry or row\n      and manually extract the contents into a different collection for re-processing.\n\nParameters:\n\n  - lobs/flobs/types                 - displays detailed info about broken LOBs/FLOBs/types\n  - consistency                      - check collection consistency\n  - order by <column> [ asc | desc ] - how to sort duplicate columns, top row from output will be kept, default is DESC - means that most newest row will be kept \n  - consistency force                - resolves consistency problems in collection, by retaining only last row\n  - top <N>                          - displays first N rows with suspect/invalid types, max N is 10000\n  - normalize [obsolete]             - fix obsolete rows\n  - normalize all                    - fix or removes suspect rows, obsolete rows will be fixed, other broken rows will be removed\n\n\nSamples:\n\nChecking SYSLDEF table:\n\n  check collection SYSLDEF consistency order by MODIFIED desc force\nChecking other tables:\n\n  check collection API_KEY_TOKENS consistency order by LAST_ACCESSED_AT desc force\n\nNormalization:\n\n Check collection types:\n   check collection mytable types top 1000\n Check collection types and normalize obsolete:\n   check collection mytable types top 1000 normalize obsolete\n").setSyntax("check collection <Collection Name> [ { lobs | flobs | types } [ top <N> ] [ normalize [{ obsolete | all }] ] | consistency [order by <column> [ desc | asc ] ] [ force ] ]"), new HelpEntry("validate flobs").setAvailableInRuntime(true).setDesc("Performs validation of all FLOBs in specified collection(s) and tuple(s) and marks them with corresponding VALID/INVALID status.\nFLOB is invalid if corresponding file doesn't exist.\n\nIf VERBOSE flag is specified, then comprehensive information about INVALID flobs will be returned.\n\nNOTE: Because all table rows will be checked command executation can take a long time.").setSyntax("validate flobs (<collection name>[.<column name>], ...) [not empty] [ verbose ]"), new HelpEntry("invalidate flobs").setAvailableInRuntime(true).setDesc("Invalidates all FLOBs in specified collection(s) and tuple(s) and marks them with corresponding INVALID status.").setSyntax("invalidate flobs (<collection name>[.<column name>], ...)"), new HelpEntry("check flobs").setAvailableInRuntime(true).setDesc("Performs check of all FLOBs in specified collection or current dataspace and returns count of invalid FLOBs.\nFLOB is invalid if it was invalidated by validate/invalidate flobs command.").setSyntax("check flobs { [(collection1, ...)] | all } [ verbose ]"), new HelpEntry("check lobs").setAvailableInRuntime(true).setDesc("Performs check of all LOBs and returns broken and not referenced LOBs.").setSyntax("check lobs"), new HelpEntry("list flobs").setAvailableInRuntime(true).setDesc("Checks and returns comprehensive information about all FLOB locations and references, in dataspadce/collection/node.\n\nWarning: the ALL option will return all FLOB references and may return thousands of rows in the result. Use this command only\nif you are aware of its consequences and have the ability to store the results. For example by redirecting output to a file.\n\nParamters:\n\n   all          - returns list of all FLOBs in the system\n   with tables  - also returns table column from where FLOB is referenced\n   locations    - returns list of all FLOB locations\n   invalid      - returns list invalid/broken FLOBs\n   unreferenced - returns list unreferenced FLOBs, cannot be specified with dataspace/collection/column").setSyntax("list flobs [ at [<dataspace>].[<collection>].[<tuple name>] ] { { locations | all } [with tables] | [ unreferenced ] [ invalid ] }"), new HelpEntry("describe collection").setAvailableInRuntime(true).setDesc("Shows metadata of the specified collection.\nTuple name should be in format <Tuple Name>[.<Sub Element Name>][.<Sub Element Name>]...\nStatistics is only available for snapshots.").setSyntax("describe collection <Collection Name> [ { tuples | tuple <Tuple Name> | indexes | triggers | statistics | meta data [ as json | as xml ] | ddl } ]"), new HelpEntry("check function").setAvailableInRuntime(true).setDesc("Performs check of function and tries to recompile the function if there are some errors.\n").setSyntax("check function <Function Name>"), new HelpEntry("check object").setAvailableInRuntime(true).setDesc("Performs check of function, trigger or actor and tries to recompile it if there are some errors.\n").setSyntax("check object <object name>"), new HelpEntry("check file table").setAvailableInRuntime(true).setDesc("Check that file table descriptor is in sync with file table. If not alter of file table is performed to set descriptor from tfcache.\nTo alter file table should be unlinked.").setSyntax("check file table <File Table Name>"), new HelpEntry("describe function").setAvailableInRuntime(true).setDesc("Shows pretty printed SQL of the specified function. Definition is default choice. For system functions body and definition are not available.").setSyntax("describe function [lib] <Function Name> { def [ inition ] | signature | body | parameters | doc | properties} [ no comment | no doc ]"), new HelpEntry("disable event trigger").setAvailableInRuntime(true).setDesc("Disables event trigger.").setSyntax("disable event trigger <Trigger Name>"), new HelpEntry("drop event trigger").setAvailableInRuntime(true).setDesc("Drops event trigger.").addTag(Tag.DROP).setSyntax("drop event trigger <Trigger Name> [ force ] [ if exists ]"), new HelpEntry("list triggers").setAvailableInRuntime(true).setDesc("Lists existing dataspace event triggers in current or specified dataspace.").setSyntax("list [ event ] triggers [ {for <Collection Name> | {at | @} [<DataspaceType>.]<DataspaceName> } ]"), new HelpEntry("describe event trigger").setAvailableInRuntime(true).setDesc("Describes event trigger. By default trigger definition is displayed.").setExamples("describe event trigger TestTrigger").setSyntax("describe event trigger <Trigger Name> { def [ inition ] | body | events | doc | properties } [ no comment | no doc ]"), new HelpEntry("list event triggers").setAvailableInRuntime(true).setDesc("Returns list of event triggers for specified collection or in current or specified dataspace.").setSyntax("list event triggers [ {for <Collection Name> | {at | @} [<DataspaceType>.]<DataspaceName> } ]"), new HelpEntry("create source stream").setAvailableInRuntime(true).setDesc("Creates new source stream collection. Parallel degree specifies how many rows are processed\nsimultaneously and can not be used if row order is important.\nWhen collection implements SourceStreamProvider interface for optimized streaming\n(e.g. file table) it is possible to force it to be processed in a generic way \n(using an index to iterate thru its rows) by specification of 'with index' statement.\n\nIf source stream created from file descriptor query expression should be a select of all fields from\nTYPES ONLY file table constrained by file descriptor. Raise eventId and with index cannot be specified in this case.\n\nEvent for stream state should be of model StreamStateEvent.").setSyntax("create source stream <Stream Name> [ if not exists ] from { table | event | file descriptor} as ( <RPL Query Expression> ) \n   raise event on <Event Id> [ at interval <Send Interval> ] \n   [ raise stream state event on <Event Id> ] [ with index ] [ parallel degree <Number Of Threads> ]"), new HelpEntry("start source stream").setAvailableInRuntime(true).setDesc("Starts source stream collection.").setSyntax("start source stream <Stream Name>"), new HelpEntry("stop source stream").setAvailableInRuntime(true).setDesc("Stops source stream collection.").setSyntax("stop source stream <Stream Name>"), new HelpEntry("suspend source stream").setAvailableInRuntime(true).setDesc("Suspends source stream collection.").setSyntax("suspend source stream <Stream Name>"), new HelpEntry("resume source stream").setAvailableInRuntime(true).setDesc("Resumes source stream collection.").setSyntax("resume source stream <Stream Name>"), new HelpEntry("create replication source").setAvailableInRuntime(true).addTag(Tag.REPLICATION).setDesc("Creates a replication source from the specified collection.\n\nIf replication underlying table is changed, replica will be notified about that eventually in 60 seconds.\nOnce replica is notified it will try to reattach. Reattach implies source/target collection schema comparison.\n\nThis command should be executed in the node where the source collection resides. Collection name\ncan be specified in the format <Dataspace Name>.<Collection Name> to specify the source collection.\nReplication source name will be the same as that of the source collection.\n\nNOTE: By default, replication sources are created in sync mode without rollback on failure. This\n      offers the fastest performance with the lowest reliability.\n\nReplication source raises the following advisories:\n\n  - advisory.replica.StateChange if replica state has changed\n  - advisory.replica.Timeout if response from replica was not received\n  - advisory.replication.Fail if replication unit was failed for SYNC replication without rollback on failure\n  - advisory.replication.Exception if any replication exception occurred\n\nParameters:\n\n    async | sync            - specifies whether replication should be performed synchronously.\n                              Asynchronous replication makes use of a Replication Queue to hold\n                              data in transit.\n                              (similar to 2-phase commit) or asynchronously (eventual consistency).\n    rollback on failure     - only applicable to SYNC replication mode.  If specified and a failure\n                              occurs at the target, the source transaction will be rolled back,\n                              similar to how a two-phase commit functions. If not specified a\n                              failure at the target will put the replica pair into out-of-sync\n                              mode but will not fail the source transaction. Rollback results\n                              can be processed by a Replication Rollback Trigger.\n    batch size              - specifies size of the statement batch used for ASYNC replication.\n    batch interval          - specifies max interval between replication batches in milliseconds,\n                              forcing the replication buffer to flush when a timer expires.\n    batch error interval    - specifies interval after unsuccessful batch delivery.\n    queue size              - specifies how big a replication queue can become (use B, Kb, Mb or Gb modifier).\n    batch timeout           - specifies timeout in milliseconds for one batch to complete. Timeout\n                              results can be processed by a Replication Timeout Trigger.\n    queue block size        - applies to JOURNAL FILE. The size of the block file used to hold data (use B, Kb, Mb or Gb modifier).\n    write buffer size       - write buffer size for JOURNAL FILE based queue (use B, Kb, Mb or Gb modifier).\n    write flush delay       - write flush delay for file based queue in milliseconds.\n    ru persist              - replication unit persistence model for file based queue (use NONE (default), NIO, RAF)\n    publish statistics for  - raises [advisory.replication.source.Metrics] advisory with metrics report\n      time window <time>    - publish statistics for every specified time window\n      unit window <count>   - publish statistics for every specified unit count\n").setSyntax("create replication source at <Collection Name> [ if not exists ] [ async | sync ] [ rollback on failure ]\n   [ batch size <Batch Size> ] [ batch interval <Batch Interval> ] [ batch error interval <Batch Error Interval> ]  [ batch timeout <timeout> ]\n   [ queue size <Queue Size> ] [ queue block size <size> ] [ write buffer size <size> ] [ write flush delay <delay> ] [ ru persist { none | nio | raf } ]\n   [ publish statistics for { time window <time> { sec | min | hr | days } | unit window <count> } ]").setExamples("create replication source at Table1 sync"), new HelpEntry("alter replication source").setAvailableInRuntime(true).addTag(Tag.REPLICATION).setDesc("Alters specified replication source.\n\nThis command can be executed on any node where specified source is visible.\n" + SOURCE_NAME_DESCRIPTION).setSyntax("alter replication source <Source name> set [ sync | async ] [ rollback on failure | process on failure ]\n   [ batch size <Batch Size> ] [ batch interval <Batch Interval> ] [ batch error interval <Batch Error Interval> ] [ batch timeout <timeout> ]    [ queue size <Queue Size> ] [ queue block size <size> ] [ write buffer size <size> ] [ write flush delay <delay> ] [ ru persist { none | nio | raf } ]\n   [ publish statistics for { time window <time> { sec | min | hr | days } | unit window <count> } ]").setExamples("alter replication source MySource1 set async\n"), new HelpEntry("create replication validate trigger").setAvailableInRuntime(true).addTag(Tag.REPLICATION).setDesc("Creates replication validate trigger on the specified replica.\nValidation trigger is executed on replica side right before statement execution in target.\nTrigger accepts new row data for INSERT, old row data for DELETE and new/old row data for DELETE.\nChanges on row data in the trigger will impact result statement. DISCARD command discard current statement\nwithout impact on other statements in the current RU and increases discarded statements count. THROW of exception\nrollbacks the current RU.\n\nThis command can be executed on local node only.\n" + REPLICA_NAME_DESCRIPTION).setSyntax("create replication validate trigger <Trigger Name> [ if not exists ] on <Replica Name>\n     before { insert | update | delete }\n     [ old data as <identifier> ] [ new data as <identifier> ]\n  as\n  {\n     <RPL Script>\n  }\n  [enable]").setExamples("create replication validate trigger MyTrigger on MyReplica\n     before insert new data as newData\n  as\n  {\n    if (newData.name == null)\n       newData.name = 'defaultname';\n    if (newData.id == null)\n       discard;\n  }\n  enable"), new HelpEntry("alter replication validate trigger").setAvailableInRuntime(true).addTag(Tag.REPLICATION).setDesc("Alters existing replication validate trigger.\n\nThis command can be executed on local node only.\n" + REPLICA_NAME_DESCRIPTION).setSyntax("alter replication validate trigger <Trigger Name> on <Replica Name>\n     before { insert | update | delete }\n     [ old data as <identifier> ] [ new data as <identifier> ]\n  as\n  {\n     <RPL Script>\n  }\n  [enable]").setExamples("alter replication validate trigger MyTrigger on MyReplica event scope observable before delete old data as oldData\n  as\n  {\n     if (oldData.id == null)\n       discard;\n  }  enable"), new HelpEntry("create replication modify trigger").setAlias("create replication modify trigger").setAvailableInRuntime(true).addTag(Tag.REPLICATION).setDesc("Creates a data transformation trigger on specified replica that lets users modify row data in-flight.\n\nA MODIFY trigger is executed on the replica side right before statement execution at the target.\nIt accepts NEW row data for INSERT, OLD row data for DELETE and NEW+OLD row data for UPDATE.\nOLD sets of data are used to drive DELETE and UPDATE logic as they are used by the replication\nengine to construct targeted WHERE clauses to access specific records.\n\nSOURCE DATA labels allow users to reference a set of data coming in from the replication source\ncollection.  OLD and NEW designations refer to before and after images of changing data.  Tuples\nor columns are based on the schema of the source collection.  You can access individual elements\nusing the following syntax:\n\nNEW SOURCE DATA AS SNEW\n \n  string name =  SNEW.fname + ' ' + SNEW.lname;\n\nREPLICA DATA labels reference the buffer that holds data to be applied to the target.  Tuples\nor columns are based on the schema of the target collection.  OLD and NEW designations refer to\nbefore and after images used to construct target SQL statement and WHERE clause.  This allows\ndata to be potentially replicated between collections with disparate schema.\n\nDeclaring a REPLICA reference will result in creation of a new empty tuple set (row) that will be\nused to construct the target SQL statement, as well as allocation of memory resources to hold\nthe transient data. \n\nIf REPLICA label is declared and elements of the REPLICA tuple set are not populated an exception\nis written to the error log.\n\nIf REPLICA DATA label is not specified no resource allocation occurs and data are passed to the\nreplica target unchanged.\n\nThrowing an exception rollbacks the current replication unit (RU).\n\nThis command can be executed on replica's local node only.\n\n" + REPLICA_NAME_DESCRIPTION).setSyntax("create replication modify trigger <Trigger Name> [ if not exists ] on <Replica Name>\n     [ using mapper <Semantic Mapper Name> ]\n     [ event scope { inherited | local | observable | global | cluster } ]\n     [ old source data as <Identifier> new source data as <Identifier> ] [ old replica data as <Identifier> new replica data as <Identifier> ]\n  as\n  {\n     <RPL Script>\n  }\n  [enable]").setExamples("create replication modify trigger MyTrigger on MyReplica\n     old source data as oldData new source data as newData old replica data as oldReplicaData new replica data as newReplicaData\n  as\n  {\n    if (newData != null) {\n      newReplicaData.id = newData.id;\n      newReplicaData.fname = newData.fname;\n      newReplicsData.fullName = newData.fname + ' ' + newData.lname;\n    }\n  }\n  enable"), new HelpEntry("alter replication modify trigger").setAlias("alter replication modify trigger").setAvailableInRuntime(true).addTag(Tag.REPLICATION).setDesc("Alters existing replication modify trigger.\n\nThis command can be executed on replica local node only.\n\n" + REPLICA_NAME_DESCRIPTION).setSyntax("alter replication modify trigger <Trigger Name> on <Replica Name>\n     [ using mapper <Semantic Mapper Name> ]\n     [ event scope { inherited | local | observable | global | cluster } ]\n     [ old source data as <Identifier> ] [ old replica data as <Identifier> ] [ new source data as <Identifier> ] [ new replica data as <Identifier> ]\n  as\n  {\n     <RPL Script>\n  }\n  [enable]").setExamples("alter replication modify trigger MyTrigger on MyReplica\n     old source data as oldData old replica data as oldReplicaData new source data as newData new replica data as newReplicaData\n  as\n  {\n    if (newData != null) {\n      newReplicaData.id = newData.id;\n      newReplicaData.name = newData.name;\n    }\n  }\n  enable"), new HelpEntry("create replica").setAvailableInRuntime(true).addTag(Tag.REPLICATION).setDesc("Creates a replica for the specified replication source.\n\nThis command should be executed in the node where the replica is going to be created.\nIf replica underlying table is changed, replica will be moved to INACTIVE state and then will try to reattach.\n\nReplica name can be specified in format <Dataspace Name>:<Replica Name> to create replica in another dataspace.\nTarget collection will be created in the same dataspace as replica. Target collection name should be specified without dataspace name.\n\nIf target collection doesn't exist or RENEW is specified the target collection will be created automtically.\nBut not for all collection type it is poosible to automatilly create the similar collection of the same type.\n\nList of collection types which can be automatically recreated:\n\n    table\n    map\n    event table\n    event queue\n    audit queue\n    process queue\n\nList of collections which cannot be automatically recreated with the same type:\n\n    log file table - table\n    file table - table\n\nList of collections which cannot be replicated:\n\n    function table\n    snapshot\n    virtual table\n    directory table\n    semagraph\n    view\n\nReplication source raises the following advisories:\n\n  - advisory.replica.StateChange if replica state has changed\n  - advisory.replication.Exception if any replication exception occurred\n\nParameters:\n    renew                - specifies whether collection needs to be recreated during replication \n                           mechanism initialization.\n    with materialization - specifies that collection needs to be materialized with existing data\n                           from the replication source.\n    stop                 - create replica in stopped state.\n    suspend              - create replica in suspended state.\n    retry count <count>  - specifies amount of retries which will be done by replication source for failed replication batch before\n                           putting replica to SUSPEND state. Default value is -1.\n                           For ASYNC replicas -1 means retry forever, 0 means don't retry.\n                           For SYNC replicas -1 and 0 means don't retry.\n    on update            - specifies the way UPDATE statements are processed\n                             'update' means as usual UPDATE statement.\n                             'upsert' means as pair of DELETE and INSERT statements.\n                           default value is UPSERT.\n    ignore on fail       - specifies to ignore UPDATE/DELETE/INSERT statements which returned zero update count or error\n                            - default(if no one specified) value is delete\n                            - (none) - don't ignore errors\n                            - (update) - ignore only UPDATE errors\n    primary key          - defines columns that will be considered as primary key on target. It means that WHERE clauses\n                           for DELETE UPDATE statements will be based on this columns. User defined primary key overrides real primary key.\n    publish statistics for  - raises [advisory.replication.replica.Metrics] advisory with metrics report\n      time window <time>    - publish statistics for every specified time window\n      batch window <count>  - publish statistics for every specified batch count\n").setSyntax("create replica <Replica Name> [ if not exists ] for <Fully Qualified Source Name> at <Target Collection Name>\n   [ renew ] [ with materialization ] [ stop ] [ suspend ] [ retry count <count> ]\n   [ on update { upsert | update } ] [ ignore on fail ( { update | delete | insert | none}, ...) ]\n   [ primary [replication] key (<column name>, ...) ]\n   [ publish statistics for { time window <time> { sec | min | hr | days } | batch window <count> } ]").setExamples("create replica Replica1 for [SourceTable1] at Table2\ncreate replica Replica1 for [RemoteNode://TSPACE.TestTspace1:SourceTable1] at Table2"), new HelpEntry("alter replica").setAvailableInRuntime(true).addTag(Tag.REPLICATION).setDesc("Alters existing replica.\n\nThis command can be executed on any node where specified replica is visible.\n" + REPLICA_NAME_DESCRIPTION).setSyntax("alter replica <Replica Name> set \n   [ replication id <replication id> ]\n   [ retry count <count> ] [ on update { upsert | update } ] [ ignore on fail ( { update | delete | insert | none}, ...) ]\n   [ primary [replication] key (<column name>, ...) ]\n   [ publish statistics for { time window <time> { sec | min | hr | days } | batch window <count> } ]").setExamples("alter replica Replica1 set retry count 10"), new HelpEntry("skip current unit for replica").setAvailableInRuntime(true).addTag(Tag.REPLICATION).setDesc("Skips current unit for the specified replica.\n\nThis command can be executed on any node where specified replica is visible.\n" + REPLICA_NAME_DESCRIPTION).setSyntax("skip current unit for <Replica Name>").setExamples("skip current unit for Replica1"), new HelpEntry("create replication pair").setAvailableInRuntime(true).addTag(Tag.REPLICATION).setDesc("Creates a replication pair - source and replica.\n\nThis command should be executed in the node where the source and the replica are going to be created.\nSource and replica names can be specified in format <Dataspace Name>:<Source/Replica Name> to create source and replica in another dataspace.\nTarget collection will be created in the same dataspace as replica. Its name should be specified without dataspace name.\nParameters:\n    async | sync         - specifies whether replication should be performed synchronously \n                           (like two-phase commit) or asynchronously (with eventual consistency).\n    renew                - specifies whether collection needs to be recreated during replication \n                           mechanism initialization.\n    with materialization - specifies that collection needs to be materialized with existing data\n                           from the replication source. This option is a placeholder, it is not implemented yet.").setSyntax("create replication pair source at <Source Name> [ async | sync ] [ rollback on failure ]\n    and replica <Replica Name> at <Target Collection Name>\n       [ renew] [ with materialization ]").setExamples("create replication pair source at Table1 and replica Replica1 at Table2"), new HelpEntry("drop replication source").setAvailableInRuntime(true).addTag(Tag.REPLICATION).addTag(Tag.DROP).setDesc("Drops specified replication source.\n\nThis command should be executed in the node where the source is located.\nSource name can be specified in format [<Dataspace Name>]:<Source Name>.\nSource should not be paired with any replica or 'force' flag should be specified.").setSyntax("drop replication source <Source Name> [ force ] [ if exists ]").setExamples("drop replication source Table1"), new HelpEntry("drop replica").setAvailableInRuntime(true).addTag(Tag.REPLICATION).addTag(Tag.DROP).setDesc("Drops specified replica.\n\nThis command should be executed in the node where the replica is located.\nReplica name can be specified in format [<Dataspace Name>]:<Replica Name>.\n").setSyntax("drop replica <Replica Name> [ if exists ]").setExamples("drop replica Replica1"), new HelpEntry("suspend replica").setAvailableInRuntime(true).addTag(Tag.REPLICATION).setDesc("Suspends specified replica. Suspended replica is connected to source but source will not send data to suspended replica.\n\nThis command can be executed on any node where specified replica is visible.\n" + REPLICA_NAME_DESCRIPTION).setSyntax("suspend replica <Replica Name>").setExamples("suspend replica Replica1\nsuspend replica [RemoteNode://TSPACE.TestTspace1:RemoteReplica1]"), new HelpEntry("resume replica").setAvailableInRuntime(true).addTag(Tag.REPLICATION).setDesc("Resumes specified replica.\n\nThis command can be executed on any node where specified replica is visible.\n" + REPLICA_NAME_DESCRIPTION).setSyntax("resume replica <Replica Name>").setExamples("resume replica Replica1\nresume replica [RemoteNode://TSPACE.TestTspace1:RemoteReplica1]"), new HelpEntry("stop replica").setAvailableInRuntime(true).addTag(Tag.REPLICATION).setDesc("Stops specified replica. All resources which were allocated for replica(on source as well) are freed for stopped replica.\n\nThis command can be executed on any node where specified replica is visible.\n" + REPLICA_NAME_DESCRIPTION).setSyntax("stop replica <Replica Name>").setExamples("stop replica Replica1\nstop replica [RemoteNode://TSPACE.TestTspace1:RemoteReplica1]"), new HelpEntry("start replica").setAvailableInRuntime(true).addTag(Tag.REPLICATION).setDesc("Starts specified replica and makes it visible to source.\n\nThis command can be executed on any node where specified replica is visible.\n" + REPLICA_NAME_DESCRIPTION).setSyntax("start replica <Replica Name>").setExamples("start replica Replica1\nstop replica [RemoteNode://TSPACE.TestTspace1:RemoteReplica1]"), new HelpEntry("evict replica").setAvailableInRuntime(true).addTag(Tag.REPLICATION).setDesc("Evicts specified replica from specified replication source.\nAlso deletes not processed transactions by this replica from replication queue. This deletion can take some time.\nOnce replica is evicted from source it will not be able to join and pair with this source again.\n\nThis command can be executed on any node where specified source is visible.").setSyntax("evict replica <Replica FQN> from <Replication Source Name>").setExamples("evict replica [RemoteNode://TSPACE.TestTspace1:RemoteReplica1] from Source1\nevict replica [RemoteNode://TSPACE.TestTspace1:RemoteReplica1] from [RemoteNode://TSPACE.TestTspace1:RemoteSource1]\n"), new HelpEntry("enable replication source").setAvailableInRuntime(true).addTag(Tag.REPLICATION).setDesc("Enables specified replication source.\n\nThis command can be executed on any node where specified source is visible.\n" + SOURCE_NAME_DESCRIPTION).setSyntax("enable replication source <Source name>").setExamples("enable replication source MySource1\nenable replication source  [RemoteNode://TSPACE.TestTspace1:RemoteSource1]\n"), new HelpEntry("disable replication source").setAvailableInRuntime(true).addTag(Tag.REPLICATION).setDesc("Disables specified replication source.\n\nThis command can be executed on any node where specified source is visible.\n" + SOURCE_NAME_DESCRIPTION).setSyntax("disable replication source <Source name>").setExamples("disable replication source MySource\ndisable replication source  [RemoteNode://TSPACE.TestTspace1:RemoteSource1]\n"), new HelpEntry("reset replication source metrics").setAvailableInRuntime(true).addTag(Tag.REPLICATION).setDesc("Resets replication source metrics.\n\nThis command can be executed on any node where specified source is visible.\n" + SOURCE_NAME_DESCRIPTION).setSyntax("reset replication source metrics <Source name>").setExamples("reset replication source metrics MySource1\nreset replication source metrics [RemoteNode://TSPACE.TestTspace1:RemoteSource1]\n"), new HelpEntry("materialize replica").setAvailableInRuntime(true).addTag(Tag.REPLICATION).setDesc("Materializes replica from its source. Append parameter specifies\nwhether the target collection will be truncated before materialization\nor the data from the source will be appended to existing data in the \ntarget collection. Copies all the data from source collection to target collection.\n\nThis command can be executed on any node where specified replica is visible.\n" + REPLICA_NAME_DESCRIPTION).setSyntax("materialize replica <Replica Name> [ append ]"), new HelpEntry("reset replica").setAvailableInRuntime(true).addTag(Tag.REPLICATION).setDesc("Resets replication ID on replica to be the same as on source. No data transfer or data update performed. Replica should be not stopped and not suspended.\nIf metrics modifier is specified reset of replica metrics is only performed.\n\nThis command can be executed on any node where specified replica is visible.\n" + REPLICA_NAME_DESCRIPTION).setSyntax("reset replica <Replica Name> [metrics]"), new HelpEntry("list replication sources").setAvailableInRuntime(true).addTag(Tag.REPLICATION).setDesc("Lists all replication sources in the current or specified dataspace.").setSyntax("list replication sources [ {at | @} [<DataspaceType>.]<DataspaceName> ]"), new HelpEntry("list replication queues").setAvailableInRuntime(true).addTag(Tag.REPLICATION).setDesc("Lists all replication queues in the current or specified dataspace.").setSyntax("list replication queues [ {at | @} [<DataspaceType>.]<DataspaceName> ]"), new HelpEntry("list replicas").setAvailableInRuntime(true).addTag(Tag.REPLICATION).setDesc("Lists all replicas in the current or specified dataspace.").setSyntax("list replicas [ {at | @} [<DataspaceType>.]<DataspaceName> ]"), new HelpEntry("describe replication source").setAvailableInRuntime(true).addTag(Tag.REPLICATION).setDesc("Shows metadata for the specified replication source.\n\nThis command can be executed on any node where specified source is visible.\n" + SOURCE_NAME_DESCRIPTION).setSyntax("describe replication source <Source Name> [ metrics ]"), new HelpEntry("describe replication queue").setAvailableInRuntime(true).addTag(Tag.REPLICATION).setDesc("Shows metadata for the specified replication queue.\n\n" + REPLICATION_QUEUE_NAME_DESCRIPTION + "\n\n" + SOURCE_NAME_DESCRIPTION).setSyntax("describe replication queue { <Queue Name> | for <Source Name> }"), new HelpEntry("describe replica").setAvailableInRuntime(true).addTag(Tag.REPLICATION).setDesc("Shows metadata for the specified replica.\nnThis command can be executed on any node where specified replica is visible.\n" + REPLICA_NAME_DESCRIPTION).setSyntax("describe replica <Replica Name> [ { metrics [full] | last replication unit | state ]"), new HelpEntry("get replication flow").setAvailableInRuntime(true).addTag(Tag.REPLICATION).setDesc("Returns replication flow for specified replication source or replication metrics for specified replica.\n\nThis command can be executed on any node where specified source is visible.\n" + SOURCE_NAME_DESCRIPTION).setSyntax("get replication flow [ metrics ] { at <Source Name> | at replica <Replica Name> } [ with metrics ] [ as json | as xml ]"), new HelpEntry("get function list").setAvailableInRuntime(true).setDesc("Returns function list in the current or specified dataspace.\nIf 'full' modifier is specified then result contains also definition and description.\nTo filter function by type use 'system', 'user', 'all' modifiers.\nTo filter function by group specify a group name. There are available group name values: \nTEXT, ARITHMETIC, DATE, FORMAT, FILE, SYSTEM, OTHER").setSyntax("get function list {parameters | full} [{ system | user | all }] [group <Group Name>] [at [<Dataspace Type>.]<Dataspace Name>]] [as json | as xml]"), new HelpEntry("create domain").setAvailableInRuntime(true).setDesc("Creates new data domain.").setExamples("create domain Employee as other check ( value is not null and\n   isType( value, 'Employee' ) )").setSyntax("create domain <Domain Name> as <Predefined Type>\n   [ <Default Clause> ] [ <Domain Constraint> ]"), new HelpEntry("alter domain").setAvailableInRuntime(true).setDesc("Alters existing data domain.").setExamples("alter domain Employee add check (isType(value,'Employee'))").setSyntax("alter domain <Domain Name> { set default <DefaultClause> | drop default |\n   add [ constraint ] <Domain Constraint> | drop constraint <Constraint Name>}"), new HelpEntry("drop domain").setAvailableInRuntime(true).addTag(Tag.DROP).setDesc("Drops existing data domain.\nIf 'cascade' modifier is specified, it works differently from most other\nobjects. If a table features a column of the specified DOMAIN, the column\nsurvives and inherits the DEFAULT CLAUSE, and the CHECK CONSTRAINT of the DOMAIN").setExamples("drop domain Employee").setSyntax("drop domain <Domain Name> [ cascade ] [ if exists ]"), new HelpEntry("list domains").setAvailableInRuntime(true).setDesc("Lists existing data type domains. If 'ALL' keyword specified, \nthen system domains are listed along with user defined ones.").setExamples("list domains (all)").setSyntax("list domains [ ( all ) ]"), new HelpEntry("describe domain").setAvailableInRuntime(true).setDesc("Describes existing data type domain.").setExamples("describe domain DataEvent").setSyntax("describe domain <Domain Name>"), new HelpEntry("check types").setAvailableInRuntime(true).setDesc("Performs check that all values in collections references to existing java types.").setExamples("check types").setSyntax("check types"), new HelpEntry("list objects").setAvailableInRuntime(true).setDesc("Returns list of all collections, actors, triggers, functions and sequences with their states in current or specified dataspace.").setExamples("list objects").setSyntax("list objects [ {at | @} [<DataspaceType>.]<DataspaceName> ]"), new HelpEntry("list references to").setAvailableInRuntime(true).setDesc("Returns list references to specified object.").setExamples("list references to type Employee").setSyntax("list references to {type | collection | table | map | function | actor | trigger} <Object Name>"), new HelpEntry("create function").setAvailableInRuntime(true).setDesc("Creates new function.\n\nJavadoc can be defined anywhere in command, preferable at the beginning and should be enclosed in /** and */.\nJavadoc extends standard html tags with the following tags:\n\n   Links:\n      {@link type#<typename>}                                               - Link to semantic type with specified name.\n      {@link prototype#<eventId>}                                           - Link to event prototype with specified eventId.\n      {@link service#<ServiceType>.<ServiceName>}                           - Link to service with specified type and name.\n      {@link handler#<ServiceType>.<ServiceName>.<HandlerName>}             - Link to service event handler with specified type and name.\n      {@link collection#[<DataspaceType>].<DataspaceName>.<CollectionName>} - Link to collection in specified dataspace. Default dataspace type is TSPACE.\n      {@link function#[<DataspaceType>].<DataspaceName>.<FunctionName>}     - Link to function in specified dataspace. Default dataspace type is TSPACE.\n\n   Code tag:\n      {@code <some code>} - Formats specified code with specific font.\n\n   Tags, in order they will be in result html:\n      @author <authors>              - Authors in javadoc style.\n      @version <version>             - Version in javadoc style.\n      @copyright <copyright>         - Copyright in javadoc style.\n      @since <since version or date> - Since in javadoc style.\n      @see <link>                    - See also in javadoc style.\n      @anytag <any text>             - Any tag.\n      @raises <events>               - Raises events.\n      @todo <what todo>              - Todo.\n\n    NOTE: Tags should be located at the end of javadoc. One tag ends where another tag starts.\n").setExamples("create function anHourBeforeMax (e integer)\n  returns timestamp\n  specific anHourBeforeMaxWithInt\n  as\n     return (select max(EventTime) from atable WHERE EventType = e) - 1 hour\n\ncreate function getTransientTable()\n  returns table(id int, name string)\nas\n{\n   transient table T1(id int, name string);\n   \n   insert into T1 values(1, 'First');\n   insert into T1 values(2, 'Second');\n   insert into T1 values(3, 'Third');\n   \n   return T1;\n}\n\ncreate function getTransientMap()\n  returns map(int, string)\nas\n{\n   transient map M1(int,string);\n   \n   M1.put(1, 'First');\n   M1.put(2, 'Second');\n   M1.put(3, 'Third');\n   \n   return M1;\n}\n\ncreate function getTransientQueue()\n  returns queue(string)\nas\n{\n   transient queue Q1(string);\n   \n   Q1.add('First');\n   Q1.add('Second');\n   Q1.add('Third');\n   \n   return Q1;\n}").setSyntax("create function <Function Name> ( [ [ { in | out | inout } ] <Tuple Name> <Data Type> ],... ) [ if not exists ]\n  returns { <Data Type> | table(<Table Definition>) | map(<Key Type>, <Value Type>) | queue(<Data Type>) }\n  [ specific <Specific Name> ]\nas \n  {\n      <RPL script>\n      return { NULL | <Value Expression> };\n  }"), new HelpEntry("alter function").setAvailableInRuntime(true).setDesc("Alters existing function.").setExamples("alter function childArrOne as\n{\n  declare idList integer array default array[];\n  forLoop:\n     for select id from ptree where pid = p_pid do\n        set idList[cardinality(id_list) + 1] = id;\n        set idList = idList || child_arr(id);\n     end for forLoop;\n  return idList;\n}").setSyntax("alter function <Function Name> [ body ] as <Function Body>"), new HelpEntry("drop function").setAvailableInRuntime(true).addTag(Tag.DROP).setDesc("Drops existing function.").setExamples("drop function childArrOne").setSyntax("drop function <Function Name> [ cascade | force ] [ if exists ]"), new HelpEntry("create aggregate function").setAvailableInRuntime(true).setDesc("Creates new aggregate function.\nParametersList should comply with the following template:\n( [IN] <ParameterName> <ParameterType>,[IN] <ParamName> BOOLEAN,  \n  INOUT <ParameterName> <ParameterType>, INOUT <ParameterName> <ParameterType> )").setExamples("create aggregate function udavg(in x integer, in flag boolean,\n  inout addup bigint, inout counter int)\n  returns integer\n{\n  if flag then\n     return addup / counter;\n  else\n     set counter = coalesce(counter, 0) + 1;\n     set addup = coalesce(addup, 0) || coalesce(x, 0);\n     return null;\n  end if;\n}").setSyntax("create aggregate function <Function Name> ( [ in ]  <Tuple Name> <Data Type>, [IN] <Tuple Name> boolean,  \n                                           inout <Tuple Name> <Data Type>, inout <Tuple Name> <Data Type> )\n [ if not exists ]\n  returns <Data Type>\n  [ specific <Specific Name> ]\n  [ { deterministic | not deterministic } ]\n  as\n  {\n      <RPL Script>\n      return { NULL | < ValueExpression > };\n  }"), new HelpEntry("create timer").setAvailableInRuntime(true).addTag(Tag.TIMER).setDesc("Creates new timer. Map can contain key-value pairs which are added to\nraised MapEvent for this timer making it possible to filter these\nevents using selector.\nInterval should be greater than 0. Repeat count less or equals 0 means repeat infinetelly, default value is 1.").setExamples("create timer QueuePurge for interval 5000 repeat 5 times group AppTimers").setSyntax("create timer <TimerName> [ if not exists ] for interval <Interval> { ms | sec | min | hr } \n   [ repeat <RepeatCount> times ] [ group <Timer Group> ]\n       [ map(<Key 1>='<Value 1>', <Key 2>='<Value 2>',...) ]"), new HelpEntry("alter timer").setAvailableInRuntime(true).addTag(Tag.TIMER).setDesc("Alters existing timer.").setExamples("alter timer QueuePurge interval 10000 repeat 10 times").setSyntax("alter timer <TimerName> [interval <Interval> { ms | sec | min | hr }] \n   [ repeat <RepeatCount> times ] [ group <Timer Group> ]\n       [ map(<Key 1>=<Value 1>, <Key 2>=<Value 2>,...) ]"), new HelpEntry("drop timer").setAvailableInRuntime(true).addTag(Tag.TIMER).addTag(Tag.DROP).setDesc("Drops existing timer.").setExamples("drop timer QueuePurge").setSyntax("drop timer <Timer Name> [ if exists ]"), new HelpEntry("start timer").setAvailableInRuntime(true).addTag(Tag.TIMER).setDesc("Starts existing timer.").setExamples("start timer QueuePurge").setSyntax("start timer <Timer Name>"), new HelpEntry("stop timer").setAvailableInRuntime(true).addTag(Tag.TIMER).setDesc("Stops existing timer.").setExamples("stop timer QueuePurge").setSyntax("stop timer <Timer Name>"), new HelpEntry("suspend timer").setAvailableInRuntime(true).addTag(Tag.TIMER).setDesc("Suspends existing timer.").setExamples("suspend timer QueuePurge").setSyntax("suspend timer <Timer Name>"), new HelpEntry("resume timer").setAvailableInRuntime(true).addTag(Tag.TIMER).setDesc("Resumes existing timer.").setExamples("resume timer QueuePurge").setSyntax("resume timer <Timer Name>"), new HelpEntry("cancel timer").setAvailableInRuntime(true).addTag(Tag.TIMER).setDesc("Cancels existing timer. If the timer is repeating, the expiration\ninterval is reset and the repeat cycle begins again.").setExamples("cancel timer QueuePurge").setSyntax("cancel timer <Timer Name>"), new HelpEntry("reset timer").setAvailableInRuntime(true).addTag(Tag.TIMER).setDesc("Resets the timer to its initial state and starts countdown again.").setExamples("reset timer QueuePurge").setSyntax("reset timer <Timer Name>"), new HelpEntry("list timers").setAvailableInRuntime(true).addTag(Tag.TIMER).setDesc("Lists timers in current or specified dataspace.").setExamples("list timers").setSyntax("list timers [ {at | @} [<DataspaceType>.]<DataspaceName> ]"), new HelpEntry("describe timer").addTag(Tag.TIMER).setAvailableInRuntime(true).setDesc("Describes existing timer.").setExamples("describe timer QueuePurge").setSyntax("describe timer <Timer Name>"), new HelpEntry("set collection").setAvailableInRuntime(true).setDesc("Allows to change collection memory model and read only/read write flags.").setExamples("set collection TestCollection memory model LOGGED\nset collection TestCollection read only\nset collection TestCollection read write").setSyntax("set collection <Collection Name> { memory model { memory | logged | persistent } | { read only | read write } }"), new HelpEntry("dump dataspace").addTag(Tag.DUMP).addTag(Tag.DATASPACE).setAvailableInRuntime(true).setDesc("Dumps content of the specified dataspace into file.").setSyntax("dump dataspace <DataspaceName> to '<DumpFile>[.gz]' [compress] [ password '<Password>' ] [ no data ] [ verbose ] [ ignore (errors) ]\n   [ { include | exclude } ( { * | collections | functions | actors | servers | triggers | views | sequences | timers | textindexes |            packages | types | event prototypes | client factories | db factories | file descriptors | flobs | deps } ) ] \n   [ packages (<type>.<name>,...) ) ] [ with wait ]").setExamples("dump dataspace TestDataspace to 'c:/Streamscape/dumps/TestDs.dmp'\ndump dataspace TestDataspace to 'c:/Streamscape/dumps/TestDs.dmp' packages(sdo.UserPkg) verbose").setInitialVersion("3.6 Build 18"), new HelpEntry("dump collection").addTag(Tag.DUMP).setAvailableInRuntime(true).setDesc("Dumps content of the specified collection into file.\n" + HelpRegistry.dropboxHelp("DumpFile")).setSyntax("dump collection <CollectionName> to '<DumpFile>[.gz]' [ compress ] [ password '<Password>' ] [ no data ] [ verbose ] [ ignore (errors) ]\n   [ { include | exclude } (triggers) ] [ packages (<type>.<name>,...) ) ]\n   [ with wait ]").setExamples("dump collection TestTable to 'c:/Streamscape/dumps/TestTable.dmp'\ndump collection TestTable to 'c:/Streamscape/dumps/TestTable.dmp' packages(sdo.UserPkg) verbose").setInitialVersion("3.6 Build 18"), new HelpEntry("load dataspace").addTag(Tag.DUMP).addTag(Tag.DATASPACE).setAvailableInRuntime(true).setDesc("Loads content of entire dataspace from the dump file.\nParameters:\n\n    - ignore errors       - ignore all errors during load\n    - ignore dependencies - don't fail if function/trigger/actor references to not existing objects in another dataspace\n" + HelpRegistry.dropboxHelp("DumpFile")).setSyntax("load dataspace <DataspaceName> from '<DumpFile>[.gz]' [ ignore (errors, dependencies) ] [ password <Password>] [ no data ] [ verbose ]\n   [ { include | exclude } ( { * | collections | functions | actors | servers | triggers | views | sequences | timers | textindexes |            packages [global { true | false}] | types | event prototypes | client factories | db factories | file descriptors | flobs | deps } ) ] \n   [ as { merge | new } ] [ with wait ]").setExamples("load dataspace TestDataspace from 'c:/Streamscape/dumps/TestDs.dmp'").setInitialVersion("3.6 Build 18"), new HelpEntry("load collection").addTag(Tag.DUMP).setAvailableInRuntime(true).setDesc("Loads the contents of specified collection from a dump file. A dump file location can also \npoint to a DropBox abstraction using a standard URL scheme.\n\n    dropbox://<dropbox name>/<drop box resource path>\n\nfor example:\n\n    dropbox://BobsBox/root/big_document.txt").setSyntax("load collection <CollectionName> from '<DumpFile>[.gz]' [ ignore (errors, dependencies, flobs) ] [password '<Password>'] [ no data ] [verbose]\n   [ { include | exclude } (triggers) ] \n   [ as { merge | replace with truncate| new [{ memory | logged | persistent }] [<NewCollectionName>]} ] \n   [ with wait ]").setExamples("load collection Users from 'c:/Streamscape/dumps/TestTable.dmp' as new\nload collection Users from 'c:/Streamscape/dumps/users.dmp' ignore ( errors ) exclude triggers\nload collection Users from 'dropbox://BobsBox/root/users.dmp'\nload collection Users from 'dropbox://BobsBox/root/users.dmp' as replace with truncate \nload collection Users from 'dropbox://BobsBox/root/users.dmp' verbose as new memory NewUsers").setInitialVersion("3.6 Build 18"), new HelpEntry("load replication queue").addTag(Tag.DUMP).setAvailableInRuntime(true).setDesc("Loads a dump file into an active Replication Queue.\n\nThe file must be in a delimited format as specified by the configuration parameters. Each\nrecord must have a matching number of elements as those defined by the Replication Source of\nthe specified Replication Queue.  Otherwise an Element Mismatch exception will be thrown.\n\nBefore this command can be run the Replication Source must be Disabled to avoid collision\nbetween active data streams and new file content.  File contents loaded into the Replication\nQueue will be immediately delivered to any active Replicas.  For better control it is\nrecommended that Replica data deliver be suspended until the load operation completes.\nIf 'metaset' option is specified it's supposed the dump file will have journal file table format.\n'No metaset as' option requires operation parameter specification (insert or delete)\n" + HelpRegistry.dropboxHelp("DumpFile")).setSyntax("load replication queue <ReplicationQueue> from '<DumpFile>' \n[format (delimiter '<delimiter>', quote '<symbol>', quote_escape '<symbol>', date '<mask>', sqldate '<mask>', sqltimestamp '<mask>')] \n[ru size <size>] [ { metaset | no metaset as } [insert][, update][, delete] ]").setExamples("load replication queue TestReplicationQueue from 'c:/Streamscape/dumps/ReplicationQueue.dmp' \nformat (delimiter '||', sqltimestamp 'MMM dd yyyy hh:mm:ss:SSSa') ru size 50"), new HelpEntry("dump replication queue").addTag(Tag.DUMP).setAvailableInRuntime(true).setDesc("Dumps data from replication queue to the file.\n" + HelpRegistry.dropboxHelp("DumpFile")).setSyntax("dump replication queue TestReplicationQueue to '<DumpFile>' [ { metaset | no metaset } [insert][, update][, delete] ]\n[format (delimiter '<delimiter>', quote '<symbol>', quote_escape '<symbol>', date '<mask>', sqldate '<mask>', sqltimestamp '<mask>')] \n").setExamples("dump replication queue TestReplicationQueue to 'c:/Streamscape/dumps/ReplicationQueue.dmp' no metaset insert"), new HelpEntry("compare dataspace").addTag(Tag.DUMP).addTag(Tag.DATASPACE).setAvailableInRuntime(true).setDesc("Compares specified target dataspace to specified source dump.").setSyntax("compare dataspace <DataspaceName> to dump '<DumpFile>[.gz]' [password '<Password>'] [verbose]").setExamples("compare dataspace TestDataspace to dump 'c:/Streamscape/dumps/TestDs.dmp'").setInitialVersion("3.8 Build 43"), new HelpEntry("retry recovery").setAvailableInRuntime(true).setDesc("Retries a statement from recovery errors table (a statement from recovery\nlog which failed during recovery log processing). If statement is not \nspecified, all statements are retried. \nFailed statements from recovery log can be seen by executing the 'show recovery'\noperation.").setSyntax("retry recovery [ { statement <Statement Id> | where <Statement Selection Condition> } ]").setExamples("retry recovery statement 12"), new HelpEntry("discard recovery").setAvailableInRuntime(true).setDesc("Discards a statement from recovery errors table (a statement from recovery\nlog which failed during recovery log processing). If statement is not \nspecified, all statements are discarded and dataspace store SUSPECT\nstate is reset to ONLINE.\nFailed statements from recovery log can be seen by executing the 'show recovery'\noperation.").setSyntax("discard recovery [ { statement <Statement Id> | where <Statement Select Condition> } ]").setExamples("discard recovery statement 12"), new HelpEntry("alter recovery").setAvailableInRuntime(true).setDesc("Updates a statement (or statements) from recovery errors table (a statement \nfrom recovery log which failed during recovery log processing). \nFailed statements from recovery log can be seen by executing the 'show recovery'\noperation.").setSyntax("alter recovery [ statement <StatementId> ] \n   set STATEMENT = <Expression> [,DATASPACE = <Expression>]\n      [where <StatementSelectionCondition>]").setExamples("alter recovery set DATASPACE=replace(DATASPACE, 'SDS', 'TEST')   where STATEMENT like '%CREATE%'"), new HelpEntry("show recovery").setAvailableInRuntime(true).setDesc("Shows a statement (or statements) from recovery errors table (a statement \nfrom recovery log which failed during recovery log processing). ").setSyntax("show recovery [ { statement <StatementId> | where <StatementSelectionCondition> } ]").setExamples("show recovery where STATEMENT like '%CREATE%'"), new HelpEntry("checkpoint").setAvailableInRuntime(true).setDesc("Dumps all memory data to disk and clears recovery log.\nLock timeout means time in milliseconds to wait for completion transaction queries which block checkpoint execution.\nDefault lock timeout is 10000 milliseconds.").setSyntax("checkpoint [ defrag ] [ lock timeout <timeout> ]").setExamples("checkpoint lock timeout 60000"), new HelpEntry("describe checkpoint").setAvailableInRuntime(true).setDesc("Returns information about checkpoint configuration and current condition.\nIf attempts is specified then checkpoint attempts during last 2 weeks will be returned.\n\nEnable consistency check during checkpoint:\n  set datastore property dtspace.checkpoint_check_consistency true\n").setSyntax("describe checkpoint [attempts]").setExamples("describe checkpoint"), new HelpEntry("select into").setAvailableInRuntime(true).setDesc("Creates a new collection based on the specified query. Query is not restricted\nby simple select from one collection. It can include joins and unions of several\ncollections as well as 'where' predicate to filter rows which have to get into\nthe new collection.\n \nWhen the target collection is file table, its source file name has to be specified\nusing the SOURCE clause in addition to collection name.\n").setSyntax("select <ColumnList> into [ { memory | logged | persistent } ] { [ file ] table | map }\n   <TargetCollectionName> [ source '<FileName>' ] \n      from <SourceCollection> [ where <QueryPredicate> ]").setExamples("select * into persistent table NewTable from OldTable\n\nselect Column1, Column2 into map NewMap from OldTable\n\nselect t1.column1, t2.column2 into file table NewTable source 'NewTable.csv;fs=,'\n   from OldTable t1, OldTable t2 where t1.column3 = t2.column3"), new HelpEntry("create dataspace").setAvailableInRuntime(true).setInitialVersion("3.7 Build 1").setDesc("Creates a new dataspace of a specified type, based on new definition or an\nexisting dataspace. There are two distinct versions of the command depending\non which approach is taken based on presence or absence of LIKE clause.\n\nWITHOUT DATA parameter applies to spaces created using the LIKE clause. When\nLIKE is specified WITHOUT DATA, the data from source model collections are not\ncopied into the new dataspace.").setExamples("create dataspace TestDataspace type TSPACE event scope GLOBAL log level DEBUG\ncreate dataspace TestDataspace like AnotherTestDataspace").setSyntax("create dataspace <Dataspace Name> [ if not exists ]\n    type { tspace | qspace | fspace | cspace }\n        [ event scope { local | observable | global | cluster } ]\n            [ owner <User Name>]\n                [ log level { debug | info | error } ]\n                  [ metaset {dynamic values '<json values string>'| predefined values '<json values string>'} ]\n\nOR\n\ncreate dataspace <DataspaceName> [if not exists]\n    like <SourceDataspaceName>\n        [event scope { local | observable | global | cluster }]\n            [ owner <User Name>]\n                [ log level { debug | info | error } ]\n                    [without data]}"), new HelpEntry("drop dataspace").setDesc("Drops the specified dataspace.").addTag(Tag.DROP).setExamples("drop dataspace TestDataspace").setSyntax("drop dataspace <Dataspace Name> [ if exists ] [ cascade ] [ force ]"), new HelpEntry("alter dataspace").setAvailableInRuntime(true).setDesc("Alters existing dataspace.").setExamples("alter dataspace TestDataspace set event scope GLOBAL set log level INFO\nalter dataspace tspace.TestDataspace set event scope observable").setSyntax("alter dataspace [<Dataspace Type>.]<Dataspace Name> \n   [ set event scope { local | observable | global } ]\n   [ set log level { debug | info | error } ]\n   [ set owner <New Owner name> ]\n   [ rename to <New Dataspace Name> [force] ]\n   [ metaset {dynamic values '<json values string>'| predefined values '<json values string>'} ]\n"), new HelpEntry("create actor").setAvailableInRuntime(true).setDesc("Creates new actor.\n\nAn actor waits for one or more events to arrive and then executes\nthe logic defined in the body of the script. Events are passed into the script\nbody as individual elements, as correlated groups (unary sets) or complete\nevent sets depending on whether the user specified a time or batch window.\nEvents may be selected based on their contents via  a SELECTOR clause or\nmay be filtered by Event Id and relevant wild-cards.  \n\nNOTE:  Event Sets (windows) filtered by Event Id wild cards are currently not\nsupported by the actor.\n\nReferences to event instances or sets may be declared and used as part of\nscript logic and will be passed as either event objects or event queues. If a \ntime window is specified, the actor's logic is executed when the \nspecified window interval expires. If a batch window is specified, the event \nactor logic is executed when a specified number of events fills in the in-\ncoming buffer of the actor. Depending on the options chosen an\nactor may discard the contents of a prior window and start the \ncorrelation anew, or may overlay the old values based on the strategies of\nMRE (Most Recent Event) or LRE (Least Recent Event).\n\nSettings and options have inter-dependencies and certain combinations\nmay not be supported and will result in actor definition errors. However\nthe body of an actor may contain any logic and may access any\ndata collection, service or application engine component normally accessible\nvia SLANG or the API interface.  The body of an actor is executed\nin it's own thread based on a worker model. As such users have the option \nof specifying a single worker for lowest latency at the expense of throughput\nor may specify multiple workers to achieve parallelism.\n\nThe Parallel Worker option tells an actor how many parallel instances\nof an actor may be executing at once. This results in higher throughput but \nwill drive up CPU and memory usage. Actors that are stopped will need to\nwait for all outstanding instances to complete their processing.\n\nIf number of workers is zero, each event set is processed in a separate new\nthread. If number of threads is more than zero, a thread pool is created and\nmanaged by the engine. If the workers option is not specified at all, each event \nset is processed in the calling thread. Thresholds instruct the engine to raise\nadvisories when the size of the worker pool increases past a threshold.\n\nNOTE: A window can only be specified in conjunction with an 'event set' modifier.\nIt is unavailable for 'any event' option.\n\nJavadoc can be defined anywhere in command, preferable at the beginning and should be enclosed in /** and */.\nJavadoc extends standard html tags with the following tags:\n\n   Links:\n      {@link type#<typename>}                                               - Link to semantic type with specified name.\n      {@link prototype#<eventId>}                                           - Link to event prototype with specified eventId.\n      {@link service#<ServiceType>.<ServiceName>}                           - Link to service with specified type and name.\n      {@link handler#<ServiceType>.<ServiceName>.<HandlerName>}             - Link to service event handler with specified type and name.\n      {@link collection#[<DataspaceType>].<DataspaceName>.<CollectionName>} - Link to collection in specified dataspace. Default dataspace type is TSPACE.\n      {@link function#[<DataspaceType>].<DataspaceName>.<FunctionName>}     - Link to function in specified dataspace. Default dataspace type is TSPACE.\n\n   Code tag:\n      {@code <some code>} - Formats specified code with specific font.\n\n   Tags, in order they will be in result html:\n      @author <authors>              - Authors in javadoc style.\n      @version <version>             - Version in javadoc style.\n      @copyright <copyright>         - Copyright in javadoc style.\n      @since <since version or date> - Since in javadoc style.\n      @see <link>                    - See also in javadoc style.\n      @anytag <any text>             - Any tag.\n      @raises <events>               - Raises events.\n      @todo <what todo>              - Todo.\n\n    NOTE: Tags should be located at the end of javadoc. One tag ends where another tag starts.\n").setExamples("create actor TestActor on [event.message] as Event1\n   for any event\nas\n{\n   log.info('Event actor fired.');\n}\nenable\n\ncreate actor TestActor on \n   [event.message1] => Event1 when (Prop1 = 'SomeValue'), \n   [event.message2] => Event2\n      for lre event set time window 30 sec\n      dynamic parallel workers 100 notify threshold 90\nas\n{\n   log.info('Event actor fired.');\n   \n   MapEvent correlation = new [event.correlator];\n   correlation.setObject('First Event', Event1);\n   correlation.setObject('Second Event', Event2);\n   \n   raise event correlation;\n}\n\ncreate actor TestActor on \n   [event.message1] as Event1 when (TickerSymbol = 'IBM') , \n   [event.message2] as Event2 when (Type = 'SELL')\n      for complete event set\n         time window 1 min\n      event scope global\n      fixed parallel workers 0\nas\n{\n   log.info('Event actor fired.');\n   \n   List messages = new List();\n   \n   for (select Event.data as message from Event1) \n      messages.add(message);\n   \n   int averagePrice = select avg(Event.data.price) from Event2;\n   \n   MapEvent correlation = new [event.correlator];\n   correlation.setObject('Messages', messages);\n   correlation.setObject('Average Price', averagePrice);\n   \n   raise event correlation;\n}").setSyntax("create [ sync ] actor <Actor Name> [ if not exists ] on \n   <Event Id1> { as | => } <Identifier> [ when (<Event Selector Clause>) ] , ... \n      for { any event | { mre | lre | complete } event set }\n         [ { time window <Window Size> { ms | sec | min | hr | days } | batch window <Window Size> } ] \n      [ event scope { inherited | local | observable | global | cluster } ]\n      [ { dynamic | fixed } parallel workers <Pool Size> [ notify threshold <Threshold Value> ] ]\nas\n{\n   <RPL Script>\n}\n[ enable ]"), new HelpEntry("alter actor").setAvailableInRuntime(true).setDesc("Alters existing actor body. See 'create actor' for details.").setExamples("alter sync actor TestActor \n on \n   [event.message1] => Event1, \n   [event.message2] => Event2\n     for lre event set\n        time window 30 sec\n event scope observable\n parallel workers 100 notify threshold 90\nas\n{\n   log.info('Event actor fired.');\n   \n   MapEvent correlation = new [event.correlator];\n   correlation.setObject('First Event', Event1);\n   correlation.setObject('Second Event', Event2);\n   \n   raise event correlation;\n}\n\nalter actor TestActor \nas\n{\n   log.info('Event actor fired with new body.');\n}").setSyntax("alter [ sync ] actor <Actor Name> \n  [ on <Event Id1> { as | => } <Identifier> [ when (<RPL boolean expression>) ] , ... ]\n     [ for { any event | { mre | lre | complete } event set } ]\n         [ { time window <Window Size> { ms | sec | min | hr | days } | batch window <Window Size> } ] \n      [ event scope { inherited | local | observable | global | cluster } ]\n      [ { dynamic | fixed } parallel workers <Pool Size> [ notify threshold <Threshold Value> ] ]\nas\n{\n   <RPL Script>\n}\n[ enable ]"), new HelpEntry("drop actor").setAvailableInRuntime(true).addTag(Tag.DROP).setDesc("Drops existing actor.").setExamples("drop actor TestActor").setSyntax("drop actor <Actor Name> [ force ] [ if exists ]"), new HelpEntry("list actors").setAvailableInRuntime(true).setDesc("Lists all actors in current or specified dataspace.").setExamples("list actors").setSyntax("list actors [ {at | @} [<DataspaceType>.]<DataspaceName> ]"), new HelpEntry("describe actor").setAvailableInRuntime(true).setDesc("Describes actor. By default actor definition is displayed.").setExamples("describe actor TestActor").setSyntax("describe actor <Actor Name> { def [ inition ] | body | events | doc | properties } [ no comment | no doc ]"), new HelpEntry("enable actor").setAvailableInRuntime(true).setDesc("Enables actor so that it starts to accept events.").setExamples("enable actor TestActor").setSyntax("enable actor <ActorName>"), new HelpEntry("disable actor").setAvailableInRuntime(true).setDesc("Disables actor so that it does not accept any events.").setExamples("disable actor TestActor").setSyntax("disable actor <Actor Name>"), new HelpEntry("create replication trigger").setAvailableInRuntime(true).addTag(Tag.REPLICATION).setDesc("Creates new replication trigger.\nThe following trigger types can be created on ROLLBACK ON FAIL SYNC SOURCE:\n   - ON ROLLBACK\nThe following trigger types can be created on REPLICA:\n   - AFTER SUCCESS\n   - AFTER FAIL").setExamples("create replication trigger ReplicaLogger on replica Replica1 after success event scope global\nas\n{ \n   log.info('Row replicated successfully.'); \n}\nenable\n\n\ncreate replication trigger ReplicaLogger on replica Replica2 after success event scope global\n   old data as OldData\n   new data as NewData\n   replica data as RepData\nas \n{ \n   log.info('RepData.operationType: ' + RepData.operationType);\n   if (operation.type == operation.INSERT) \n   {\n      log.info('Operation Type: INSERT');\n      log.info('NewData: ' + NewData.id + ', ' + NewData.name);\n   }\n   else if (operation.type == operation.DELETE) \n   {\n      log.info('Operation Type: DELETE');\n      log.info('OldData: ' + OldData.id + ', ' + OldData.name);\n   }\n   else if (operation.type == operation.UPDATE) \n   {\n      log.info('Operation Type: UPDATE');\n      log.info('OldData: ' + OldData.id + ', ' + OldData.name);\n      log.info('NewData: ' + NewData.id + ', ' + NewData.name);\n   }\n}\nenable\n\n\ncreate replication trigger ReplicaFailLogger on replica Replica2 after fail event scope global\n   old data as OldData\n   new data as NewData\n   replica data as RepData\n   exception as excp\nas \n{ \n   log.error('Exception message: ' + excp.message);\n}\nenable\n\n\ncreate replication trigger ReplicaOnRollbackTrigger on source MySource on rollback event scope global \n   old data as OldData\n   new data as NewData\n   replica data as RepData\n   exception as excp\nas \n{ \n   log.error('Exception message: ' + excp.message);\n}\nenable").setSyntax("create replication trigger <Trigger Name> [ if not exists ] on { source <Replication Source Name> | replica <Replica Name> } \n   { after { success | fail } | on rollback } \n   [ event scope { inherited | local | observable | global | cluster } ]\n   [ replica data as <Identifier> ] [ old data as <Identifier> ] [ new data as <Identifier> ] [ exception as <Identifier> ]\nas\n   {\n       <RPL Script>\n   }\n   [ enable ]"), new HelpEntry("alter replication trigger").setAvailableInRuntime(true).addTag(Tag.REPLICATION).setDesc("Alters existing replication trigger.").setExamples("alter replication trigger ReplicaLogger on Replica1 event scope observable after success \n   as { log.info('Row replicated successfully.'); }").setSyntax("alter replication trigger <Trigger Name> \n   { after { success | fail } | on rollback } \n   [ event scope { inherited | local | observable | global | cluster } ]\n   [ replica data as <Identifier> ] [ old data as <Identifier> ] [ new data as <Identifier> ] [ exception as <Identifier> ]\nas\n   {\n       <RPL Script>\n   }"), new HelpEntry("drop replication trigger").setAvailableInRuntime(true).addTag(Tag.REPLICATION).addTag(Tag.DROP).setDesc("Drops replication trigger.").setSyntax("drop replication trigger <Trigger Name> [ if exists ]"), new HelpEntry("create sequence").setAvailableInRuntime(true).setDesc("Creates new sequence.\n\nSequences can be used in insert statements:\n    insert into mytable values(next value for mysequence, ...)\n\nIf it is used in transaction or in function, then last value returned from sequence can be get using the following query:\n    select current value for mysequence\n\nAssignment of next value to variable:\n    long v = select next value for mysequence\n").setExamples("create sequence Seq1 as bigint increment by 1 start with 1").setSyntax("create sequence <Sequence Name> [ if not exists ] [ as <Data Type> ]\n   [ increment by <Increment Value> ] [ start with <Start Value> ] [ cycle ] [ [no] minvalue [<value>] ] [ [no] maxvalue [<maxvalue>] ] [ comment '<comment>' ]"), new HelpEntry("alter sequence").setAvailableInRuntime(true).setDesc("Alters sequence.").setExamples("alter sequence Seq1 comment 'my comment'").setSyntax("create sequence <Sequence Name>\n  [ cycle ] [ [no] minvalue [<value>] ] [ [no] maxvalue [<maxvalue>] ] [ comment '<comment>' ]"), new HelpEntry("describe sequence").setAvailableInRuntime(true).setDesc("Describes specified sequence.").setExamples("describe sequence Seq1").setSyntax("describe sequence <Sequence Name>"), new HelpEntry("drop sequence").setAvailableInRuntime(true).addTag(Tag.DROP).setDesc("Drops existing sequence.").setExamples("drop sequence Seq1").setSyntax("drop sequence <Sequence Name> [ if exists ]"), new HelpEntry("drop server").setAvailableInRuntime(true).addTag(Tag.DROP).setDesc("Drops existing reference to external server.").setSyntax("drop server <Server Name> [ if exists ]"), new HelpEntry("list servers").setAvailableInRuntime(true).setDesc("Lists all servers with specified role and/or type in current, specified dataspace or all dataspaces.\n\nRoles and types can be the following:\n\n   - file (fs/hdfs/nvfs)\n   - sql (type depends on connection factory)\n   - nosql (mongo/salesforce/aws)\n   - web (http/oapi/jira)\n   - message (kafka)").setSyntax("list servers [ role(<role>) ] [ type(<type>) ] [ { {at | @} [<DataspaceType>.]<DataspaceName> ] | all }"), new HelpEntry("describe server").setAvailableInRuntime(true).setDesc("Shows external server properties.").setSyntax("describe server <Server Name>"), new HelpEntry("export function").setAvailableInRuntime(true).setDesc("Exports specified function as a virtual table allowing regular select\nqueries on this table. If 'include parameters' modifier is specified, \nparameters of the function are included in the result table.\nNOTE: export supports only functions which return table.").setSyntax("export function <Function Name> as function table <Table Name> [ default values (<DefaultParameterValue1>, ...) ]\n   [ include parameters ]").setExamples("export function TestFunction as function table TestTable"), new HelpEntry("describe package manifest").setDesc("Describes package manifest of the current dataspace.").setSyntax("describe package manifest"), new HelpEntry("register package").setDesc("Registers specified package to the dataspace package manifest.\nPackage type can be one of the following: service, transport, client, \njdbc, sdo, collection.").setSyntax("register package <Package Type>.<Package Name> \n   [ autoload { true | false } ]\n   [ sequence <LoadSequence> ]").setExamples("register package sdo.TestPackage autoload true sequence 1"), new HelpEntry("unregister package").setDesc("Unregisters specified package from the dataspace package manifest.\nPackage type can be one of the following: service, transport, client, \njdbc, sdo, collection.").setSyntax("unregister package <Package Type>.<Package Name>").setExamples("unregister package sdo.TestPackage"), new HelpEntry("alter package manifest").setDesc("Alters specified package parameters at the dataspace package manifest.\nPackage type can be one of the following: service, transport, client, \njdbc, sdo, collection.").setSyntax("alter package manifest <Package Type>.<Package Name> \n   [ autoload { true | false } ]\n   [ sequence <Load Sequence> ]").setExamples("alter package manifest sdo.TestPackage autoload false"), new HelpEntry("describe dataspace").setAvailableInRuntime(true).setDesc("Returns dataspace/dataspace store state(without lobs and types check) and basic info.").setSyntax("describe dataspace [ store ] <Dataspace Name>"), new HelpEntry("describe dataspace dump").setAvailableInRuntime(true).setDesc("Shows manifest of specified database dump file").setSyntax("describe dataspace dump <Dump File>").setInitialVersion("3.8 Build 14"), new HelpEntry("check dataspace").setAvailableInRuntime(true).setDesc("Depending on parameters performs the following actions:\n  STORE       - checks overall health of the Dataspace Store, reporting on\n                Disk Usage and Structural Integrity issues\n  CONSISTENCY - checks of all dataspaces with tables and types, aggregates and \n                returns their states, identifying corrupt (ie. duplicate) keys or objects\n  REFERENCES  - checks data object Types and LOB references\n  ALL         - checks all references from Functions, Actors, Triggers, Views and \n                Collection Keys and re-compiles the RPL objects if neededReturns aggregated state of relevant dataspace objects, depending on options.").setSyntax("check dataspace [ store ] [ collections | references | all | consistency"), new HelpEntry("analyze dataspace").setAvailableInRuntime(true).setDesc(String.format(ANALYZE_COMMAND_DESC, "dataspace", "dataspace")).setSyntax(String.format(ANALYZE_COMMAND_SYNTAX, "dataspace")).setInitialVersion("3.7 Build 1"), new HelpEntry("analyze collection").setAvailableInRuntime(true).setDesc(String.format(ANALYZE_COMMAND_DESC, "collection", "collection")).setSyntax(String.format(ANALYZE_COMMAND_SYNTAX, "collection")).setInitialVersion("3.7 Build 1"), new HelpEntry("analyze actor").setAvailableInRuntime(true).setDesc(String.format(ANALYZE_COMMAND_DESC, "actor", "actor")).setSyntax(String.format(ANALYZE_COMMAND_SYNTAX, "actor")).setInitialVersion("3.7 Build 1"), new HelpEntry("analyze function").setAvailableInRuntime(true).setDesc(String.format(ANALYZE_COMMAND_DESC, "function", "function")).setSyntax(String.format(ANALYZE_COMMAND_SYNTAX, "function")).setInitialVersion("3.7 Build 1"), new HelpEntry("analyze trigger").setAvailableInRuntime(true).setDesc(String.format(ANALYZE_COMMAND_DESC, "trigger", "trigger")).setSyntax(String.format(ANALYZE_COMMAND_SYNTAX, "trigger")).setInitialVersion("3.7 Build 1"), new HelpEntry("analyze view").setAvailableInRuntime(true).setDesc(String.format(ANALYZE_COMMAND_DESC, "view", "view")).setSyntax(String.format(ANALYZE_COMMAND_SYNTAX, "view")).setInitialVersion("3.7 Build 1"), new HelpEntry("analyze reference link").setAvailableInRuntime(true).setDesc(String.format(ANALYZE_COMMAND_DESC, "reference link", "reference link")).setSyntax(String.format(ANALYZE_COMMAND_SYNTAX, "reference link")).setInitialVersion("3.7 Build 1"), new HelpEntry("list events").setAvailableInRuntime(true).setDesc("Returns list of events which are used by the specified object \n(or current or specified dataspace if object name is not specified).\nSupported object types are the following: collection, event\ntrigger, actor, function.").setSyntax("list events [ { for <Object Name> |  {at | @} [<DataspaceType>.]<DataspaceName> } ]").setExamples("list events\nlist events for TestActor\nlist events for TestEventQueue"), new HelpEntry("alter collection").setAvailableInRuntime(true).setDesc("Alters existing collection. ").setSyntax("alter collection <Collection Name> \n   [ add [ tuple] <Tuple Definition> [ before <Other Tuple> ] ]\n   [ drop [ tuple ] <Tuple Name> { restrict | cascade } ]\n   [ add <Constraint Definition> ]\n   [ drop constraint <Constraint Name> [ cascade ] ]\n   [ drop primary key ]\n   [ alter [ tuple ] <Tuple Name> \n      [ set <Default Tuple Expression> ]\n      [ drop default ]\n      [ set data type <Data Type> ]\n      [ set generated { by default | always } as identity ( start with <Seed> ) ]\n      [ restart with <New Identity Value> ]\n      [ set increment by <Identity Increment Value> ]\n      [ drop generated ]\n      [ set [ not ] null ]\n      [ rename to ]\n      [ set flob location '<location?' ]\n   ]\n\nConstraint Definition:\n\n[constraint <name>]\n    unique ( <column> [,<column>...] ) |\n    primary key ( <column> [,<column>...] ) |\n    foreign key ( <column> [,<column>...] )\n    references <refTable> ( <column> [,<column>...]) \n    [on {delete | update}\n    {cascade | set default | set null}] |\n    check(<search condition>)\n\n").setExamples("alter collection TestCollection add tuple NewColumn decimal(10,3)\nalter collection TestCollection add CreatedDate sqltimestamp default now() not null\nalter collection TestCollection drop tuple NewColumn\nalter collection TestCollection alter tuple NewColumn set data type decimal(17,3)\nalter collection TestCollection alter tuple IdColumn set generated always as identity (start with 20000)\nalter collection TestCollection alter tuple IdColumn restart with 1000\nalter collection TestCollection alter tuple IdColumn set increment by 5\nalter collection TestCollection alter tuple IdColumn drop generated\nalter collection TestCollection alter tuple IdColumn set flob location 'my/new/location'\nalter collection TestCollection add primary key (Col1, Col2)\nalter collection TestCollection add constraint CC check(Col1 > 0)\nalter collection TestCollection drop primary key\nalter collection TestCollection drop constraint CC\nalter collection TestCollection alter tuple Col rename to ColNew\nalter collection TestCollection add tuple id int generated by default as identity (start with 1 increment by 11) before id"), new HelpEntry("truncate collection").setAvailableInRuntime(true).setDesc("Truncates collection data.").setSyntax("truncate collection <Collection Name>"), new HelpEntry("create index").setAvailableInRuntime(true).setDesc("Creates a new index on a collection, such as Table, File Table, Queue or Snapshot. By default all indices are AVL and can be\ncreated on any collection that supports the operation.  This is also true of Primary Keys which are always a Unique Index.\n\nSNAPSHOT tables support several index types and additionally use a Bitmap index to map Category data types to speed up\nprocessing and compress data.  This is an internal function of SNAPSHOT tables and is activated by defining a Category column.\nNo additional user interaction is required.\n\n" + SNAPSHOT_INDEX_HELP).setSyntax("create [unique] index <Index Name> [ if not exists ] on <Collection Name> (<Tuple1> [ ASC | DESC ] [, <Tuple2> ] ) [ { avl | readonly } ]").setExamples("create index Index1 on Table1 (Fname, Sname)"), new HelpEntry("alter index").setAvailableInRuntime(true).setDesc("Redefine an index with a new column list. This statement is more efficient \nthan dropping an existing index and creating a new one.").setSyntax("alter index <Index Name> { rename to <new name> | as (<Tuple1> [ ASC | DESC ] [, <Tuple2> ] ) "), new HelpEntry("drop index").setAvailableInRuntime(true).addTag(Tag.DROP).setDesc("Drops existing index on collection.").setSyntax("drop index <Index Name> [ if exists ]"), new HelpEntry("create collection like").setAvailableInRuntime(true).setDesc("Creates new collection based on existing one.").setSyntax("create collection <New Collection Name> [ if not exists ] like <Existing Collection Name> \n    [ without data ]"), new HelpEntry("create reference link").setAvailableInRuntime(true).addTag(Tag.REFERENCE_LINK).setDesc("Creates a new reference link between two data collection tuples.\nReference links are similar to Referential Integrity declarations\nin relational tables because they describe relationships between\ndata collections. Source collections are considered parents and\nTarget collections are considered child entities.\n\nUnlike Primary/Foreign Key relationships, reference links are\nsoft references and not constraints.  Users can declare links\nbetween elements without being concerned that data updates may\nfail if a relationship between collections is not satisfied.\n\nDefining a link does not affect data manipulation commands. Their\nprimary purpose is to document data relationships and act as\nnavigation references (also known as Navigation Links) for tools\nthat support such capabilities.\n\nFor example, declaring a relationship between a DEPT_ID element\nin an EMPLOYEES table and an ID element in a DEPARTMENTS table\nwill create a reference that informs the user that the two tables\nare potentially related.\n\nTools that support navigation link capabilities will allow users\nto automatically drill into the related element based on the\nvalue of the parent.  Effectively reference links are declared\non collections to inform users of possible JOIN candidates. \nThey may be declared on primitive types or object elements.\n\nColumn Name - should be in format [<DataspaceName>.]<Collection Name>.<Column Name>.\n\nSpath can be specified for complex column types and should be in format //<subelement1>[/<subelement2>]...\n").setSyntax("create reference link <Link Name> [ if not exists ]\n{\n    [with] source [ { at | @ } ] <Source Column Name> [spath 'spath'] [and] target [ { at | @ } ] <Target Column Name> [spath 'spath'] [nullable] |\n    [as] facet join on <Source Facets Column>, <Target Facets Column> ( { keys | values } { any | all | none | <degree> } ) | \n    [as] aspect join on <Source Aspects Column>, <Target Aspects Column> ( { any | all | none | <degree> } )\n}\n[description <description>] ").setExamples("create reference link DepartmentsLink source departments.id target employees.dept_id\ncreate reference link Emp_Skills_Projects_Facets_Link facet join on Emp_Skills.skills, Projects.proj_skills (keys any)\ncreate reference link Emp_Skills_Projects_Aspects_Link aspect join on Emp_Skills.main_skills, Projects.required_skills (all)"), new HelpEntry("alter reference link").setAvailableInRuntime(true).addTag(Tag.REFERENCE_LINK).setDesc("Alters reference link.").setSyntax("alter reference link <Link Name> set [ name <name> ] [ description '<description>' ]").setExamples("alter reference link DepartmentsLink set name MyDepartmentsLink descripton 'my link'"), new HelpEntry("drop reference link").setAvailableInRuntime(true).addTag(Tag.REFERENCE_LINK).addTag(Tag.DROP).setDesc("Drops reference link.").setSyntax("drop reference link <Link Name> [ if exists ]").setExamples("drop reference link DepartmentsLink"), new HelpEntry("describe reference link").setAvailableInRuntime(true).addTag(Tag.REFERENCE_LINK).setDesc("Describes reference link.").setSyntax("describe reference link <Link Name>").setExamples("describe reference link DepartmentsLink"), new HelpEntry("list reference links").setAvailableInRuntime(true).addTag(Tag.REFERENCE_LINK).setDesc("Lists reference links in current or specified dataspace.").setSyntax("list reference links [ {at | @} [<DataspaceType>.]<DataspaceName> ]").setExamples("list reference links"), new HelpEntry("bind producer for").setAvailableInRuntime(true).setDesc("Binds producer for specified event to current dataspace.").setSyntax("bind producer for <eventId>").setExamples("bind producer for [event.audit]"), new HelpEntry("raise").setAvailableInRuntime(true).setDesc("Raises specified event, advisory, exception, acknowledgement or request.\nEvent ID of raised event, advisory or exception can be changed using 'on [<EventId>]' syntax.\n\nCommand 'raise request' waits until a reply will be received or timeout period will expire.\n\nParameters of 'raise request':\n\n   reply timeout         - Waiting time for a reply (in milliseconds)\n   distribution strategy - Strategy used for distribution of the request.\n                           Available options are AUCTION, FAIR, WEIGHTED, CYCLIC. Only AUCTION option is currently supported.\n   match strategy        - Strategy used for matching of a reply.\n                           Available options are REPLY_TO, REPLY_WITH_CORRELATION_ID\n\nCommand 'raise acknowledge' creates and raises AcknowledgementEvent based on the specified source event (with 'for <Event>')\nor event id (with 'on [<EventId>]'). It is expected that Event Identity Management elements from a header of the source event\nare copied into the ack event to allow correlation between an event and its acknowledgement.\n\nParameters of 'raise acknowledge':\n\n   with source data - Sets data from the source event to acknowledgement event. Applicable only with 'for' parameter.\n   with data        - Sets the specified data to acknowledgement event.\n   action           - ACKNOWLEDGE, ACKNOWLEDGE_AND_RETRY, ACKNOWLEDGE_AND_FORWARD, ACKNOWLEDGE_AND_DISCARD, ACKNOWLEDGE_AND_EXPIRE,\n                      ACKNOWLEDGE_UNDELIVERED, ACKNOWLEDGE_AND_SUSPEND, RESCIND, RESCIND_AND_FORWARD, RESCIND_AND_DISCARD\n                      Default is ACKNOWLEDGE.").setSyntax("raise { event | advisory | exception | request | ack[nowledge] for } <Event> [ on [<EventId>] ]\n  [ reply timeout <timeout> [distribution strategy <Dist Strategy>] [match strategy <Match Strategy>]]\n  [ [ { with source data | with data <data> } ] [ action <Acknowledge Action> ] ] [scope <scope>]").setExamples("raise event myevent\nraise event myevent scope observable\nraise event myevent on [event.new.id]\nraise request myrequest reply timeout 1000 distribution strategy AUCTION match strategy REPLY_TO\nraise ack for myevent with source data action acknowledge\nraise ack for myevent with data 'ackdata'\nraise ack on [e.reply.xxx]\nraise ack on [e.reply.xxx] with data 'ackdata' action acknowledge").setAlias("raise"), new HelpEntry("interrupt session").setAvailableInRuntime(true).addTag(Tag.SESSION).setDesc("Interrupts current statement in session with specified ID. Session is not closed and can be used further.\n\nNOTE: Not every session can be interrupted. Session is interrupted by interrupting the thread which executes the statement.\n       If statement is not interruptable session will not be interrupted. Interruption is implemented for CRUD queries and loops.\n      For example if there is long running complex calculation - it cannot be interrupted.\n").setSyntax("interrupt session <ID>"), new HelpEntry("kill session").setAvailableInRuntime(true).addTag(Tag.SESSION).setDesc("Closes session with specified ID. Session should be interrupted first, and don't execute any statements.\n").setSyntax("kill session <ID>"), new HelpEntry("start transaction").setAvailableInRuntime(true).addTag(Tag.SESSION).setDesc("Starts new transaction with specified transaction characteristics.").setSyntax("start transaction [isolation level { serializable | repeatable read | read committed | read uncommitted } \n   [ { read only | read write } ] ] }").setAlias("begin transaction"), new HelpEntry("commit").setAvailableInRuntime(true).addTag(Tag.SESSION).setDesc("Terminates the current SQL-transaction with commit. This makes all the changes to the database permanent.").setSyntax("commit [ work ] [ and [ no ] chain ]"), new HelpEntry("rollback").setAvailableInRuntime(true).addTag(Tag.SESSION).setDesc("Rollback the current SQL transaction and terminate it. The statement rolls back all the actions performed during the transaction.\nIf NO CHAIN is specified, a new SQL transaction is started just after the rollback.\nThe new transaction inherits the properties of the old transaction.\nIf rollback statement is called inside function or trigger transaction will be rolled back and exception with code 7100 will be thrown.\n  'WITH ERROR <error text>' allows to specify user-defined exception error text.\n  'WITHOUT ERROR' means don't throw exception on rollback.").setSyntax("rollback { to savepoint <Savepoint> | [ work ] [ and [ no ] chain ] [ with error <'error text'> | without error ] }"), new HelpEntry("savepoint").setAvailableInRuntime(true).addTag(Tag.SESSION).setDesc("Establish a savepoint. This command is used during an SQL transaction. It establishes a milestone for the current transaction.\nThe SAVEPOINT can be used at a later point in the transaction to rollback the transaction to the milestone.").setSyntax("savepoint <Name>"), new HelpEntry("release savepoint").setAvailableInRuntime(true).addTag(Tag.SESSION).setDesc("It removes a SAVEPOINT that has already been defined.").setSyntax("release savepoint <Name>"), new HelpEntry("set transaction isolation level").setAvailableInRuntime(true).addTag(Tag.SESSION).setDesc("Sets current session transaction isolation level.").setSyntax("set transaction [ isolation level { serializable | repeatable read | read committed | read uncommitted } ] [ { read only | read write } ] "), new HelpEntry("set autocommit").setAvailableInRuntime(true).addTag(Tag.SESSION).setDesc("Enables/disables transaction autocommit in current session.").setSyntax("set autocommit { true | false }"), new HelpEntry("get autocommit").setAvailableInRuntime(true).addTag(Tag.SESSION).setDesc("Returns either transaction autocommit is enabled or disabled in current session.").setSyntax("get autocommit"), new HelpEntry("set session transaction").setAvailableInRuntime(true).addTag(Tag.SESSION).setDesc("Sets default transaction characteristics in current session.").setSyntax("set session transaction [ { read only | read write } ] [ isolation level { serializable | repeatable read | read committed | read uncommitted } ] "), new HelpEntry("set session authorization").setAvailableInRuntime(true).addTag(Tag.SESSION).setDesc("Sets the DSQL-session user identifier. Changes the current user.").setSyntax("set session authorization '<User>'"), new HelpEntry("set session context").addTag(Tag.SESSION).setDesc("Sets a default session context for the current session.\nIf session context is set to CLIENT then file operations will lookup for files on a client side.\nIf session context is set to SERVER then file operations will lookup for files on a server side.\nIn case of SERVER context the Dataspace file access restrictions will be applied.\nCurrent session context can be checked with 'describe session' command.\nAll interactive sessions by default have CLIENT context set. All internal sessions have SERVER context set by default.").setSyntax("set session context { client | server }"), new HelpEntry("declare").setAvailableInRuntime(true).setDesc("Declares session variable. Session variables can be assigned to IN, INOUT and OUT parameters of stored procedures and functions. ").setSyntax("declare <Name> <Type> [ default <Value> ]"), new HelpEntry("set").setAvailableInRuntime(true).setDesc("Sets session variable value.").setSyntax("set <Variable Name> = <Value>"), new HelpEntry("drop").setAvailableInRuntime(true).setDesc("Drops session variable.").setSyntax("drop myvar").addTag(Tag.DROP).setExamples("drop { myvar | (myvar1 [ , myvar2, ... ]) }"), new HelpEntry("create transient table").setAvailableInRuntime(true).setDesc("Creates transient session table.\n\nAll transient tables are created in SDS dataspace and can be accessed from any dataspace without SDS dataspace name specifications.\nTransient tables are memory tables and their data are stored during one transaction or while node is running depending on scope specified.\n\n  ON COMMIT DELETE ROWS   - deleted all rows when transaction finishes\n  ON COMMIT PRESERVE ROWS - preserve all rows when transaction finishes\n ").setSyntax("create transient table <table definition> \n   [ on commit { delete | preserve } rows ]"), new HelpEntry("drop transient table").setAvailableInRuntime(true).setDesc("Drops transient table.").addTag(Tag.DROP).setSyntax("drop transient table <Table Name> [ if exists ]"), new HelpEntry("set time zone").setAvailableInRuntime(true).setDesc("Sets dataspace time zone. This time zone will be used to interpret passed to session and stored in dataspace date/time values.\nNOTE: To apply this change node restart is required.\n'default' means that the time zone will be set to the time zone of the host right after node restart.\n'local' means that the time zone will be set to the time zone of the host right on command execution.").setSyntax("set time zone '<Timezone ID>'").setExamples("set time zone 'America/New_York'\nset time zone 'default'\nset time zone 'local'"), new HelpEntry("get time zone").setAvailableInRuntime(true).setDesc("Returns time zone set in dataspace configuration and in session.\nIf time zones are different node restart is required.\n").setSyntax("get time zone").setExamples("get time zone"), new HelpEntry("list time zones").setAvailableInRuntime(true).setDesc("Returns list of available time zone ids.\n").setSyntax("list time zones").setExamples("list time zones"), new HelpEntry("set session ccsid").setAvailableInRuntime(true).setDesc("Sets default session CCSID(Coded Character Set ID). Session CCSID overloads default datastore CCSID.\nCCSID is used in file operations like read/write file and directory table operations where characters encoding/decoding is needed.").setSyntax("set session ccsid '<CCSID>'").setExamples("set session ccsid 'UTF-8'"), new HelpEntry("set datastore ccsid").setAvailableInRuntime(true).setDesc("Sets default datastore CCSID(Coded Character Set ID). Dataspace CCSID is used as default for newly created sessions.\nCCSID is used in file operations like read/write file and directory table operations where characters encoding/decoding is needed.").setSyntax("set datastore ccsid '<CCSID>'").setExamples("set datastore ccsid 'UTF-8'"), new HelpEntry("set maxrows").setAvailableInRuntime(true).addTag(Tag.SESSION).setDesc("Sets the maximum number of rows of the result returned by executing queries.").setSyntax("set maxrows <Count>"), new HelpEntry("set session result memory rows").setAvailableInRuntime(true).addTag(Tag.SESSION).setDesc("Sets the session's result memory rows. By default the session uses memory to build result sets and transient tables.\nThis command sets the maximum number of rows of the result (and transient tables) that should be kept in memory.\nIf the row count of the result or transient table exceeds the setting, the result is stored on disk.\nThe default is 0, meaning all result sets are held in memory.").setSyntax("set session result memory rows <Number Of Rows>"), new HelpEntry("list sessions").setAvailableInRuntime(true).addTag(Tag.SESSION).setDesc("List dataspace sessions.\n\n  all    - show session on all datasapce(not only in current)\n  active - show session currently in transaction").setSyntax("list sessions [ all ] [ active ]"), new HelpEntry("list session variables").setAvailableInRuntime(true).addTag(Tag.SESSION).setDesc("Displays list of session variables and their types.").setSyntax("list session variables"), new HelpEntry("describe session").setAvailableInRuntime(true).addTag(Tag.SESSION).setDesc("Displays session characteristics.").setSyntax("describe session [ with id <id> ]"), new HelpEntry("describe mvcc").setAvailableInRuntime(true).addTag(Tag.SESSION).setDesc("Displays mvcc info.").setSyntax("describe mvcc"), new HelpEntry("get fetch size").setDesc("Returns fetch size.").setSyntax("get fetch size").setExamples("get fetch size"), new HelpEntry("set fetch size").setDesc(AbstractSetFetchSizeOperation.description).setSyntax("set fetch size <Fetch Size>").setExamples("set fetch size 100"), new HelpEntry("get transfer buffer size").setDesc("Returns transfer buffer size.").setSyntax("get transfer buffer size").setExamples("get transfer buffer size"), new HelpEntry("set transfer buffer size").setDesc(SetTransferBufferSizeOperation.description).setSyntax("set transfer buffer size <Buffer Size> {bytes | Kb | Mb}").setExamples("set transfer buffer size 10 Mb"), new HelpEntry("list datastore properties").setAvailableInRuntime(true).setDesc("Returns list of datastore properties with values.").setSyntax("list datastore properties"), new HelpEntry("set datastore property").setAvailableInRuntime(true).setDesc("Sets datastore property.\n\nThe following operations are supported:\n\nset datastore property dtspace.cache_size <SizeInKilobytes>\nset datastore property dtspace.cache_rows <NumberOfCachedRows>\nset datastore property dtspace.cache_file_scale { 8 | 16 | 32 | 64 | 128 }\nset datastore property dtspace.defrag_limit <LimitInPercent>\nset datastore property dtspace.incremental_backup { true | false }\nset datastore property dtspace.default_dataspace <DataspaceName>\nset datastore property dtspace.result_max_memory_rows <RowsNumber>\nset datastore property dtspace.default_memory_model { memory | logged | persistent }\nset datastore property dtspace.tx_isolation_level {serialized|read commited}\nset datastore property file.allow_full_path { true | false }\nset datastore property file.quoted { true | false }\nset datastore property file.all_quoted { true | false }\nset datastore property file.ignore_first { true | false }\nset datastore property file.ignore_first_lines <RowsNumber>\nset datastore property file.fs <FieldSeparator>\nset datastore property file.vs <VarcharSeparator>\nset datastore property file.lvs <LongVarcharSeparator>\nset datastore property file.encoding <FileEncoding>\nset datastore property file.cache_scale { 8 | 16 }\nset datastore property file.cache_size_scale { 6 | 8 | 10 | 12 | 14 | 16 | 18 | 20 }\nset datastore property file.compression_block_size <CompressionBlockSizeInBytes>\nset datastore property dtspace.applog { 0 | 1 | 2 | 3 }\nset datastore property runtime.gc_interval <NumberOfRowOperations>\nset datastore property sql.ref_integrity { true | false }\nset datastore property dtspace.tx_management { locks | mvlocks | mvcc }\nset datastore property dtspace.lob_file_scale {1 | 2 | 4 | 8 | 16 | 32}\nset datastore property dtspace.lob_in_mem { false | true }\nset datastore property dtspace.extended_sql_audit { false | true }\nset datastore property dtspace.script_format { text | compressed }\nset datastore property dtspace.nio_data_file { true | false }\nset datastore property dtspace.nio_max_size <SizeInMegabytes>\nset datastore property dtspace.log_data { true | false }\nset datastore property dtspace.log_size <SizeInMegabytes>\nset datastore property dtspace.write_delay_millis { <DelayInMillis> | true | false }\nset datastore property sql.enforce_names { true | false }\nset datastore property sql.enforce_refs { true | false }\nset datastore property sql.enforce_size { true | false }\nset datastore property sql.enforce_types { true | false }\nset datastore property sql.enforce_tdc_delete { true | false }\nset datastore property sql.enforce_tdc_update { true | false }\nset datastore property sql.string_precision <PrecisionValue>\nset datastore property jdbc.translate_tti_types { true | false }\nset datastore property sql.concat_nulls { true | false }\nset datastore property sql.unique_nulls { true | false }\nset datastore property sql.convert_trunc { true | false }\nset datastore property sql.pad_space { true | false }\nset datastore property dtspace.checkpoint_interval <Interval> [{ s | m | h }]\nset datastore property dtspace.typesafe { true | false }\nset datastore property dtspace.timezone <TimeZoneID>\nset datastore property dtspace.checkpoint_interval_critical <value> [{ s | m | h }]\nset datastore property dtspace.checkpoint_interval_repeat <count>\nset datastore property dtspace.checkpoint_lock_timeout1 <value> [{ s | m | h }]\nset datastore property dtspace.checkpoint_lock_timeout2 <value> [{ s | m | h }]\nset datastore property dtspace.checkpoint_check_consistency { true | false }\nset datastore property dtspace.log_size_critical <value in mb>\nset datastore property dtspace.index_operation_max_time <value> [{ s | m | h }]\nset datastore property dtspace.cache_free_count_scale <value>\nset datastore property dtspace.exception_log_processing { true  | false }\nset datastore property dtspace.files_readonly { true  | false }\nset datastore property dtspace.flob_location_path '<path>'\nset datastore property dtspace.readonly { true  | false }\nset datastore property dtspace.temp_directory '<path>'\nset datastore property dtspace.tx_conflict_rollback { true  | false }\nset datastore property qspace.expiration_interval <value in seconds>\nset datastore property sql.compare_in_locale { true  | false }\nset datastore property sql.enforce_strict_size { true  | false }\n").setExamples("set datastore property dtspace.cache_size 10000\nset datastore property dtspace.cache_rows 20000\nset datastore property dtspace.cache_file_scale 8\nset datastore property dtspace.defrag_limit 10\nset datastore property dtspace.incremental_backup true\nset datastore property dtspace.default_dataspace TestDataspace\nset datastore property dtspace.result_max_memory_rows 0\nset datastore property dtspace.default_memory_model logged\nset datastore property dtspace.tx_isolation_level read commited\nset datastore property file.allow_full_path true\nset datastore property file.quoted false\nset datastore property file.all_quoted false\nset datastore property file.ignore_first true\nset datastore property file.ignore_first_lines 3\nset datastore property file.fs \\semi\nset datastore property file.vs \\quote\nset datastore property file.lvs \\apos\nset datastore property file.encoding UTF-8\nset datastore property file.cache_scale 8\nset datastore property file.cache_size_scale 8\nset datastore property file.compression_block_size 4096\nset datastore property dtspace.applog 0\nset datastore property runtime.gc_interval 0\nset datastore property sql.ref_integrity true\nset datastore property dtspace.tx_management mvcc\nset datastore property dtspace.lob_file_scale 1\nset datastore property dtspace.lob_in_mem true\nset datastore property dtspace.extended_sql_audit true\nset datastore property dtspace.script_format compressed\nset datastore property dtspace.nio_data_file true\nset datastore property dtspace.nio_max_size 256\nset datastore property dtspace.log_data true\nset datastore property dtspace.log_size 50\nset datastore property dtspace.write_delay_millis 500\nset datastore property sql.enforce_names false\nset datastore property sql.enforce_refs false\nset datastore property sql.enforce_size true\nset datastore property sql.enforce_types false\nset datastore property sql.enforce_tdc_delete true\nset datastore property sql.enforce_tdc_update true\nset datastore property sql.string_precision 32768\nset datastore property jdbc.translate_tti_types false\nset datastore property sql.concat_nulls true\nset datastore property sql.unique_nulls true\nset datastore property sql.convert_trunc true\nset datastore property sql.pad_space true\nset datastore property dtspace.checkpoint_interval 1h\nset datastore property dtspace.typesafe true").setSyntax("set datastore property <propertyName> [=] <propertyValue>").setAdmin(true), new HelpEntry("create text index").setAvailableInRuntime(false).setDesc("Creates a text search index for one or more specified collections.\nMultiple tuples (or columns) may be specified for one index. Note \nthat the associate FIND query will return all rows that match the\nindex search criteria so use of a Primary Key is recommended.\n\nPerformance of atomic transactions against indexed collections can\nbe improved by specifying a Change Commit strategy (see below).\n\nParameters:\n\n    IndexName           - the unique name of the index.\n    CollectionNameN     - the name of the collection that contains tuples included\n                          in the full-text index.\n    ColN                - specifies the name of collection tuple. If tuples are not specified \n                          then all the tuples with string type will be added to the full-text index.\n    TimeInterval        - the number of seconds to wait between auto-commit operations for \n                          this index.\n    ChangeBufferSize    - the size of buffer that holds uncommitted changes. When the \n                          buffer fills to capacity a COMMIT operation will be triggered \n                          on this index, regardless of TimeInterval.\n    explicit-collection - instructs the INDEX mechanism to generate element name/value pairs for collections such as Lists or Arrays. \n                          This is useful if you need to later search for such pairs in text derived from a complex object.  See example below.").setSyntax("create text index <indexname> [ if not exists ] \n    on <collectionname1>[(col1, col2,...)], <collectionname2>[(col1, col2,...)], ... \n        change commit ( <TimeInterval>, <ChangeBufferSize>) [ explicit-collection ]").setExamples("create text index ProductIdx on films(title, description), books(title, description)\ncreate text index ProductIdx on films(title, description), books(title, description) change commit (120, 500)\ncreate text index ProductIdx on films explicit-collection").setInitialVersion("3.8 Build 1"), new HelpEntry("describe text index").setAvailableInRuntime(false).setDesc("Shows metadata of the specified full-text index.").setSyntax("describe text index <IndexName>"), new HelpEntry("drop text index").setAvailableInRuntime(false).setDesc("Drops specified full-text index").setSyntax("drop text index <IndexName> [ if exists ]").addTag(Tag.DROP).setExamples("drop text index TestIdx"), new HelpEntry("reindex").setAvailableInRuntime(true).setDesc("Re-indexes specified full-text index").setSyntax("reindex { text | rpl } [ <IndexName> ]").setExamples("reindex text TestIdx\nreindex rpl").setInitialVersion("3.8 Build 14"), new HelpEntry("list text indexes").setAvailableInRuntime(false).setDesc("Returns list of full-text indexes").setSyntax("list text indexes"), new HelpEntry("find").setAvailableInRuntime(false).addTag(Tag.FIND).setDesc("Performs linguistic searches against text data in full-text indexes\n\n<u>Parameters:</u>\n\n    text         - Specifies that a token or phrase will be searched in the index space.\n                   Search is not case sensitive and matches on the exact token (word) \n                   or sequence of tokens. \n\n    match        - Specifies search criteria using Lucene query syntax and allows for partial\n                   matching using wild card, inclusion or exclusion characters as well as grouping\n                   using parenthesis to create compound tokens.\n\n    collection   - Search one or more tuples (columns) in a collection for matching values.  Columns \n                   must be indexed in order to be used in a search.  when searching a collection and\n                   specifying multiple tuples, the resulting key will consider all columns.\n\n    index        - Search a particular index space that may be comprised of many collections \n\n    *            - search in all indexes of the current dataspace\n\n\n    The following modifiers specify the order in which results are returned based on term frequency \n    across documents or contents of a single document.  These settings tune the Text Scoring system \n    and may be further used to determine relevance and semantic context of the returned results.\n\n    frequency    - Enables term's frequency processing in a document.  High frequency may be indicative of relevance,\n                   however a low frequency (inverse frequency) may also be a useful indicator.\n\n    comatch      - Enables inverse document frequency processing. This measures of how often the term appears across \n                   the index.  It may also be used as a relevant semantic hint. Low frequency may be more meaningful \n                   in certain cases.\n\n    docsize      - Enables measure of term importance compared to the total number of terms (features) in a document.\n\n    asc | desc   - Specifies whether to sort the query results in descending or ascending order by score.\n\n    return       - Specifies which tuples (fields) should be part of the result.  It may be used to return specific \n                   columns in a predicate table (which is part of the index) or returns statistics of the search,\n                   indicating Collection, Tuple and Key where the matched term appears.\n\n                   If the option is not specified then the query result contains the following columns:\n\n                   tuple        - collection tuple name\n                   collection   - collection name\n                   key          - appropriate collection primary key value\n                   index used   - full-text index\n                   tf           - term frequency score\n                   idf          - inverse document frequency score \n                   lengthnorm   - length normalization score\n                   score        - total score\n                   relevance    - total score percentage\n                   entries      - returns location of search tokens in a document as a series of off-set entries.\n                                  useful if Highlight tools need emphasis information.\n                   fragment     - returns the entire text fragment with search  tokens decorated using Bold HTML tag\n\n                   The following fields may also be included in the result set specified by RETURN clause:\n\n                   score, tuple, collection, relevance\n\n<u>Overview:</u>\n\nFIND TEXT performs a literal search of the text index using simple Boolean directives or EQUAL, AND, OR and returns\neither results or Key and Tuple names sorted by statistical relevance or term frequency.\n\n\t<i>find text 'respiratory' in index icd10_codes return (who_ICD10_codes.ICD10_code, who_ICD10_codes.description_FY2020)</i>\n\nReturns the columns ICD10_code and description_FY2020 for every row that has the word 'respiratory' in the index.\nThe term 'respiratory' is matched to all entries in the Text Index and then the result is filtered again.\n\nThis query automatically filters out any results that are not part of the who_ICD10_codes collection. It is useful for \nreturning Row Sets that can be further used in dynamic JOIN operations with other collections.  For example you can \nsearch h index by description_FY2020, but JOIN to other collections using ICD10_code. \n\n\t<i>find text 'Mary Poppins' in collection books(title, description)</i> \n\nReturns a list of Tuples, Collections and Keys that contain the text 'Mary Poppins'.  Either tuple (column)\nmay contain the text.  The result in this case is a so-called tuple-heap of fields and key values from a specific \ncollection.  \n\nResult Keys are automatically sorted by Relevance Score. Since a key represents a Row (or tuple set), and\nin this case a single collection is searched, tuple sets that have the highest occurrence of the term are \nseen as more relevant.  For example if 'Mary Poppins' occurs in title and description, the set (row) is \nseen as more relevant than if the term occurred in only one of the columns.  \n\nThe relevance predicate allows users to control how Relevance Score is calculated to some extent.  See\ndocumentation of this option for further information. \n\n\t<i>find text 'Mary Poppins' in collection books</i>\n\nIn this case we do not specify the tuples to be searched.  Any tuple that is part of the index will be searched.\nAnd similarly, if all dataspace collections across all indices need to be searched, we can use the following:\n\n\t<i>find text 'Mary Poppins' in *</i>\n\nTo search in a specific text index use the following command.  A text index scope is the Dataspace.  Hence\nsearching a specific index can search multiple collections but only in the same Dataspace.\n\n\t<i>find text 'Mary Poppins' in index myIndex</i>\n\nText search is a literal search.  It allows basic EQUAL, AND, OR expressions to be implicitly evaluated\nacross tuples.  Specifying multiple tuples will implicitly perform an OR test.  Using a + directive allows\nusers to specify AND conditions.  For example: \n\n\t<i>find text 'Mary Poppins' in collection books(title + description)</i>\n\nIn this case every tuple occurrence for AND condition is returned, grouped by Key.  Due to the\nsimple, Boolean nature of the search, FIND TEXT offers the best performance. \n\nFIND MATCH allows users to specify a query that includes wild card and regular expression directives.\nTerms (words) are not evaluated as literals.  They are seen as term tokens with expression modifiers.  \nSeparating each word with a SPACE results in implicit OR behavior.\n\n\t<i>find match (Mary Poppins) in collection books(title, description)</i> \n\nThis returns all Keys and Tuples where either 'Mary' or 'Poppins' are found.   Relevance is calculated\nbased on term frequency in a given tuple set (row).\n\nTo combine terms into a literal the following directives should be used:\n\n\t<i>find match ('Mary Poppins') in collection books(title, description)</i> \n\nNote that we are following the standard Lucene Query syntax with one notable exception: the use\nof single quotes.  This is done to conform to ANSII SQL standards wherein double quotes denote a\nquoted identifier and single quotes are used for literals.\n\nTo search for 'Mary Poppins' or 'Mary' we can use the following:\n\n\t<i>find match ({Mary Poppins} OR Mary) in collection books(title, description)</i>\n\nIn the above case, the sequence of terms is important.  'Poppins' must follow 'Mary' and the\nterm 'Poppins' appearing by itself will be excluded.  To find a match using either term regardless\nof sequence use:\n\n\t<i>find match (+Mary +Poppins) in collection books(title, description)</i>\n\nand similarly, negation can be achieved like so:\n\n\t<i>find match (+Mary -Poppins) in collection books(title, description)</i>\n\nTerm boosting and all standard Lucene query syntax are supported.  For example to boost the\nrelevance of 'Poppins' use:\n\n\t<i>find match (Mary Poppins^5) in *</i>\n\nThis will look for 'Mary' or 'Poppins' and assign a higher score to tuple sets that have 'Poppins' \nin their content.  See relevance option for how to sort and score boosted content.\n\nWildcard substitution may be used to search for terms that begin or end with certain characters:\n\n\t<i>find match (Mar*) in *</i>\n\nor you can search for terms ending with some characters.  However, note that ENDS-WITH\noperations may be extremely slow and resource intensive on large indices due to post retrieval \nsorting that has to occur:\n\n\t<i>find match (*Mar) in *</i>\n\nCaution and common sense experimentation should be exercised when using wildcards at the\nbeginning of a term.\n\nCombinations of directives may also be provided to effect a so-called fuzzy search of approximate\nterms and their combinations:\n\n\t<i>find match (+Mar* +Pop*) in *</i>\n\nYou can further control the search logic by using groups.  Lucene syntax is fully supported for\nGROUP usage.  For example to find 'Mary' or 'Jerry' that is also a 'Poppins' use:\n\n\t<i>find match ( (Mary OR Jerry) +Poppins ) in *</i>\n").setSyntax("find { text '<text>' | match (<query>) }\n    in  { collection <collectionname1>(col1, col2,...), <collectionname2>(col1, col2,...),...\n        | index <indexname1>, <indexname2>,... | * }\n    [ relevance ( frequency={ on | off}, comatch={ on | off }, docsize={ on | off } )]\n    [ asc | desc ]\n    [ return ( [<collectionname1>.]col1, [<collectionname2>.]col2,... ) ]\n    [ top <nn> ]").setExamples("\n<i>find text 'respiratory' in index icd10_codes return (who_ICD10_codes.ICD10_code, who_ICD10_codes.description_FY2020)</i>\n<i>find text 'Mary Poppins' in collection books(title, description)</i>\n<i>find text 'Mary Poppins' in collection books</i>\n<i>find text 'Mary Poppins' in *</i>\n<i>find text 'Mary Poppins' in collection books(title + description)</i>\n<i>find match (Mary Poppins) in collection books(title, description)</i>\n<i>find match ({Mary Poppins} OR Mary) in collection books(title, description)</i>\n<i>find match (+Mary +Poppins) in collection books(title, description)</i>\n<i>find match (Mary Poppins^5) in *</i>\n<i>find match (Mar*) in *</i>\n<i>find match (*Mar) in *</i>\n<i>find match (+Mar* +Pop*) in *</i>\n<i>find match ( (Mary OR Jerry) +Poppins ) in *</i>\n<i>find text 'Mary Poppins' in index ProductIdx return (books.id, books.title, score, \n    tuple, collection, relevance) relevance (frequency=off) asc</i>"), new HelpEntry("analyze rpl find").setAvailableInRuntime(true).addTag(Tag.FIND).setDesc("Performs linguistic searches against schema object definitions.\n\nSee FIND command for additional information. The same syntax is used for querying.").setSyntax("analyze rpl find { text | match } '<queryString>'").setInitialVersion("3.8 Build 1").setExamples("\n<i>analyze rpl find text 'request'</i>\n<i>analyze rpl find text 'metricName string'</i>\n<i>analyze rpl find match (map clusterMap)</i>\n<i>analyze rpl find match (+map +clusterMap)</i>\n<i>analyze rpl find match (map clusterMap^5)</i>\n"), new HelpEntry("reindex rpl").setAvailableInRuntime(true).setDesc("Re-indexes rpl index.").setSyntax("reindex rpl").setInitialVersion("3.8 Build 1"), new HelpEntry("analyze schema find").setAvailableInRuntime(true).addTag(Tag.FIND).setDesc("Performs search against schema object names\n\nParameters:\n    query    - query to perform. Use SQL LIKE condition syntax for the query\n").setSyntax("analyze schema find '<query>'").setExamples("analyze schema find 'id'\nanalyze schema find '%title%'").setInitialVersion("3.8 Build 1"), new HelpEntry("analyze log file").setAvailableInRuntime(true).setDesc("Analyzes log file to detect its records structure and record timestamps.\nAlso the command provides syntax that can be used in 'create log file table' command.\n\nTo separate adjacent log records and handle multiline records it is needed to know log records formats, at least its unique prefix format.\nFor example StreamScape log record looks like:\n\n    [01/18/19 14:41:54.120] [TRACE] [INFO ] [com.streamscape.runtime.RuntimeContext] Opening Dataspace Manager...\n\nStreamScape log record starts with timestamp, trace word and trace level.\n\nStreamscape filter can be specified using the following placeholders:\n   - N  - number\n   - d  - digit\n   - W  - word including digits\n   - CN - class name\n   - IP - IP address\n   - QS - quoted string\n   - all other symbols - delimiters stay as they are\n   - there can be zero or more whitespaces between delimiter and others\n   - space in the filter means one or more spaces\n\nStreamscape log records start filter can be described as following:\n   [N/N/N N:N:N.N] [W] [W] [CN] W W W...\nTimestamp filter can be defined as:\n   N/N/N N:N:N.N\nTimestamp format can defined as:\n   MM/dd/yy HH:mm:ss.SSS\n\nTimestamp format should be specified using Java date format syntax:\n\n  Letter   Date or Time Component            Presentation         Examples\n  G        Era designator                    Text                 AD\n  y        Year                              Year                 1996; 96\n  Y        Week year                         Year                 2009; 09\n  M        Month in year (context sensitive) Month                July; Jul; 07\n  L        Month in year (standalone form)   Month                July; Jul; 07\n  w        Week in year                      Number               27\n  W        Week in month                     Number               2\n  D        Day in year                       Number               189\n  d        Day in month                      Number               10\n  F        Day of week in month              Number               2\n  E        Day name in week                  Text                 Tuesday; Tue\n  u        Day number of week (1 = Monday, ) Number               1\n  a        Am/pm marker                      Text                 PM\n  H        Hour in day (0-23)                Number               0\n  k        Hour in day (1-24)                Number               24\n  K        Hour in am/pm (0-11)              Number               0\n  h        Hour in am/pm (1-12)              Number               12\n  m        Minute in hour                    Number               30\n  s        Second in minute                  Number               55\n  S        Millisecond                       Number               978\n  z        Time zone                         General time zone    Pacific Standard Time; PST; GMT-08:00\n  Z        Time zone                         RFC 822 time zone    -0800; +0800\n  X        Time zone                         ISO 8601 time zone   -08; +08; Z\n  XX       Time zone                         ISO 8601 time zone   -0800; +0800\n  XXX      Time zone                         ISO 8601 time zone   -08:00; +08:00\n\n\nBy default date and timestamp are serialized in local timezone. To append timezone name/value use z,Z or X placeholders.\nTo serialize date or timestamp in UTC timezone, append 'Z' placeholder to the end: yyyy-MM-dd'T'HH:mm:ss'Z'\n\nThe following date/timestamp formats are also used as default during date/timestamp deserialization:\n   yyyy-MM-dd'T'HH:mm:ss\n   yyyy-MM-dd'T'HH:mm:ss.SSS\n   yyyy-MM-dd'T'HH:mm:ssX\n   yyyy-MM-dd'T'HH:mm:ss.SSSX\n   yyyy-MM-dd'T'HH:mm:ssXX\n   yyyy-MM-dd'T'HH:mm:ss.SSSXX\n   yyyy-MM-dd'T'HH:mm:ssXXX\n   yyyy-MM-dd'T'HH:mm:ss.SSSXXX\n   yyyy-MM-dd'T'HH:mm:ss z\n   yyyy-MM-dd'T'HH:mm:ss.SSS z\n\nDefault Dataspace formats (used in dataspace queries, and displayed in console):\n   yyyy-MM-dd HH:mm:ss - date\n   MM-yyyy-dd - sqldate\n   ss:HH:mm - sqltime\n   MM-yyyy-dd HH:mm:ss.SSS - sqltimestamp\n\nOther formats:\n\n   MM/dd/yy HH:mm:ss.SSS\n   yyyy-MM-dd'T'HH:mm:ssX\n   yyyy-MM-dd'T'HH:mm:ss'Z'\n\nDate unit samples:\n    date.toString(now(), 'yyyy-MM-dd HH:mm:ss.SSS')\n    date.toString(now(), 'yyyy-MM-dd''T''HH:mm:ss.SSSXXX')\n    date.toString(now(), 'yyyy-MM-dd HH:mm:ss.SSS z')\n    date.toString(now(), 'yyyy-MM-dd''T''HH:mm:ss.SSS''Z''')\n\n    date.fromString('2024-03-22T06:44:56.156Z')\n    date.fromString('2024-03-22T06:44:56.156+03')\n    date.fromString('2024-03-22T06:44:56.156 PST')\n\n\n\nIf result 'timestamp pattern' is n/a then it is not possible to determine timestamp from provided log.\nIf result 'timestamp java format' is n/a then it is not possible to determine timestamp format from provided log.\nIf result 'timestamp pattern' is n/a try to specify 'timestamp java format' in command.\n" + HelpRegistry.dropboxHelp("filename")).setSyntax("analyze log file <filename> [ first lines <count> ] [ sample rate <rate> ] [ timestamp java format <format> ]").setExamples("analyze log file mylog.log timestamp java format MM/dd/yy HH:mm:ss.SSS").setInitialVersion("3.7 Build 1"), new HelpEntry("comment").setAvailableInRuntime(false).setDesc("Adds a comment to the schema object metadata.\nThe comment can be later read from 'describe' command.\n\nParameters:\n\n    on { <schema object type> } - specifies schema object type\n                                      collection  - collection schema type\n                                      table       - table collection\n                                      queue       - queue collection\n                                      file        - file table collection\n                                      column      - table column type\n                                      tuple       - is synonym for column\n                                      rpl         - refers to a function and Actor").setSyntax("comment on { collection | table | queue | file | column | tuple | rpl } is <comment> ").setExamples("comment on collection TestCol is 'This is a test collection'\ncomment on column TestCol.name is 'This is a name column'"), new HelpEntry("describe directory table").setAvailableInRuntime(false).setDesc("Describes a directory table or directory table files.\nIf 'tuples' option is specified it returns a row.").setSyntax("describe directory table <table name> [ file <file name> ] [ tuples ]").setExamples("describe directory table Logs\ndescribe directory table Logs tuples\ndescribe directory table Logs file 'main.log'\ndescribe directory table Logs file 'main.log' tuples"), new HelpEntry("print").setAvailableInRuntime(true).setDesc("Asynchronously sends argument message to console.").setSyntax("print(<variable>)").setExamples("print('hello message')"), new HelpEntry("exec immediate").setAvailableInRuntime(true).setDesc("Executes a dynamically composed DSQL, DDL or EDL statement in the current session.\n\nAny valid command line declaration or query can be executed using the EXEC IMMEDIATE call.\nThis may be a query with parameters, a function call, a data definition command, service call\nor other directive. Fully qualified namespaces are supported, allowing users to make cross\ndataspace calls.\n\nThe first argument is a string that represents the Statement. Several forms of the operation are \nsupported. If the Statement string is fully resolved (through substitution or string concatenation)\nthen the Statement can be executed as is. \n\nPositional place holders for parametrized processing are also supported through the use of the <?>\ncharacter, allowing for Compound Statements. Type casting is automatically performed in such \ncases, allowing the user to specify an arbitrary list of substitution parameters following the string\ncontaining the parametrized Statement.\n\nLiteral substitution using @variable syntax is also supported, allowing for direct substitution of \nidentifiers or numeric values. Note that literal substitution cannot be used to pass arguments\ninto a compound statement. String concatenation or <?> should be used in such cases.").setSyntax("exec immediate('<statement>'[, <arg1>, <arg2>, ... <argN>])").setExamples("exec immediate('select id, name from employees where age > ?', ageVariable)\nexec immediate('create dataspace @dsname like @anotherdsname')\nexec immediate('select [aiops_aws_Events_' + AccountId + '].cw_sendMail(?, ?, ?, ?, ?, ?)', namespace, type, subType, shortCode, EventGroupId, Event)"), new HelpEntry("explain plan for").setAvailableInRuntime(true).setDesc("Can be used with any query to get a detailed list of the elements in the execution plan.\nThis list includes the indexes used for performing the query and can be used to optimise the query or to add indexes to tables.\n").setSyntax("explain plan [ as json ] for { select ... | delete ... | insert ... | update ...};\n").setExamples("explain plan for select Name from Employees where id=10"), new HelpEntry("save").setAvailableInRuntime(false).addTag(Tag.DUMP).setSyntax("save (<statement>) as { csv | xml | json } [ no header ] [ quoted ] at '<file>'\n").setDesc("Saves DSQL query results as CSV, XML or JSON file format.\n\nParameters:\n    CSV | XML | JSON  - file format\n    no header         - do not write column name into the first line of the result\n    quoted            - surround column data with quotes").setExamples("save ('select * from users') as csv at 'c:/StreamScape/dumps/users.csv'\nsave ('select * from users') as csv no header quoted at 'c:/StreamScape/dumps/users.csv'\nsave ('select * from users where id = ?', 2) as csv at 'c:/StreamScape/dumps/users.csv'\nsave ('select * from table(test_foo())') as csv no header quoted at 'c:/StreamScape/dumps/users.csv'"), new HelpEntry("help function").setAvailableInRuntime(true), new HelpEntry("export semagraph for").setAvailableInRuntime(false).setScope(DataspaceType.FSPACE, DataspaceType.TSPACE).setOperationVisibleChecker(semagraphOperationsVisibleChecker).setDesc("Exports semagraph service as a table.\n").setSyntax("export semagraph for <service name> [ as <table name>]\n").setExamples("export semagraph for MyService as MyTable"), new HelpEntry("select for nearest").setAvailableInRuntime(true).setOperationVisibleChecker(semagraphOperationsVisibleChecker).setDesc("Implements the Semagraph FIND NEAREST operation and returns a row set of TERM and SCORE combinations.\nEVAL evaluates an expression of Semagraph query such as ('man' \u2013 'woman' + 'king') and\nsupports variable assignment such as (var1 \u2013 var2 + 'king')").setSyntax("select for nearest { top <number> | count(*) } term,score from <table> [ where eval (<term expression>) ] [ and score { > | >= } <score>]\n").setExamples("select for nearest count(*) from MyDictionary\nselect for nearest term,score from MyDictionary where eval('dirty')\nselect for nearest top 10 term, score from MyDictionary where eval('dirty') and score >= 0.8\nselect for nearest top 10 term, score from MyDictionary where eval('man' - 'women' + 'king')"), new HelpEntry("select for similarity").setAvailableInRuntime(true).setOperationVisibleChecker(semagraphOperationsVisibleChecker).setDesc("Implements the Semagraph CALCULATE SIMILARITY operation and returns a row set of 1 row with SCORE column of similarity between specified expressions.\nEVAL evaluates an expression of Semagraph query such as ('man' \u2013 'woman' + 'king') and supports variable assignment such as (var1 \u2013 var2 + 'king')").setSyntax("select for similarity score from <table> where eval (<term expression1>, <term expresson2>)\n").setExamples("select for similarity score from MyDictionary where eval('dirty', 'clean')\n"), new HelpEntry("select for classify").setAvailableInRuntime(true).setOperationVisibleChecker(semagraphOperationsVisibleChecker).setDesc("Implements the Semagraph CLASSIFY operation and returns a row set of cluster indexes and associative arrays of terms.\nEVAL evaluates an expression of Semagraph query such as ('man' \u2013 'woman' + 'king') and supports variable assignment such as (var1 \u2013 var2 + 'king')\nIf a term expression in the EVAL array is not in the model a Cluster named -1 is created and the term is added to its SET.\n").setSyntax("select for classify <cluster count> cluster [as <alias>], set [as <alias>] from <table> where eval (<term expression1>, <term expresson2>, ...)\n").setExamples("select for classify 2 cluster as index, set as [my terms] from MyDictionary where eval('dirty', 'clean', 'unclean', 'spotless')\n"), new HelpEntry("describe producer").setAvailableInRuntime(false).setDesc("Shows information about an event producer associated with the current dataspace component.\n\nParameters:\n\n   events - Shows information about all events bound to the current event producer.").setSyntax("describe producer [events]\n"), new HelpEntry("create facets").setAvailableInRuntime(true).setDesc("Creates a facet set.\n\nA facet set is similar to a Hash Map that can be used for indirect (inferred) data projections.\n\n" + APECTS_FACETS_SUPPORTED_TYPES + "\nFacets can be inserted into collection using the following syntax:\n\n    insert into mycollection (1, new facets({name: 'North America', population: 1234, lang: 'en'})\n\nParameters:\n\n   indexed - implies that when used in a TABLE declaration, a Text Index is automatically created for this column\n   static  - static facet set does not allow addition or removal of keys\n\nCollection sets (rows) can be JOINED to create projections based on complete or partial Key and Value match conditions.\nThis is accomplished using FACET JOIN syntax. Unlike Relational Set projections (SQL JOINS), that are created by\nspecifying direct equality operators, FACET JOINS use indirect means of relationship discovery between rows in\ncollections. Meaning they can use Key names, Values or a combination of these elements to relate data.\n\nA DEGREE of relationship can also be specified to give the query processor a hint as to how deep a relationship between\nthe elements can be. For example, KEY ANY will instruct the engine to match on any KEY name that occurs in source and\ntarget collection. A match based on KEY DEGREE 3 indicates that sets (rows) are only considered matching if at least\n3 KEY names are the same.\n\nSince candidate JOIN data references are not direct (not based on tuple equality), this is considered an Inference Join.\nAnd any queries that make use of this capability are called Inference Queries. FACET values can be derived via some\nDSQL computing expressions, populated by external processes or generated using Cognitive AI services. This allows data\nrelationships or inferences to be defined using Machine Learning techniques rather than SQL programming procedures.\n\nFACET JOIN relationships can be specified as LINKS, allowing the Inferences to be used during EXPAND, UNNEST and\nUNFOLD operations.\n\nFacet values are typed. They can be declared as any SQL primitive type, including Date or Timestamp, and they can\nalso de declared as Semantic Types (objects). During JOIN or SELECT operations, semantic types are serialize into\nhuman-readable form (JSON) and compared for equality. Schema differences are treated as semantic differences and are\nevaluated as FALSE is schema elements are missing. To be considered equal, data objects must truly be clones. Their\nschema and content must match. For opaque types (object tuples with no specific type), Hyponymy JOINS and queries can\nbe affected by using functions that allow you to discern if a stored object is an INSTANCE OF a specific semantic type.\nThis is currently not supported for JOIN or LINK declarations but ay be performed using standard DSQL SELECT syntax.\n\nExpanded Equality Syntax for Value Comparison:\n\n{ GT | LT } VALUES  - specifies that the values are considered TRUE if Target is Same, Less Than or Greater Than\nSource value, depending on the hint.  Source value is used as a basis for comparison.  This hint is applicable only to\nNumeric, Date or Timestamp values.  These hints applied against all other data types will raise an error.\n\n{ STARTS WITH | ENDS WITH | CONTAINS | SOUNDEX } VALUES applies to text elements and evaluates the Target value text as a\nsingle entity.  For Sources, only the first WORD in the value is evaluated. No processing occurs after the first space.\nFor all operations the Source value  (first word) is compared to the Target value text. This can be useful in comparing\nfor basic similarity, intent or reference (when using CONTAINS). The SOUNDEX hint instructs the engine to chose the\nfirst word in both Source and Target elements and compare using the SOUNDEX capability to check if the two elements are\nHomonyms (sound alike). These hints applied against all other data types will raise an error.\n\nFacet JOIN syntax:\n\n   select <tuple1>, <tuple2>, <expression> ... from <table name 1> T1\n          facet join <table name 2> T2 on T1.<facets source column>, T2.<facets target column>\n                ( { { keys | values } { any | all | none | degree <degree> } |\n                    { gt | lt } values { any | all | none | degree <degree> } |\n                    { starts with | ends with | contains | soundex } values { any | all | none | degree <degree> } |\n                  }\n                )\n\nFacet SELECT syntax:\n\n   select <tuple1>, <tuple2>, <expression> ... from <table name >\n      where <facets column> facet { contains keys { <array var> | <aspect var> | <facets var> | <map var> } |\n                                    eq { <facets var> | <map var> } |\n                                    match { <facets var> | <map var> } degree <degree>\n                                  }\n\n").setSyntax("create facets <name> (<key1 name> <value1 type>, <key2 name> <value2 type>,... ) [indexed] [static] [description <description>]\n"), new HelpEntry("list facet sets").setAvailableInRuntime(true).setAlias("list facets").setDesc("Lists existing facet sets. If keys modifier is specified additional columns keys and types will be added to output.").setSyntax("list facet sets [keys]"), new HelpEntry("describe facets").setAvailableInRuntime(true).setDesc("Describes facet set.").setSyntax("describe facets <name> [{ keys | as ddl }]"), new HelpEntry("drop facets").setAvailableInRuntime(true).setDesc("Drops facet set.").setSyntax("drop facets <name> [ if exists ]"), new HelpEntry("create aspects").setAvailableInRuntime(true).setDesc("Creates an aspect set.\n\nAn aspect set is similar to an Unbound Array that can be used for indirect (inferred) data projections.\n\n" + APECTS_FACETS_SUPPORTED_TYPES + "\nAspects can be inserted into collection using the following syntax:\n\n    insert into mycollection (1, new aspects(['North America', 'France']))\n\nParameters:\n\n   indexed - implies that when used in a TABLE declaration, a Text Index is automatically created for this column\n\nCollection sets (rows) can be JOINED to create projections based on complete or partial Element match conditions.\nThis is accomplished using ASPECT JOIN syntax. Unlike Relational Set projections (SQL JOINS), that are created by\nspecifying direct equality operators, ASPECT JOINS use indirect means of relationship discovery between rows in\ncollections. Meaning they can use one or more Element values to relate data.\n\nA DEGREE of relationship can also be specified to give the query processor a hint as to how deep a relationship\nbetween the elements can be. For example, ANY will instruct the engine to match on any Element value that occurs\nin source and target collection. A match based on DEGREE 3 indicates that sets (rows) are only considered matching\nif at least 3 Element values are the same.\n\nSince candidate JOIN data references are not direct (not based on tuple equality), this is considered an Inference Join.\nAnd any queries that make use of this capability are called Inference Queries. ASPECT values can be derived via some\nDSQL computing expressions, populated by external processes or generated using Cognitive AI services. This allows data\nrelationships or inferences to be defined using Machine Learning techniques rather than SQL programming procedures.\n\nASPECT JOIN relationships can be specified as LINKS, allowing the Inferences to be used during EXPAND, UNNEST and\nUNFOLD operations.\n\nExpanded Equality Syntax for Value Comparison:\n\n{ GT | LT } VALUES - specifies that the values are considered TRUE if Target is Same, Less Than or Greater Than\nSource value, depending on the hint. Source value is used as a basis for comparison. This hint is applicable only to\nNumeric, Date or Timestamp values. These hints applied against all other data types will raise an error.\n\n{ STARTS WITH | ENDS WITH | CONTAINS | SOUNDEX } VALUES applies to text elements and evaluates the Target value text as a\nsingle entity.  For Sources, only the first WORD in the value is evaluated. No processing occurs after the first space.\nFor all operations the Source value  (first word) is compared to the Target value text. This can be useful in comparing\nfor basic similarity, intent or reference (when using CONTAINS). The SOUNDEX hint instructs the engine to chose the\nfirst word in both Source and Target elements and compare using the SOUNDEX capability to check if the two elements are\nHomonyms (sound alike). These hints applied against all other data types will raise an error.\n\nAspect JOIN syntax:\n\n   select <tuple1>, <tuple2>, <expression> ... from <table name 1> T1\n          aspect join <table name 2> T2 on T1.<aspects column>, T2.<aspects column>\n                 ( [{ gt | lt | starts with | ends with | contains | soundex } values]  { any | all | none | degree <degree> } )\n\nAspect SELECT syntax:\n\n   select <tuple1>, <tuple2>, <expression> ... from <table name >\n      where <aspects column> aspect { contains keys { <array var> | <aspect var> } |\n                                      eq { <array var> | <aspect var> } |\n                                      match { <array var> | <aspect var> } degree <degree>\n                                    }\n\n").setSyntax("create aspects <name>(<value type>) [indexed] [description <description>]\n"), new HelpEntry("list aspect sets").setAvailableInRuntime(true).setAlias("list aspects").setDesc("Lists existing aspect sets.").setSyntax("list aspect sets"), new HelpEntry("describe aspects").setAvailableInRuntime(true).setDesc("Describes aspect set.").setSyntax("describe aspects <name> [ as ddl ]"), new HelpEntry("drop aspects").setAvailableInRuntime(true).setDesc("Drops aspect set.").setSyntax("drop aspects <name> [ if exists ]"), new HelpEntry("create knode").addTag(Tag.KGRAPH).setAlias("create engram").setAvailableInRuntime(true).setDesc("Create new KNode type.").setExamples("create knode Car (model subject key, make string, type string, year int, description string)\n   comment 'Describes a car by manufacturer'\n   if not exists\n").setSyntax("create { knode | engram | concept } <name>(<name> subject key [, <key1 name> <value1 type> ...]) [ comment <comment> ] [ if not exists ]"), new HelpEntry("list knodes").addTag(Tag.KGRAPH).setAlias("list engrams").setAvailableInRuntime(true).setDesc("Returns list of existing KNode types.").setSyntax("list { knodes | engrams | concept }"), new HelpEntry("describe knode").addTag(Tag.KGRAPH).setAlias("describe engram").setAvailableInRuntime(true).setDesc("Describes KNode type.").setSyntax("describe { knode | engram | concept} <name> [ { keys | as ddl | as json } ]"), new HelpEntry("drop knode").addTag(Tag.KGRAPH).setAlias("drop engram").setAvailableInRuntime(true).setDesc("Drops KNode type.").setSyntax("drop { knode | engram | concept } <name> [ if exists ]"), new HelpEntry("create klink").addTag(Tag.KGRAPH).setAvailableInRuntime(true).setDesc("Creates new KLink type.").setExamples("create klink [has-car] (state string, color string)\n   comment 'Represents a floor that has a Car.'\n   if not exists\n").setSyntax("create klink <name>[(<key1 name> <value1 type>, ...)] [ comment <comment> ] [ if not exists ]"), new HelpEntry("list klinks").addTag(Tag.KGRAPH).setAvailableInRuntime(true).setDesc("Returns list of existing KLink types.").setSyntax("list klinks"), new HelpEntry("describe klink").addTag(Tag.KGRAPH).setAvailableInRuntime(true).setDesc("Describes KLink type.").setSyntax("describe klink <name> [ { keys | as ddl | as json} ]"), new HelpEntry("drop klink").addTag(Tag.KGRAPH).setAvailableInRuntime(true).setDesc("Drops KLink type.").setSyntax("drop klink <name> [ if exists ]"), new HelpEntry("define kgraph").addTag(Tag.KGRAPH).setAvailableInRuntime(true).setDesc("Creates KGraph type.").setSyntax("define kgraph <name> [ (<key1 name> <value1 type>, ...) ] [ comment '<comment>' ] [ if not exists ]\n  { knodes | engrams | concepts } (<knode name>, ...)\n  klinks (<klink name> [ ({ <facet key> <facet value>, ... }) ], ... )\n  assertions(<knode name> -> :<klink name> -> <knode name> (<min>:<max | N>), ...)\n").setExamples("define kgraph Garage comment 'A garage for cars'\n    knodes (Car,Floor,Attendant)\n    klinks ([has-car] ({inGarage true}), [has-attendant] ({onDuty true})\n    assertions(Floor -> :[has-car] -> Car (0:N),\n               Floor -> :[has-attendant] -> Attendant (0:1))\n\ncreate knode [tskl.Start] (name subject key, [render.description] string, [render.type] string, [render.state] string, [render.tooltip] string)\ncreate knode [tskl.End] (name subject key, [render.description] string, [render.type] string, [render.state] string, [render.tooltip] string)\ncreate knode [tskl.Task] (name subject key, [render.description] string, [render.type] string, [render.state] string, [render.tooltip] string)\ncreate knode [tskl.Exception] (name subject key, [render.description] string, [render.type] string, [render.state] string, [render.tooltip] string)\n\ncreate klink [tskl.transition-to] ([render.description] string, [render.type] string, [render.state] string)\ncreate klink [tskl.loop-to] ([render.description] string, [render.type] string, [render.state] string)\ncreate klink [tskl.select-to] ([render.description] string, [render.type] string, [render.state] string)\ncreate klink [tskl.exception-to] ([render.description] string, [render.type] string, [render.state] string)\n\nset delimiter $$\ndefine kgraph TaskList\n      knodes ([tskl.Start], [tskl.End], [tskl.Task], [tskl.Exception])\n      klinks ([tskl.transition-to], [tskl.loop-to], [tskl.select-to], [tskl.exception-to])\n      assertions(\n         [tskl.Start] -> :[tskl.transition-to] -> [tskl.Task] (1:1),\n         [tskl.Start] -> :[tskl.transition-to] -> [tskl.End] (0:1),\n         [tskl.Task] -> :[tskl.transition-to] -> [tskl.Task] (0:N),\n         [tskl.Task] -> :[tskl.loop-to] -> [tskl.Task] (0:N),\n         [tskl.Task] -> :[tskl.select-to] -> [tskl.Task] (0:N),\n         [tskl.Task] -> :[tskl.exception-to] -> [tskl.Exception] (0:1),\n         [tskl.Task] -> :[tskl.transition-to] -> [tskl.End] (0:1)\n      )\n$$\nset delimiter\n").setScope(DataspaceType.CSPACE), new HelpEntry("redefine kgraph").addTag(Tag.KGRAPH).setAvailableInRuntime(true).setDesc("Alters KGraph type.").setSyntax("redefine kgraph <name> [ comment '<comment>' ]\n  remove facets (<key1 name>, ...)\n  add facets (<key1 name> <value1 type>, ...)\n  remove { knodes | engrams | concept } (<knode name>, ...)\n  add { knodes | engrams | concept } (<knode name>, ...)\n  remove klinks (<klink name>, ...)\n  add klinks (<klink name> [ ({ <facet key> <facet value>, ... }) ], ... )\n  update klinks (<klink name> [ ({ <facet key> <facet value>, ... }) ], ... )\n  remove assertions(<knode name> -> :<klink name> -> <knode name>, ...)\n  add assertions(<knode name> -> :<klink name> -> <knode name> (<min>:<max | N>), ...)\n").setScope(DataspaceType.CSPACE), new HelpEntry("list kgraph types").addTag(Tag.KGRAPH).setAvailableInRuntime(true).setDesc("Returns list of existing KGraph types.").setSyntax("list kgraph types").setScope(DataspaceType.CSPACE), new HelpEntry("describe kgraph type").addTag(Tag.KGRAPH).setAvailableInRuntime(true).setDesc("Describes KGraph type.").setSyntax("describe kgraph type <name> [ { knodes | engrams | concepts | klinks | assertions | as ddl | as json} ]").setScope(DataspaceType.CSPACE), new HelpEntry("drop kgraph type").addTag(Tag.KGRAPH).setAvailableInRuntime(true).setDesc("Drops KGraph type.").setSyntax("drop kgraph type <name> [ if exists ] [ cascade ] ").setScope(DataspaceType.CSPACE), new HelpEntry("create kgraph").addTag(Tag.KGRAPH).setAvailableInRuntime(true).setDesc("Creates new KGraph instance.").setExamples("create kgraph mykgraph constrained by Garage").setSyntax("create kgraph <name> constrained by <kgraph type> [ comment <comment> ] [ if not exists ]").setScope(DataspaceType.CSPACE), new HelpEntry("list kgraphs").addTag(Tag.KGRAPH).setAvailableInRuntime(true).setDesc("Returns list of existing KGraphs.").setSyntax("list kgraphs").setScope(DataspaceType.CSPACE), new HelpEntry("describe kgraph").addTag(Tag.KGRAPH).setAvailableInRuntime(true).setDesc("Describes KGraph.").setSyntax("describe kgraph <name> [ { knodes | engrams | concepts | assertions | as ddl | as json } ]").setScope(DataspaceType.CSPACE), new HelpEntry("drop kgraph").addTag(Tag.KGRAPH).setAvailableInRuntime(true).setDesc("Drops KGraph.").setSyntax("drop kgraph <name> [ if exists ]").setScope(DataspaceType.CSPACE), new HelpEntry("kgraph").addTag(Tag.KGRAPH).setAvailableInRuntime(true).setDesc("KGraph operations.").setSyntax("kgraph <name> link \n        { <knode type>:{ [subject key value] | @var } | <knode instance> | new knode(<knode type>: {facets values}) } to \n        { <knode type>:{ [subject key value] | @var } | <knode instance> | new knode(<knode type>: {facets values}) } as \n        :<klink name> [ ({ <facet key> <facet value>, ... }) ]\n\nkgraph <name> knode \n        { <knode type>:{ [subject key value] | @var } ({facets values}) | <knode instance> | new knode(<knode type>: {facets values}) }").setExamples("kgraph myGarage link Car:[F-150] to Floor:@floorName as :[has-car]\n\nkgraph myGarage knode new knode(Car: {model: 'mazda', color: 'red'})\nkgraph myGarage knode Car:[mazda]({color: 'green'})\nkgraph myGarage knode Car:@model({color: 'green'})\n").setScope(DataspaceType.CSPACE), new HelpEntry("new knode").addTag(Tag.KGRAPH).setAlias("new engram").setAvailableInRuntime(true).setDesc("Returns new KNode instance.").setSyntax("new { knode | engram | concept } ( [ <knode type name> [: {facets values} ] ])").setExamples("KNode emptyKNode = new knode\nKNode anotherEmptyKNode = new knode()\nKNode emptyCar = new knode(Car)\nKNode carWithKey = new knode(Car: 'ultima')\nKNode someCar = new knode(Car: {model: 'Ultima 320', \"make\": 'Nissan', type 'Sedan', year 2014, description 'Sedan, Extended, 4 Door'})\nmap m = new map();\nm.put('model', 'ultima');\nKNode carWithFacets = new knode(Car: m);\n").setScope(DataspaceType.CSPACE), new HelpEntry("recall kgraph").addTag(Tag.KGRAPH).setAvailableInRuntime(true).setDesc("Loads KGraph from dataspace and return in KGraph object.").setSyntax("recall kgraph <kgraph name>").setExamples("KGraph garage = (recall kgraph Garage)").setScope(DataspaceType.CSPACE), new HelpEntry("table kgraph").addTag(Tag.KGRAPH).setAvailableInRuntime(true).setDesc("Validates and saves KGraph to current dataspace.").setSyntax("table kgraph <kgraph variable>").setExamples("table kgraph garage").setScope(DataspaceType.CSPACE), new HelpEntry("validate kgraph").addTag(Tag.KGRAPH).setAvailableInRuntime(true).setDesc("Validates KGraph with KGraph type defined.").setSyntax("validate kgraph <kgraph variable>").setExamples("validate kgraph garage").setScope(DataspaceType.CSPACE), new HelpEntry("new facets").setAvailableInRuntime(true).setDesc("Returns new Facets instance.").setSyntax("new facets [ (<facets type> [ : {facets values} ] ) ] ").setExamples("facets defaultEmptyFacet = new facets\nfacets defaultNotEmptyFacet = new facets({id: 1, name: 'Steeve', age: @steeveAge, expr: @someValue + 'some string'})\nfacets typedEmptyFacet = new facets(Car)\nfacets typedNotEmptyFacet = new facets(Car: {model: 'Ultime', year: 2002, commet: @commet})\n"), new HelpEntry("new aspects").setAvailableInRuntime(true).setDesc("Returns new Aspects instance.").setSyntax("new aspects [ (<aspects type> [ : [aspects values] ] ) ] ").setExamples("aspects defaultEmptyAspect = new aspects()\naspects defaultNotEmptyAspects = new aspects([1, 'Steeve', @someValue + 'some string'])\naspects typedEmptyAspects = new aspects(Car)\naspects typedNotEmptyAspects = new aspects(Car: ['Ultime', @commet])\n"), new HelpEntry("list futures").setAvailableInRuntime(true).setDesc("Returns list of scheduled and execution futures.").setSyntax("list futures"), new HelpEntry("attach metaset").setAvailableInRuntime(true).setDesc("Attaches a new instance of the specified Metaset to the current dataspace.\n\nOnce metaset is attached to dataspace it can be accessed using Metaset function unit.\n\nSample operations:\n\n   metaset.getName()\n   metaset.set('mykey', 'myvalue')\n   string mykeyvalue = metaset.get('mykey')\n   metaset.listKeys()\n").setSyntax("attach metaset <name> [ at <dataspace name> ] [ if not attached ]"), new HelpEntry("detach metaset").setAvailableInRuntime(true).setDesc("Detaches the Metaset instance from the current dataspace.").setSyntax("detach metaset [ for <dataspace name> ]"), new HelpEntry("describe metaset").setAvailableInRuntime(true).setInitialVersion("3.8 Build 25").setDesc("Shows information about the Metaset instance attached to the current dataspace.\n\nOptional parameters:\n\n   &lt;MetasetName&gt; - Shows information about the specified Metaset.\n   description   - Shows a description of the Metaset.\n   properties    - Shows a list of properties of the Metaset.").setSyntax("describe metaset [<MetasetName>]\n   [{description | values}]").setExamples("describe metaset\ndescribe metaset properties\ndescribe metaset description\ndescribe metaset Test\ndescribe metaset Test description\ndescribe metaset Test properties")};

    public static String dropboxHelp(String name) {
        return name + " can also point to a DropBox abstraction using the StreamScape URL \nscheme. A DropBox file or folder location may be specified using URL format:\n\n\n    dropbox://<dropbox name>/<drop box resource path>\n\nfor example:\n\n    dropbox://BobsBox/big_document.txt\n    dropbox://JoesBox/";
    }

    public static class HelpEntry {
        private List<DataspaceType> scope;
        private String name;
        private String alias;
        private String description;
        private String syntax;
        private TreeSet<String> tags;
        private String examples;
        private String initialVersion = "3.4 Build 1";
        private String status = "Current";
        private boolean admin;
        private boolean availableInRuntime;
        private OperationVisibleCondition operationVisibleChecker;

        HelpEntry(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        HelpEntry setScope(DataspaceType ... scope) {
            this.scope = new ArrayList<DataspaceType>();
            this.scope.addAll(Arrays.asList(scope));
            return this;
        }

        public List<DataspaceType> getScope() {
            return this.scope;
        }

        HelpEntry setAlias(String alias) {
            this.alias = alias;
            return this;
        }

        public String getAlias() {
            return this.alias;
        }

        HelpEntry setDesc(String desc) {
            this.description = desc;
            return this;
        }

        public String getDesc() {
            return this.description;
        }

        HelpEntry setSyntax(String syntax) {
            this.syntax = syntax;
            return this;
        }

        public String getSyntax() {
            return this.syntax;
        }

        HelpEntry setExamples(String examples) {
            this.examples = examples;
            return this;
        }

        public String getExamples() {
            return this.examples;
        }

        public HelpEntry addTag(Tag tag) {
            if (this.tags == null) {
                this.tags = new TreeSet();
            }
            this.tags.add(tag.name);
            return this;
        }

        public TreeSet<String> getTags() {
            return this.tags;
        }

        public String getInitialVersion() {
            return this.initialVersion;
        }

        public HelpEntry setInitialVersion(String initialVersion) {
            this.initialVersion = initialVersion;
            return this;
        }

        public String getStatus() {
            return this.status;
        }

        public HelpEntry setStatus(String status) {
            this.status = status;
            return this;
        }

        HelpEntry setAdmin(boolean admin) {
            this.admin = admin;
            return this;
        }

        public boolean isAdmin() {
            return this.admin;
        }

        public boolean isAvailableInRuntime() {
            return this.availableInRuntime;
        }

        public HelpEntry setAvailableInRuntime(boolean availableInRuntime) {
            this.availableInRuntime = availableInRuntime;
            return this;
        }

        public OperationVisibleCondition getOperationVisibleChecker() {
            return this.operationVisibleChecker;
        }

        public HelpEntry setOperationVisibleChecker(OperationVisibleCondition operationVisibleChecker) {
            this.operationVisibleChecker = operationVisibleChecker;
            return this;
        }
    }

    static enum Tag {
        REPLICATION("replication"),
        SESSION("session"),
        PROCESS_QUEUE("processqueue"),
        QUEUE("queue"),
        HADOOP("hadoop"),
        JFT("jft"),
        FILE("file"),
        SECURITY("security"),
        GRANT("grant"),
        TIMER("timer"),
        DUMP("dump"),
        DATASPACE("dataspace"),
        VIRTUAL("virtual"),
        REFERENCE_LINK("referencelink"),
        SNAPSHOT("snapshot"),
        DROP("drop"),
        FIND("find"),
        KGRAPH("kgraph");

        private final String name;

        private Tag(String name) {
            this.name = name;
        }
    }
}

