/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.future;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.future.FutureFunctionCaller;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExpressionFutureFunctionParam;
import com.streamscape.ds.schema.DataspaceSchema;
import com.streamscape.ds.schema.procedure.FunctionSQLInvoked;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.IntervalSecondData;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.lib.numalloc.IntNumberAllocator;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.event.MapEvent;
import com.streamscape.sdo.excp.FabricEventException;
import com.streamscape.sef.EventAsyncConsumer;
import com.streamscape.sef.FabricEventListener;
import com.streamscape.sef.enums.EventScope;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class FutureFunctionManager
implements FabricEventListener {
    Map<Integer, FutureFunctionCaller> futures = new ConcurrentHashMap<Integer, FutureFunctionCaller>();
    DataspaceStore store = null;
    EventAsyncConsumer consumer = null;
    DataspaceSchema sysSchema = null;
    IntNumberAllocator callerIdAllocator = new IntNumberAllocator();

    public void init(DataspaceStore store, DataspaceSchema schema) {
        try {
            this.store = store;
            this.sysSchema = schema;
            EventAsyncConsumer consumer = schema.createEventAsyncConsumer("FutureFunctionsTimer", this, "event.Timer", "timerGroup = 'DataspaceFutureFunctions' and timerState = 'EXPIRED'", EventScope.OBSERVABLE, false);
            consumer.start();
        }
        catch (Exception error) {
            Trace.logError(this, "Unable to init consumer for future functions.");
        }
    }

    public void open() {
    }

    public void close() {
        if (this.consumer != null) {
            this.consumer.close();
            this.consumer = null;
        }
    }

    public boolean scheduleFunction(Session session, Expression function, Expression interval, Expression userKey) {
        long intervalValueSeconds;
        Object intervalValue = interval.getValue(session);
        if (intervalValue instanceof IntervalSecondData) {
            intervalValueSeconds = ((IntervalSecondData)intervalValue).getSeconds();
        } else if (intervalValue instanceof Number) {
            intervalValueSeconds = ((Number)intervalValue).longValue();
        } else if (intervalValue instanceof String) {
            intervalValueSeconds = Integer.valueOf((String)intervalValue).intValue();
        } else {
            throw new DataspaceException("Invalid interval value type for future function scheduling, should be interval or number of seconds.");
        }
        Object userKeyValue = userKey != null ? userKey.getValue(session) : null;
        try {
            Integer callerId = this.callerIdAllocator.getNumber();
            ArrayList<Object> funcParams = new ArrayList<Object>();
            this.checkExpression(session, function.nodes, funcParams);
            FutureFunctionCaller.FutureFunctionInfo info = new FutureFunctionCaller.FutureFunctionInfo(function.getSQL(), interval.getSQL(), (int)intervalValueSeconds, System.currentTimeMillis(), userKeyValue != null ? userKeyValue.toString() : null);
            FutureFunctionCaller caller = new FutureFunctionCaller(callerId, (FunctionSQLInvoked)function, funcParams, session.getCurrentDataspaceName(), info);
            this.futures.put(callerId, caller);
            Executors.newSingleThreadScheduledExecutor().schedule(() -> this.execute(callerId), intervalValueSeconds, TimeUnit.SECONDS);
            return true;
        }
        catch (Exception error) {
            Trace.logError(this, "Unable to schedule function for future execution. " + error.getMessage());
            throw new DataspaceException("Unable to schedule function for future execution.", error);
        }
    }

    private void checkExpression(Session session, Expression[] exprs, ArrayList<Object> futureParams) {
        for (int i = 0; i < exprs.length; ++i) {
            if (exprs[i] instanceof ExpressionFutureFunctionParam && exprs[i].nodes != null && exprs[i].nodes.length > 0) {
                futureParams.add(OtherTypeWrapper.unwrap(exprs[i].nodes[0].getValue(session)));
                continue;
            }
            if (exprs[i] != null && exprs[i].isFutureFunctionSensitive()) {
                Expression temp = exprs[i];
                exprs[i] = new ExpressionFutureFunctionParam(temp, futureParams.size());
                futureParams.add(OtherTypeWrapper.unwrap(temp.getValue(session)));
                continue;
            }
            futureParams.add(OtherTypeWrapper.unwrap(exprs[i].getValue(session)));
        }
    }

    @Override
    public void onEvent(ImmutableEventDatagram event) throws FabricEventException {
        try {
            int futureId = ((MapEvent)event).getInt("FutureId");
            this.execute(futureId);
        }
        catch (Exception error) {
            Trace.logError(this, "Future function execution failed. " + error.getMessage());
        }
    }

    private void execute(int futureId) {
        FutureFunctionCaller function = this.futures.get(futureId);
        function.execute(this.store);
        this.futures.remove(futureId);
        this.callerIdAllocator.releaseNumber(futureId);
    }

    public Map<Integer, FutureFunctionCaller> getFutures() {
        return this.futures;
    }
}

