/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.future;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.schema.procedure.FunctionSQLInvoked;
import com.streamscape.ds.session.Session;
import java.util.ArrayList;

public class FutureFunctionCaller {
    Integer id = 0;
    FunctionSQLInvoked function = null;
    ArrayList<Object> futureParams = null;
    NameManager.ObjectName dsName = null;
    private final FutureFunctionInfo info;
    private FutureFucntionState futureFucntionState;

    FutureFunctionCaller(Integer id, FunctionSQLInvoked function, ArrayList<Object> params, NameManager.ObjectName dsName, FutureFunctionInfo info) {
        this.id = id;
        this.function = function;
        this.futureParams = params;
        this.dsName = dsName;
        this.info = info;
        this.futureFucntionState = FutureFucntionState.SCHEDULED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(DataspaceStore store) {
        Session systemSession = null;
        Session oldSession = Session.sessionThreadLocal.get();
        try {
            systemSession = store.getSessionManager().newSysSession();
            systemSession.setCurrentDataspaceName(this.dsName);
            Session.sessionThreadLocal.set(systemSession);
            this.info.sessionId = systemSession.getId();
            String sql = this.function.getSQLWithQuestions();
            Statement statement = null;
            try {
                statement = systemSession.compileStatement(sql);
            }
            catch (Exception e) {
                Trace.logError(this, "Faield to compile future statement: " + sql);
                Trace.logException(this, e, true);
            }
            this.futureFucntionState = FutureFucntionState.EXECUTING;
            if (statement != null) {
                systemSession.executeCompiledStatement(statement, this.futureParams.toArray(new Object[this.futureParams.size()]));
            } else {
                systemSession.sessionContext.futureParams = this.futureParams;
                this.function.getValue(systemSession);
            }
            systemSession.commit(false);
            this.futureFucntionState = FutureFucntionState.FINISHED;
        }
        catch (Throwable error) {
            this.futureFucntionState = FutureFucntionState.ERROR;
            Trace.logError(this, "Future execution failed: " + this.function.getSQL());
            Trace.logException(this, error, true);
            systemSession.rollback(false);
        }
        finally {
            this.info.finishedAtUtc = System.currentTimeMillis();
            if (systemSession != null) {
                systemSession.close();
                systemSession = null;
            }
            Session.sessionThreadLocal.set(oldSession);
        }
    }

    public FutureFunctionInfo getInfo() {
        return this.info;
    }

    public Integer getId() {
        return this.id;
    }

    public FutureFucntionState getFutureFucntionState() {
        return this.futureFucntionState;
    }

    public ArrayList<Object> getFutureParams() {
        return this.futureParams;
    }

    public static class FutureFunctionInfo {
        String functionSql;
        String functionIntervalSql;
        int intervalSeconds;
        long createdAtUtc;
        private final String userKey;
        long finishedAtUtc;
        Long sessionId;

        public FutureFunctionInfo(String functionSql, String functionIntervalSql, int intervalSeconds, long createdAtUtc, String userKey) {
            this.functionSql = functionSql;
            this.functionIntervalSql = functionIntervalSql;
            this.intervalSeconds = intervalSeconds;
            this.createdAtUtc = createdAtUtc;
            this.userKey = userKey;
        }

        public String getFunctionSql() {
            return this.functionSql;
        }

        public FutureFunctionInfo setFunctionSql(String functionSql) {
            this.functionSql = functionSql;
            return this;
        }

        public String getFunctionIntervalSql() {
            return this.functionIntervalSql;
        }

        public FutureFunctionInfo setFunctionIntervalSql(String functionIntervalSql) {
            this.functionIntervalSql = functionIntervalSql;
            return this;
        }

        public int getIntervalSeconds() {
            return this.intervalSeconds;
        }

        public FutureFunctionInfo setIntervalSeconds(int intervalSeconds) {
            this.intervalSeconds = intervalSeconds;
            return this;
        }

        public long getCreatedAtUtc() {
            return this.createdAtUtc;
        }

        public FutureFunctionInfo setCreatedAtUtc(long createdAtUtc) {
            this.createdAtUtc = createdAtUtc;
            return this;
        }

        public Long getSessionId() {
            return this.sessionId;
        }

        public String getUserKey() {
            return this.userKey;
        }
    }

    static enum FutureFucntionState {
        SCHEDULED,
        EXECUTING,
        FINISHED,
        ERROR;

    }
}

