/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.error;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.error.ErrorCode;
import com.streamscape.ds.lib.StringUtil;
import com.streamscape.ds.resources.BundleHandler;
import com.streamscape.ds.result.Result;
import java.lang.reflect.Field;

public class Error {
    public static boolean TRACE = false;
    public static boolean TRACESYSTEMOUT = false;
    private static final String errPropsName = "sql-state-messages";
    private static final int bundleHandle = BundleHandler.getBundleHandle("sql-state-messages", null);
    private static final String MESSAGE_TAG = "$$";
    private static final int SQL_STATE_DIGITS = 5;
    private static final int SQL_CODE_DIGITS = 4;
    private static final int ERROR_CODE_BASE = 11;

    public static RuntimeException runtimeError(int code, String add) {
        DataspaceException e = Error.error(code, add);
        return new RuntimeException(e.getMessage());
    }

    public static DataspaceException error(int code, String add) {
        return Error.error(null, code, add);
    }

    public static DataspaceException error(Throwable t, int code, String add) {
        Object s = Error.getMessage(code);
        if (add != null) {
            s = (String)s + ": " + add.toString();
        }
        return new DataspaceException(t, ((String)s).substring(6), ((String)s).substring(0, 5), -code);
    }

    public static DataspaceException error(int code) {
        return Error.error(null, code, 0, null);
    }

    public static DataspaceException error(int code, Throwable t) {
        String message = Error.getMessage(code, 0, null);
        if (message != null) {
            return new DataspaceException(t, message.substring(0, 5), -code);
        }
        return new DataspaceException(t, "", -code);
    }

    public static DataspaceException error(Throwable t, int code, int subCode, Object[] add) {
        String message = Error.getMessage(code, subCode, add);
        int sqlCode = subCode < 11 ? code : subCode;
        return new DataspaceException(t, message.substring(6), message.substring(0, 5), -sqlCode);
    }

    public static DataspaceException error(int code, Object[] add) {
        String message = Error.getMessage(code, 0, add);
        int sqlCode = code;
        return new DataspaceException(null, message.substring(6), message.substring(0, 5), -sqlCode);
    }

    public static DataspaceException parseError(int code, String add, int lineNumber) {
        Object s = Error.getMessage(code);
        if (add != null) {
            s = (String)s + ": " + add;
        }
        if (lineNumber > 1) {
            add = Error.getMessage(24);
            s = (String)s + " :" + add + String.valueOf(lineNumber);
        }
        return new DataspaceException(null, ((String)s).substring(6), ((String)s).substring(0, 5), -code);
    }

    public static DataspaceException parseError(int code, int subCode, int lineNumber, Object[] add) {
        Object message = Error.getMessage(code, subCode, add);
        if (lineNumber > 1) {
            String sub = Error.getMessage(24);
            message = (String)message + " :" + sub + String.valueOf(lineNumber);
        }
        int sqlCode = subCode < 11 ? code : subCode;
        return new DataspaceException(null, ((String)message).substring(6), ((String)message).substring(0, 5), -sqlCode);
    }

    public static DataspaceException error(int code, int code2) {
        return Error.error(code, Error.getMessage(code2));
    }

    public static DataspaceException error(String message, String sqlState) {
        int code = Error.getCode(sqlState);
        if (code < 1000) {
            code = 5800;
        }
        if (message == null) {
            message = Error.getMessage(code);
        }
        return new DataspaceException(null, message, sqlState, code);
    }

    private static String insertStrings(String message, Object[] add) {
        StringBuffer sb = new StringBuffer(message.length() + 32);
        int lastIndex = 0;
        int escIndex = message.length();
        for (int i = 0; i < add.length && (escIndex = message.indexOf(MESSAGE_TAG, lastIndex)) != -1; ++i) {
            sb.append(message.substring(lastIndex, escIndex));
            sb.append(add[i] == null ? "null exception message" : add[i].toString());
            lastIndex = escIndex + MESSAGE_TAG.length();
        }
        escIndex = message.length();
        sb.append(message.substring(lastIndex, escIndex));
        return sb.toString();
    }

    public static String getMessage(int errorCode) {
        return Error.getResourceString(errorCode);
    }

    public static String getStateString(int errorCode) {
        return Error.getMessage(errorCode, 0, null).substring(0, 5);
    }

    public static String getMessage(int code, int subCode, Object[] add) {
        String subCodeMessage;
        Object message = Error.getResourceString(code);
        if (subCode != 0 && (subCodeMessage = Error.getResourceString(subCode)) != null) {
            message = (String)message + subCodeMessage;
        }
        if (add != null) {
            message = Error.insertStrings((String)message, add);
        }
        return message;
    }

    private static String getResourceString(int code) {
        String key = StringUtil.toZeroPaddedString(code, 4, 4);
        return BundleHandler.getString(bundleHandle, key);
    }

    public static DataspaceException error(Result result) {
        return new DataspaceException(result);
    }

    public static void printSystemOut(String message) {
        if (TRACESYSTEMOUT) {
            System.out.println(message);
        }
    }

    public static int getCode(String sqlState) {
        try {
            Field[] fields = ErrorCode.class.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                String name = fields[i].getName();
                if (name.length() != 7 || !name.endsWith(sqlState)) continue;
                return fields[i].getInt(ErrorCode.class);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return -1;
    }

    public static DataspaceException incompatibleComparisonTypesError(String expected, String got) {
        return Error.error(5611, new String[]{expected, got});
    }

    public static DataspaceException incompatibleComparisonTypesError(String expected, Object got) {
        return Error.incompatibleComparisonTypesError(expected, got.getClass().getSimpleName());
    }

    public static DataspaceException incompatibleComparisonTypesError(Object expected, Object got) {
        return Error.incompatibleComparisonTypesError(expected.getClass().getSimpleName(), got.getClass().getSimpleName());
    }
}

