/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.analyze.finder;

import com.streamscape.ds.analyze.Operand;
import com.streamscape.ds.analyze.ResultRow;
import com.streamscape.ds.analyze.SearchType;
import com.streamscape.ds.analyze.TokenSet;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.session.Session;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public interface TypeFinder {
    public List<ResultRow> find(Session var1, TokenSet var2) throws Exception;

    public static Result executeCompiledStatement(Session session, String sql, String searchColumn, TokenSet tokenSet) {
        ArrayList<String> tokens = new ArrayList<String>();
        for (String token : tokenSet.getTokens()) {
            token = token.replace("*", "%");
            if (tokenSet.getSearchType().equals((Object)SearchType.MULTI)) {
                token = StringUtils.appendIfMissing((String)token, (CharSequence)"%", (CharSequence[])new CharSequence[0]);
                token = StringUtils.prependIfMissing((String)token, (CharSequence)"%", (CharSequence[])new CharSequence[0]);
            }
            tokens.add(token);
        }
        sql = TypeFinder.addLikeStatement(sql, searchColumn, new ArrayList<Operand>(tokenSet.getOperands()));
        return session.executeCompiledStatement(session.compileStatement(sql), tokens.toArray());
    }

    public static String addLikeStatement(String sql, String searchColumn, List<Operand> operands) {
        StringBuilder likeSql = new StringBuilder();
        for (int i = 0; i < operands.size(); ++i) {
            likeSql.append((i != 0 ? operands.get(i).name() : "") + " LOWER(" + searchColumn + ") LIKE LOWER(?) ");
        }
        return sql.replace("#LIKE#", likeSql.toString());
    }
}

