/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.analyze.finder;

import com.streamscape.cli.ds.CollectionType;
import com.streamscape.ds.analyze.ResultRow;
import com.streamscape.ds.analyze.TokenSet;
import com.streamscape.ds.analyze.finder.TypeFinder;
import com.streamscape.ds.analyze.finder.Util;
import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.collection.fspace.hadoop.HadoopVirtualTableCollection;
import com.streamscape.ds.session.Session;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableFinder
implements TypeFinder {
    private String SYS_TABLE_NAME = "SYS.SYSTEM_TABLES";
    private String TABLE_NAME_COL = "TABLE_NAME";
    private String TABLE_NAME_DS = "TABLE_SCHEM";
    private static Map<CollectionType, String> typeNameMap = new HashMap<CollectionType, String>();

    @Override
    public List<ResultRow> find(Session session, TokenSet query) {
        ArrayList<ResultRow> rs = new ArrayList<ResultRow>();
        String sql = "SELECT " + this.TABLE_NAME_COL + "," + this.TABLE_NAME_DS + " FROM " + this.SYS_TABLE_NAME + " WHERE TABLE_TYPE = 'TABLE' AND (#LIKE#)";
        Result sqlResult = TypeFinder.executeCompiledStatement(session, sql, this.TABLE_NAME_COL, query);
        RowSetNavigator rowSet = sqlResult.getNavigator();
        while (rowSet.next()) {
            Object[] currentRow = rowSet.getCurrent();
            String tableName = (String)currentRow[0];
            String dsName = (String)currentRow[1];
            String dsType = Util.getSchemaType(session, dsName);
            String tableType = this.getTableType(session, tableName, dsName);
            if (tableType == null) continue;
            rs.add(new ResultRow(tableType, tableName, dsType + "." + dsName));
        }
        return rs;
    }

    private String getTableType(Session session, String tableName, String dsName) {
        Collection collection = session.dataspaceStore.schemaManager.findUserCollection(session, tableName, dsName);
        if (collection == null || collection instanceof HadoopVirtualTableCollection) {
            return null;
        }
        String tableType = typeNameMap.get((Object)collection.getCollectionType());
        if (tableType == null) {
            return typeNameMap.get(null);
        }
        return tableType;
    }

    static {
        typeNameMap.put(CollectionType.QUEUE, "Queue");
        typeNameMap.put(CollectionType.SNAPSHOT_TABLE, "Snaptable");
        typeNameMap.put(CollectionType.MAP, "Map");
        typeNameMap.put(CollectionType.EVENT_QUEUE, "EventQueue");
        typeNameMap.put(CollectionType.EVENT_TABLE, "EventTable");
        typeNameMap.put(CollectionType.FILE_TABLE, "FileTable");
        typeNameMap.put(CollectionType.TABLE, "Table");
        typeNameMap.put(null, "Table");
    }
}

