/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.analyze.finder;

import com.streamscape.ds.analyze.ResultRow;
import com.streamscape.ds.analyze.TokenSet;
import com.streamscape.ds.analyze.finder.OtherTypeFinder;
import com.streamscape.ds.session.Session;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.service.ServiceName;
import java.util.ArrayList;
import java.util.List;

public class ServiceFinder
extends OtherTypeFinder {
    private static final String TYPE_NAME = "Service";

    @Override
    public List<ResultRow> find(Session session, TokenSet query) throws Exception {
        ArrayList<ResultRow> rows = new ArrayList<ResultRow>();
        List<ServiceName> filteredList = this.filterByLikeExp(this.listServices(), servName -> servName.getName(), query);
        for (ServiceName servName2 : filteredList) {
            rows.add(new ResultRow(TYPE_NAME, servName2.getName(), servName2.getType()));
        }
        return rows;
    }

    private List<ServiceName> listServices() throws Exception {
        ArrayList<ServiceName> result = new ArrayList<ServiceName>();
        for (String serviceType : RuntimeContext.getInstance().getRepositoryAccessor().listServiceTypes()) {
            this.addServices(serviceType, result);
        }
        return result;
    }

    private void addServices(String type, List<ServiceName> result) throws Exception {
        for (String name : RuntimeContext.getInstance().getRepositoryAccessor().listServicesByType(type)) {
            if (!ServiceFinder.isActualService(name)) continue;
            result.add(new ServiceName(type, name));
        }
    }

    private static boolean isActualService(String name) {
        return !name.equalsIgnoreCase("prototype");
    }
}

