/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.analyze.finder;

import com.streamscape.ds.analyze.ResultRow;
import com.streamscape.ds.analyze.TokenSet;
import com.streamscape.ds.analyze.finder.TypeFinder;
import com.streamscape.ds.analyze.finder.Util;
import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.session.Session;
import java.util.ArrayList;
import java.util.List;

public abstract class SchemaTypeFinder
implements TypeFinder {
    protected String typeName;
    protected String sysDataspace;
    protected String sysTableName;
    protected String columnName;
    protected String parentColumn;

    public SchemaTypeFinder(String typeName, String sysDataspace, String sysTableName, String columnName, String parentColumn) {
        this.typeName = typeName;
        if (sysDataspace == null) {
            sysDataspace = "SYS";
        }
        this.sysDataspace = sysDataspace;
        this.sysTableName = sysTableName;
        this.columnName = columnName;
        this.parentColumn = parentColumn;
    }

    @Override
    public List<ResultRow> find(Session session, TokenSet query) {
        ArrayList<ResultRow> rs = new ArrayList<ResultRow>();
        Result sqlResult = TypeFinder.executeCompiledStatement(session, this.generateStatement(), this.columnName, query);
        RowSetNavigator rowSet = sqlResult.getNavigator();
        while (rowSet.next()) {
            Object[] currentRow = rowSet.getCurrent();
            if (!this.findFilter(currentRow)) continue;
            rs.add(new ResultRow(this.typeName, (String)currentRow[0], this.parentNameString(session, currentRow)));
        }
        return rs;
    }

    public boolean findFilter(Object[] current) {
        return true;
    }

    private String parentNameString(Session session, Object[] currentRow) {
        if (this.parentColumn == null) {
            return null;
        }
        String dsType = Util.getSchemaType(session, (String)currentRow[1]);
        return (String)(dsType != null ? dsType + "." : "") + String.valueOf(currentRow[1]);
    }

    protected String generateStatement() {
        Object parentColumnNameSql = this.parentColumn != null ? "," + this.parentColumn : "";
        return "SELECT " + this.columnName + (String)parentColumnNameSql + " FROM " + this.sysDataspace + "." + this.sysTableName + " WHERE #LIKE#";
    }
}

