/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.analyze.finder;

import com.streamscape.ds.analyze.Operand;
import com.streamscape.ds.analyze.TokenSet;
import com.streamscape.ds.analyze.finder.TypeFinder;
import com.streamscape.lib.utils.Pair;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public abstract class OtherTypeFinder
implements TypeFinder {
    protected <T> List<Pair<T, String>> filterPairsByLikeExp(List<Pair<T, String>> items, Function<T, String> mapper, TokenSet tokenSet) {
        if (tokenSet.isEmpty()) {
            return items;
        }
        boolean isDefaultAlgo = tokenSet.size() == 1;
        Pattern defaultPattern = Pattern.compile("(?i)" + tokenSet.getTokens().get(0).replace("*", "(.*)"));
        List<String> andTokens = tokenSet.getTokens(Operand.AND);
        List<String> orTokens = tokenSet.getTokens(Operand.OR);
        Predicate<Pair> matcher = item -> {
            String matchString = (String)mapper.apply(item.first);
            if (isDefaultAlgo) {
                return defaultPattern.matcher(matchString).matches();
            }
            return this.containsAll(matchString, andTokens) && this.containsAny(matchString, orTokens);
        };
        return items.stream().filter(matcher).collect(Collectors.toList());
    }

    protected <T> List<T> filterByLikeExp(List<T> items, Function<T, String> mapper, TokenSet tokenSet) {
        List<Pair<T, String>> pairedItems = items.stream().map(item -> new Pair<Object, Object>(item, null)).collect(Collectors.toList());
        return this.filterPairsByLikeExp(pairedItems, mapper, tokenSet).stream().map(p -> p.first).collect(Collectors.toList());
    }

    private boolean containsAll(String inputString, List<String> words) {
        inputString = inputString.toLowerCase();
        for (String word : words) {
            if (inputString.contains(word)) continue;
            return false;
        }
        return true;
    }

    private boolean containsAny(String inputString, List<String> words) {
        inputString = inputString.toLowerCase();
        for (String word : words) {
            if (!inputString.contains(word)) continue;
            return true;
        }
        return false;
    }

    protected List<String> filterByLikeExp(List<String> items, TokenSet tokenSet) {
        return this.filterByLikeExp(items, item -> item, tokenSet);
    }
}

