/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.analyze.finder;

import com.streamscape.ds.analyze.ResultRow;
import com.streamscape.ds.analyze.TokenSet;
import com.streamscape.ds.analyze.finder.OtherTypeFinder;
import com.streamscape.ds.session.Session;
import com.streamscape.repository.types.Prototype;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.mf.admin.DatagramPrototypeCache;
import com.streamscape.sef.dispatcher.AbstractOperation;
import java.util.ArrayList;
import java.util.List;

public class EventPrototypeFinder
extends OtherTypeFinder {
    @Override
    public List<ResultRow> find(Session session, TokenSet query) {
        ArrayList<ResultRow> resultRows = new ArrayList<ResultRow>();
        List<PrototypeRow> filteredList = this.filterByLikeExp(this.listPrototypes(), row -> row.eventId, query);
        for (PrototypeRow row2 : filteredList) {
            resultRows.add(new ResultRow(row2.modelName, row2.eventId, "Event"));
        }
        return resultRows;
    }

    private List<PrototypeRow> listPrototypes() {
        ArrayList<PrototypeRow> rows = new ArrayList<PrototypeRow>();
        DatagramPrototypeCache cache = RuntimeContext.getInstance().getDatagramPrototypeCache();
        List<Prototype> prototypes = cache.getPrototypes();
        prototypes.stream().forEach(prototype -> {
            String eventId = cache.lookupEventId((Prototype)prototype);
            if (AbstractOperation.isUserEvent(eventId)) {
                rows.add(new PrototypeRow(this, eventId, prototype.getModelName()));
            }
        });
        return rows;
    }

    private class PrototypeRow {
        private String eventId;
        private String modelName;

        public PrototypeRow(EventPrototypeFinder eventPrototypeFinder, String eventId, String modelName) {
            this.eventId = eventId;
            this.modelName = modelName;
        }
    }
}

