/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.analyze.finder;

import com.streamscape.ds.analyze.ResultRow;
import com.streamscape.ds.analyze.TokenSet;
import com.streamscape.ds.analyze.finder.TypeFinder;
import com.streamscape.ds.analyze.finder.Util;
import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.collection.fspace.hadoop.HadoopVirtualTableCollection;
import com.streamscape.ds.session.Session;
import java.util.ArrayList;
import java.util.List;

public class ColumnFinder
implements TypeFinder {
    private String TYPE_NAME = "column";

    private String getStatement() {
        return "SELECT sc.COLUMN_NAME, sc.TABLE_SCHEM, sc.TABLE_NAME, sc.TYPE_NAME FROM SYS.SYSTEM_COLUMNS sc  INNER JOIN SYS.SYSTEM_TABLES st     ON sc.TABLE_NAME = st.TABLE_NAME AND sc.TABLE_SCHEM = st.TABLE_SCHEM WHERE st.TABLE_TYPE = 'TABLE'  AND (#LIKE#)";
    }

    @Override
    public List<ResultRow> find(Session session, TokenSet query) {
        ArrayList<ResultRow> rs = new ArrayList<ResultRow>();
        Result sqlResult = TypeFinder.executeCompiledStatement(session, this.getStatement(), "sc.COLUMN_NAME", query);
        RowSetNavigator rowSet = sqlResult.getNavigator();
        while (rowSet.next()) {
            Object columnTypeAddition;
            Object[] currentRow = rowSet.getCurrent();
            String columnTypeName = (String)currentRow[3];
            Object object = columnTypeAddition = columnTypeName == null ? "" : "(" + columnTypeName + ")";
            if (!this.isUserCollection(session, (String)currentRow[1], (String)currentRow[2])) continue;
            rs.add(new ResultRow(this.TYPE_NAME + (String)columnTypeAddition, (String)currentRow[0], this.parentName(session, currentRow)));
        }
        return rs;
    }

    boolean isUserCollection(Session session, String dsName, String tableName) {
        Collection collection = session.dataspaceStore.schemaManager.findUserCollection(session, tableName, dsName);
        if (collection == null) {
            return false;
        }
        return !(collection instanceof HadoopVirtualTableCollection);
    }

    private String parentName(Session session, Object[] values) {
        if (values == null) {
            return null;
        }
        String dsType = Util.getSchemaType(session, (String)values[1]);
        return (String)(dsType != null ? dsType + "." : "") + String.valueOf(values[1]) + "." + String.valueOf(values[2]);
    }
}

