/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.analyze;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.analyze.Operand;
import com.streamscape.ds.analyze.ResultSet;
import com.streamscape.ds.analyze.TokenSet;
import com.streamscape.ds.analyze.finder.ActorFinder;
import com.streamscape.ds.analyze.finder.ColumnFinder;
import com.streamscape.ds.analyze.finder.CommentFinder;
import com.streamscape.ds.analyze.finder.DataObjectFinder;
import com.streamscape.ds.analyze.finder.DataspaceFinder;
import com.streamscape.ds.analyze.finder.EventPrototypeFinder;
import com.streamscape.ds.analyze.finder.FunctionFinder;
import com.streamscape.ds.analyze.finder.ReplicaFinder;
import com.streamscape.ds.analyze.finder.ReplicationSourceFinder;
import com.streamscape.ds.analyze.finder.SchedulerJobFinder;
import com.streamscape.ds.analyze.finder.SchedulerTaskFinder;
import com.streamscape.ds.analyze.finder.SchedulerTaskListFinder;
import com.streamscape.ds.analyze.finder.ServerFinder;
import com.streamscape.ds.analyze.finder.ServiceFinder;
import com.streamscape.ds.analyze.finder.TableFinder;
import com.streamscape.ds.analyze.finder.TimerFinder;
import com.streamscape.ds.analyze.finder.TriggerFinder;
import com.streamscape.ds.analyze.finder.TypeFinder;
import com.streamscape.ds.analyze.finder.ViewFinder;
import com.streamscape.ds.session.Session;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;

public class SchemaAnalyzer {
    private static List<TypeFinder> finders;

    public ResultSet find(Session session, String searchString) {
        try {
            ResultSet rs = new ResultSet();
            searchString = searchString.replace("%", "");
            TokenSet tokenSet = this.tokenizeSearchString(searchString);
            if (tokenSet.isEmpty()) {
                return rs;
            }
            for (TypeFinder objectType : finders) {
                rs.addRows(objectType.find(session, tokenSet));
            }
            return rs;
        }
        catch (Exception e) {
            Trace.logException(this, e, true);
            throw new DataspaceException("Unable to find entries.");
        }
    }

    private TokenSet tokenizeSearchString(String searchString) {
        TokenSet tokenSet = new TokenSet();
        StringTokenizer tokenizer = new StringTokenizer(searchString);
        ArrayList<String> tokens = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        for (String token : tokens) {
            Operand operand = Operand.OR;
            if (token.startsWith("+")) {
                operand = Operand.AND;
                token = StringUtils.stripStart((String)token, (String)"+");
            }
            tokenSet.add(token, operand);
        }
        return tokenSet;
    }

    static {
        ArrayList<TypeFinder> ent = new ArrayList<TypeFinder>();
        ent.add(new DataspaceFinder());
        ent.add(new TableFinder());
        ent.add(new ViewFinder());
        ent.add(new TriggerFinder());
        ent.add(new ColumnFinder());
        ent.add(new FunctionFinder());
        ent.add(new ServerFinder());
        ent.add(new ReplicaFinder());
        ent.add(new ReplicationSourceFinder());
        ent.add(new TimerFinder());
        ent.add(new SchedulerJobFinder());
        ent.add(new SchedulerTaskListFinder());
        ent.add(new SchedulerTaskFinder());
        ent.add(new ActorFinder());
        ent.add(new DataObjectFinder());
        ent.add(new ServiceFinder());
        ent.add(new EventPrototypeFinder());
        ent.add(new CommentFinder());
        finders = Collections.unmodifiableList(ent);
    }
}

