/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.advisory;

import com.streamscape.sdo.SDOFormatException;
import com.streamscape.sdo.advisory.DataspaceStateAdvisory;
import com.streamscape.sdo.advisory.StateAdvisory;
import com.streamscape.sef.advisories.AdvisoriesFactoryException;
import com.streamscape.sef.advisories.StateAdvisoryDefinition;
import com.streamscape.sef.advisories.StateAdvisoryFactory;
import com.streamscape.sef.dispatcher.AbstractDataspaceComponent;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class DataspaceStateAdvisoriesFactory
implements StateAdvisoryFactory {
    private Hashtable<String, DataspaceStateAdvisory> runtimeStateAdvisoriesTable = new Hashtable();

    public DataspaceStateAdvisoriesFactory(AbstractDataspaceComponent dataspace) {
        List<StateAdvisoryDefinition> advisories = dataspace.getStateAdvisoryDefinitions();
        for (StateAdvisoryDefinition advisoryDefinition : advisories) {
            DataspaceStateAdvisory advisory = new DataspaceStateAdvisory();
            try {
                advisory.init(advisoryDefinition);
                this.runtimeStateAdvisoriesTable.put(advisoryDefinition.getName(), advisory);
            }
            catch (SDOFormatException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @Override
    public StateAdvisory createAdvisory(String advisoryName) throws AdvisoriesFactoryException {
        DataspaceStateAdvisory advisory = this.runtimeStateAdvisoriesTable.get(advisoryName);
        if (advisory != null) {
            return (StateAdvisory)advisory.clone();
        }
        return null;
    }

    public Vector<String> listAdvisoryNames() {
        return new Vector<String>(this.runtimeStateAdvisoriesTable.keySet());
    }
}

