/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds;

import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.schema.collection.fspace.table.JftSeqIdTrackManager;
import com.streamscape.ds.schema.server.SysServersManager;
import com.streamscape.ds.session.Session;

public class SysTablesManager {
    private DataspaceStore store;
    private SysServersManager sysServersManager;
    private JftSeqIdTrackManager jftSqIdTrackManager;

    SysTablesManager(DataspaceStore store) {
        this.store = store;
        this.sysServersManager = new SysServersManager(this);
        this.jftSqIdTrackManager = new JftSeqIdTrackManager(this);
    }

    void initialize() {
        try (Session session = this.createSession();){
            this.sysServersManager.initialize(session);
            this.jftSqIdTrackManager.initialize(session);
        }
    }

    public SysServersManager getSysServersManager() {
        return this.sysServersManager;
    }

    public JftSeqIdTrackManager getJftSeqIdTrackManager() {
        return this.jftSqIdTrackManager;
    }

    Session createSession() {
        AbstractDataspace dataspace = (AbstractDataspace)this.store.schemaManager.findSchema("SDS");
        if (dataspace == null) {
            throw new DataspaceException("SDS schema doesn't exist.");
        }
        return dataspace.createSession();
    }
}

