/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds;

import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.schema.collection.fspace.hadoop.HadoopVirtualTableType;
import com.streamscape.ds.schema.collection.qspace.pqueue.ProcessQueueRecipientsTableManager;
import com.streamscape.ds.schema.collection.qspace.pqueue.ProcessQueueStateTableManager;
import com.streamscape.ds.types.CharacterType;
import com.streamscape.ds.types.Charset;
import com.streamscape.ds.types.DateTimeType;
import com.streamscape.ds.types.NumberType;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.types.UserTypeModifier;
import java.util.ArrayList;
import java.util.List;

public class SqlInvariants {
    public static final String SYSTEM_AUTHORIZATION_NAME = "sysadmin";
    public static final String ADMINS_GROUP_NAME = "Admins";
    public static final String USERS_GROUP_NAME = "Users";
    public static final String GLOBAL_TIMER_GROUP = "DataspaceStore";
    public static final String SYSTEM_SUBQUERY = "SYSTEM_SUBQUERY";
    public static final String SYSTEM_SCHEMA = "SYSTEM_SCHEMA";
    public static final String LOBS_SCHEMA = "SYS_LOBS";
    public static final String FLOBS_SCHEMA = "SYS_FLOBS";
    public static final String DEFINITION_SCHEMA = "DEFINITION_SCHEMA";
    public static final String SYS_SCHEMA = "SYS";
    public static final String SDS_SCHEMA = "SDS";
    public static final String CSPACE_SCHEMA = "CSPACE";
    public static final String SCH_SCHEMA = "SCH";
    public static final String RDS_SCHEMA = "RDS";
    public static final String SYS_USR_DS_PREFIX = "usr$";
    public static final String SYS_QLT_DS_PREFIX = "qlt$";
    public static final String CLASSPATH_NAME = "CLASSPATH";
    public static final String MODULE = "MODULE";
    public static final String DUAL = "DUAL";
    public static final String DUMMY = "DUMMY";
    public static final String IDX = "IDX";
    public static final NameManager.ObjectName SYS_SCHEMA_NAME = NameManager.newSystemObjectName("SYS", 2);
    public static final NameManager.ObjectName SDS_SCHEMA_NAME;
    public static final NameManager.ObjectName SCH_SCHEMA_NAME;
    public static final NameManager.ObjectName RDS_SCHEMA_NAME;
    public static final NameManager.ObjectName SYSTEM_SCHEMA_NAME;
    public static final NameManager.ObjectName LOBS_SCHEMA_NAME;
    public static final NameManager.ObjectName FLOBS_SCHEMA_NAME;
    public static final NameManager.ObjectName SYSTEM_SUBQUERY_NAME;
    public static final NameManager.ObjectName MODULE_NAME;
    public static final NameManager.ObjectName DUAL_TABLE_NAME;
    public static final NameManager.ObjectName DUAL_COLUMN_NAME;
    public static final NameManager.ObjectName SYSTEM_INDEX_NAME;
    public static final List<String> SYSTEM_DATASPACES;
    public static final Charset SQL_TEXT;
    public static final Charset SQL_IDENTIFIER_CHARSET;
    public static final Charset SQL_CHARACTER;
    public static final Charset ASCII_GRAPHIC;
    public static final Charset GRAPHIC_IRV;
    public static final Charset ASCII_FULL;
    public static final Charset ISO8BIT;
    public static final Charset LATIN1;
    public static final Charset UTF32;
    public static final Charset UTF16;
    public static final Charset UTF8;
    public static final Type CARDINAL_NUMBER;
    public static final Type YES_OR_NO;
    public static final Type CHARACTER_DATA;
    public static final Type SQL_IDENTIFIER;
    public static final Type TIME_STAMP;

    public static final void checkSchemaNameNotSystem(String name) {
        if (SqlInvariants.isSystemSchemaName(name)) {
            throw Error.error(5503, name);
        }
    }

    public static final boolean isSystemSchemaName(String name) {
        return DEFINITION_SCHEMA.equals(name) || SYS_SCHEMA.equals(name) || SYSTEM_SCHEMA.equals(name);
    }

    public static final boolean isLobsSchemaName(String name) {
        return LOBS_SCHEMA.equals(name) || FLOBS_SCHEMA.equals(name);
    }

    public static final boolean isRdsSchemaName(String name) {
        return RDS_SCHEMA.equals(name);
    }

    public static final boolean isSdsSchemaName(String name) {
        return SDS_SCHEMA.equals(name);
    }

    public static final boolean isSchemaNameSystem(NameManager.ObjectName name) {
        if (name.schema != null) {
            name = name.schema;
        }
        return SYS_SCHEMA_NAME.equals(name) || SYSTEM_SCHEMA_NAME.equals(name);
    }

    public static boolean isSystemCollection(DataspaceType dataspaceType, String dataspaceName, String collectionName) {
        return SqlInvariants.isSystemCollection(dataspaceType.toString(), dataspaceName, collectionName);
    }

    public static boolean isSystemCollection(String dataspaceType, String dataspaceName, String collectionName) {
        return dataspaceType.equals("QSPACE") ? collectionName.equals(ProcessQueueStateTableManager.TABLE_NAME) || collectionName.equals(ProcessQueueRecipientsTableManager.TABLE_NAME) : dataspaceType.equals("FSPACE") && (collectionName.equals(HadoopVirtualTableType.HADOOP_APPLICATIONS.getName()) || collectionName.equals(HadoopVirtualTableType.HADOOP_CLUSTER_METRICS.getName()));
    }

    public static boolean isSystemUserDataspace(String name) {
        return name.startsWith(SYS_USR_DS_PREFIX);
    }

    public static boolean isSystemQuiltDataspace(String name) {
        return name.startsWith(SYS_QLT_DS_PREFIX);
    }

    static {
        SYS_SCHEMA_NAME.setId(0);
        SDS_SCHEMA_NAME = NameManager.newSystemObjectName(SDS_SCHEMA, 2);
        SDS_SCHEMA_NAME.setId(1);
        SCH_SCHEMA_NAME = NameManager.newSystemObjectName(SCH_SCHEMA, 2);
        SCH_SCHEMA_NAME.setId(6);
        RDS_SCHEMA_NAME = NameManager.newSystemObjectName(RDS_SCHEMA, 2);
        RDS_SCHEMA_NAME.setId(2);
        SYSTEM_SCHEMA_NAME = NameManager.newSystemObjectName(SYSTEM_SCHEMA, 2);
        SYSTEM_SCHEMA_NAME.setId(3);
        LOBS_SCHEMA_NAME = NameManager.newSystemObjectName(LOBS_SCHEMA, 2);
        LOBS_SCHEMA_NAME.setId(4);
        FLOBS_SCHEMA_NAME = NameManager.newSystemObjectName(FLOBS_SCHEMA, 2);
        FLOBS_SCHEMA_NAME.setId(5);
        SYSTEM_SUBQUERY_NAME = NameManager.newSystemObjectName(SYSTEM_SUBQUERY, 3);
        MODULE_NAME = NameManager.newSystemObjectName(MODULE, 2);
        DUAL_TABLE_NAME = NameManager.newSystemObjectName(DUAL, 2);
        DUAL_COLUMN_NAME = NameManager.newSystemObjectName(DUMMY, 2);
        SYSTEM_INDEX_NAME = NameManager.newSystemObjectName(IDX, 21);
        SYSTEM_SUBQUERY_NAME.setSchemaIfNull(SYSTEM_SCHEMA_NAME);
        SYSTEM_DATASPACES = new ArrayList<String>();
        SYSTEM_DATASPACES.add(DEFINITION_SCHEMA);
        SYSTEM_DATASPACES.add(SYS_SCHEMA);
        SYSTEM_DATASPACES.add(SYSTEM_SCHEMA);
        SYSTEM_DATASPACES.add(LOBS_SCHEMA);
        SYSTEM_DATASPACES.add(FLOBS_SCHEMA);
        SYSTEM_DATASPACES.add(SDS_SCHEMA);
        SYSTEM_DATASPACES.add(RDS_SCHEMA);
        SYSTEM_DATASPACES.add(SCH_SCHEMA);
        NameManager.ObjectName name = NameManager.newInfoSchemaObjectName("SQL_TEXT", false, 15);
        SQL_TEXT = new Charset(name);
        name = NameManager.newInfoSchemaObjectName("SQL_IDENTIFIER", false, 15);
        SQL_IDENTIFIER_CHARSET = new Charset(name);
        name = NameManager.newInfoSchemaObjectName("SQL_CHARACTER", false, 15);
        SQL_CHARACTER = new Charset(name);
        name = NameManager.newInfoSchemaObjectName("LATIN1", false, 15);
        LATIN1 = new Charset(name);
        name = NameManager.newInfoSchemaObjectName("ASCII_GRAPHIC", false, 15);
        ASCII_GRAPHIC = new Charset(name);
        name = NameManager.newInfoSchemaObjectName("GRAPHIC_IRV", false, 15);
        GRAPHIC_IRV = new Charset(name);
        name = NameManager.newInfoSchemaObjectName("ASCII_FULL", false, 15);
        ASCII_FULL = new Charset(name);
        name = NameManager.newInfoSchemaObjectName("ISO8BIT", false, 15);
        ISO8BIT = new Charset(name);
        name = NameManager.newInfoSchemaObjectName("UTF32", false, 15);
        UTF32 = new Charset(name);
        name = NameManager.newInfoSchemaObjectName("UTF16", false, 15);
        UTF16 = new Charset(name);
        name = NameManager.newInfoSchemaObjectName("UTF8", false, 15);
        UTF8 = new Charset(name);
        name = NameManager.newInfoSchemaObjectName("CARDINAL_NUMBER", false, 14);
        CARDINAL_NUMBER = new NumberType(25, 0L, 0);
        SqlInvariants.CARDINAL_NUMBER.userTypeModifier = new UserTypeModifier(name, 14, CARDINAL_NUMBER);
        name = NameManager.newInfoSchemaObjectName("YES_OR_NO", false, 14);
        YES_OR_NO = new CharacterType(12, 3L);
        SqlInvariants.YES_OR_NO.userTypeModifier = new UserTypeModifier(name, 14, YES_OR_NO);
        name = NameManager.newInfoSchemaObjectName("CHARACTER_DATA", false, 14);
        CHARACTER_DATA = new CharacterType(12, 65536L);
        SqlInvariants.CHARACTER_DATA.userTypeModifier = new UserTypeModifier(name, 14, CHARACTER_DATA);
        name = NameManager.newInfoSchemaObjectName("SQL_IDENTIFIER", false, 14);
        SQL_IDENTIFIER = new CharacterType(12, 128L);
        SqlInvariants.SQL_IDENTIFIER.userTypeModifier = new UserTypeModifier(name, 14, SQL_IDENTIFIER);
        name = NameManager.newInfoSchemaObjectName("TIME_STAMP", false, 14);
        TIME_STAMP = new DateTimeType(93, 93, 6);
        SqlInvariants.TIME_STAMP.userTypeModifier = new UserTypeModifier(name, 14, TIME_STAMP);
    }
}

