/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceWriteMessage;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.io.rowio.RowInputBinary;
import com.streamscape.ds.io.rowio.RowOutputBinary;
import com.streamscape.ds.io.rowio.RowOutputInterface;
import com.streamscape.ds.lib.DataOutputStream;
import com.streamscape.ds.lib.HsqlByteArrayOutputStream;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.session.Session;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.utils.SDOUtils;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class ServerConnection {
    private Session session;
    static final int BUFFER_SIZE = 4096;
    final byte[] mainBuffer = new byte[4096];
    RowOutputInterface rowOut;
    RowInputBinary rowIn;

    public ServerConnection(Session session) {
        this.session = session;
        RowOutputBinary rowOutTemp = new RowOutputBinary(this.mainBuffer);
        this.rowIn = new RowInputBinary(rowOutTemp);
        this.rowOut = rowOutTemp;
    }

    public ImmutableEventDatagram processDataspaceWriteMessage(DataspaceWriteMessage message) throws Exception {
        DataInputStream dataInput = new DataInputStream(new ByteArrayInputStream(message.getBytes()));
        HsqlByteArrayOutputStream memStream = new HsqlByteArrayOutputStream();
        DataOutputStream tempOutput = new DataOutputStream(memStream);
        this.receiveResult(dataInput, tempOutput);
        return SDOUtils.createOpaqueEvent("e.sys.dataspace.write", new DataspaceWriteMessage(memStream.toByteArray()));
    }

    private void receiveResult(DataInputStream dataInput, DataOutputStream dataOutput) throws IOException {
        byte resultMode = dataInput.readByte();
        this.rowOut.reset();
        this.rowIn.resetRow(this.mainBuffer.length);
        Result resultIn = Result.newResult(this.session, resultMode, dataInput, this.rowIn);
        resultIn.readLobResults(this.session, dataInput, this.rowIn);
        this.printRequest(resultIn);
        Result resultOut = null;
        switch (resultIn.getType()) {
            case 31: {
                resultOut = Result.newConnectionAcknowledgeResponse(this.session.getDataspaceStore(), this.session.getId(), this.session.getDataspaceStore().getDatabaseID());
                break;
            }
            case 32: {
                resultOut = Result.updateZeroResult;
                break;
            }
            case 10: {
                this.session.resetSession();
                resultOut = Result.updateZeroResult;
                break;
            }
            case 21: {
                resultOut = Result.newErrorResult(Error.error(1252));
                break;
            }
            default: {
                resultOut = this.session.execute(resultIn);
            }
        }
        resultOut.write(this.session, dataOutput, this.rowOut);
    }

    final void printRequest(Result r) {
        if (!Trace.isDebugEnabled(this.getClass())) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        block0 : switch (r.getType()) {
            case 37: {
                sb.append("SQLCLI:SQLPREPARE ");
                sb.append(r.getMainString());
                break;
            }
            case 34: {
                sb.append(r.getMainString());
                break;
            }
            case 21: 
            case 35: {
                sb.append("SQLCLI:SQLEXECUTE:");
                sb.append(r.getStatementID());
                break;
            }
            case 9: {
                sb.append("SQLCLI:SQLEXECUTE:");
                sb.append("BATCHMODE:");
                sb.append(r.getStatementID());
                break;
            }
            case 41: {
                sb.append("SQLCLI:RESULTUPDATE:");
                sb.append(r.getStatementID());
                break;
            }
            case 36: {
                sb.append("SQLCLI:SQLFREESTMT:");
                sb.append(r.getStatementID());
                break;
            }
            case 7: {
                sb.append("HSQLCLI:GETSESSIONATTR");
                break;
            }
            case 6: {
                sb.append("HSQLCLI:SETSESSIONATTR:");
                break;
            }
            case 33: {
                sb.append("SQLCLI:SQLENDTRAN:");
                switch (r.getActionType()) {
                    case 0: {
                        sb.append("COMMIT");
                        break block0;
                    }
                    case 1: {
                        sb.append("ROLLBACK");
                        break block0;
                    }
                    case 4: {
                        sb.append("SAVEPOINT_NAME_RELEASE ");
                        sb.append(r.getMainString());
                        break block0;
                    }
                    case 2: {
                        sb.append("SAVEPOINT_NAME_ROLLBACK ");
                        sb.append(r.getMainString());
                        break block0;
                    }
                }
                sb.append(r.getActionType());
                break;
            }
            case 39: {
                sb.append("SQLCLI:SQLSTARTTRAN");
                break;
            }
            case 32: {
                sb.append("SQLCLI:SQLDISCONNECT");
                break;
            }
            case 38: {
                sb.append("SQLCLI:SQLSETCONNECTATTR:");
                switch (r.getConnectionAttrType()) {
                    case 10027: {
                        sb.append("SQL_ATTR_SAVEPOINT_NAME ");
                        sb.append(r.getMainString());
                        break block0;
                    }
                }
                sb.append(r.getConnectionAttrType());
                break;
            }
            case 40: {
                sb.append("HQLCLI:CLOSE_RESULT:RESULT_ID ");
                sb.append(r.getResultId());
                break;
            }
            case 13: {
                sb.append("HQLCLI:REQUESTDATA:RESULT_ID ");
                sb.append(r.getResultId());
                sb.append(" ROWOFFSET ");
                sb.append(r.getUpdateCount());
                sb.append(" ROWCOUNT ");
                sb.append(r.getFetchSize());
                break;
            }
            default: {
                sb.append("SQLCLI:MODE:");
                sb.append(r.getType());
            }
        }
        Trace.logDebug(this, sb.toString());
    }
}

