/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds;

import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.SqlInvariants;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.parser.Tokens;
import com.streamscape.ds.rights.Grantee;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;

public final class NameManager {
    public static final String DEFAULT_CATALOG_NAME = "LOCAL";
    private static final NameManager staticManager = new NameManager(null);
    private static final ObjectName[] autoColumnNames = new ObjectName[32];
    private static final String[] autoNoNameColumnNames = new String[32];
    private AtomicInteger serialNumber = new AtomicInteger(1);
    private AtomicInteger sysNumber = new AtomicInteger(10000);
    private ObjectName catalogName = new ObjectName(this, "LOCAL", 1, false);
    private static Pattern nameNoNeedQuoteChars;

    public NameManager(DataspaceStore database) {
    }

    public ObjectName getCatalogName() {
        return this.catalogName;
    }

    public static ObjectName newSystemObjectName(String name, int type) {
        return new ObjectName(staticManager, name, type, false);
    }

    public static ObjectName newInfoSchemaColumnName(String name, ObjectName table) {
        return NameManager.newInfoSchemaColumnName(name, table, false);
    }

    public static ObjectName newInfoSchemaColumnName(String name, ObjectName table, boolean isQuoted) {
        ObjectName hsqlName = new ObjectName(staticManager, name, isQuoted, 10);
        hsqlName.schema = SqlInvariants.SYS_SCHEMA_NAME;
        hsqlName.parent = table;
        return hsqlName;
    }

    public static ObjectName newInfoSchemaTableName(String name) {
        ObjectName hsqlName = new ObjectName(staticManager, name, 3, false);
        hsqlName.schema = SqlInvariants.SYS_SCHEMA_NAME;
        return hsqlName;
    }

    public static ObjectName newInfoSchemaObjectName(String name, boolean isQuoted, int type) {
        ObjectName hsqlName = new ObjectName(staticManager, name, type, isQuoted);
        hsqlName.schema = SqlInvariants.SYS_SCHEMA_NAME;
        return hsqlName;
    }

    public ObjectName newHsqlName(ObjectName schema, String name, int type) {
        ObjectName hsqlName = new ObjectName(this, name, type, false);
        hsqlName.schema = schema;
        return hsqlName;
    }

    public ObjectName newObjectName(String name, boolean isquoted, int type) {
        return new ObjectName(this, name, isquoted, type);
    }

    public ObjectName newHsqlName(ObjectName schema, String name, boolean isquoted, int type) {
        ObjectName hsqlName = new ObjectName(this, name, isquoted, type);
        hsqlName.schema = schema;
        return hsqlName;
    }

    public ObjectName newHsqlName(ObjectName schema, String name, boolean isquoted, int type, ObjectName parent) {
        ObjectName hsqlName = new ObjectName(this, name, isquoted, type);
        hsqlName.schema = schema;
        hsqlName.parent = parent;
        return hsqlName;
    }

    public ObjectName newColumnSchemaHsqlName(ObjectName table, SimpleName name) {
        return this.newColumnHsqlName(table, name.name, name.isNameQuoted);
    }

    public ObjectName newColumnHsqlName(ObjectName table, String name, boolean isquoted) {
        ObjectName hsqlName = new ObjectName(this, name, isquoted, 10);
        hsqlName.schema = table.schema;
        hsqlName.parent = table;
        return hsqlName;
    }

    public ObjectName getSubqueryTableName() {
        ObjectName hsqlName = new ObjectName(this, "SYSTEM_SUBQUERY", false, 3);
        hsqlName.schema = SqlInvariants.SYSTEM_SCHEMA_NAME;
        return hsqlName;
    }

    public ObjectName newAutoName(String prefix, ObjectName schema, ObjectName parent, int type) {
        return this.newAutoName(prefix, null, schema, parent, type);
    }

    public ObjectName newSpecificRoutineName(ObjectName name) {
        ObjectName hsqlName = new ObjectName(this, name.name, 25, name.isNameQuoted);
        hsqlName.parent = name;
        hsqlName.schema = name.schema;
        return hsqlName;
    }

    public static ObjectName getAutoColumnName(int i) {
        if (i < autoColumnNames.length) {
            return autoColumnNames[i];
        }
        return new ObjectName(staticManager, "C_" + (i + 1), 0, false);
    }

    public static String getAutoColumnNameString(int i) {
        if (i < autoColumnNames.length) {
            return NameManager.autoColumnNames[i].name;
        }
        return "C" + (i + 1);
    }

    public static String getAutoNoNameColumnString(int i) {
        if (i < autoColumnNames.length) {
            return autoNoNameColumnNames[i];
        }
        return String.valueOf(i);
    }

    public static String getAutoSavepointNameString(long i, int j) {
        StringBuilder builder = new StringBuilder("S");
        builder.append(i).append('_').append(j);
        return builder.toString();
    }

    public static String escapeNewAutoNamePrefix(String prefix) {
        StringBuilder builder = new StringBuilder();
        builder.append("SYS_");
        prefix = prefix.replace('.', '_');
        prefix = prefix.replace('-', '_');
        prefix = prefix.replace('$', '_');
        builder.append(prefix);
        builder.append('_');
        return builder.toString();
    }

    public ObjectName newAutoName(String prefix, String namepart, ObjectName schema, ObjectName parent, int type) {
        StringBuilder builder = new StringBuilder();
        if (prefix != null) {
            if (prefix.length() != 0) {
                builder.append(NameManager.escapeNewAutoNamePrefix(prefix));
                if (namepart != null) {
                    builder.append(namepart);
                    builder.append('_');
                }
                builder.append(this.sysNumber.incrementAndGet());
            }
        } else {
            builder.append(namepart);
        }
        ObjectName name = new ObjectName(this, builder.toString(), type, false);
        name.schema = schema;
        name.parent = parent;
        return name;
    }

    void resetNumbering() {
        this.sysNumber.set(0);
        this.serialNumber.set(0);
    }

    public static SimpleName getSimpleName(String name, boolean isNameQuoted) {
        return new SimpleName(name, isNameQuoted);
    }

    public static String quoteNameIfNeeded(String name) {
        if (name != null && !name.startsWith("[") && !nameNoNeedQuoteChars.matcher(name).matches()) {
            name = NameManager.quoteName(name);
        }
        return name;
    }

    public static String quoteName(String name) {
        if (name != null && !((String)name).startsWith("[")) {
            name = "[" + (String)name + "]";
        }
        return name;
    }

    public static String quoteNameIfNeededInQuotes(String name) {
        if (name != null && !name.startsWith("\"") && !nameNoNeedQuoteChars.matcher(name).matches()) {
            name = NameManager.quoteNameInQuotes(name);
        }
        return name;
    }

    public static String quoteNameInQuotes(String name) {
        if (name != null && !((String)name).startsWith("\"")) {
            name = "\"" + (String)name + "\"";
        }
        return name;
    }

    public static String unquoteString(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).startsWith("[") && s.endsWith("]") || s.startsWith("\"") && s.endsWith("\"")) {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static String[] splitDataspaceName(String dataspaceFullName) {
        String dataspaceFullNameLowerCase = dataspaceFullName.toLowerCase().trim();
        String type = Arrays.stream(DataspaceType.values()).map(v -> v.name().toLowerCase()).filter(v -> dataspaceFullNameLowerCase.startsWith(v + ".")).findAny().orElse(null);
        if (type != null) {
            return new String[]{type, NameManager.unquoteString(dataspaceFullName.substring(type.length() + 1))};
        }
        return new String[]{NameManager.unquoteString(dataspaceFullName)};
    }

    static {
        NameManager.staticManager.serialNumber.set(Integer.MIN_VALUE);
        for (int i = 0; i < autoColumnNames.length; ++i) {
            NameManager.autoColumnNames[i] = new ObjectName(staticManager, "C" + (i + 1), 0, false);
            NameManager.autoNoNameColumnNames[i] = String.valueOf(i);
        }
        nameNoNeedQuoteChars = Pattern.compile("[a-zA-Z_0-9]*");
    }

    public static final class ObjectName
    extends SimpleName {
        public static ObjectName[] emptyArray = new ObjectName[0];
        transient NameManager manager;
        public String statementName;
        public String comment;
        public ObjectName schema;
        public ObjectName parent;
        public Grantee owner;
        public final int type;
        private final int hashCode;
        private int id = -1;
        static final String[] sysPrefixes = new String[]{"SYS_IDX_", "SYS_PK_", "SYS_REF_", "SYS_CT_", "SYS_FK_"};

        private ObjectName(NameManager manager, int type) {
            this.manager = manager;
            this.type = type;
            this.hashCode = manager.serialNumber.getAndIncrement();
        }

        private ObjectName(NameManager manager, String name, boolean isquoted, int type) {
            this(manager, type);
            this.rename(name, isquoted);
        }

        private ObjectName(NameManager manager, String name, int type, boolean isQuoted) {
            this(manager, type);
            this.name = name;
            this.statementName = name;
            this.isNameQuoted = isQuoted;
            if (this.isNameQuoted) {
                this.statementName = NameManager.quoteName(name);
            }
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        @Override
        public String getStatementName() {
            return this.statementName;
        }

        public String getSchemaQualifiedStatementName() {
            return this.getSchemaQualifiedStatementName(this.schema);
        }

        public String getSchemaQualifiedStatementNameNoSys() {
            Object result = this.getSchemaQualifiedStatementName(this.schema == null || this.schema == SqlInvariants.SYS_SCHEMA_NAME ? null : this.schema);
            if (this.type == 36) {
                result = "[" + (String)result + "]";
            }
            return result;
        }

        public String getSchemaQualifiedStatementName(ObjectName schema) {
            return this.getSchemaQualifiedStatementName(schema != null ? schema.getStatementName() : null);
        }

        public String getSchemaQualifiedStatementName(String schemaName) {
            switch (this.type) {
                case 23: 
                case 24: {
                    return this.getStatementName();
                }
                case 10: {
                    if (this.parent == null || "SYSTEM_SUBQUERY".equals(this.parent.name)) {
                        return this.getStatementName();
                    }
                    StringBuilder builder = new StringBuilder();
                    if (schemaName != null) {
                        builder.append(schemaName);
                        builder.append('.');
                    }
                    builder.append(this.parent.getStatementName());
                    builder.append('.');
                    builder.append(this.getStatementName());
                    return builder.toString();
                }
            }
            if (schemaName == null) {
                return this.getStatementName();
            }
            StringBuilder builder = new StringBuilder();
            if (schemaName != null) {
                builder.append(schemaName);
                builder.append('.');
            }
            builder.append(this.getStatementName());
            return builder.toString();
        }

        public void rename(ObjectName name) {
            this.rename(name.name, name.isNameQuoted);
        }

        public void rename(String name, boolean isquoted) {
            if (name.length() > 128) {
                throw Error.error(5501, name);
            }
            this.name = new String(name);
            this.statementName = name;
            this.isNameQuoted = isquoted;
            if (this.isNameQuoted) {
                this.statementName = NameManager.quoteName(name);
            }
            if (name.startsWith("SYS_")) {
                int length = name.lastIndexOf(95) + 1;
                try {
                    int temp = Integer.parseInt(name.substring(length));
                    if (temp > this.manager.sysNumber.get()) {
                        this.manager.sysNumber.set(temp);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        void rename(String prefix, String name, boolean isquoted) {
            StringBuilder builder = new StringBuilder(prefix);
            builder.append('_');
            builder.append(name);
            this.rename(builder.toString(), isquoted);
        }

        public void setSchemaIfNull(ObjectName schema) {
            if (this.schema == null) {
                this.schema = schema;
            }
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof ObjectName) {
                return this.hashCode == ((ObjectName)other).hashCode;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.hashCode;
        }

        static int sysPrefixLength(String name) {
            for (int i = 0; i < sysPrefixes.length; ++i) {
                if (!name.startsWith(sysPrefixes[i])) continue;
                return sysPrefixes[i].length();
            }
            return 0;
        }

        static boolean isReservedName(String name) {
            return ObjectName.sysPrefixLength(name) > 0;
        }

        public boolean isReservedName() {
            return ObjectName.isReservedName(this.name);
        }

        public String toString() {
            return this.getClass().getName() + super.hashCode() + "[this.hashCode()=" + this.hashCode + ", name=" + this.name + ", name.hashCode()=" + this.name.hashCode() + ", isNameQuoted=" + this.isNameQuoted + "]";
        }

        public int compareTo(Object o) {
            return this.hashCode - o.hashCode();
        }

        static boolean isRegularIdentifier(String name) {
            int length = name.length();
            for (int i = 0; i < length; ++i) {
                char c = name.charAt(i);
                if (c >= 'A' && c <= 'Z' || c == '_' && i > 0 || c >= '0' && c <= '9') continue;
                return false;
            }
            return !Tokens.isKeyword(name);
        }
    }

    public static class SimpleName {
        public String name;
        public boolean isNameQuoted;

        private SimpleName() {
        }

        private SimpleName(String name, boolean isNameQuoted) {
            this.name = name;
            this.isNameQuoted = isNameQuoted;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof SimpleName) {
                return ((SimpleName)other).isNameQuoted == this.isNameQuoted && ((SimpleName)other).name.equals(this.name);
            }
            return false;
        }

        public String getStatementName() {
            return this.isNameQuoted ? NameManager.quoteName(this.name) : this.name;
        }

        public String getNameString() {
            return this.name;
        }
    }
}

