/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.ds.persist.BaseStoreProperties;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.runtime.RuntimeState;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;

public class DataspaceURL {
    public static final String url_connection_type = "connection_type";
    public static final String S_MEM = "mem://";
    public static final String S_FILE = "file://";
    public static final String S_LOCAL = "local:";
    public static final String S_RUNTIME = "runtime:";
    public static final String S_REMOTE = "//";
    public static final String S_URL_PREFIX = "jdbc:streamscape:dataspace:";
    public static final String S_URL_HTTP_PREFIX = "http:streamscape:dataspace:";
    public static final String S_URL_HTTPS_PREFIX = "https:streamscape:dataspace:";
    public static final String S_URL_INTERNAL = "jdbc:default:connection";
    public static final String remote_protocol_type = "remote_protocol_type";
    public static final String PROTO_TLP = "tlp";
    public static final String PROTO_HTTP = "http";
    public static final String PROTO_HTTPS = "https";

    public static boolean isFileBasedDatabaseType(String type) {
        return type.equals(S_FILE);
    }

    public static boolean isInProcessDatabaseType(String type) {
        return type == S_FILE || type == S_MEM || type == S_RUNTIME;
    }

    public static boolean isInProcessDatabaseType(BaseStoreProperties props) {
        return DataspaceURL.isInProcessDatabaseType(props.getProperty(url_connection_type));
    }

    public static BaseStoreProperties parseURL(String url, boolean hasPrefix, boolean noPath) throws SQLException {
        Object database;
        int replacePos;
        int pos = 0;
        String urlImage = ((String)url).toLowerCase(Locale.ENGLISH);
        String runtimeWorkingDir = null;
        BaseStoreProperties props = new BaseStoreProperties();
        BaseStoreProperties extraProps = null;
        String remoteProtocol = PROTO_TLP;
        if (hasPrefix) {
            if (urlImage.startsWith(S_URL_PREFIX)) {
                pos = S_URL_PREFIX.length();
                remoteProtocol = PROTO_TLP;
            } else if (urlImage.startsWith(S_URL_HTTP_PREFIX)) {
                pos = S_URL_HTTP_PREFIX.length();
                remoteProtocol = PROTO_HTTP;
            } else if (urlImage.startsWith(S_URL_HTTPS_PREFIX)) {
                pos = S_URL_HTTPS_PREFIX.length();
                remoteProtocol = PROTO_HTTPS;
            } else {
                return props;
            }
        }
        props.setProperty(remote_protocol_type, remoteProtocol);
        while ((replacePos = ((String)url).indexOf("${")) != -1) {
            int endPos = ((String)url).indexOf("}", replacePos);
            if (endPos == -1) continue;
            String varName = ((String)url).substring(replacePos + 2, endPos);
            String varValue = System.getProperty(varName);
            if (varValue != null) {
                url = ((String)url).substring(0, replacePos) + varValue + ((String)url).substring(endPos + 1);
            }
            urlImage = ((String)url).toLowerCase(Locale.ENGLISH);
        }
        props.setProperty("url", (String)url);
        String propertiesDelimiter = ";";
        int semiPos = ((String)url).indexOf(propertiesDelimiter, pos);
        if (semiPos == -1) {
            propertiesDelimiter = "?";
            semiPos = ((String)url).indexOf(propertiesDelimiter, pos);
        }
        if (semiPos == -1) {
            semiPos = ((String)url).length();
        }
        String type = null;
        if (urlImage.startsWith(S_MEM, pos)) {
            type = S_MEM;
            runtimeWorkingDir = ((String)url).substring(pos + S_MEM.length(), semiPos);
        } else if (urlImage.startsWith(S_FILE, pos)) {
            type = S_FILE;
            runtimeWorkingDir = ((String)url).substring(pos + S_FILE.length(), semiPos);
        } else if (urlImage.startsWith(S_LOCAL, pos)) {
            if (!RuntimeState.isActive()) {
                throw new DataspaceException(new RuntimeException("Runtime is not active. Can't use 'local' connection type."), "..", 0);
            }
            runtimeWorkingDir = (String)DataspaceStoreManager.getRuntimeContext().getEnvironment().get("streamscape.runtime.startup.dir");
            if (runtimeWorkingDir.equals(".")) {
                runtimeWorkingDir = System.getProperty("user.dir");
            }
            if (urlImage.startsWith(S_FILE, pos + S_LOCAL.length())) {
                type = S_FILE;
            } else if (urlImage.startsWith(S_MEM, pos + S_LOCAL.length())) {
                type = S_MEM;
            }
        } else if (urlImage.startsWith(S_REMOTE, pos)) {
            type = S_REMOTE;
        } else if (urlImage.startsWith(S_RUNTIME, pos)) {
            type = S_RUNTIME;
        }
        if (type == null) {
            type = S_FILE;
        } else {
            pos += type.length();
        }
        props.setProperty(url_connection_type, type);
        if (type == S_REMOTE) {
            String pathSeg = null;
            String path = null;
            int endPos = ((String)url).indexOf(47, pos);
            if (endPos > 0 && endPos < semiPos) {
                pathSeg = ((String)url).substring(endPos, semiPos);
            } else {
                endPos = semiPos;
            }
            String urls = ((String)url).substring(pos, endPos);
            DataspaceURL.validateUrls(urls);
            if (noPath) {
                path = "";
                database = pathSeg;
            } else if (pathSeg == null) {
                path = "/";
                database = "";
            } else {
                int lastSlashPos = pathSeg.lastIndexOf(47);
                if (lastSlashPos < 1) {
                    path = "/";
                    database = pathSeg.substring(1);
                } else {
                    path = pathSeg.substring(0, lastSlashPos);
                    database = pathSeg.substring(lastSlashPos + 1);
                }
            }
            if (((String)database).length() == 0) {
                throw new SQLException("Dataspace is not specified.");
            }
            props.setProperty("urls", urls);
            props.setProperty("path", path);
            props.setProperty("dataspace", (String)database);
        } else {
            props.setProperty("runtimeWorkingDir", runtimeWorkingDir);
            database = runtimeWorkingDir + "/.dscache/dtspace";
            if (((String)database).startsWith("~")) {
                String userHome = System.getProperty("user.home");
                database = userHome + ((String)database).substring(1);
            }
        }
        if (semiPos < ((String)url).length()) {
            String arguments = ((String)url).substring(semiPos + 1, urlImage.length());
            extraProps = BaseStoreProperties.delimitedArgPairsToProps(arguments, "=", propertiesDelimiter, null);
            props.addProperties(extraProps);
        }
        if (((String)database).length() == 0) {
            throw new SQLException("Dataspace is not specified.");
        }
        props.setProperty("database", (String)database);
        return props;
    }

    public static List<String> validateUrls(String urls) throws SQLException {
        List<String> urlList = StringUtils.split(urls.trim(), '&');
        if (urlList.isEmpty()) {
            throw new SQLException("Invalid url[s] specified: " + urls);
        }
        for (String url : urlList) {
            url = url.trim();
            int portPos = -1;
            if (url.charAt(0) == '[') {
                portPos = url.indexOf(93, 1);
                if (portPos < 0) {
                    throw new SQLException("Invalid IPv6 address specified in url " + url);
                }
                ++portPos;
            } else {
                portPos = url.indexOf(58);
                if (portPos < -1) {
                    throw new SQLException("Invalid IPv4 address specified in url " + url);
                }
                ++portPos;
            }
            try {
                Integer.parseInt(url.substring(portPos));
            }
            catch (NumberFormatException e) {
                throw new SQLException("Invalid port number specified in url " + url);
            }
        }
        return urlList;
    }
}

