/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds;

import com.streamscape.cli.ClientContext;
import com.streamscape.cli.ClientState;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.lib.HsqlTimer;
import com.streamscape.ds.persist.BaseStoreProperties;
import com.streamscape.ds.session.Session;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.mf.admin.FabricContext;
import com.streamscape.sef.security.User;
import java.util.TimeZone;

public class DataspaceStoreManager {
    private static RuntimeContext runtimeCtx = null;
    private static DataspaceStore db = null;
    private static final HsqlTimer timer = new HsqlTimer();

    public static synchronized void setRuntimeContext(RuntimeContext ctx) {
        runtimeCtx = ctx;
    }

    public static synchronized RuntimeContext getRuntimeContext() {
        return runtimeCtx;
    }

    public static synchronized FabricContext getContext() {
        if (runtimeCtx == null && ClientState.isActive()) {
            return ClientContext.getInstance();
        }
        return runtimeCtx;
    }

    public static synchronized Session newSession(String type, String path, String user, String password, BaseStoreProperties props, TimeZone timeZone) {
        DataspaceStore db = DataspaceStoreManager.getDatabaseObject(type, path, props);
        if (db == null) {
            return null;
        }
        return db.connect(user, password, timeZone);
    }

    public static synchronized Session newSession(String type, String path, User user, BaseStoreProperties props) {
        DataspaceStore db = DataspaceStoreManager.getDatabaseObject(type, path, props);
        if (db == null) {
            return null;
        }
        return db.connect(user);
    }

    public static synchronized DataspaceStore getDatabaseStore() {
        return db;
    }

    public static synchronized Session getSession(int dbId, long sessionId) {
        return db == null ? null : DataspaceStoreManager.db.collectionSessionManager.getSession(sessionId);
    }

    private static synchronized DataspaceStore getDatabaseObject(String type, String path, BaseStoreProperties props) {
        if (db == null) {
            db = new DataspaceStore(type, path, props);
            DataspaceStoreManager.db.storeID = 1;
        }
        return db;
    }

    public static synchronized void registerDataspaceStore(DataspaceStore store) {
        String key = store.getPath();
        store.storeID = 1;
        db = store;
    }

    public static HsqlTimer getTimer() {
        return timer;
    }
}

