/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds;

import com.streamscape.Trace;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.CheckpointManager;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceLogger;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.SqlInvariants;
import com.streamscape.ds.SysTablesManager;
import com.streamscape.ds.Version;
import com.streamscape.ds.core.DataspaceStoreState;
import com.streamscape.ds.future.FutureFunctionManager;
import com.streamscape.ds.info.SysSchema;
import com.streamscape.ds.jdbc.JDBCConnection;
import com.streamscape.ds.jdbc.JDBCDriver;
import com.streamscape.ds.lib.DataspaceDateTime;
import com.streamscape.ds.lib.FileUtil;
import com.streamscape.ds.lib.HashMappedList;
import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.navigator.RowSetNavigatorClient;
import com.streamscape.ds.parser.expression.DataspaceQueryMemoryMonitor;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.persist.BaseStoreProperties;
import com.streamscape.ds.persist.DataspaceStoreProperties;
import com.streamscape.ds.persist.FlobManager;
import com.streamscape.ds.persist.LobManager;
import com.streamscape.ds.persist.LobValidator;
import com.streamscape.ds.persist.LogRecordType;
import com.streamscape.ds.persist.Logger;
import com.streamscape.ds.persist.PersistentStoreCollectionDatabase;
import com.streamscape.ds.persist.StoreFilesState;
import com.streamscape.ds.persist.fulltext.FullTextManager;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.rights.GranteeManager;
import com.streamscape.ds.rights.UserManager;
import com.streamscape.ds.rights.UserWrapper;
import com.streamscape.ds.schema.DataspaceSchema;
import com.streamscape.ds.schema.SchemaManager;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.SyntaxStore;
import com.streamscape.ds.schema.collection.AbstractCollection;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.collection.fspace.table.FileTableCollection;
import com.streamscape.ds.schema.collection.tspace.table.TableCollection;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.procedure.FunctionCustom;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.DataspaceSessionInfo;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.session.SessionManager;
import com.streamscape.ds.state.DataspaceStateHolder;
import com.streamscape.ds.transaction.TransactionManager;
import com.streamscape.ds.transaction.TransactionManagerMVCC;
import com.streamscape.ds.types.Collation;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.ConfigurationState;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.obj.ObjectConfigurationException;
import com.streamscape.sdo.SystemDataObject;
import com.streamscape.sdo.utils.EventPrototypeComparator;
import com.streamscape.sef.EventTriggerState;
import com.streamscape.sef.dataspace.DataspaceComponent;
import com.streamscape.sef.dataspace.DataspaceManagerException;
import com.streamscape.sef.dataspace.Store;
import com.streamscape.sef.dispatcher.AbstractRuntimeFactory;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.security.SecurityContext;
import com.streamscape.sef.security.User;
import com.streamscape.sef.utils.RepositoryUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.CountDownLatch;

public class DataspaceStore
extends AbstractRuntimeFactory
implements Store,
SystemDataObject {
    public static final String SINK_EVENTS_TABLE = "SINK_EVENTS";
    public static final String ADVISORIES_TABLE = "ADVISORIES";
    public static final String EXCEPTIONS_TABLE = "EXCEPTIONS";
    public static final String ACTIONABLE_EVENTS_TABLE = "ACTIONABLE_EVENTS";
    public static final String ACTIONABLE_GROUPS_TABLE = "ACTIONABLE_GROUPS";
    public static final String SYSLDEF_TABLE = "SYSLDEF";
    public static final String UNREFERENCED_LOBS_TABLE = "UNREFERENCED_LOBS";
    public static final String RECOVERY_LOG = "RECOVERY_LOG";
    public static final String REPLICATION_SOURCES_TABLE = "REPLICATION_SOURCES";
    public static final String SOURCE_REPLICAS_TABLE = "SOURCE_REPLICAS";
    public static final String REPLICAS_TABLE = "REPLICAS";
    public static final String ROOT_DIRECTORY = ".dscache";
    public static final String DATASPACE_STORE_NAME = "dtspace";
    public transient DataspaceStoreState storeState = DataspaceStoreState.SHUTDOWN;
    private StoreFilesState storeFilesState = StoreFilesState.NOT_MODIFIED_NEW;
    private transient long lastCheckTime = 0L;
    protected long serialVersionUID = 7961930000302040L;
    protected Date timestamp = new Date(System.currentTimeMillis());
    int storeID;
    String storeUniqueName;
    String storeType;
    private transient String canonicalPath;
    transient BaseStoreProperties urlProperties;
    private transient String path;
    public transient Collation collation;
    transient boolean storeReadOnly;
    private transient boolean filesReadOnly;
    private transient boolean filesInJar;
    private transient TimeZone timezone;
    private transient Charset ccsid;
    public transient boolean sqlEnforceTypes = false;
    public transient boolean sqlEnforceRefs = false;
    public transient boolean sqlEnforceSize = true;
    public transient boolean sqlEnforceNames = false;
    public transient boolean sqlEnforceTDCD = true;
    public transient boolean sqlEnforceTDCU = true;
    public transient boolean sqlTranslateTTI = true;
    public transient boolean sqlConcatNulls = true;
    public transient boolean sqlUniqueNulls = true;
    public transient boolean sqlNullsFirst = true;
    public transient boolean sqlConvertTruncate = true;
    public transient int sqlAvgScale = 0;
    public transient boolean sqlDoubleNaN = true;
    public transient boolean sqlLongvarIsLob = false;
    public transient int sqlDefaultStringPrecision = Integer.MAX_VALUE;
    private transient boolean isReferentialIntegrity = true;
    public transient DataspaceStoreProperties dataspaceStoreProperties;
    public Properties properties;
    transient int resultMaxMemoryRows;
    public transient int defaultIsolationLevel = 2;
    public transient boolean txConflictRollback = true;
    public transient long txConflictSpinLockTimeout = 0L;
    public transient String dataspaceLocation;
    private String vendorString = "StreamScape Dataspace Store " + Version.getMajorVersion() + "." + Version.getMajorVersion() + " b" + Version.getBuild() + ".";
    public transient SysSchema dsInfo;
    public transient UserManager userManager;
    public transient GranteeManager granteeManager;
    public transient NameManager nameManager;
    protected transient String url;
    private transient String fileSeparator;
    public transient SchemaManager schemaManager;
    public transient PersistentStoreCollectionDatabase persistentStoreCollection;
    public transient LobManager lobManager;
    public transient FlobManager flobManager;
    public transient CheckpointManager checkpointManager;
    public transient Logger dataspaceLogger;
    public transient SessionManager collectionSessionManager;
    public transient TransactionManager txManager;
    public transient FutureFunctionManager futureFunctionManager = null;
    transient Statement existsActionableEventStat;
    transient Statement existsActionableEventGroupStat;
    transient Statement hasActionableEventGroupsStat;
    transient Statement listActionableEventGroupsStat;
    transient Statement listActionableEventsStat;
    transient Statement hasAdvisoriesStat;
    private transient SysTablesManager sysTablesManager;
    public transient boolean generateLogIndex = false;
    private transient DataspaceLogger defaultLogger = null;
    public transient DataspaceQueryMemoryMonitor queryMemoryMonitor;
    private transient FullTextManager fullTextManager;
    public static boolean sysldefHasTimestamps = true;
    public transient Map<Integer, DDLRecordNode> logIndexBuilder = null;

    protected DataspaceStore() {
        this.storeType = "file://";
        this.urlProperties = new BaseStoreProperties();
        this.storeState = DataspaceStoreState.SHUTDOWN;
        this.properties = DataspaceStoreProperties.getDefaults();
    }

    DataspaceStore(String type, String path, BaseStoreProperties props) {
        this.url = "jdbc:streamscape:dataspace:local:file//;";
        this.storeState = DataspaceStoreState.SHUTDOWN;
        this.storeType = type;
        this.path = path;
        try {
            this.canonicalPath = FileUtil.getFileUtil().canonicalPath(path);
        }
        catch (IOException error) {
            this.canonicalPath = path;
        }
        this.urlProperties = props;
    }

    protected void init(RuntimeContext context) throws DataspaceManagerException {
        Trace.logInfo(this, "Default dataspace provider initializing...");
        DataspaceStoreManager.setRuntimeContext(context);
        EventPrototypeComparator.setRuntimeContext(context);
        try {
            this.setStoreState(DataspaceStoreState.SHUTDOWN);
            this.fileSeparator = System.getProperty("file.separator");
            this.url = "jdbc:streamscape:dataspace:local:file//;catalog=dtspace";
            String startupDir = (String)context.getEnvironment().get("streamscape.runtime.startup.dir");
            if (startupDir == null || startupDir.equals(".") || startupDir.length() == 0) {
                startupDir = System.getProperty("user.dir");
            }
            this.dataspaceLocation = startupDir + this.fileSeparator + ROOT_DIRECTORY;
            if (!FileIOUtils.fileAvailable(this.dataspaceLocation)) {
                FileIOUtils.newFileDir(this.dataspaceLocation);
            }
            this.path = this.dataspaceLocation + this.fileSeparator + DATASPACE_STORE_NAME;
            try {
                this.canonicalPath = FileUtil.getFileUtil().canonicalPath(this.path);
            }
            catch (IOException error) {
                this.canonicalPath = this.path;
            }
            this.urlProperties = new BaseStoreProperties();
            System.out.println("\n\t" + Version.getVendorString() + "\n");
            Trace.logInfo(this, "Default dataspace provider initialized.");
        }
        catch (UtilitiesException error) {
            throw new DataspaceManagerException(2002, "Initialization of dataspace provider failed.", error);
        }
        DataspaceStoreManager.registerDataspaceStore(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create() {
        this.dataspaceLogger = new Logger(this);
        this.lobManager = new LobManager(this);
        this.flobManager = new FlobManager(this);
        this.sysTablesManager = new SysTablesManager(this);
        this.futureFunctionManager = new FutureFunctionManager();
        this.fullTextManager = new FullTextManager(this);
        DataspaceStoreProperties p = new DataspaceStoreProperties(this);
        String timezoneProperty = p.getStringProperty("dtspace.timezone");
        if (timezoneProperty == null) {
            timezoneProperty = DataspaceStoreProperties.getDefaultTimezone();
        }
        if ("default".equalsIgnoreCase(timezoneProperty)) {
            timezoneProperty = DataspaceStoreProperties.getDefaultTimezone();
        }
        this.timezone = TimeZone.getTimeZone(timezoneProperty);
        if (!this.timezone.getID().equals(timezoneProperty)) {
            this.timezone = TimeZone.getDefault();
            Trace.logError(this, "WARNING: Invalid timezone ID '" + timezoneProperty + "'. Set timezone to default '" + this.timezone.getID() + "'.");
        }
        DataspaceDateTime.setTimezone(this.timezone);
        p = new DataspaceStoreProperties(this);
        String ccsidProperty = p.getStringProperty("file.ccsid");
        if (ccsidProperty == null) {
            ccsidProperty = DataspaceStoreProperties.getDefaultCCSID();
        }
        try {
            this.ccsid = Charset.forName(ccsidProperty);
        }
        catch (Exception exception) {
            throw new DataspaceException("Invalid charset '" + ccsidProperty + "' for dataspace property 'file.ccsid' is specifed.");
        }
        if (this.isShutdown()) {
            this.reopen();
        }
        Session tempSession = null;
        try {
            DataspaceSchema[] schemas;
            tempSession = this.getSessionManager().newSysSession();
            this.checkSystemTables();
            this.checkSystemFunctions();
            this.initializeSystemSqlStatements();
            for (DataspaceSchema dataspace : schemas = this.schemaManager.getAllSchemas()) {
                if (!dataspace.getName().equals("SDS")) continue;
                dataspace.open(tempSession);
            }
            for (DataspaceSchema dataspace : schemas) {
                if (!dataspace.getName().equals("SCH")) continue;
                dataspace.open(tempSession);
            }
        }
        finally {
            if (tempSession != null) {
                tempSession.commit(false);
                tempSession.close();
                tempSession = null;
            }
        }
        DataspaceSchema sysDataspace = this.schemaManager.findSchema("SYS");
        if (sysDataspace == null) {
            throw new IllegalStateException("Unable to resolve system schema.");
        }
        this.futureFunctionManager.init(this, sysDataspace);
        this.granteeManager.open();
        this.storeFilesState = StoreFilesState.MODIFIED;
        this.persistStoreState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        Session tempSession = null;
        try {
            DataspaceSchema[] schemas;
            tempSession = this.getSessionManager().newSysSession();
            for (DataspaceSchema dataspace : schemas = this.schemaManager.getAllSchemas()) {
                if (dataspace.getName().equals("SDS") || dataspace.getName().equals("SCH")) continue;
                if (dataspace.isOnline()) {
                    Trace.logDebug(this, "Opening dataspace '" + dataspace.getFullName() + "'...");
                    this.setInitProperty("Dataspace Opening", dataspace.getFullName());
                    dataspace.open(tempSession);
                    Trace.logDebug(this, "Dataspace '" + dataspace.getFullName() + "' opened.");
                    continue;
                }
                Trace.logInfo(this, "Dataspace '" + dataspace.getFullName() + "' is not online.");
                if (dataspace.isStarted()) continue;
                Trace.logInfo(this, "Dataspace '" + dataspace.getFullName() + "' is not started.");
                dataspace.destroy(tempSession);
            }
            this.futureFunctionManager.open();
        }
        finally {
            if (tempSession != null) {
                tempSession.commit(false);
                tempSession.close();
                tempSession = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.getStoreState() != DataspaceStoreState.SHUTDOWN) {
            Session tempSession = null;
            try {
                DataspaceSchema[] schemas;
                tempSession = this.getSessionManager().newSysSession();
                this.fullTextManager.closeAll();
                for (DataspaceSchema dataspace : schemas = this.schemaManager.getAllSchemas()) {
                    dataspace.persist(tempSession);
                    dataspace.close(tempSession);
                }
            }
            finally {
                if (tempSession != null) {
                    tempSession.commit(false);
                    tempSession.close();
                    tempSession = null;
                }
            }
            this.futureFunctionManager.close();
            this.granteeManager.close();
            this.closeInternal();
            DataspaceDateTime.setTimezone(null);
            FunctionCustom.unloadSerializers();
            OtherTypeWrapper.unloadSerializer();
        }
    }

    @Override
    public long getSerialVersionUID() {
        return this.serialVersionUID;
    }

    @Override
    public Date getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void touch() {
        this.timestamp = new Date(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkSystemFunctions() throws DataspaceException {
        String ddxUserName = DataspaceStore.getContext().getDeploymentDescriptor().getSecurityPrincipal();
        User user = null;
        try {
            user = DataspaceStore.getContext().getSecurityManager().lookupUser(ddxUserName);
        }
        catch (Exception error) {
            error.printStackTrace();
        }
        try (Session session = this.createSession(user);){
            Result result;
            session.setDataspace("SDS");
            if (this.schemaManager.findSchemaObject("wb_DataspaceCollections", "SDS", 17) == null ? (result = session.executeDirectStatement("create function wb_DataspaceCollections(string nodeName, string dsType, string dsName) returns map\nas\n{\n   map result = new map();\n\n   Dataspace ds = sys.lookup(nodeName + '://' + dsType + '.' + dsName);\n\n   RowSet rs = ds.executeQuery('list collections');\n   rs.beforeFirst();\n   while(rs.next())\n   {\n      string type = rs.getString('Type');\n      string name = rs.getString('Name');\n      map typesMap = (map)result.get(type);\n      if(typesMap == null)\n      {\n         typesMap = new map();\n         result.put(type, typesMap);\n      }\n\n      map collectionMap = typesMap.get(name);\n      if(collectionMap == null)\n      {\n         collectionMap = new map();\n         typesMap.put(name, collectionMap);\n      }\n\n      RowSet describeRS = ds.executeQuery('describe collection [' + name + ']');\n      RowSet tuplesRS = ds.executeQuery('describe collection [' + name + '] tuples');\n      collectionMap.put('PROPERTIES', describeRS);\n      collectionMap.put('TUPLES', tuplesRS);\n   }\n\n   return result;\n}")).isError() : (result = session.executeDirectStatement("alter function wb_DataspaceCollections\nas\n{\n   map result = new map();\n\n   Dataspace ds = sys.lookup(nodeName + '://' + dsType + '.' + dsName);\n\n   RowSet rs = ds.executeQuery('list collections');\n   rs.beforeFirst();\n   while(rs.next())\n   {\n      string type = rs.getString('Type');\n      string name = rs.getString('Name');\n      map typesMap = (map)result.get(type);\n      if(typesMap == null)\n      {\n         typesMap = new map();\n         result.put(type, typesMap);\n      }\n\n      map collectionMap = typesMap.get(name);\n      if(collectionMap == null)\n      {\n         collectionMap = new map();\n         typesMap.put(name, collectionMap);\n      }\n\n      RowSet describeRS = ds.executeQuery('describe collection [' + name + ']');\n      RowSet tuplesRS = ds.executeQuery('describe collection [' + name + '] tuples');\n      collectionMap.put('PROPERTIES', describeRS);\n      collectionMap.put('TUPLES', tuplesRS);\n   }\n\n   return result;\n}")).isError()) {
                throw new DataspaceException(result);
            }
            if (this.schemaManager.findSchemaObject("wb_TaskListFlow", "SDS", 17) == null && (result = session.executeDirectStatement("create function wb_TaskListFlow(string nodeName, string taskListName) returns map\nas\n{\n   map result = new map();\n   \n   Runtime rt = sys.lookup(nodeName);\n\n   RowSet taskListRowSet = rt.query('describe tasklist ' + taskListName + ' metadata').getRowSet();\n   result.put('TASKLISTMETADATA', taskListRowSet);\n\n   map tasks = new map();\n   result.put('TASKS', tasks);\n\n   RowSet tasksRowSet = rt.query('describe tasklist ' + taskListName + ' tasks').getRowSet();\n   tasksRowSet.beforeFirst();\n   while(tasksRowSet.next())\n   {\n      string taskName = tasksRowSet.getString('Name');\n      RowSet taskRowSet = rt.query('describe task ' + taskListName + '.' + taskName).getRowSet();\n      tasks.put(taskName, taskRowSet);\n   }\n\n   return result;\n}")).isError()) {
                throw new DataspaceException(result);
            }
            if (this.schemaManager.findSchemaObject("wb_FunctionUnits", "SDS", 17) == null && (result = session.executeDirectStatement("create function wb_FunctionUnits(string nodeName) returns list\nas\n{\n   list result = new list();\n\n   Runtime rt = sys.lookup(nodeName);\n\n   RowSet rs = rt.query('list functions lib').getRowSet();;\n   rs.beforeFirst();\n   while(rs.next())\n   {\n      string groupName = rs.getString(1);\n      string functionsNamesStr = rs.getString(2);\n      string[] functionsNames = functionsNamesStr.split('\\n');\n      for(string functionName: functionsNames)\n      {\n         map functionMap = new map();\n\n         RowSet rsSignature = rt.query('describe function lib ' + groupName + '.' + functionName).getRowSet();\n         string signature = '';\n         if(rsSignature.getRowAt(1).getColumn(1) != null)\n         {\n            signature = rsSignature.getRowAt(1).getColumn(1).toString();\n         }\n\n         RowSet rsDoc = rt.query('describe function lib ' + groupName + '.' + functionName + ' doc').getRowSet();\n         string doc = '';\n         if(rsDoc.getRowAt(1).getColumn(1) != null)\n         {\n            doc = rsDoc.getRowAt(1).getColumn(1).toString();\n         }\n\n         RowSet rsHelp = rt.query('describe function lib ' + groupName + '.' + functionName + ' help').getRowSet();\n         string fuhelp = '';\n         if(rsHelp.getRowAt(1).getColumn(1) != null)\n         {\n            fuhelp = rsHelp.getRowAt(1).getColumn(1).toString();\n         }\n\n         functionMap.put('groupName', groupName);\n         functionMap.put('functionName', functionName);\n         functionMap.put('signature', signature);\n         functionMap.put('doc', doc);\n         functionMap.put('help', fuhelp);\n\n         result.add(functionMap);\n      }\n   }\n\n   return result;\n}")).isError()) {
                throw new DataspaceException(result);
            }
        }
    }

    protected void checkSystemTables() throws DataspaceException {
        Session session;
        block24: {
            FileTableCollection recoveryErrors;
            Result result;
            String ddxUserName = DataspaceStore.getContext().getDeploymentDescriptor().getSecurityPrincipal();
            User user = null;
            try {
                user = DataspaceStore.getContext().getSecurityManager().lookupUser(ddxUserName);
            }
            catch (Exception error) {
                error.printStackTrace();
            }
            session = this.createSession(user);
            session.setDataspace("SDS");
            if (this.schemaManager.findSchemaObject(SINK_EVENTS_TABLE, "SDS", 4) == null && (result = session.executeDirectStatement("create persistent table SINK_EVENTS(DATASPACE        varchar(255), NAME             varchar(100) PRIMARY KEY, REQUEST_EVENT_ID  varchar(100), RESPONSE_EVENT_ID varchar(100), CACHE_MODEL      varchar(30))")).isError()) {
                throw new DataspaceException(result);
            }
            if (this.schemaManager.findSchemaObject(ACTIONABLE_EVENTS_TABLE, "SDS", 4) == null && (result = session.executeDirectStatement("create persistent table ACTIONABLE_EVENTS(DATASPACE          varchar(255), EVENT_ID            varchar(1024), PROTOTYPE_MODEL    varchar(1024), PROTOTYPE_INSTANCE varchar(1024))")).isError()) {
                throw new DataspaceException(result);
            }
            if (this.schemaManager.findSchemaObject(ADVISORIES_TABLE, "SDS", 4) == null && (result = session.executeDirectStatement("create persistent table ADVISORIES(DATASPACE          varchar(255), ADVISORY_NAME      varchar(1024), PROTOTYPE_MODEL    varchar(1024), PROTOTYPE_INSTANCE varchar(1024))")).isError()) {
                throw new DataspaceException(result);
            }
            if (this.schemaManager.findSchemaObject(EXCEPTIONS_TABLE, "SDS", 4) == null && (result = session.executeDirectStatement("create persistent table EXCEPTIONS(DATASPACE          varchar(255), EVENT_ID            varchar(1024), PROTOTYPE_MODEL    varchar(1024), PROTOTYPE_INSTANCE varchar(1024))")).isError()) {
                throw new DataspaceException(result);
            }
            if (this.schemaManager.findSchemaObject(ACTIONABLE_GROUPS_TABLE, "SDS", 4) == null && (result = session.executeDirectStatement("create persistent table ACTIONABLE_GROUPS(DATASPACE  varchar(255), GROUP_NAME varchar(1024))")).isError()) {
                throw new DataspaceException(result);
            }
            if (this.schemaManager.findSchemaObject(SYSLDEF_TABLE, "SDS", 4) == null) {
                result = session.executeDirectStatement("create persistent table SYSLDEF(COMPONENT_TYPE  varchar(255), COMPONENT_NAME varchar(1024),ENTITY_TYPE  varchar(255), ENTITY_NAME varchar(1024),DEFINITION string, CREATED sqltimestamp, MODIFIED sqltimestamp, PRIMARY KEY(COMPONENT_TYPE, COMPONENT_NAME, ENTITY_TYPE, ENTITY_NAME))");
                if (result.isError()) {
                    throw new DataspaceException(result);
                }
            } else {
                TableCollection collection = (TableCollection)this.schemaManager.findSchemaObject(SYSLDEF_TABLE, "SDS", 4);
                if (collection.getBaseTable().getColumn("CREATED") == null) {
                    SyntaxStore.unload();
                    SyntaxStore.setDataspaceStore(this);
                    result = session.executeDirectStatement("alter collection SYSLDEF add CREATED sqltimestamp default null");
                    if (result.isError()) {
                        Trace.logError(this, "FAILED TO ADD COLUMN CREATED TO SYSLDEF TABLE.");
                        Trace.logException(this, new DataspaceException(result), true);
                        sysldefHasTimestamps = false;
                    } else if (collection.getBaseTable().getColumn("MODIFIED") == null && (result = session.executeDirectStatement("alter collection SYSLDEF add MODIFIED sqltimestamp default null")).isError()) {
                        Trace.logError(this, "FAILED TO ADD COLUMN MODIFIED TO SYSLDEF TABLE.");
                        Trace.logException(this, new DataspaceException(result), true);
                        sysldefHasTimestamps = false;
                    }
                }
            }
            session.setDataspace("RDS");
            ColumnDef[] repSourceTableCols = new ColumnDef[]{new ColumnDef(this, "DATASPACE_TYPE", "STRING"), new ColumnDef(this, "DATASPACE_NAME", "STRING", true), new ColumnDef(this, "NAME", "STRING", true), new ColumnDef(this, "VERSION", "INTEGER"), new ColumnDef(this, "REPLICATION_ID", "LONG")};
            this.checkReplicationMetadataTable(session, REPLICATION_SOURCES_TABLE, repSourceTableCols);
            ColumnDef[] sourceReplicasTableCols = new ColumnDef[]{new ColumnDef(this, "SOURCE_DATASPACE_TYPE", "STRING"), new ColumnDef(this, "SOURCE_DATASPACE_NAME", "STRING", true), new ColumnDef(this, "SOURCE_NAME", "STRING", true), new ColumnDef(this, "REPLICA_NODE", "STRING", true), new ColumnDef(this, "REPLICA_DATASPACE_TYPE", "STRING"), new ColumnDef(this, "REPLICA_DATASPACE_NAME", "STRING", true), new ColumnDef(this, "REPLICA_NAME", "STRING", true), new ColumnDef(this, "STATE", "STRING"), new ColumnDef(this, "REPLICATION_ID", "LONG"), new ColumnDef(this, "LAST_MODIFIED", "SQLTIMESTAMP"), new ColumnDef(this, "PRIMARY_KEY", "INTEGER ARRAY[]")};
            SchemaObject repTable = this.schemaManager.findSchemaObject(SOURCE_REPLICAS_TABLE, "RDS", 4);
            if (repTable != null && ((Collection)repTable).getBaseTable().findColumn("PRIMARY_KEY") == -1 && (result = session.executeDirectStatement("alter table SOURCE_REPLICAS add PRIMARY_KEY int[] default null")).isError()) {
                throw new DataspaceException(result);
            }
            this.checkReplicationMetadataTable(session, SOURCE_REPLICAS_TABLE, sourceReplicasTableCols);
            ColumnDef[] replicasTableCols = new ColumnDef[]{new ColumnDef(this, "DATASPACE_TYPE", "STRING"), new ColumnDef(this, "DATASPACE_NAME", "STRING", true), new ColumnDef(this, "NAME", "STRING", true), new ColumnDef(this, "VERSION", "INTEGER"), new ColumnDef(this, "REPLICATION_ID", "LONG")};
            this.checkReplicationMetadataTable(session, REPLICAS_TABLE, replicasTableCols);
            session.setDataspace("SDS");
            if (this.schemaManager.findSchemaObject(UNREFERENCED_LOBS_TABLE, "SDS", 4) == null && (result = session.executeDirectStatement("create persistent table UNREFERENCED_LOBS(LOB_ID long, BLOB_DATA BLOB,CLOB_DATA CLOB, PRIMARY KEY(LOB_ID))")).isError()) {
                throw new DataspaceException(result);
            }
            SchemaObject recoveryErrorsTable = this.schemaManager.findSchemaObject(RECOVERY_LOG, "SDS", 4);
            if (recoveryErrorsTable == null && (result = session.executeDirectStatement("create file table RECOVERY_LOG(STATEMENT_ID  int GENERATED BY DEFAULT AS IDENTITY, SESSION_ID int,DATASPACE varchar(255),RECORD_ID int,STATEMENT varchar(4048), LOG boolean, PRIMARY KEY (RECORD_ID, LOG))")).isError()) {
                throw new DataspaceException(result);
            }
            if (recoveryErrorsTable == null) {
                recoveryErrorsTable = this.schemaManager.findSchemaObject(RECOVERY_LOG, "SDS", 4);
            }
            if (!(recoveryErrors = (FileTableCollection)recoveryErrorsTable).isLinked()) {
                recoveryErrors.linkDataSource(session, new File(this.getPath()).getAbsolutePath() + ".err;fs=,;vs=,;lvs=,;quoted=true", false, false, false, 0L);
            }
            this.sysTablesManager.initialize();
            if (this.fullTextManager != null && this.getProperties().isPropertyTrue("text.engine.ds.index.rpl")) {
                try {
                    this.fullTextManager.retrieveSysldefIndex(session);
                }
                catch (Throwable e) {
                    String message = e.getMessage();
                    if (!message.contains("Could not load codec")) break block24;
                    try {
                        this.fullTextManager.reindexSysldefIndex(session);
                        this.fullTextManager.retrieveSysldefIndex(session);
                    }
                    catch (Exception e1) {
                        Trace.logInfo(this, "Failed to initialize Document Index: SYSLDEF_TEXT_INDEX. The Index needs to be re-indexed");
                    }
                }
            }
        }
        session.close();
    }

    private void checkReplicationMetadataTable(Session session, String tableName, ColumnDef[] columns) {
        SchemaObject repTable = this.schemaManager.findSchemaObject(tableName, "RDS", 4);
        if (repTable != null) {
            for (int i = 0; i < ((Collection)repTable).getBaseTable().getColumnCount(); ++i) {
                ColumnSchema column = ((Collection)repTable).getBaseTable().getColumn(i);
                if (columns[i].name.equals(column.getNameString())) continue;
                Trace.logInfo(this, "WARNING: System table '" + tableName + "' has outdated structure and will be recreated.");
                Result result = session.executeDirectStatement("drop collection " + tableName);
                if (result.isError()) {
                    throw new DataspaceException(result);
                }
                repTable = null;
                break;
            }
        }
        if (repTable == null) {
            StringBuilder tempBuffer = new StringBuilder();
            tempBuffer.append("create persistent table ").append(tableName).append(" (");
            Arrays.stream(columns).forEach(col -> tempBuffer.append(col.name).append(' ').append(col.type).append(','));
            tempBuffer.append(" PRIMARY KEY(");
            Arrays.stream(columns).forEach(col -> {
                if (col.primary) {
                    tempBuffer.append(col.name).append(',');
                }
            });
            tempBuffer.deleteCharAt(tempBuffer.length() - 1);
            tempBuffer.append("))");
            Result result = session.executeDirectStatement(tempBuffer.toString());
            if (result.isError()) {
                throw new DataspaceException(result);
            }
            result = session.executeDirectStatement("grant update,delete,insert,select on " + tableName + " to Users");
            if (result.isError()) {
                throw new DataspaceException(result);
            }
        }
    }

    public SysTablesManager getSysTablesManager() {
        return this.sysTablesManager;
    }

    @Override
    public DataspaceStoreProperties getProperties() {
        return this.dataspaceStoreProperties;
    }

    public String getUrl() {
        return this.url;
    }

    public String getVersion() {
        return Version.getVendorString();
    }

    void reopen() throws DataspaceException {
        this.setStoreState(DataspaceStoreState.OPENING);
        try {
            this.nameManager = new NameManager(this);
            this.granteeManager = new GranteeManager(this);
            this.userManager = new UserManager(this);
            this.schemaManager = new SchemaManager(this);
            this.persistentStoreCollection = new PersistentStoreCollectionDatabase();
            this.isReferentialIntegrity = true;
            this.collectionSessionManager = new SessionManager(this);
            this.collation = Collation.getDatabaseInstance();
            this.dsInfo = SysSchema.newDatabaseInformation(this);
            this.txManager = new TransactionManagerMVCC(this);
            this.schemaManager.createSystemSchemas();
            this.lobManager.createSchema();
            this.flobManager.createSchema();
            this.collectionSessionManager.getSysLobSession().setDataspace("SYS_LOBS");
            this.collectionSessionManager.getSysFlobSession().setDataspace("SYS_FLOBS");
            this.schemaManager.setSchemaChangeTimestamp();
            this.dataspaceLogger.openPersistence();
            this.checkpointManager = new CheckpointManager(this);
            boolean isNew = this.dataspaceLogger.isNewDatabase;
            if (isNew) {
                this.lobManager.initialiseLobSpace();
                this.flobManager.initialiseFlobSpace();
                if (this.checkpointManager != null) {
                    this.checkpointManager.setLastCheckpointAttemptTimestamp(false);
                }
                CheckpointManager.CheckpointStats.CheckpointAttempt checkpointAttempt = new CheckpointManager.CheckpointStats.CheckpointAttempt(CheckpointManager.CheckpointAction.CHECKPOINT_SYSTEM, System.currentTimeMillis(), 0L, false, this.checkpointManager != null ? this.checkpointManager.getRecoveryLogSize() : -1L);
                if (this.checkpointManager != null) {
                    checkpointAttempt.setDuplicatesBefore(this.checkpointManager.checkConsistencyAndLogBefore());
                }
                Result result = this.dataspaceLogger.checkpoint(false, checkpointAttempt);
                if (this.checkpointManager != null) {
                    checkpointAttempt.setSuccess(!result.isError());
                    checkpointAttempt.setEndTimestamp(System.currentTimeMillis());
                    checkpointAttempt.setDuplicatesAfter(this.checkpointManager.checkConsistencyAndLogAfter());
                    this.checkpointManager.addCheckpointAttempt(checkpointAttempt);
                    this.checkpointManager.updateCheckpointResult(result);
                }
            }
            this.lobManager.open();
            this.flobManager.open();
            this.dsInfo.setWithContent(true);
            if (!this.isRecoveryFailed()) {
                this.lobManager.synch();
                this.lobManager.deleteUnusedLobs(false);
                this.flobManager.synch();
                this.flobManager.deleteUnusedFlobs();
                this.validateOnStartup();
            }
            if (this.getStoreState() == DataspaceStoreState.OPENING) {
                this.setStoreState(DataspaceStoreState.ONLINE);
            }
            this.checkpointManager.start();
        }
        catch (Throwable e) {
            this.dataspaceLogger.closePersistence();
            this.setStoreState(DataspaceStoreState.SHUTDOWN);
            this.clearStructures();
            this.dataspaceLogger.logSevereEvent("could not reopen dataspace store", e);
            Trace.logException(this, e, true);
            throw new DataspaceException(e);
        }
    }

    private void validateOnStartup() {
        this.validatateLobs(true);
        this.validate(true);
    }

    public void validate(boolean withLobs) {
        for (DataspaceSchema schema : this.schemaManager.getAllSchemas()) {
            ((AbstractDataspace)schema).validate(withLobs);
        }
        this.lastCheckTime = System.currentTimeMillis();
    }

    public boolean validateReferences(Session session) {
        boolean result = false;
        for (DataspaceSchema schema : this.schemaManager.getAllSchemas()) {
            result = ((AbstractDataspace)schema).validateReferences(session) || result;
        }
        this.lastCheckTime = System.currentTimeMillis();
        return result;
    }

    private void validatateLobs(boolean onStartup) {
        LobValidator.InvalidLobs invalidLobs = this.lobManager.getValidator().checkAllLobs(true);
        if (invalidLobs.getInvalidTables().size() != 0) {
            Trace.logError(this, "WARNING: Broken LOBs were found in dataspaces");
            invalidLobs.getInvalidTables().forEach(t -> {
                StringBuilder builder = new StringBuilder();
                builder.append("\n");
                builder.append("Table name: ").append(t.getObjectName().getSchemaQualifiedStatementName()).append("\n");
                builder.append("Lob column names: ").append(t.getColumnNames()).append("\n");
                t.getInvalidRows().forEach(r -> {
                    builder.append(" Row indentity: (").append(r.getIdentity()).append(")\n");
                    r.getInvalidColumns().forEach(c -> {
                        builder.append("  Column ").append(t.getColumnNames().get(c.getColumnId())).append(" references to broken LOB ID(").append(c.getLobId()).append(").");
                        builder.append(" Cause: ").append(c.getException().getMessage());
                        builder.append("\n");
                    });
                });
                Trace.logError(this, builder.toString());
                AbstractCollection collection = (AbstractCollection)this.schemaManager.findSchemaObject(t.getObjectName().name, t.getObjectName().schema.name, 4);
                if (collection != null) {
                    collection.getStateHolder().setSuspectState(DataspaceStateHolder.lob, "Table references to broken or missing LOBs.");
                } else {
                    Trace.logError(this, "WARNING: Collection {} not found.", t.getObjectName().getSchemaQualifiedStatementName());
                }
            });
        }
        if (invalidLobs.getUnreferencedLobs().size() > 0) {
            if (onStartup && !this.isRecoveryFailed()) {
                Trace.logError(this, "WARNING: Unreferenced LOB IDS: {}. Will be moved into SDS.UNREFERENCED_LOBS collection.", invalidLobs.getUnreferencedLobs());
                this.lobManager.moveUnreferencedLobs(invalidLobs.getUnreferencedLobs());
            } else {
                Trace.logError(this, "WARNING: Unreferenced LOB IDS: {}.", invalidLobs.getUnreferencedLobs());
            }
        }
        LobValidator.InvalidLobs invalidFlobs = this.flobManager.getValidator(false).checkAllLobs(false);
        if (onStartup && !this.isRecoveryFailed()) {
            this.flobManager.deleteFlobs(invalidFlobs.getUnreferencedLobs());
        }
    }

    public DataspaceStateHolder aggregateDataspaceStoreState() {
        DataspaceStateHolder stateHolder = new DataspaceStateHolder(this.storeState);
        for (DataspaceSchema schema : this.schemaManager.getAllSchemas()) {
            DataspaceStateHolder holder = ((AbstractDataspace)schema).aggregateDataspaceState();
            if (!holder.isSuspectState() && !holder.isRecoveryFailedState()) continue;
            if (schema.getObjectName() == SqlInvariants.SYS_SCHEMA_NAME) {
                stateHolder.setSuspectState(holder);
                continue;
            }
            if (holder.isRecoveryFailedState()) {
                stateHolder.setSuspectState(DataspaceStateHolder.dataspaceRecoveryFailed(schema.getObjectName()), "");
                continue;
            }
            stateHolder.setSuspectState(DataspaceStateHolder.dataspace(schema.getObjectName()), "");
        }
        if (this.storeState == DataspaceStoreState.RECOVERY_FAILED) {
            stateHolder.setRecoveryFailedState();
        }
        return stateHolder;
    }

    public void exposeDataspaceStoreState(RowSetNavigatorClient navigator) {
        this.aggregateDataspaceStoreState().exposeState(navigator, false, false, "Dataspace Store State", new Class[0]);
        navigator.add(new Object[]{"Last Check Time", this.lastCheckTime != 0L ? new Date(this.lastCheckTime).toString() : "---"});
    }

    void clearStructures() {
        if (this.schemaManager != null) {
            this.schemaManager.clearStructures();
        }
        this.granteeManager = null;
        this.userManager = null;
        this.nameManager = null;
        this.schemaManager = null;
        this.collectionSessionManager = null;
        this.dsInfo = null;
    }

    public int getDatabaseID() {
        return this.storeID;
    }

    public String getUniqueName() {
        return this.storeUniqueName;
    }

    public void setUniqueName(String name) {
        this.storeUniqueName = name;
    }

    public String getModel() {
        return this.storeType;
    }

    public String getPath() {
        return this.path;
    }

    public NameManager.ObjectName getCatalogName() {
        return this.nameManager.getCatalogName();
    }

    public DataspaceStoreProperties getDataspaceStoreProperties() {
        return this.dataspaceStoreProperties;
    }

    public SessionManager getSessionManager() {
        return this.collectionSessionManager;
    }

    public boolean isReadOnly() {
        return this.storeReadOnly;
    }

    synchronized boolean isShutdown() {
        return this.getStoreState() == DataspaceStoreState.SHUTDOWN;
    }

    synchronized Session connect(String username, String password, TimeZone timeZone) {
        UserWrapper user = this.userManager.getUser(username, password);
        return this.collectionSessionManager.newSession(this, user, this.storeReadOnly, true);
    }

    synchronized Session connect(User user) {
        UserWrapper userWrapper = this.userManager.getUser(user);
        return this.collectionSessionManager.newSession(this, userWrapper, this.storeReadOnly, true);
    }

    public void setReadOnly() {
        this.storeReadOnly = true;
        this.filesReadOnly = true;
    }

    public void setFilesReadOnly() {
        this.filesReadOnly = true;
    }

    public boolean isFilesReadOnly() {
        return this.filesReadOnly;
    }

    public boolean isFilesInJar() {
        return this.filesInJar;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public GranteeManager getGranteeManager() {
        return this.granteeManager;
    }

    public void setReferentialIntegrity(boolean ref) {
        this.isReferentialIntegrity = ref;
    }

    public boolean isReferentialIntegrity() {
        return this.isReferentialIntegrity;
    }

    public int getResultMaxMemoryRows() {
        return this.resultMaxMemoryRows;
    }

    public void setResultMaxMemoryRows(int size) {
        this.resultMaxMemoryRows = size;
    }

    public void setStrictNames(boolean mode) {
        this.sqlEnforceNames = mode;
    }

    public void setStrictColumnSize(boolean mode) {
        this.sqlEnforceSize = mode;
    }

    public void setStrictReferences(boolean mode) {
        this.sqlEnforceRefs = mode;
    }

    public void setStrictTypes(boolean mode) {
        this.sqlEnforceTypes = mode;
    }

    public void setStrictTDCD(boolean mode) {
        this.sqlEnforceTDCD = mode;
    }

    public void setStrictTDCU(boolean mode) {
        this.sqlEnforceTDCU = mode;
    }

    public void setTranslateTTI(boolean mode) {
        this.sqlTranslateTTI = mode;
    }

    public void setConcatNulls(boolean mode) {
        this.sqlConcatNulls = mode;
    }

    public void setUniqueNulls(boolean mode) {
        this.sqlUniqueNulls = mode;
    }

    public void setConvertTrunc(boolean mode) {
        this.sqlConvertTruncate = mode;
    }

    public void setDoubleNaN(boolean mode) {
        this.sqlDoubleNaN = mode;
    }

    public void setAvgScale(int scale) {
        this.sqlAvgScale = scale;
    }

    public void setLongVarIsLob(boolean mode) {
        this.sqlLongvarIsLob = mode;
    }

    public void setDefaultStringPrecision(int value) {
        this.sqlDefaultStringPrecision = value;
    }

    protected void finalize() {
    }

    public void closeInternal() throws DataspaceException {
        if (!this.isRecoveryFailed()) {
            this.setStoreState(DataspaceStoreState.CLOSING);
        }
        this.dataspaceLogger.closePersistence();
        this.lobManager.close();
        this.flobManager.close();
        this.collectionSessionManager.close();
        this.setStoreState(DataspaceStoreState.SHUTDOWN);
        this.clearStructures();
    }

    public void setStoreState(DataspaceStoreState storeState) {
        this.storeState = storeState;
    }

    @Override
    public DataspaceStoreState getStoreState() {
        return this.storeState;
    }

    public boolean isRecoveryFailed() {
        return this.storeState == DataspaceStoreState.RECOVERY_FAILED;
    }

    public void getSettingsSQL(List<String> list) {
        String name;
        if (!this.getCatalogName().name.equals("LOCAL")) {
            name = this.getCatalogName().statementName;
            list.add("ALTER CATALOG LOCAL RENAME TO " + name);
        }
        if (!this.collation.isDefaultCollation()) {
            name = this.collation.getObjectName().statementName;
            list.add("SET DATABASE COLLATION " + name);
        }
        HashMappedList lobTables = this.schemaManager.getTables("SYS_LOBS");
        for (int i = 0; i < lobTables.size(); ++i) {
            Table table = (Table)lobTables.get(i);
            if (!table.isCached()) continue;
            StringBuffer sb = new StringBuffer();
            sb.append("SET").append(' ').append("TABLE");
            sb.append(' ');
            sb.append(table.getObjectName().getSchemaQualifiedStatementName());
            sb.append(' ').append("TYPE").append(' ');
            sb.append("LOGGED");
            list.add(sb.toString());
        }
    }

    public Result getScript(boolean indexRoots) {
        Result r = Result.newSingleColumnResult("COMMAND");
        ArrayList<String> statsList = new ArrayList<String>();
        this.getSettingsSQL(statsList);
        this.schemaManager.getSQLArray(statsList);
        String[] list = statsList.toArray(new String[0]);
        int loggedStatements = 0;
        DataspaceStore.addRows(r, list);
        loggedStatements += list.length;
        list = this.schemaManager.getCommentsArray();
        DataspaceStore.addRows(r, list);
        loggedStatements += list.length;
        if (indexRoots) {
            list = this.schemaManager.getIndexRootsSQL(loggedStatements);
            DataspaceStore.addRows(r, list);
            loggedStatements += list.length;
        }
        list = this.schemaManager.getTablePropsSQL(!indexRoots, loggedStatements);
        DataspaceStore.addRows(r, list);
        loggedStatements += list.length;
        list = this.getUserManager().getInitialSchemaSQL();
        DataspaceStore.addRows(r, list);
        loggedStatements += list.length;
        list = this.getGranteeManager().getRightsSQL(loggedStatements);
        DataspaceStore.addRows(r, list);
        loggedStatements += list.length;
        return r;
    }

    private static void addRows(Result r, String[] sql) {
        if (sql == null) {
            return;
        }
        for (String str : sql) {
            Object[] s = new String[]{str};
            r.initialiseNavigator().add(s);
        }
    }

    public String getURI() {
        return this.storeType + this.canonicalPath;
    }

    public String getCanonicalPath() {
        return this.canonicalPath;
    }

    public BaseStoreProperties getURLProperties() {
        return this.urlProperties;
    }

    public String getLastError(String triggerName) {
        return null;
    }

    public EventTriggerState getTriggerState(String triggerName) {
        return null;
    }

    protected void doEnableEventTrigger(String triggerName) {
    }

    protected void doDisableEventTrigger(String triggerName) {
    }

    protected String getTriggerActionableEventId(String triggerName) {
        return null;
    }

    @Override
    public SemanticType getSemanticType() {
        SemanticType stype = DataspaceStore.createSemanticType(DataspaceStore.class.getSimpleName(), this, true);
        stype.setAncestorType("DataspaceProvider");
        stype.setDescription("DBH Dataspace Provider.");
        return stype;
    }

    @Override
    public String getVendorString() {
        return this.vendorString;
    }

    public boolean isDataspaceExist(String name) {
        return this.schemaManager.findSchema(name) != null;
    }

    @Override
    public DataspaceComponent lookup(String name) {
        return this.schemaManager.findSchema(name);
    }

    @Override
    public DataspaceComponent[] getDataspaceComponents() {
        return this.schemaManager.getAllSchemas();
    }

    public Session createSession(User user) {
        return this.connect(user);
    }

    public DataspaceComponent createDataspace(DataspaceType model, String name, EventScope scope, User user) throws DataspaceManagerException {
        return this.createDataspace(model, name, scope, user, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataspaceComponent createDataspace(DataspaceType model, String name, EventScope scope, User user, String authorization) throws DataspaceManagerException {
        try (Session session = this.createSession(user);){
            Result result = session.executeDirectStatement("CREATE DATASPACE " + NameManager.quoteNameIfNeeded(name) + " TYPE " + model.name() + " EVENT SCOPE " + String.valueOf((Object)scope) + (String)(authorization != null ? " authorization " + authorization : ""));
            if (result.isError()) {
                throw new DataspaceManagerException(2002, "Creation of dataspace failed.", result.getException());
            }
        }
        return this.schemaManager.findSchema(name);
    }

    @Override
    public DataspaceComponent createDataspace(DataspaceType model, String name, EventScope scope, String location, boolean autoload, User user, String authorization) throws DataspaceManagerException {
        return this.createDataspace(model, name, scope, user, authorization);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropDataspace(String name, User user, boolean cascade, boolean force) throws DataspaceManagerException {
        try (Session session = null;){
            session = this.createSession(user);
            Result result = session.executeDirectStatement("DROP DATASPACE \"" + name + "\"" + (cascade ? " cascade " : "") + (force ? " force " : ""));
            if (result.isError()) {
                throw new DataspaceManagerException(2002, "Drop dataspace failed." + String.valueOf(result.getException()) != null ? result.getException().getMessage() : result.getMainString());
            }
        }
    }

    @Override
    public String getName() {
        return DataspaceStore.class.getSimpleName();
    }

    @Override
    public List<String> getSupportedDataspaceModels() {
        ArrayList<String> models = new ArrayList<String>();
        models.add(DataspaceType.TSPACE.name());
        models.add(DataspaceType.QSPACE.name());
        return models;
    }

    public Properties getDefaultProperties() {
        return new Properties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeSystemSqlStatements() {
        String ddxUserName = DataspaceStore.getContext().getDeploymentDescriptor().getSecurityPrincipal();
        User user = null;
        try {
            user = DataspaceStore.getContext().getSecurityManager().lookupUser(ddxUserName);
        }
        catch (Exception error) {
            error.printStackTrace();
        }
        try (Session session = null;){
            session = this.createSession(user);
            session.setDataspace("SDS");
            this.existsActionableEventStat = session.compileStatement("select true from ACTIONABLE_EVENTS where DATASPACE = ? and EVENT_ID = ?", 0);
            this.existsActionableEventGroupStat = session.compileStatement("select true from ACTIONABLE_GROUPS where DATASPACE = ? and GROUP_NAME = ?", 0);
            this.hasActionableEventGroupsStat = session.compileStatement("select count(GROUP_NAME) as counter from ACTIONABLE_GROUPS where DATASPACE = ?", 0);
            this.listActionableEventGroupsStat = session.compileStatement("select GROUP_NAME from ACTIONABLE_GROUPS where DATASPACE = ?", 0);
            this.listActionableEventsStat = session.compileStatement("select EVENT_ID from ACTIONABLE_EVENTS where DATASPACE = ?", 0);
            this.hasAdvisoriesStat = session.compileStatement("select count(ADVISORY_NAME) as counter from ADVISORIES where DATASPACE = ?", 0);
        }
    }

    public boolean existsActionableEvent(Session session, String dataspace, String eventId) {
        Result result = session.executeCompiledStatement(this.existsActionableEventStat, new Object[]{dataspace, eventId});
        if (!result.isError() && result.isData()) {
            RowSetNavigator rowSet = result.navigator;
            return rowSet.next();
        }
        return false;
    }

    public boolean existsActionableEventGroup(Session session, String dataspace, String groupName) {
        Result result = session.executeCompiledStatement(this.existsActionableEventGroupStat, new Object[]{dataspace, groupName});
        if (!result.isError() && result.isData()) {
            RowSetNavigator rowSet = result.navigator;
            return rowSet.next();
        }
        return false;
    }

    public boolean hasActionableEventGroups(Session session, String dataspace) {
        RowSetNavigator rowSet;
        Result result = session.executeCompiledStatement(this.hasActionableEventGroupsStat, new Object[]{dataspace});
        if (!result.isError() && result.isData() && (rowSet = result.navigator).next()) {
            Integer value = (Integer)rowSet.getCurrent(0);
            return value > 0;
        }
        return false;
    }

    public List<String> listActionableEventGroups(Session session, String dataspace) {
        ArrayList<String> groups = new ArrayList<String>();
        Result result = session.executeCompiledStatement(this.listActionableEventGroupsStat, new Object[]{dataspace});
        if (!result.isError() && result.isData()) {
            RowSetNavigator rowSet = result.navigator;
            while (rowSet.next()) {
                groups.add((String)rowSet.getCurrent(0));
            }
        }
        return groups;
    }

    public List<String> listActionableEvents(Session session, String dataspace) {
        ArrayList<String> events = new ArrayList<String>();
        Result result = session.executeCompiledStatement(this.listActionableEventsStat, new Object[]{dataspace});
        if (!result.isError() && result.isData()) {
            RowSetNavigator rowSet = result.navigator;
            while (rowSet.next()) {
                events.add((String)rowSet.getCurrent(0));
            }
        }
        return events;
    }

    public boolean hasAdvisories(Session session, String dataspace) {
        RowSetNavigator rowSet;
        Result result = session.executeCompiledStatement(this.hasAdvisoriesStat, new Object[]{dataspace});
        if (!result.isError() && result.isData() && (rowSet = result.navigator).next()) {
            Integer value = (Integer)rowSet.getCurrent(0);
            return value > 0;
        }
        return false;
    }

    public void persistStoreState() {
        try {
            RepositoryUtils.bindObject("/sys/dataspace/", this);
        }
        catch (ObjectConfigurationException error) {
            Trace.logException(this, error, true);
            throw new DataspaceException(error);
        }
    }

    @Override
    public Connection getJDBCConnection(String username, String password) throws SQLException {
        Properties props = new Properties();
        props.put("user", username);
        props.put("password", password);
        return new JDBCDriver().connect("jdbc:streamscape:dataspace:local://;", props);
    }

    @Override
    public Connection getJDBCConnection(String dataspaceName, SecurityContext context) throws SQLException {
        return new JDBCConnection(this.dataspaceStoreProperties, this.storeType, this.path, dataspaceName, context.getUser());
    }

    @Override
    public Connection getJDBCConnection(String dataspaceName, SecurityContext context, BaseStoreProperties props) throws SQLException {
        return new JDBCConnection(props, this.storeType, this.path, dataspaceName, context.getUser());
    }

    public void setDBModified(StoreFilesState value) {
        this.storeFilesState = value;
    }

    public StoreFilesState getDBModified() {
        return this.storeFilesState;
    }

    @Override
    public CountDownLatch lock() throws DataspaceManagerException {
        return this.dataspaceLogger.lock();
    }

    @Override
    public void unlock() throws DataspaceManagerException {
        this.dataspaceLogger.unlock();
    }

    public CheckpointManager getCheckpointManager() {
        return this.checkpointManager;
    }

    @Override
    public void addSemanticType(SemanticType type) {
        this.schemaManager.registerSemanticTypeAsType(type, null);
    }

    @Override
    public HashSet<NameManager.ObjectName> getSemanticTypeReferences(SemanticType semanticType) {
        return this.schemaManager.getSemanticTypeReferences(semanticType);
    }

    @Override
    public void removeSemanticType(String typeName) {
        this.schemaManager.unregisterSemanticTypeAsType(typeName);
    }

    @Override
    public void checkSemanticTypes(List<SemanticType> types, boolean validate) {
        this.schemaManager.checkSemanticTypes(types, validate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initDataspace(String name, String userName) {
        Session tempSession = null;
        try {
            tempSession = this.getSessionManager().newSysSession();
            DataspaceSchema schema = this.schemaManager.findSchema(name);
            if (schema == null) {
                throw new DataspaceException("Dataspace '" + name + "' does not exist.");
            }
            this.checkAdminOrOwner(schema, userName, "start");
            schema.init(tempSession);
            tempSession.executeDirectStatement("internal start dataspace [" + name + "]");
        }
        finally {
            if (tempSession != null) {
                tempSession.commit(false);
                tempSession.close();
                tempSession = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openDataspace(String name, String userName) {
        Session tempSession = null;
        try {
            tempSession = this.getSessionManager().newSysSession();
            DataspaceSchema schema = this.schemaManager.findSchema(name);
            if (schema == null) {
                throw new DataspaceException("Dataspace '" + name + "' does not exist.");
            }
            this.checkAdminOrOwner(schema, userName, "online");
            schema.init(tempSession);
            schema.open(tempSession);
            tempSession.executeDirectStatement("internal online dataspace [" + name + "]");
        }
        finally {
            if (tempSession != null) {
                tempSession.commit(false);
                tempSession.close();
                tempSession = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeDataspace(String name, String userName) {
        Session tempSession = null;
        try {
            tempSession = this.getSessionManager().newSysSession();
            DataspaceSchema schema = this.schemaManager.findSchema(name);
            if (schema == null) {
                throw new DataspaceException("Dataspace '" + name + "' does not exist.");
            }
            this.checkAdminOrOwner(schema, userName, "offline");
            schema.close(tempSession);
            tempSession.executeDirectStatement("internal offline dataspace [" + name + "]");
        }
        finally {
            if (tempSession != null) {
                tempSession.commit(false);
                tempSession.close();
                tempSession = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyDataspace(String name, String userName) {
        Session tempSession = null;
        try {
            tempSession = this.getSessionManager().newSysSession();
            DataspaceSchema schema = this.schemaManager.findSchema(name);
            if (schema == null) {
                throw new DataspaceException("Dataspace '" + name + "' does not exist.");
            }
            this.checkAdminOrOwner(schema, userName, "stop");
            schema.close(tempSession);
            schema.destroy(tempSession);
            tempSession.executeDirectStatement("internal stop dataspace [" + name + "]");
        }
        finally {
            if (tempSession != null) {
                tempSession.commit(false);
                tempSession.close();
                tempSession = null;
            }
        }
    }

    private void checkAdminOrOwner(DataspaceSchema schema, String userName, String command) {
        UserWrapper grantee = ((AbstractDataspace)schema).getStore().getUserManager().get(userName);
        if (!grantee.isAdmin() && !schema.getOwner().getObjectName().equals(grantee.getObjectName())) {
            throw new DataspaceException("Only admin user or dataspace owner can start/stop/online/offline dataspace.");
        }
    }

    @Override
    public List<DataspaceSessionInfo> getBlockedSessions() {
        if (this.collectionSessionManager != null) {
            return this.collectionSessionManager.getBlockedSessions();
        }
        return null;
    }

    @Override
    public void setLogger(String dataspaceName, DataspaceLogger logger) {
        DataspaceSchema schema = this.schemaManager.findSchema(dataspaceName);
        if (schema != null) {
            schema.setLogger(logger);
        }
    }

    @Override
    public void setDefaultLogger(DataspaceLogger defaultLogger) {
        this.defaultLogger = defaultLogger;
    }

    @Override
    public DataspaceLogger getDefaultLogger() {
        return this.defaultLogger;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timezone;
    }

    @Override
    public void setTimeZone(TimeZone timezone) {
        this.setTimeZone(timezone.getID());
    }

    public synchronized void setTimeZone(String timezoneId) {
        String propertyTimeZone;
        String string = propertyTimeZone = this.dataspaceStoreProperties.isPropertyExist("dtspace.timezone") ? this.dataspaceStoreProperties.getStringProperty("dtspace.timezone") : null;
        if (propertyTimeZone == null || !propertyTimeZone.equals(timezoneId)) {
            this.dataspaceStoreProperties.setProperty("dtspace.timezone", timezoneId);
            this.persistStoreState();
            Trace.logInfo(this, "WARNING: Dataspace timezone has been changed to '" + timezoneId + "'. Restart required to apply changes.");
            if (this.timezone != null && !this.timezone.getID().equals(timezoneId)) {
                DataspaceStoreManager.getRuntimeContext().setConfigurationState(ConfigurationState.RESTART_REQUIRED);
            }
        }
    }

    public synchronized void setCCSID(String ccsid) {
        String propertyCCSID;
        String string = propertyCCSID = this.dataspaceStoreProperties.isPropertyExist("file.ccsid") ? this.dataspaceStoreProperties.getStringProperty("file.ccsid") : null;
        if (propertyCCSID == null || !propertyCCSID.equals(ccsid)) {
            try {
                this.ccsid = Charset.forName(ccsid);
            }
            catch (Exception exception) {
                throw new DataspaceException("Invalid charset '" + ccsid + "' specified.");
            }
            this.dataspaceStoreProperties.setProperty("file.ccsid", ccsid);
            this.persistStoreState();
        }
    }

    @Override
    public synchronized Charset getCCSID() {
        return this.ccsid;
    }

    public void setInitProperty(String name, Object value) {
        DataspaceStore.setRuntimeInitProperty(name, value);
    }

    public FullTextManager getFullTextManager() {
        return this.fullTextManager;
    }

    class ColumnDef {
        String name;
        String type;
        boolean primary;

        ColumnDef(DataspaceStore this$0, String name, String type) {
            this.name = name;
            this.type = type;
        }

        ColumnDef(DataspaceStore this$0, String name, String type, boolean primary) {
            this(this$0, name, type);
            this.primary = primary;
        }
    }

    public static class DDLRecordNode {
        public LogRecordType type;
        public String objectName;
        public int dataspaceId;
        public int objectId;
    }
}

