/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds;

import com.streamscape.ds.error.Error;
import com.streamscape.ds.result.Result;
import com.streamscape.sef.utils.Utils;
import com.streamscape.tools.parser.ParserPositionalException;
import java.sql.SQLException;
import java.util.Objects;

public class DataspaceException
extends RuntimeException
implements ParserPositionalException {
    public static final DataspaceException[] emptyArray = new DataspaceException[0];
    public static final DataspaceException noDataCondition = Error.error(1100);
    private String message;
    private String state;
    private int code;
    private int level;
    private int statementGroup;
    private int statementCode;
    private int lineNumber = -1;
    private int positionInLine = -1;
    private String line = null;
    private boolean logged = false;

    public DataspaceException(String message) {
        this.message = message;
        this.state = "00000";
        this.code = 458;
    }

    public DataspaceException(Throwable exception) {
        this(Utils.formatExceptionWithUnrepeatedCauses(exception));
        this.initFromSqlOrDataspaceException(exception);
    }

    public DataspaceException(Throwable exception, boolean withCause) {
        super(exception);
        this.message = exception.getMessage();
        this.state = "00000";
        this.code = 458;
        this.initFromSqlOrDataspaceException(exception);
    }

    public DataspaceException(ParserPositionalException exception) {
        this(exception.getErrorMessage());
        this.lineNumber = exception.getLineNumber();
        this.positionInLine = exception.getPositionInLine();
        this.line = exception.getLine();
        this.initFromSqlOrDataspaceException(exception);
    }

    public DataspaceException(String message, Throwable cause) {
        super(cause);
        this.message = message;
        this.state = "00000";
        this.code = 458;
        this.initFromSqlOrDataspaceException(cause);
    }

    public DataspaceException(Throwable t, String message, String state, int code) {
        super(t);
        this.message = message;
        this.state = state;
        this.code = code;
    }

    public DataspaceException(String message, String state, int code) {
        this.message = message;
        this.state = state;
        this.code = code;
    }

    public DataspaceException(Result r) {
        this.message = r.getMainString();
        this.state = r.getSubString();
        this.code = r.getErrorCode();
    }

    public DataspaceException(Throwable t, String errorState, int errorCode) {
        super(t);
        this.message = t.getMessage() != null && t.getMessage().length() > 0 ? t.getMessage() : t.toString();
        this.state = errorState;
        this.code = errorCode;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getSQLState() {
        return this.state;
    }

    public int getErrorCode() {
        return this.code;
    }

    public DataspaceException setLevel(int level) {
        this.level = level;
        return this;
    }

    public int getLevel() {
        return this.level;
    }

    public int getStatementCode() {
        return this.statementCode;
    }

    public void setStatementType(int group, int code) {
        this.statementGroup = group;
        this.statementCode = code;
    }

    @Override
    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public void setLine(String line) {
        this.line = line;
    }

    @Override
    public String getLine() {
        return this.line;
    }

    @Override
    public int getPositionInLine() {
        return this.positionInLine;
    }

    @Override
    public void setPositionInLine(int positionInLine) {
        this.positionInLine = positionInLine;
    }

    @Override
    public String getErrorMessage() {
        return this.getFullErrorMessage();
    }

    public String getFullErrorMessage() {
        return "DSQL-" + Math.abs(this.getErrorCode()) + " " + Utils.formatExceptionWithUnrepeatedCauses(this);
    }

    public int hashCode() {
        return this.code;
    }

    public boolean equals(Object other) {
        if (other instanceof DataspaceException) {
            DataspaceException o = (DataspaceException)other;
            return this.code == o.code && Objects.equals(this.state, o.state) && Objects.equals(this.message, o.message);
        }
        return false;
    }

    private void initFromSqlOrDataspaceException(Object exception) {
        if (exception instanceof DataspaceException) {
            this.state = ((DataspaceException)exception).getSQLState();
            this.code = ((DataspaceException)exception).getErrorCode();
        } else if (exception instanceof SQLException) {
            this.state = ((SQLException)exception).getSQLState();
            this.code = ((SQLException)exception).getErrorCode();
            if (this.state == null) {
                this.state = "00000";
                this.code = 458;
            }
        }
    }

    @Override
    public String toString() {
        String s = "Dataspace Exception";
        String message = this.getLocalizedMessage();
        return message != null ? s + ": " + message : s;
    }

    public boolean isLogged() {
        return this.logged;
    }

    public DataspaceException setLogged(boolean logged) {
        this.logged = logged;
        return this;
    }
}

