/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds;

import com.streamscape.Trace;
import com.streamscape.cli.ds.CollectionFactory;
import com.streamscape.cli.ds.CollectionType;
import com.streamscape.ds.AbstractDataspace;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CollectionFactoryFactory {
    private Map<CollectionType, Class<? extends CollectionFactory>> factories = new HashMap<CollectionType, Class<? extends CollectionFactory>>();

    public void registerCollectionFactory(Class<? extends CollectionFactory> clazz) {
        try {
            CollectionFactory factory = clazz.newInstance();
            this.getInitMethod(clazz);
            this.factories.put(factory.getCollectionType(), clazz);
        }
        catch (Exception exception) {
            Trace.logError(this, "Failed to instantiate collection factory of class " + clazz.getName());
            throw new RuntimeException(exception);
        }
    }

    public CollectionFactory instantiateCollectionFactory(CollectionType type, AbstractDataspace dataspace) {
        Class<? extends CollectionFactory> clazz = this.factories.get((Object)type);
        if (clazz == null) {
            return null;
        }
        try {
            CollectionFactory factory = clazz.newInstance();
            Method method = this.getInitMethod(clazz);
            method.invoke((Object)factory, dataspace);
            return factory;
        }
        catch (Exception exception) {
            Trace.logError(this, "Failed to instantiate and inti collection factory of class " + clazz.getName() + " and type " + String.valueOf((Object)type) + ".");
            throw new RuntimeException(exception);
        }
    }

    private Method getInitMethod(Class<? extends CollectionFactory> clazz) throws NoSuchMethodException, SecurityException {
        Method method = clazz.getMethod("init", AbstractDataspace.class);
        if (method == null) {
            throw new RuntimeException("Method init(" + String.valueOf(AbstractDataspace.class) + ") not found in factory class " + clazz.getName() + ".");
        }
        return method;
    }

    public Set<CollectionType> listCollectionTypes() {
        return this.factories.keySet();
    }
}

