/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.core.DataspaceStoreState;
import com.streamscape.ds.lib.HsqlTimer;
import com.streamscape.ds.lib.store.ValuePool;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.parser.statement.StatementCommand;
import com.streamscape.ds.persist.DataspaceStoreDuplicatesResolver;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.session.Session;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import com.streamscape.sef.security.User;
import com.streamscape.slex.SizeUnit;
import com.streamscape.slex.lang.AbstractDSLOperation;
import java.util.Date;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CheckpointManager {
    private DataspaceStore store;
    private long checkpointInterval = 3600000L;
    private long checkpointIntervalRepeat = 300000L;
    private long checkpointIntervalCritical = 18000000L;
    private long logSizeMax = 0x3200000L;
    private long logSizeCritical = 0xC800000L;
    private long checkpointLockTimeout1 = 100L;
    private long checkpointLockTimeout2 = 200L;
    private boolean checkpointCheckConsistency = false;
    private volatile boolean started = false;
    private final Object propertiesMutex = new Object();
    private volatile boolean checkpointManagedByMVCC = false;
    private volatile boolean checkpointRequired = false;
    private volatile long lastCheckpointAttemptTimestamp = 0L;
    private volatile long lastCheckpointSuccessfulTimestamp = 0L;
    private volatile long startTimestamp = 0L;
    private CheckpointExecutor checkpointExecutor;
    private Thread checkpointExecutorThread;
    private final boolean checkpointDisabled;
    private final CheckpointStats totalStats = new CheckpointStats();
    private final CheckpointStats localStats = new CheckpointStats();
    private volatile boolean checkpointInProgress = false;
    private final HsqlTimer timer = new HsqlTimer();
    private Object timerTask;

    public CheckpointManager(DataspaceStore store) {
        this.store = store;
        this.checkpointExecutor = new CheckpointExecutor();
        this.checkpointDisabled = !store.dataspaceLogger.isLogged();
        this.startTimestamp = System.currentTimeMillis();
        this.setCheckpointInterval(store.dataspaceLogger.propCheckpointInterval);
        this.setCheckpointIntervalRepeat(store.dataspaceLogger.propCheckpointIntervalRepeat);
        this.setCheckpointIntervalCritical(store.dataspaceLogger.propCheckpointIntervalCritical);
        this.setCheckpointLockTimeout1(store.dataspaceLogger.propCheckpointLockTimeout1);
        this.setCheckpointLockTimeout2(store.dataspaceLogger.propCheckpointLockTimeout2);
        this.setCheckpointCheckConsistency(store.dataspaceLogger.propCheckpointCheckConsistency);
        this.setLogSizeMax((long)store.dataspaceLogger.propLogSize * 1024L * 1024L);
        this.setLogSizeCritical((long)store.dataspaceLogger.propLogSizeCritical * 1024L * 1024L);
    }

    public void setCheckpointInterval(String value) {
        if (value == null || value.length() == 0) {
            value = "1 h";
        }
        this.checkpointInterval = CheckpointManager.convertInterval(value);
    }

    public void setCheckpointIntervalRepeat(String value) {
        if (value == null || value.length() == 0) {
            value = "1 m";
        }
        this.checkpointIntervalRepeat = CheckpointManager.convertInterval(value);
    }

    public void setCheckpointIntervalCritical(String value) {
        if (value == null || value.length() == 0) {
            value = "5 h";
        }
        this.checkpointIntervalCritical = CheckpointManager.convertInterval(value);
    }

    public void setCheckpointLockTimeout1(String value) {
        if (value == null || value.length() == 0) {
            value = "100";
        }
        this.checkpointLockTimeout1 = CheckpointManager.convertInterval(value);
    }

    public void setCheckpointLockTimeout2(String value) {
        if (value == null || value.length() == 0) {
            value = "200";
        }
        this.checkpointLockTimeout2 = CheckpointManager.convertInterval(value);
    }

    public void setCheckpointCheckConsistency(boolean value) {
        this.checkpointCheckConsistency = value;
    }

    public long getLogSizeMax() {
        return this.logSizeMax;
    }

    public void setLogSizeMax(long logSizeMax) {
        this.logSizeMax = logSizeMax;
    }

    public void setLogSizeCritical(long logSizeCritical) {
        this.logSizeCritical = logSizeCritical;
    }

    private long getTimeSinceLastSuccessfulCheckpoint() {
        if (this.lastCheckpointSuccessfulTimestamp > 0L) {
            return System.currentTimeMillis() - this.lastCheckpointSuccessfulTimestamp;
        }
        return System.currentTimeMillis() - this.startTimestamp;
    }

    public CheckpointStats getTotalStats() {
        return this.totalStats;
    }

    public long getCheckpointInterval() {
        return this.checkpointInterval;
    }

    public long getCheckpointIntervalRepeat() {
        return this.checkpointIntervalRepeat;
    }

    public long getCheckpointIntervalCritical() {
        return this.checkpointIntervalCritical;
    }

    public long getLogSizeCritical() {
        return this.logSizeCritical;
    }

    public long getCheckpointLockTimeout1() {
        return this.checkpointLockTimeout1;
    }

    public long getCheckpointLockTimeout2() {
        return this.checkpointLockTimeout2;
    }

    public boolean isCheckpointCheckConsistency() {
        return this.checkpointCheckConsistency;
    }

    public long getLastCheckpointAttemptTimestamp() {
        return this.lastCheckpointAttemptTimestamp;
    }

    public long getLastCheckpointSuccessfulTimestamp() {
        return this.lastCheckpointSuccessfulTimestamp;
    }

    public long getNextCheckpointTimestamp() {
        Date nextCheckpointDate;
        Object timerTaskLocal = this.timerTask;
        if (timerTaskLocal != null && (nextCheckpointDate = HsqlTimer.getNextScheduled(timerTaskLocal)) != null) {
            return nextCheckpointDate.getTime();
        }
        return 0L;
    }

    public synchronized void start() {
        if (this.checkpointDisabled) {
            return;
        }
        this.started = true;
        Trace.logInfo(this, "Starting checkpoint manager. Checkpoint interval: {} ms, interval repeat: {} ms, interval critical: {} ms, lock timeout1: {} ms, lock timeout2: {}ms, log max size: {}, log critical size: {}", this.checkpointInterval, this.checkpointIntervalRepeat, this.checkpointIntervalCritical, this.checkpointLockTimeout1, this.checkpointLockTimeout2, SizeUnit.convertToBestFractional(this.logSizeMax, SizeUnit.BYTES).toStringWithPrecision(2), SizeUnit.convertToBestFractional(this.logSizeCritical, SizeUnit.BYTES).toStringWithPrecision(2));
        this.checkpointExecutorThread = new Thread(this.checkpointExecutor);
        this.checkpointExecutorThread.start();
        this.scheduleCheckpointIn(this.checkpointInterval);
    }

    public synchronized void stop() {
        if (this.checkpointDisabled) {
            return;
        }
        this.started = false;
        if (this.timerTask != null) {
            Object timerTaskLocal = this.timerTask;
            HsqlTimer.cancel(timerTaskLocal);
        }
        if (this.checkpointExecutorThread != null) {
            Trace.logInfo(this, "Stopping checkpoint manager.");
            this.checkpointExecutor.running = false;
            this.checkpointExecutor.queue.offer(CheckpointAction.CHECKPOINT_STOP);
            try {
                this.checkpointExecutorThread.join(120000L);
            }
            catch (InterruptedException exception) {
                Trace.logException(this, exception, true);
            }
            this.checkpointExecutorThread.interrupt();
            try {
                this.checkpointExecutorThread.join(60000L);
            }
            catch (InterruptedException exception) {
                Trace.logException(this, exception, true);
            }
            this.checkpointExecutorThread = null;
        }
    }

    public synchronized void join() {
        if (this.checkpointDisabled) {
            return;
        }
        if (this.checkpointExecutorThread != null) {
            try {
                this.checkpointExecutorThread.join(120000L);
            }
            catch (InterruptedException exception) {
                Trace.logException(this, exception, true);
            }
        }
    }

    public Statement getCheckpointStatement(boolean withDefrag, boolean auto, long lockTimeout, CheckpointStats.CheckpointAttempt checkpointAttempt) {
        NameManager.ObjectName[] names = this.store.schemaManager.getCatalogAndBaseTableNames();
        Object[] args = new Object[]{withDefrag, auto, lockTimeout, checkpointAttempt};
        StatementCommand cs = new StatementCommand(1002, args, null, names);
        cs.setCompileTimestamp(this.store.txManager.getGlobalChangeTimestamp());
        cs.setSQL("CHECKPOINT");
        return cs;
    }

    public long getRecoveryLogSize() {
        return this.store.dataspaceLogger.getRecoveryLogSize();
    }

    public long getLogSize() {
        return this.store.dataspaceLogger.getLogSize();
    }

    private void scheduleCheckpointIn(long inTime) {
        if (this.checkpointDisabled) {
            return;
        }
        this.log(Trace.Level.DEBUG, "Schedule checkpoint by timer at {}(in {} ms).", AbstractDSLOperation.formatDateMillis(System.currentTimeMillis() + inTime), inTime);
        this.timerTask = this.timer.scheduleAfter(inTime, () -> this.checkpointExecutor.queue.offer(CheckpointAction.CHECKPOINT_BY_TIMER));
    }

    private void rescheduleCheckpointIn(long inTime) {
        if (this.checkpointDisabled) {
            return;
        }
        if (this.timer.rescheduleTaskAfter(this.timerTask, inTime)) {
            this.log(Trace.Level.DEBUG, "Reschedule checkpoint by timer at {}(in {} ms).", AbstractDSLOperation.formatDateMillis(System.currentTimeMillis() + inTime), inTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enqueueCheckpointMVCC() {
        if (this.checkpointDisabled) {
            return false;
        }
        if (this.store.storeState != DataspaceStoreState.ONLINE) {
            return false;
        }
        Object object = this.propertiesMutex;
        synchronized (object) {
            if (this.checkpointManagedByMVCC) {
                this.log(Trace.Level.DEBUG, "Enqueue checkpoint by MVCC.", new Object[0]);
                this.checkpointExecutor.queue.offer(CheckpointAction.CHECKPOINT_BY_MVCC);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueCheckpointRequired() {
        if (this.checkpointDisabled) {
            return;
        }
        if (this.store.storeState != DataspaceStoreState.ONLINE) {
            return;
        }
        if (this.checkpointRequired) {
            return;
        }
        Object object = this.propertiesMutex;
        synchronized (object) {
            if (this.checkpointRequired) {
                return;
            }
            this.checkpointRequired = true;
            if (!this.checkpointManagedByMVCC || this.getRecoveryLogSize() >= this.logSizeCritical || this.checkpointIntervalCritical > 0L && this.getTimeSinceLastSuccessfulCheckpoint() >= this.checkpointIntervalCritical) {
                this.log(Trace.Level.DEBUG, "Enqueue checkpoint required.", new Object[0]);
                this.checkpointExecutor.queue.offer(CheckpointAction.CHECKPOINT_REQUIRED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCheckpointManagedByMVCC() {
        if (this.checkpointDisabled) {
            return;
        }
        Object object = this.propertiesMutex;
        synchronized (object) {
            this.log(Trace.Level.DEBUG, "Set checkpoint manage by mvcc.", new Object[0]);
            this.checkpointManagedByMVCC = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastCheckpointAttemptTimestamp(boolean auto) {
        Object object = this.propertiesMutex;
        synchronized (object) {
            this.totalStats.incAttemptsCount();
            this.localStats.incAttemptsCount();
            if (auto) {
                this.totalStats.incAttemptsCountAuto();
                this.localStats.incAttemptsCountAuto();
            }
            this.lastCheckpointAttemptTimestamp = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCheckpointResult(Result result) {
        Object object = this.propertiesMutex;
        synchronized (object) {
            if (!result.isError()) {
                this.totalStats.incSuccessCount();
                this.localStats.incSuccessCount();
                this.lastCheckpointSuccessfulTimestamp = System.currentTimeMillis();
                this.checkpointManagedByMVCC = false;
                this.checkpointRequired = false;
                this.log(Trace.Level.DEBUG, "Checkpoint successfully executed.", new Object[0]);
            } else {
                this.log(Trace.Level.DEBUG, "Checkpoint error" + (String)(result.getException() != null ? ": " + result.getException().toString() : "."), new Object[0]);
                if (result.getException() != null && result.getErrorCode() != -4866) {
                    Trace.logException(this, result.getException(), true);
                }
            }
        }
    }

    public void addCheckpointAttempt(CheckpointStats.CheckpointAttempt checkpointAttempt) {
        this.totalStats.addAttempt(checkpointAttempt);
        this.localStats.addAttempt(checkpointAttempt);
    }

    public boolean isCheckpointManagedByMVCC() {
        return this.checkpointManagedByMVCC;
    }

    public boolean isCheckpointRequired() {
        return this.checkpointRequired;
    }

    public boolean isCheckpointInProgress() {
        return this.checkpointInProgress;
    }

    public CheckpointExecutor getCheckpointExecutor() {
        return this.checkpointExecutor;
    }

    public DataspaceStoreDuplicatesResolver.DataspaceStoreDuplicates checkConsistencyAndLogBefore() {
        return this.checkConsistencyAndLog("BEFORE CHECKPOINT");
    }

    public DataspaceStoreDuplicatesResolver.DataspaceStoreDuplicates checkConsistencyAndLogAfter() {
        return this.checkConsistencyAndLog("AFTER CHECKPOINT");
    }

    private DataspaceStoreDuplicatesResolver.DataspaceStoreDuplicates checkConsistencyAndLog(String prefix) {
        if (this.checkpointCheckConsistency) {
            try {
                DataspaceStoreDuplicatesResolver.DataspaceStoreDuplicates duplicates = new DataspaceStoreDuplicatesResolver(this.store).findDuplicates(false, false);
                Trace.logInfo(this, "Checkpoint check consistency time: {} ms", duplicates.durationMs);
                if (duplicates.hasDuplicates()) {
                    Trace.logInfo(this, "WARNING: DATASPACE DUPLICATES FOUND {}, COUNT: {}, DATASPACES: {}, TABLES: {}", prefix, duplicates.getDuplicateKeysCount(), duplicates.getDuplicateDataspaceNames(), duplicates.getDuplicateTableNames());
                    Trace.logInfo(this, "WARNING: DATASPACE DUPLICATES {}, DETAILS: {}", prefix, HTTPUtils.getJsonSerializerForJaxrx().serialize(duplicates));
                }
                return duplicates;
            }
            catch (Exception exception) {
                Trace.logError(this, "Failed to check for duplicates.");
                Trace.logException(this, exception, true);
                return null;
            }
        }
        return null;
    }

    public static long convertInterval(String value) {
        if (value == null) {
            return 0L;
        }
        long actualValue = 0L;
        long scale = 1L;
        Pattern pattern = Pattern.compile("(\\d+)\\s+(\\w+)");
        Matcher matcher = pattern.matcher(value);
        if (matcher.find()) {
            String numberValue = matcher.group(1);
            try {
                actualValue = Long.valueOf(numberValue);
            }
            catch (NumberFormatException ex) {
                throw new DataspaceException("Failed to convert interval value " + value + ".", ex);
            }
            String unit = matcher.group(2);
            unit = unit.trim().toLowerCase();
            if (unit.equals("s") || unit.equals("sec")) {
                scale = 1000L;
            } else if (unit.equals("m") || unit.equals("min")) {
                scale = 60000L;
            } else if (unit.equals("h") || unit.equals("hr")) {
                scale = 3600000L;
            }
            return actualValue *= scale;
        }
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException ex) {
            throw new DataspaceException("Failed to convert interval value " + value + ".", ex);
        }
    }

    private void log(Trace.Level level, String message, Object ... args) {
        message = "Checkpoint[lastStartTime=" + (this.lastCheckpointAttemptTimestamp != 0L ? AbstractDSLOperation.formatDateMillis(this.lastCheckpointAttemptTimestamp) : "none") + ", lastSuccessTime=" + (this.lastCheckpointSuccessfulTimestamp != 0L ? AbstractDSLOperation.formatDateMillis(this.lastCheckpointSuccessfulTimestamp) : "none") + ", Initiated by " + (this.checkpointManagedByMVCC ? "MVCC" : "Scheduler") + ", required=" + this.checkpointRequired + ", logSize=" + SizeUnit.convertToBestEvent(this.getLogSize(), SizeUnit.BYTES).toStringWithPrecision(2) + ", recoveryLogSize=" + SizeUnit.convertToBestEvent(this.getRecoveryLogSize(), SizeUnit.BYTES).toStringWithPrecision(2) + "]: " + (String)message;
        Trace.log(this, level, (String)message, args);
        switch (level) {
            case ERROR: {
                break;
            }
            case INFO: {
                break;
            }
        }
    }

    public static class CheckpointStats {
        private long startTime;
        private int attemptsCount;
        private int attemptsCountAuto;
        private int successCount;
        private long autoDuration;
        private Queue<CheckpointAttempt> attempts = new ConcurrentLinkedQueue<CheckpointAttempt>();
        private static final long ATTEMPTS_PERIOD = TimeUnit.DAYS.toMillis(14L);

        public CheckpointStats() {
            this.startTime = System.currentTimeMillis();
        }

        public void incAttemptsCount() {
            ++this.attemptsCount;
        }

        public void incAttemptsCountAuto() {
            ++this.attemptsCountAuto;
        }

        public void incSuccessCount() {
            ++this.successCount;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public int getAttemptsCount() {
            return this.attemptsCount;
        }

        public int getAttemptsCountAuto() {
            return this.attemptsCountAuto;
        }

        public int getSuccessCount() {
            return this.successCount;
        }

        public int getFailCount() {
            return this.attemptsCount - this.successCount;
        }

        public long getAverageAutoDuration() {
            return this.attemptsCountAuto > 0 ? this.autoDuration / (long)this.attemptsCountAuto : 0L;
        }

        public void addAttempt(CheckpointAttempt checkpointAttempt) {
            CheckpointAttempt attempt = this.attempts.peek();
            while (attempt != null && System.currentTimeMillis() - attempt.getStartTimestamp() >= ATTEMPTS_PERIOD) {
                this.attempts.poll();
                attempt = this.attempts.peek();
            }
            if (this.attempts.size() > 2000) {
                this.attempts.poll();
            }
            this.attempts.add(checkpointAttempt);
            if (checkpointAttempt.isAuto()) {
                this.autoDuration += checkpointAttempt.getDuration();
            }
        }

        public Queue<CheckpointAttempt> getAttempts() {
            return this.attempts;
        }

        public static class CheckpointAttempt {
            private CheckpointAction action;
            private long startTimestamp;
            private long endTimestamp;
            private long lockEndTimestamp;
            private long lockStartTimestamp;
            private final long lockTimeout;
            private boolean success;
            private boolean defrag;
            private long logSize;
            private boolean forcedDefrag;
            private DataspaceStoreDuplicatesResolver.DataspaceStoreDuplicates duplicatesBefore;
            private DataspaceStoreDuplicatesResolver.DataspaceStoreDuplicates duplicatesAfter;

            public CheckpointAttempt(CheckpointAction action, long startTimestamp, long lockTimeout, boolean defrag, long logSize) {
                this.action = action;
                this.startTimestamp = startTimestamp;
                this.lockTimeout = lockTimeout;
                this.defrag = defrag;
                this.logSize = logSize;
            }

            public CheckpointAttempt(long startTimestamp, long lockTimeout, boolean defrag, long logSize) {
                this(null, startTimestamp, lockTimeout, defrag, logSize);
            }

            public void setSuccess(boolean success) {
                this.success = success;
            }

            public CheckpointAction getAction() {
                return this.action;
            }

            public long getLockTimeout() {
                return this.lockTimeout;
            }

            public long getStartTimestamp() {
                return this.startTimestamp;
            }

            public long getEndTimestamp() {
                return this.endTimestamp;
            }

            public boolean isSuccess() {
                return this.success;
            }

            public void setEndTimestamp(long endTimestamp) {
                this.endTimestamp = endTimestamp;
            }

            public long getDuration() {
                long duration = this.endTimestamp - this.startTimestamp;
                if (this.duplicatesBefore != null) {
                    duration -= this.duplicatesBefore.durationMs;
                }
                if (this.duplicatesAfter != null) {
                    duration -= this.duplicatesAfter.durationMs;
                }
                return duration;
            }

            public boolean isAuto() {
                return this.action != null;
            }

            public boolean isDefrag() {
                return this.defrag;
            }

            public boolean isForcedDefrag() {
                return this.forcedDefrag;
            }

            public long getLogSize() {
                return this.logSize;
            }

            public void setLockEndTimestamp(long lockEndTimestamp) {
                this.lockEndTimestamp = lockEndTimestamp;
            }

            public long getLockEndTimestamp() {
                return this.lockEndTimestamp;
            }

            public void setLockStartTimestamp(long lockStartTimestamp) {
                this.lockStartTimestamp = lockStartTimestamp;
            }

            public long getLockStartTimestamp() {
                return this.lockStartTimestamp;
            }

            public long getLockDuration() {
                return this.lockEndTimestamp - this.lockStartTimestamp;
            }

            public void setForcedDefrag(boolean forcedDefrag) {
                this.forcedDefrag = forcedDefrag;
            }

            public void setDuplicatesBefore(DataspaceStoreDuplicatesResolver.DataspaceStoreDuplicates duplicatesBefore) {
                this.duplicatesBefore = duplicatesBefore;
            }

            public void setDuplicatesAfter(DataspaceStoreDuplicatesResolver.DataspaceStoreDuplicates duplicatesAfter) {
                this.duplicatesAfter = duplicatesAfter;
            }

            public DataspaceStoreDuplicatesResolver.DataspaceStoreDuplicates getDuplicatesBefore() {
                return this.duplicatesBefore;
            }

            public DataspaceStoreDuplicatesResolver.DataspaceStoreDuplicates getDuplicatesAfter() {
                return this.duplicatesAfter;
            }
        }
    }

    public class CheckpointExecutor
    implements Runnable {
        private BlockingQueue<CheckpointAction> queue = new LinkedBlockingQueue<CheckpointAction>();
        private volatile boolean running = true;

        @Override
        public void run() {
            try {
                this.runInternal();
            }
            catch (Exception exception) {
                Trace.logException(this, exception, true);
            }
            if (this.running && CheckpointManager.this.started) {
                CheckpointManager.this.log(Trace.Level.INFO, "Re-running checkpoint executor thread.", new Object[0]);
                CheckpointManager.this.start();
            }
        }

        private void runInternal() {
            CheckpointManager.this.log(Trace.Level.INFO, "Checkpoint manager thread started.", new Object[0]);
            while (!Thread.interrupted() && this.running) {
                CheckpointAction action;
                block9: {
                    action = null;
                    try {
                        action = this.queue.poll(10L, TimeUnit.SECONDS);
                        if (action == null) continue;
                        if (action == CheckpointAction.CHECKPOINT_STOP) {
                            Trace.logInfo(this, "CheckpointExecutor thread is stopped.");
                        }
                        break block9;
                    }
                    catch (InterruptedException exception) {
                        Trace.logInfo(this, "CheckpointExecutor thread is interrupted.");
                    }
                    break;
                }
                if (!this.running) break;
                CheckpointManager.this.log(Trace.Level.DEBUG, "Checkpoint action: {}.", new Object[]{action});
                long timeSinceCheckpointSuccessful = System.currentTimeMillis() - CheckpointManager.this.lastCheckpointSuccessfulTimestamp;
                long timeSinceCheckpointAttempt = System.currentTimeMillis() - CheckpointManager.this.lastCheckpointAttemptTimestamp;
                if (action == CheckpointAction.CHECKPOINT_BY_TIMER) {
                    if (CheckpointManager.this.checkpointManagedByMVCC || CheckpointManager.this.checkpointRequired) {
                        if (timeSinceCheckpointAttempt >= CheckpointManager.this.checkpointIntervalRepeat) {
                            this.executeCheckpointAutoAndSchedule(action);
                            continue;
                        }
                        CheckpointManager.this.scheduleCheckpointIn(CheckpointManager.this.checkpointIntervalRepeat - timeSinceCheckpointAttempt);
                        continue;
                    }
                    if (timeSinceCheckpointSuccessful < CheckpointManager.this.checkpointInterval) {
                        CheckpointManager.this.scheduleCheckpointIn(CheckpointManager.this.checkpointInterval - timeSinceCheckpointSuccessful + 10L);
                        continue;
                    }
                    this.executeCheckpointAutoAndSchedule(action);
                    continue;
                }
                if (action == CheckpointAction.CHECKPOINT_BY_MVCC) {
                    if (CheckpointManager.this.checkpointInterval != -1L && timeSinceCheckpointSuccessful < CheckpointManager.this.checkpointIntervalRepeat && CheckpointManager.this.logSizeMax != -1L && CheckpointManager.this.getRecoveryLogSize() <= CheckpointManager.this.logSizeMax) continue;
                    this.executeCheckpointAutoAndReschedule(action);
                    continue;
                }
                if (action != CheckpointAction.CHECKPOINT_REQUIRED) continue;
                this.executeCheckpointAutoAndReschedule(action);
            }
            CheckpointManager.this.log(Trace.Level.INFO, "Checkpoint manager thread finished.", new Object[0]);
        }

        private synchronized void executeCheckpointAutoAndSchedule(CheckpointAction action) {
            long lastCheckpointSuccessfulTimestampOld = CheckpointManager.this.lastCheckpointSuccessfulTimestamp;
            this.executeCheckpoint(action, false, true, this.getCheckpointLockTimeout());
            if (lastCheckpointSuccessfulTimestampOld == CheckpointManager.this.lastCheckpointSuccessfulTimestamp) {
                CheckpointManager.this.scheduleCheckpointIn(CheckpointManager.this.checkpointIntervalRepeat);
            } else {
                CheckpointManager.this.scheduleCheckpointIn(CheckpointManager.this.checkpointInterval);
            }
        }

        private synchronized void executeCheckpointAutoAndReschedule(CheckpointAction action) {
            long lastCheckpointSuccessfulTimestampOld = CheckpointManager.this.lastCheckpointSuccessfulTimestamp;
            this.executeCheckpoint(action, false, true, this.getCheckpointLockTimeout());
            if (lastCheckpointSuccessfulTimestampOld == CheckpointManager.this.lastCheckpointSuccessfulTimestamp) {
                CheckpointManager.this.rescheduleCheckpointIn(CheckpointManager.this.checkpointIntervalRepeat);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void executeCheckpoint(CheckpointAction action, boolean withDefrag, boolean auto, long lockTimeout) {
            block14: {
                if (CheckpointManager.this.checkpointDisabled) {
                    return;
                }
                this.checkCheckpointCounts();
                Session sysSession = null;
                CheckpointStats.CheckpointAttempt checkpointAttempt = new CheckpointStats.CheckpointAttempt(action, System.currentTimeMillis(), lockTimeout, withDefrag, CheckpointManager.this.store.checkpointManager.getRecoveryLogSize());
                try {
                    CheckpointManager.this.checkpointInProgress = true;
                    String ddxUserName = DataspaceStoreManager.getRuntimeContext().getDeploymentDescriptor().getSecurityPrincipal();
                    try {
                        User user = DataspaceStoreManager.getRuntimeContext().getSecurityManager().lookupUser(ddxUserName);
                        sysSession = CheckpointManager.this.store.connect(user);
                        sysSession.setDataspace("SYS");
                        CheckpointManager.this.setLastCheckpointAttemptTimestamp(auto);
                        CheckpointManager.this.log(Trace.Level.DEBUG, "Start checkpoint execution, defrag: {}, auto: {}, lockTimeout: {}.", withDefrag, auto, lockTimeout);
                        Statement checkpoint = CheckpointManager.this.getCheckpointStatement(false, true, lockTimeout, checkpointAttempt);
                        Result result = sysSession.executeCompiledStatement(checkpoint, ValuePool.emptyObjectArray);
                        checkpointAttempt.setSuccess(!result.isError());
                        if (!auto) break block14;
                        Object object = CheckpointManager.this.propertiesMutex;
                        synchronized (object) {
                            CheckpointManager.this.checkpointManagedByMVCC = true;
                            CheckpointManager.this.updateCheckpointResult(result);
                        }
                    }
                    catch (Exception error) {
                        CheckpointManager.this.log(Trace.Level.DEBUG, "Checkpoint exception.", new Object[0]);
                        Trace.logException(this, error, true);
                        if (auto) {
                            CheckpointManager.this.updateCheckpointResult(Result.newErrorResult(error));
                        }
                        Trace.logError(this, error.getMessage());
                        Trace.logException(this, error, true);
                    }
                }
                catch (Exception e) {
                    checkpointAttempt.setSuccess(false);
                }
                finally {
                    checkpointAttempt.setEndTimestamp(System.currentTimeMillis());
                    if (auto) {
                        CheckpointManager.this.totalStats.addAttempt(checkpointAttempt);
                        CheckpointManager.this.localStats.addAttempt(checkpointAttempt);
                    }
                    CheckpointManager.this.checkpointInProgress = false;
                    if (sysSession != null) {
                        sysSession.close();
                    }
                }
            }
        }

        private void checkCheckpointCounts() {
        }

        private long getCheckpointLockTimeout() {
            long logSize = CheckpointManager.this.getRecoveryLogSize();
            long timeSinceLastSuccessfulCheckpoint = CheckpointManager.this.getTimeSinceLastSuccessfulCheckpoint();
            if (CheckpointManager.this.logSizeCritical > 0L && logSize >= CheckpointManager.this.logSizeCritical || CheckpointManager.this.checkpointIntervalCritical > 0L && timeSinceLastSuccessfulCheckpoint >= CheckpointManager.this.checkpointIntervalCritical) {
                CheckpointManager.this.log(Trace.Level.INFO, "WARNING: executing checkpoint with lock because {}", CheckpointManager.this.logSizeCritical > 0L && logSize >= CheckpointManager.this.logSizeCritical ? "log size is critical" : "time without checkpoint in critical");
                return 0L;
            }
            if (logSize < CheckpointManager.this.logSizeMax) {
                return CheckpointManager.this.checkpointLockTimeout1;
            }
            if (logSize < CheckpointManager.this.logSizeCritical) {
                return CheckpointManager.this.checkpointLockTimeout2;
            }
            CheckpointManager.this.log(Trace.Level.INFO, "WARNING: executing checkpoint with lock because log size is critical", new Object[0]);
            return 0L;
        }
    }

    public static enum CheckpointAction {
        CHECKPOINT_STOP("stop"),
        CHECKPOINT_BY_TIMER("timer"),
        CHECKPOINT_BY_MVCC("mvcc"),
        CHECKPOINT_REQUIRED("request"),
        CHECKPOINT_SYSTEM("system");

        private final String name;

        private CheckpointAction(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

