/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds;

import com.streamscape.Logger;
import com.streamscape.Trace;
import com.streamscape.cli.ds.CollectionFactory;
import com.streamscape.cli.ds.CollectionType;
import com.streamscape.cli.ds.DataCollection;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.ds.CollectionFactoryFactory;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceLogger;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.advisory.DataspaceStateAdvisoriesFactory;
import com.streamscape.ds.advisory.StateAdvisories;
import com.streamscape.ds.lib.Iterator;
import com.streamscape.ds.lib.WrapperIterator;
import com.streamscape.ds.mf.DataspaceLexiconProcessor;
import com.streamscape.ds.mf.DataspaceMFSession;
import com.streamscape.ds.navigator.RowSetNavigatorClient;
import com.streamscape.ds.persist.TableTypesValidator;
import com.streamscape.ds.replication.ReplicationManager;
import com.streamscape.ds.replication.ReplicationTarget;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.rights.Grantee;
import com.streamscape.ds.schema.DataspaceSchema;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.SchemaObjectSet;
import com.streamscape.ds.schema.collection.AbstractCollection;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.collection.CollectionMetaData;
import com.streamscape.ds.schema.collection.CollectionMetaDataImpl;
import com.streamscape.ds.schema.collection.qspace.pqueue.ProcessQueueCollection;
import com.streamscape.ds.schema.collection.stream.SourceStreamCollection;
import com.streamscape.ds.schema.event.Actor;
import com.streamscape.ds.schema.procedure.RoutineSchema;
import com.streamscape.ds.schema.procedure.RplScript;
import com.streamscape.ds.schema.server.ServerObject;
import com.streamscape.ds.schema.timer.TimerMetaData;
import com.streamscape.ds.schema.timer.TimerObject;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.state.DataspaceStateHolder;
import com.streamscape.ds.trigger.AbstractReplicationEventTrigger;
import com.streamscape.ds.trigger.EventTriggerDefSQL;
import com.streamscape.ds.trigger.ReplicationModifyTrigger;
import com.streamscape.ds.trigger.ReplicationValidateTrigger;
import com.streamscape.ds.trigger.SystemEventTrigger;
import com.streamscape.ds.trigger.SystemEventTriggerType;
import com.streamscape.ds.trigger.TriggerDef;
import com.streamscape.sdo.excp.DatabaseSQLException;
import com.streamscape.sdo.operation.SLCallable;
import com.streamscape.sef.EventTriggerCompileException;
import com.streamscape.sef.EventTriggerState;
import com.streamscape.sef.FabricNamingException;
import com.streamscape.sef.IllegalTriggerStateException;
import com.streamscape.sef.advisories.StateAdvisoryDefinition;
import com.streamscape.sef.dataspace.DataspaceComponentException;
import com.streamscape.sef.dispatcher.SLOperationLogger;
import com.streamscape.sef.enums.ComponentState;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.evtrigger.EventTriggerDefinition;
import com.streamscape.sef.evtrigger.TriggerActionTime;
import com.streamscape.sef.moderator.Moderator;
import com.streamscape.sef.security.User;
import com.streamscape.service.osf.config.EventTriggerData;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.SemanticLexiconProcessor;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class AbstractDataspace
extends DataspaceSchema
implements Logger,
SLCallable {
    protected DataspaceStore store = null;
    protected ReplicationManager replicationManager = null;
    protected CollectionFactoryFactory collectionFactoryFactories = null;
    protected Map<String, CollectionFactory> collectionFactories = null;
    protected long lastCheckTime = 0L;

    public AbstractDataspace(NameManager.ObjectName name, DataspaceType type, EventScope scope, Grantee owner, DataspaceStore store) throws FabricNamingException {
        super(name, type, owner);
        this.isComponent = !systemSchemas.contains(name.name);
        this.setStore(store);
        this.eventScope = scope;
        this.eventTriggers = new HashMap();
        this.collectionFactoryFactories = new CollectionFactoryFactory();
        this.collectionFactories = new HashMap<String, CollectionFactory>();
        this.assignDescription(type);
    }

    @Override
    public String getFullName() {
        return super.getFullName();
    }

    @Override
    protected String findCurrentOwnerName() {
        return this.name.owner.getObjectName().name;
    }

    public SchemaObjectSet getTypeLookup() {
        return this.typeLookup;
    }

    public SchemaObjectSet getCharsetLookup() {
        return this.charsetLookup;
    }

    public Session createSession() {
        String ddxUserName = this.context.getDeploymentDescriptor().getSecurityPrincipal();
        User user = null;
        try {
            user = this.context.getSecurityManager().lookupUser(ddxUserName);
        }
        catch (Exception error) {
            Trace.logError(this, error.getMessage());
        }
        return this.createSession(user);
    }

    public Session createSystemSession() {
        User user = null;
        try {
            user = this.context.getSecurityManager().lookupUser(this.context.getDeploymentDescriptor().getSecurityPrincipal());
        }
        catch (Exception error) {
            Trace.logException(this, error, true);
        }
        return this.createSession(user, true);
    }

    public Session createSession(User user) {
        return this.createSession(user, false);
    }

    private Session createSession(User user, boolean forLog) {
        Session session = this.store.connect(user);
        session.isProcessingRecoveryLog = forLog;
        session.setDataspace(this.getName());
        return session;
    }

    public void execute(String statement, MFSession session) throws DatabaseSQLException {
        if (!(session instanceof DataspaceMFSession)) {
            throw new IllegalStateException("Wrong session has been passed during operation execution.");
        }
        Session sqlSession = ((DataspaceMFSession)session).getSession();
        sqlSession.executeDirectStatement(statement);
    }

    protected void loadEventTriggers() throws DataspaceException {
        Trace.logDebug(this, "Initializing event triggers...");
        try {
            List<String> triggers = this.listEventTriggers();
            for (String trigger : triggers) {
                this.compileEventTrigger(trigger);
            }
        }
        catch (EventTriggerCompileException error) {
            error.printStackTrace();
            throw new DataspaceException(error);
        }
        Trace.logDebug(this, "Initialized event triggers.");
    }

    @Override
    public void logDebug(String message) {
        if (this.logger != null) {
            this.logger.logDebug(this.logger instanceof DataspaceLogger ? message : this.buildTraceMessage(message));
        } else {
            Trace.logDebug(this, this.buildTraceMessage(message));
        }
    }

    @Override
    public void logDebug(String entity, String message) {
        if (this.logger != null) {
            if (this.logger instanceof DataspaceLogger) {
                ((DataspaceLogger)this.logger).logDebug(entity, message);
            } else {
                this.logger.logDebug(this.buildTraceMessage(entity, message));
            }
        } else {
            Trace.logDebug(this, this.buildTraceMessage(entity, message));
        }
    }

    @Override
    public void logError(String message) {
        if (this.logger != null) {
            this.logger.logError(this.logger instanceof DataspaceLogger ? message : this.buildTraceMessage(message));
        } else {
            Trace.logError(this, this.buildTraceMessage(message));
        }
    }

    @Override
    public void logError(String entity, String message) {
        if (this.logger != null) {
            if (this.logger instanceof DataspaceLogger) {
                ((DataspaceLogger)this.logger).logError(entity, message);
            } else {
                this.logger.logError(this.buildTraceMessage(entity, message));
            }
        } else {
            Trace.logError(this, this.buildTraceMessage(entity, message));
        }
    }

    @Override
    public void logInfo(String message) {
        if (this.logger != null) {
            this.logger.logInfo(this.logger instanceof DataspaceLogger ? message : this.buildTraceMessage(message));
        } else {
            Trace.logInfo(this, this.buildTraceMessage(message));
        }
    }

    @Override
    public void logInfo(String entity, String message) {
        if (this.logger != null) {
            if (this.logger instanceof DataspaceLogger) {
                ((DataspaceLogger)this.logger).logInfo(entity, message);
            } else {
                this.logger.logInfo(this.buildTraceMessage(entity, message));
            }
        } else {
            Trace.logInfo(this, this.buildTraceMessage(entity, message));
        }
    }

    private String buildTraceMessage(String message) {
        return "[" + this.getType() + "/" + this.getName() + "] " + message;
    }

    private String buildTraceMessage(String entity, String message) {
        return this.buildTraceMessage("[" + entity + "] " + message);
    }

    public SemanticLexiconProcessor getLexiconProcessor() {
        return this.lexiconProcessor;
    }

    public Moderator getModerator() {
        return this.moderator;
    }

    @Override
    protected void doInit(Session session) {
        super.doInit(session);
        if (this.replicationManager == null) {
            this.replicationManager = new ReplicationManager(this);
        }
        if (this.isComponent) {
            if (this.eventScope != EventScope.LOCAL) {
                this.createSessionManager();
            }
            SLOperationLogger.log("  Initializing Lexicon Processor...");
            this.lexiconProcessor = new DataspaceLexiconProcessor(this, this.context);
            SLOperationLogger.log(" done.\n");
        }
    }

    @Override
    protected void doDestroy(Session session) {
        this.destroySessionManager();
        super.doDestroy(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doOpen(Session session) {
        Object schemaObject;
        try {
            this.advisoriesFactory = new DataspaceStateAdvisoriesFactory(this);
            if (this.isComponent) {
                this.bindAdvisories();
                this.replicationManager.open(session);
            }
        }
        catch (DataspaceComponentException error) {
            throw new DataspaceException("Dataspace opening failed.", error);
        }
        Iterator iter = this.store.schemaManager.dataspaceObjectIterator(this.getName(), 4);
        while (iter.hasNext()) {
            schemaObject = iter.next();
            if (!(schemaObject instanceof Collection)) continue;
            this.wrapInLoggedOpening("collection", schemaObject, () -> {
                ((Collection)schemaObject).open(session);
                if (((Collection)schemaObject).getReplicationSource() != null) {
                    ((Collection)schemaObject).getReplicationSource().open(session);
                }
                if (schemaObject instanceof ProcessQueueCollection) {
                    ((ProcessQueueCollection)schemaObject).startPoller();
                }
            });
        }
        iter = this.store.schemaManager.dataspaceObjectIterator(this.getName(), 27);
        while (iter.hasNext()) {
            schemaObject = iter.next();
            if (!(schemaObject instanceof ServerObject)) continue;
            this.wrapInLoggedOpening("server", schemaObject, () -> ((ServerObject)schemaObject).open(session));
        }
        iter = this.store.schemaManager.dataspaceObjectIterator(this.getName(), 29);
        while (iter.hasNext()) {
            schemaObject = iter.next();
            if (!(schemaObject instanceof ReplicationTarget)) continue;
            this.wrapInLoggedOpening("replication target", schemaObject, () -> {
                ((ReplicationTarget)schemaObject).open(session);
                ((ReplicationTarget)schemaObject).attachToSource(session);
            });
        }
        iter = this.store.schemaManager.dataspaceObjectIterator(this.getName(), 17);
        while (iter.hasNext()) {
            schemaObject = iter.next();
            if (!(schemaObject instanceof RoutineSchema)) continue;
            this.wrapInLoggedOpening("function", schemaObject, () -> {
                if (((RoutineSchema)schemaObject).routines != null) {
                    for (RplScript routine : ((RoutineSchema)schemaObject).routines) {
                        routine.open(session);
                    }
                }
            });
        }
        session.disableReplication(true);
        try {
            iter = this.store.schemaManager.dataspaceObjectIterator(this.getName(), 9);
            while (iter.hasNext()) {
                schemaObject = iter.next();
                if (!(schemaObject instanceof SystemEventTrigger)) continue;
                SystemEventTrigger systemTrigger = (SystemEventTrigger)schemaObject;
                if (systemTrigger.isAutoEnable()) {
                    systemTrigger.enable(session);
                }
                try {
                    if (systemTrigger.getSystemTriggerType() == SystemEventTriggerType.MATERIALIZE) {
                        this.wrapInLogged("  Executing materialize trigger " + systemTrigger.getObjectName().name + "...", () -> systemTrigger.execute(session));
                    }
                    session.commit(false);
                }
                catch (Throwable error) {
                    Trace.logError(this, "Execution of the system trigger '" + systemTrigger.getObjectName().name + "' failed. " + error.getMessage());
                    session.rollback(false);
                }
            }
        }
        finally {
            session.disableReplication(false);
        }
        iter = this.store.schemaManager.dataspaceObjectIterator(this.getName(), 32);
        while (iter.hasNext()) {
            schemaObject = iter.next();
            if (!(schemaObject instanceof Actor) || !((Actor)schemaObject).isAutoEnable()) continue;
            this.wrapInLoggedEnabling("actor", schemaObject, () -> ((Actor)schemaObject).enable(session));
        }
        iter = this.store.schemaManager.dataspaceObjectIterator(this.getName(), 9);
        while (iter.hasNext()) {
            EventTriggerDefSQL eventTrigger;
            schemaObject = iter.next();
            if (schemaObject instanceof EventTriggerDefSQL) {
                eventTrigger = (EventTriggerDefSQL)schemaObject;
                if (!eventTrigger.isAutoEnable() || eventTrigger instanceof ReplicationValidateTrigger || eventTrigger instanceof ReplicationModifyTrigger) continue;
                this.wrapInLoggedEnabling("trigger", schemaObject, () -> eventTrigger.enable(session));
                continue;
            }
            if (!(schemaObject instanceof AbstractReplicationEventTrigger) || !(eventTrigger = (AbstractReplicationEventTrigger)schemaObject).isAutoEnable()) continue;
            this.wrapInLoggedEnabling("trigger", schemaObject, () -> AbstractDataspace.lambda$doOpen$7((AbstractReplicationEventTrigger)eventTrigger, session));
        }
    }

    protected void wrapInLoggedEnabling(String name, Object schemaObject, Runnable runnable) {
        this.wrapInLogged("  Enabling " + name + " " + ((SchemaObject)schemaObject).getObjectName().name + "...", runnable);
    }

    protected void wrapInLoggedDisabling(String name, Object schemaObject, Runnable runnable) {
        this.wrapInLogged("  Disabling " + name + " " + ((SchemaObject)schemaObject).getObjectName().name + "...", runnable);
    }

    protected void wrapInLoggedOpening(String name, Object schemaObject, Runnable runnable) {
        this.wrapInLogged("  Opening " + name + " " + ((SchemaObject)schemaObject).getObjectName().name + "...", runnable);
    }

    protected void wrapInLoggedClosing(String name, Object schemaObject, Runnable runnable) {
        this.wrapInLogged("  Closing " + name + " " + ((SchemaObject)schemaObject).getObjectName().name + "...", runnable);
    }

    protected void wrapInLogged(String message, Runnable runnable) {
        SLOperationLogger.log(message);
        runnable.run();
        SLOperationLogger.log(" done.\n");
    }

    @Override
    public void persist(Session session) {
        Iterator iter = this.store.schemaManager.dataspaceObjectIterator(this.getName(), 9);
        while (iter.hasNext()) {
            SystemEventTrigger systemTrigger;
            Object schemaObject = iter.next();
            if (!(schemaObject instanceof SystemEventTrigger) || (systemTrigger = (SystemEventTrigger)schemaObject).getSystemTriggerType() != SystemEventTriggerType.PERSIST) continue;
            systemTrigger.execute(session);
        }
    }

    @Override
    protected void doClose(Session session) {
        Object schemaObject;
        this.replicationManager.close(session);
        Iterator iter = this.store.schemaManager.dataspaceObjectIterator(this.getName(), 4);
        while (iter.hasNext()) {
            RplScript[] collection;
            schemaObject = iter.next();
            if (schemaObject instanceof SourceStreamCollection) {
                this.wrapInLogged("  Stopping source stream " + ((SourceStreamCollection)schemaObject).getObjectName().name, () -> ((SourceStreamCollection)schemaObject).stop(null));
            }
            if ((collection = (RplScript[])schemaObject).getReplicationSource() != null) {
                collection.getReplicationSource().close(session);
            }
            this.wrapInLoggedClosing("collection", collection, () -> AbstractDataspace.lambda$doClose$9((Collection)collection));
        }
        iter = this.store.schemaManager.dataspaceObjectIterator(this.getName(), 29);
        while (iter.hasNext()) {
            schemaObject = iter.next();
            if (!(schemaObject instanceof ReplicationTarget)) continue;
            ((ReplicationTarget)schemaObject).detachFromSource(session, true);
        }
        this.replicationManager.close2(session);
        iter = this.store.schemaManager.dataspaceObjectIterator(this.getName(), 32);
        while (iter.hasNext()) {
            schemaObject = iter.next();
            if (!(schemaObject instanceof Actor)) continue;
            this.wrapInLoggedClosing("actor", schemaObject, () -> ((Actor)schemaObject).disable());
        }
        iter = this.store.schemaManager.dataspaceObjectIterator(this.getName(), 17);
        while (iter.hasNext()) {
            schemaObject = iter.next();
            if (!(schemaObject instanceof RoutineSchema) || ((RoutineSchema)schemaObject).routines == null) continue;
            for (RplScript routine : ((RoutineSchema)schemaObject).routines) {
                this.wrapInLoggedClosing("function", routine, () -> routine.close());
            }
        }
        iter = this.store.schemaManager.dataspaceObjectIterator(this.getName(), 27);
        while (iter.hasNext()) {
            schemaObject = iter.next();
            if (!(schemaObject instanceof ServerObject)) continue;
            this.wrapInLoggedClosing("server", schemaObject, () -> ((ServerObject)schemaObject).stopServerWithoutStateUpdate(session));
        }
        iter = this.store.schemaManager.dataspaceObjectIterator(this.getName(), 9);
        while (iter.hasNext()) {
            schemaObject = iter.next();
            if (!(schemaObject instanceof EventTriggerDefSQL)) continue;
            EventTriggerDefSQL eventTrigger = (EventTriggerDefSQL)schemaObject;
            this.wrapInLoggedDisabling("trigger", eventTrigger, () -> eventTrigger.disable());
        }
    }

    @Override
    public List<String> listEventTriggers() {
        return this.executeWithSysSession(session -> this.listEventTriggers((Session)session));
    }

    public List<String> listEventTriggers(Session session) {
        ArrayList<String> triggers = new ArrayList<String>();
        Iterator iter = this.store.schemaManager.dataspaceObjectIterator(this.name.name, 9);
        while (iter.hasNext()) {
            TriggerDef trigger = (TriggerDef)iter.next();
            triggers.add(trigger.getObjectName().name);
        }
        return triggers;
    }

    @Override
    public boolean existsEventTrigger(String triggerName) {
        return this.executeWithSysSession(session -> this.existsEventTrigger((Session)session, triggerName));
    }

    public boolean existsEventTrigger(Session session, String triggerName) {
        SchemaObject object = this.store.schemaManager.getSchemaObject(triggerName, this.name.name, 9);
        return object instanceof EventTriggerDefSQL;
    }

    @Override
    public List<StateAdvisoryDefinition> getStateAdvisoryDefinitions() {
        return StateAdvisories.getStateAdvisoryDefinitions();
    }

    public boolean hasEventTriggers(Session session) {
        Iterator iter = this.store.schemaManager.dataspaceObjectIterator(this.name.name, 9);
        while (iter.hasNext()) {
            if (!(iter.next() instanceof EventTriggerDefSQL)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasEventTriggers() {
        return this.executeWithSysSession(session -> this.hasEventTriggers((Session)session));
    }

    public boolean existsActionableEvent(Session session, String eventId) {
        return this.store.existsActionableEvent(session, this.getName(), eventId);
    }

    @Override
    public boolean existsActionableEvent(String eventId) {
        return this.executeWithSysSession(session -> this.existsActionableEvent((Session)session, eventId));
    }

    @Override
    public boolean hasActionableEvents() {
        return false;
    }

    public List<String> listActionableEvents(Session session) {
        return this.store.listActionableEvents(session, this.getName());
    }

    @Override
    public List<String> listActionableEvents() {
        return this.executeWithSysSession(session -> this.listActionableEvents((Session)session));
    }

    public EventTriggerDefinition getEventTriggerDefinition(Session session, String triggerName) {
        SchemaObject trigger = this.store.schemaManager.getSchemaObject(triggerName, this.name.name, 9);
        if (trigger instanceof EventTriggerDefSQL) {
            return ((EventTriggerDefSQL)trigger).getTriggerDefinition();
        }
        return null;
    }

    @Override
    public EventTriggerDefinition getEventTriggerDefinition(String triggerName) throws ServiceConfigurationException {
        return this.executeWithSysSession(session -> this.getEventTriggerDefinition((Session)session, triggerName));
    }

    public List<EventTriggerDefinition> getEventTriggerDefinitions(Session session) {
        ArrayList<EventTriggerDefinition> definitions = new ArrayList<EventTriggerDefinition>();
        Iterator iter = this.store.schemaManager.dataspaceObjectIterator(this.name.name, 9);
        while (iter.hasNext()) {
            Object trigger = iter.next();
            if (!(trigger instanceof EventTriggerDefSQL)) continue;
            definitions.add(((EventTriggerDefSQL)trigger).getTriggerDefinition());
        }
        return definitions;
    }

    @Override
    public List<EventTriggerDefinition> getEventTriggerDefinitions() {
        return this.executeWithSysSession(session -> this.getEventTriggerDefinitions((Session)session));
    }

    @Override
    public void addEventTrigger(String triggerSyntax) throws ServiceConfigurationException {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public void alterEventTrigger(String triggerSyntax) throws ServiceConfigurationException {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public String getEventTriggerSyntax(String triggerName) throws ServiceConfigurationException {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public EventTriggerData getEventTriggerData(String triggerName) throws ServiceConfigurationException {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public boolean isEventTriggerAutoEnable(String triggerName) throws IllegalTriggerStateException {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public void setEventTriggerAutoEnable(String triggerName, boolean autoEnable) throws IllegalTriggerStateException, ServiceConfigurationException {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public boolean existsAdvisory(String eventId) {
        return false;
    }

    public boolean hasAdvisories(Session session) {
        return this.store.hasAdvisories(session, this.getName());
    }

    @Override
    public boolean hasAdvisories() {
        return this.executeWithSysSession(session -> this.hasAdvisories((Session)session));
    }

    @Override
    public List<String> listAdvisories() {
        return null;
    }

    public void disable(Session session, String triggerName) {
    }

    @Override
    public void disableEventTrigger(String triggerName) {
        this.executeWithSysSessionNoReturn(session -> this.disable((Session)session, triggerName));
    }

    public void enable(Session session, String triggerName) {
    }

    @Override
    public void enableEventTrigger(String triggerName) {
        this.executeWithSysSessionNoReturn(session -> this.enable((Session)session, triggerName));
    }

    public void removeAllEventTriggers(Session session) {
    }

    @Override
    public void removeAllEventTriggers() throws ServiceConfigurationException, IllegalTriggerStateException {
        this.executeWithSysSessionNoReturn(session -> this.removeAllEventTriggers((Session)session));
    }

    public void removeEventTrigger(Session session, String triggerName) {
    }

    @Override
    public void removeEventTrigger(String triggerName) throws ServiceConfigurationException {
        this.executeWithSysSessionNoReturn(session -> this.removeEventTrigger((Session)session, triggerName));
    }

    @Override
    public List<String> listSinkEvents() {
        return null;
    }

    @Override
    public boolean hasSinkEvents() {
        return false;
    }

    @Override
    public String getLastError(String triggerName) {
        SchemaObject trigger = this.store.schemaManager.getSchemaObject(triggerName, this.name.name, 9);
        if (trigger instanceof EventTriggerDefSQL) {
            return ((EventTriggerDefSQL)trigger).aggregateStateHolder().getLastError();
        }
        return null;
    }

    @Override
    public TriggerActionTime getTriggerActionTime(String triggerName) {
        return null;
    }

    @Override
    public EventTriggerState getTriggerState(String triggerName) {
        SchemaObject trigger = this.store.schemaManager.getSchemaObject(triggerName, this.name.name, 9);
        if (trigger instanceof EventTriggerDefSQL) {
            return ((EventTriggerDefSQL)trigger).getTriggerState();
        }
        return null;
    }

    @Override
    protected void doEnableEventTrigger(String triggerName) {
    }

    @Override
    protected void doDisableEventTrigger(String triggerName) {
    }

    @Override
    protected String getTriggerActionableEventId(String triggerName) {
        return null;
    }

    public CollectionFactory createCollectionFactory(Session session, CollectionType type) throws DataspaceComponentException {
        return this.collectionFactoryFactories.instantiateCollectionFactory(type, this);
    }

    public void storeCollectionFactory(Session session, String name, CollectionFactory factory) throws DataspaceComponentException {
        this.collectionFactories.put(name, factory);
    }

    public void dropCollectionFactory(Session session, String name) throws DataspaceComponentException {
        this.collectionFactories.remove(name);
    }

    public CollectionFactory lookupCollectionFactory(Session session, String name) throws DataspaceComponentException {
        return this.collectionFactories.get(name);
    }

    public List<String> listCollections(Session session) throws DataspaceComponentException {
        ArrayList<String> result = new ArrayList<String>();
        Iterator iter = this.store.schemaManager.dataspaceObjectIterator(this.getName(), 4);
        while (iter.hasNext()) {
            SchemaObject schemaObject = (SchemaObject)iter.next();
            result.add(schemaObject.getObjectName().name);
        }
        return result;
    }

    public DataCollection lookupCollection(String name) {
        SchemaObject object = this.store.schemaManager.findSchemaObject(NameManager.unquoteString(name), this.getName(), 4);
        if (object instanceof DataCollection) {
            return (DataCollection)((Object)object);
        }
        return null;
    }

    public void dropCollection(Session session, String name) throws DataspaceComponentException {
        Result result = session.executeDirectStatement("DROP COLLECTION " + name);
        if (result.isError()) {
            throw new DataspaceComponentException(2002, "Dropping of collection '" + name + "' failed.", result.getException());
        }
    }

    @Override
    public List<CollectionType> getCollectionTypes() {
        return new ArrayList<CollectionType>(this.collectionFactoryFactories.listCollectionTypes());
    }

    @Override
    public List<String> listCollectionsByType(CollectionType type) {
        ArrayList<String> result = new ArrayList<String>();
        Iterator iter = this.store.schemaManager.dataspaceObjectIterator(this.getName(), 4);
        while (iter.hasNext()) {
            Collection collection = (Collection)iter.next();
            if (collection.getCollectionType() != type) continue;
            result.add(collection.getObjectName().name);
        }
        return result;
    }

    @Override
    public List<String> listCollectionsAll() {
        ArrayList<String> result = new ArrayList<String>();
        Iterator iter = this.store.schemaManager.dataspaceObjectIterator(this.getName(), 4);
        while (iter.hasNext()) {
            Collection collection = (Collection)iter.next();
            result.add(collection.getObjectName().name);
        }
        return result;
    }

    @Override
    public List<CollectionMetaData> getCollectionsByType(CollectionType type) {
        ArrayList<CollectionMetaData> result = new ArrayList<CollectionMetaData>();
        Iterator iter = this.store.schemaManager.dataspaceObjectIterator(this.getName(), 4);
        while (iter.hasNext()) {
            Collection collection = (Collection)iter.next();
            if (collection.getCollectionType() != type) continue;
            result.add(new CollectionMetaDataImpl(collection, this.createSystemSession()));
        }
        return result;
    }

    @Override
    public List<CollectionMetaData> getCollectionsAll() {
        ArrayList<CollectionMetaData> result = new ArrayList<CollectionMetaData>();
        Iterator iter = this.store.schemaManager.dataspaceObjectIterator(this.getName(), 4);
        while (iter.hasNext()) {
            Collection collection = (Collection)iter.next();
            result.add(new CollectionMetaDataImpl(collection, this.createSystemSession()));
        }
        return result;
    }

    @Override
    public CollectionMetaData lookupCollectionMetaData(String name) {
        AbstractCollection collection = (AbstractCollection)this.lookupCollection(name);
        if (collection != null) {
            return new CollectionMetaDataImpl(collection, this.createSystemSession());
        }
        return null;
    }

    @Override
    public List<String> listTimers() {
        ArrayList<String> result = new ArrayList<String>();
        Iterator iter = this.store.schemaManager.dataspaceObjectIterator(this.getName(), 30);
        while (iter.hasNext()) {
            TimerObject timer = (TimerObject)iter.next();
            result.add(timer.getObjectName().name);
        }
        return result;
    }

    @Override
    public List<TimerMetaData> getTimers() {
        ArrayList<TimerMetaData> result = new ArrayList<TimerMetaData>();
        Iterator iter = this.store.schemaManager.dataspaceObjectIterator(this.getName(), 30);
        while (iter.hasNext()) {
            TimerObject timer = (TimerObject)iter.next();
            result.add(new TimerMetaData(timer));
        }
        return result;
    }

    @Override
    public TimerMetaData lookupTimer(String name) {
        SchemaObject object = this.store.schemaManager.findSchemaObject(name, this.getName(), 30);
        if (object instanceof TimerObject) {
            return new TimerMetaData((TimerObject)object);
        }
        return null;
    }

    private void assignDescription(DataspaceType type) {
        if (this.name.getNameString().equals("SYS")) {
            this.description = "Catalog Dataspace";
        } else if (this.name.getNameString().equals("SDS")) {
            this.description = "System Dataspace";
        } else if (this.name.getNameString().equals("SCH")) {
            this.description = "Scheduler Dataspace";
        } else {
            switch (type) {
                case TSPACE: {
                    this.description = "Table Space";
                    break;
                }
                case QSPACE: {
                    this.description = "Queue Space";
                    break;
                }
                case FSPACE: {
                    this.description = "File Space";
                    break;
                }
                case CSPACE: {
                    this.description = "Concept Space";
                    break;
                }
                case HSPACE: {
                    this.description = "Hierarchical Space";
                    break;
                }
                case USPACE: {
                    this.description = "Tuple Space";
                }
            }
        }
    }

    public ReplicationManager getReplicationManager() {
        return this.replicationManager;
    }

    public void validate(boolean withLobs) {
        Iterator iterator = this.collectionLookup.map.values().iterator();
        while (iterator.hasNext()) {
            ((AbstractCollection)iterator.next()).validate(withLobs, 1);
        }
        this.lastCheckTime = System.currentTimeMillis();
    }

    public boolean validateReferences(Session session) {
        boolean result = false;
        Iterator iterator = this.collectionLookup.map.values().iterator();
        iterator = new WrapperIterator(iterator, this.procedureLookup.map.values().iterator());
        iterator = new WrapperIterator(iterator, this.functionLookup.map.values().iterator());
        iterator = new WrapperIterator(iterator, this.actorLookup.map.values().iterator());
        iterator = new WrapperIterator(iterator, this.triggerLookup.map.values().iterator());
        iterator = new WrapperIterator(iterator, this.referenceLinkLookup.map.values().iterator());
        while (iterator.hasNext()) {
            SchemaObject object = (SchemaObject)iterator.next();
            DataspaceStateHolder stateHolder = object.aggregateObjectStateHolder();
            if (!stateHolder.isSuspectState()) continue;
            object.recompileObject(session);
            stateHolder = object.aggregateObjectStateHolder();
            if (stateHolder.isSuspectState()) continue;
            result = true;
        }
        return result;
    }

    public long getLastCheckTime() {
        return this.lastCheckTime;
    }

    public TableTypesValidator.InvalidTypes validateTypes() {
        TableTypesValidator.InvalidTypes invalidType = new TableTypesValidator.InvalidTypes();
        Iterator iterator = this.collectionLookup.map.values().iterator();
        while (iterator.hasNext()) {
            invalidType.add(((AbstractCollection)iterator.next()).validateTypes(1, TableTypesValidator.NormalizeScope.NONE));
        }
        return invalidType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataspaceStateHolder aggregateDataspaceState() {
        DataspaceStateHolder stateHolder = new DataspaceStateHolder();
        Iterator iterator = this.collectionLookup.map.values().iterator();
        iterator = new WrapperIterator(iterator, this.typeLookup.map.values().iterator());
        iterator = new WrapperIterator(iterator, this.procedureLookup.map.values().iterator());
        iterator = new WrapperIterator(iterator, this.functionLookup.map.values().iterator());
        iterator = new WrapperIterator(iterator, this.actorLookup.map.values().iterator());
        iterator = new WrapperIterator(iterator, this.triggerLookup.map.values().iterator());
        iterator = new WrapperIterator(iterator, this.sequenceLookup.map.values().iterator());
        iterator = new WrapperIterator(iterator, this.referenceLinkLookup.map.values().iterator());
        while (iterator.hasNext()) {
            DataspaceStateHolder.aggregateState(stateHolder, (SchemaObject)iterator.next(), this.store.schemaManager);
        }
        try (Session session = null;){
            long count;
            session = this.store.collectionSessionManager.newSysSession();
            Result result = session.executeDirectStatement("select count(*) from SDS.RECOVERY_LOG where DATASPACE = '" + this.getObjectName().name + "'");
            if (!result.isError() && result.isData() && result.navigator.next() && (count = ((Number)result.navigator.getCurrent(0)).longValue()) != 0L) {
                stateHolder.setRecoveryFailedState();
            }
        }
        return stateHolder;
    }

    public void exposeDataspaceState(RowSetNavigatorClient navigator, boolean withValid, ComponentState componentState) {
        this.aggregateDataspaceState().exposeState(navigator, withValid, false, "Dataspace State", componentState, DataspaceStateHolder.DomainSuspectStateOriginator.class, DataspaceStateHolder.TypeSuspectStateOriginator.class, DataspaceStateHolder.SemanticTypeSuspectStateOriginator.class, DataspaceStateHolder.PrototypeSuspectStateOriginator.class, DataspaceStateHolder.LobDataspaceSuspectStateOriginator.class, DataspaceStateHolder.FlobDataspaceSuspectStateOriginator.class, DataspaceStateHolder.CollectionDataspaceSuspectStateOriginator.class, DataspaceStateHolder.FunctionSuspectStateOriginator.class, DataspaceStateHolder.ActorSuspectStateOriginator.class, DataspaceStateHolder.TriggerSuspectStateOriginator.class, DataspaceStateHolder.IndexSuspectStateOriginator.class);
        navigator.add(new Object[]{"Last Check Time", this.lastCheckTime != 0L ? new Date(this.lastCheckTime).toString() : "---"});
    }

    public DataspaceStore getStore() {
        return this.store;
    }

    public void setStore(DataspaceStore store) {
        this.store = store;
    }

    public static void log(Class<?> clazz, Trace.Level level, AbstractDataspace dataspace, NameManager.ObjectName objectName, String message) {
        if (dataspace != null) {
            if (level == Trace.Level.INFO) {
                dataspace.logInfo(objectName.getNameString(), (String)message);
            } else if (level == Trace.Level.ERROR) {
                dataspace.logError(objectName.getNameString(), (String)message);
            } else if (level == Trace.Level.DEBUG) {
                dataspace.logDebug(objectName.getNameString(), (String)message);
            }
        } else {
            message = "[ " + objectName.getSchemaQualifiedStatementName() + " ] : " + (String)message;
            if (level == Trace.Level.INFO) {
                Trace.logInfo(clazz, (String)message);
            } else if (level == Trace.Level.ERROR) {
                Trace.logError(clazz, (String)message);
            } else if (level == Trace.Level.DEBUG) {
                Trace.logDebug(clazz, (String)message);
            }
        }
    }

    @Override
    public boolean isNativeContext(MFSession session) {
        return session instanceof DataspaceMFSession;
    }

    @Override
    public String getStartupDir() {
        return this.context.getStartupDir();
    }

    private void executeWithSysSessionNoReturn(Consumer<Session> runnable) {
        try (Session session = this.store.getSessionManager().newSysSession();){
            runnable.accept(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T executeWithSysSession(Function<Session, T> function) {
        try (Session session = this.store.getSessionManager().newSysSession();){
            T t = function.apply(session);
            return t;
        }
    }

    private static /* synthetic */ void lambda$doClose$9(Collection collection) {
        collection.close();
    }

    private static /* synthetic */ void lambda$doOpen$7(AbstractReplicationEventTrigger eventTrigger, Session session) {
        eventTrigger.enable(session);
    }
}

