/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.cli.tlp;

import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.cli.service.ServiceAccessor;
import com.streamscape.cli.tlp.ClientId;
import com.streamscape.cli.tlp.FabricConnectionException;
import com.streamscape.cli.tlp.PingResult;
import com.streamscape.lib.utils.ArchiveException;
import com.streamscape.repository.RepositoryException;
import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.sdo.AdvisoryEventDatagram;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.enums.AcknowledgeAction;
import com.streamscape.sdo.enums.CacheThresholdAction;
import com.streamscape.sdo.enums.ExceptionStrategy;
import com.streamscape.sdo.enums.ReplyMatchStrategy;
import com.streamscape.sdo.enums.RequestDistributionStrategy;
import com.streamscape.sdo.event.AcknowledgementEvent;
import com.streamscape.sdo.excp.FabricEventException;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sdo.mf.admin.SemanticTypeFactoryException;
import com.streamscape.sef.DomainConstraint;
import com.streamscape.sef.EventAsyncConsumer;
import com.streamscape.sef.EventCache;
import com.streamscape.sef.EventConsumer;
import com.streamscape.sef.EventReceiver;
import com.streamscape.sef.EventRequestConsumer;
import com.streamscape.sef.FabricEventDispatcherException;
import com.streamscape.sef.FabricEventListener;
import com.streamscape.sef.FabricEventSourceException;
import com.streamscape.sef.FabricRequestException;
import com.streamscape.sef.FabricRequestListener;
import com.streamscape.sef.FabricUnboundEventException;
import com.streamscape.sef.RangeConstraint;
import com.streamscape.sef.accessor.FabricComponentAccessorException;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.exchange.FabricAddress;
import com.streamscape.sef.group.FabricGroupLink;
import com.streamscape.sef.group.FabricGroupManager;
import com.streamscape.sef.group.FabricGroupManagerException;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.Moderator;
import com.streamscape.sef.moderator.RequestConsumerReference;
import com.streamscape.sef.network.LinkProtocol;
import com.streamscape.sef.security.AuthenticationType;
import com.streamscape.sef.security.SecurityManager;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.slex.slang.SLSession;
import com.streamscape.slex.slang.SLSessionException;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import javax.naming.NamingException;

public interface FabricConnection {
    public static final String URL_PREFIX = LinkProtocol.TLP.getURLPrefix();
    public static final String SSL_URL_PREFIX = LinkProtocol.TLPS.getURLPrefix();
    public static final String TLP_TYPE = "Client_TLP";
    public static final String TLPS_TYPE = "Client_TLPS";
    public static final String HTTP_TYPE = "Client_HTTP";
    public static final String HTTPS_TYPE = "Client_HTTPS";
    public static final String REST_TYPE = "Client_REST";
    public static final String XMPP_TYPE = "Client_XMPP";
    public static final String LOCAL_URL = URL_PREFIX + "local";
    public static final int DEFAULT_RECONNECT_ATTEMPTS = -1;
    public static final long DEFAULT_RECONNECT_INTERVAL = 30L;

    public String getName();

    public void setName(String var1) throws FabricConnectionException;

    public ClientId getClientId();

    public void setClientId(ClientId var1) throws FabricConnectionException;

    public String getType();

    public String getDescription();

    public void setDescription(String var1) throws FabricConnectionException;

    public void addURL(String var1) throws FabricConnectionException;

    public void removeURL(String var1);

    public List<String> getURLs();

    public String getURL();

    public EventScope getEventScope();

    public void setEventScope(EventScope var1) throws FabricConnectionException;

    public String getUserName();

    public void setUserName(String var1) throws FabricConnectionException;

    public void setPassword(String var1) throws FabricConnectionException;

    public void setSecurityToken(String var1) throws FabricConnectionException;

    public int getReconnectAttempts() throws FabricConnectionException;

    public void setReconnectAttempts(int var1) throws FabricConnectionException;

    public long getReconnectInterval() throws FabricConnectionException;

    public void setReconnectInterval(long var1) throws FabricConnectionException;

    public boolean isReconnecting() throws FabricConnectionException;

    public PingResult ping();

    public boolean isSecurityEnabled() throws FabricConnectionException;

    public void open() throws FabricConnectionException, SecurityManagerException;

    public void open(long var1) throws FabricConnectionException, SecurityManagerException;

    public void close() throws FabricConnectionException;

    public void close(long var1) throws FabricConnectionException;

    public void forceClose() throws FabricConnectionException;

    public boolean isOpened();

    public long getTimestamp();

    public AuthenticationType getAuthenticationType() throws FabricConnectionException;

    public ComponentReference getComponentReference() throws FabricConnectionException;

    public FabricAddress getFabricAddress() throws FabricConnectionException;

    public Moderator getModerator() throws FabricConnectionException;

    public SecurityManager getSecurityManager() throws FabricConnectionException, SecurityManagerException;

    public RepositoryAccessor getRepositoryAccessor() throws FabricConnectionException;

    public RepositoryAccessor getRepositoryAccessor(String var1) throws FabricConnectionException;

    public DataspaceAccessor createDataspaceAccessor(DataspaceType var1, String var2) throws FabricConnectionException, FabricComponentAccessorException;

    public DataspaceAccessor createDataspaceAccessor(String var1, DataspaceType var2, String var3) throws FabricConnectionException, FabricComponentAccessorException;

    public ServiceAccessor createServiceAccessor(String var1, String var2) throws FabricConnectionException, FabricComponentAccessorException;

    public ServiceAccessor createServiceAccessor(String var1, String var2, String var3) throws FabricConnectionException, FabricComponentAccessorException;

    public SLSession createSLSession() throws FabricConnectionException, SLSessionException;

    public SLSession createSLSession(String var1) throws FabricConnectionException, SLSessionException;

    public void raiseAdvisory(AdvisoryEventDatagram var1, EventScope var2) throws FabricConnectionException, FabricEventSourceException, FabricUnboundEventException, FabricEventException;

    public void raiseEvent(ImmutableEventDatagram var1, EventScope var2, long var3) throws FabricConnectionException, FabricEventSourceException, FabricUnboundEventException, FabricEventException;

    public ImmutableEventDatagram raiseRequest(RequestConsumerReference var1, ImmutableEventDatagram var2, long var3) throws FabricConnectionException, FabricEventSourceException, FabricUnboundEventException, FabricRequestException;

    public AcknowledgementEvent raiseRequest(EventDatagram var1, EventScope var2, RequestDistributionStrategy var3, ReplyMatchStrategy var4, long var5) throws FabricConnectionException, FabricEventSourceException, FabricUnboundEventException, FabricEventException;

    public void raiseException(ExceptionEventDatagram var1, EventScope var2) throws FabricConnectionException, FabricEventSourceException, FabricUnboundEventException, FabricEventException;

    public void raiseAcknowledgement(AcknowledgementEvent var1, EventScope var2, long var3) throws FabricConnectionException, FabricEventSourceException, FabricUnboundEventException, FabricEventException;

    public void acknowledgeEvent(EventDatagram var1, boolean var2, AcknowledgeAction var3, String var4, EventScope var5, long var6) throws FabricConnectionException, FabricEventSourceException, FabricUnboundEventException, FabricEventException;

    public void acknowledgeException(ExceptionEventDatagram var1, AcknowledgeAction var2, String var3, EventScope var4, long var5) throws FabricConnectionException, FabricEventSourceException, FabricUnboundEventException, FabricEventException;

    public EventConsumer createEventConsumer(String var1, FabricEventListener var2, String var3, String var4, EventScope var5, boolean var6) throws FabricConnectionException, FabricEventDispatcherException;

    public void dropEventConsumer(String var1) throws FabricConnectionException, FabricEventDispatcherException;

    public EventAsyncConsumer createEventAsyncConsumer(String var1, FabricEventListener var2, String var3, String var4, EventScope var5, boolean var6) throws FabricConnectionException, FabricEventDispatcherException;

    public void dropEventAsyncConsumer(String var1) throws FabricConnectionException, FabricEventDispatcherException;

    public EventRequestConsumer createRequestConsumer(String var1, FabricRequestListener var2, EventScope var3) throws FabricConnectionException, FabricEventDispatcherException;

    public void dropRequestConsumer(String var1) throws FabricConnectionException, FabricEventDispatcherException;

    public void dropConsumer(String var1) throws FabricConnectionException, FabricEventDispatcherException;

    public EventConsumer getEventConsumer(String var1) throws FabricConnectionException;

    public EventAsyncConsumer getEventAsyncConsumer(String var1) throws FabricConnectionException;

    public EventRequestConsumer getRequestConsumer(String var1) throws FabricConnectionException;

    public List<String> listEventConsumers() throws FabricConnectionException;

    public List<String> listEventAsyncConsumers() throws FabricConnectionException;

    public List<String> listRequestConsumers() throws FabricConnectionException;

    public EventReceiver createEventReceiver(String var1, String var2, String var3, EventScope var4, boolean var5) throws FabricConnectionException, FabricEventDispatcherException;

    public void dropEventReceiver(String var1) throws FabricConnectionException, FabricEventDispatcherException;

    public EventReceiver getEventReceiver(String var1) throws FabricConnectionException;

    public List<String> listEventReceivers() throws FabricConnectionException;

    public void addEventCache(String var1, int var2, CacheThresholdAction var3) throws FabricConnectionException, FabricEventDispatcherException;

    public void removeEventCache(String var1) throws FabricConnectionException;

    public EventCache getEventCache(String var1) throws FabricConnectionException;

    public void bindProducerFor(String var1) throws FabricConnectionException, FabricEventDispatcherException;

    public void unbindProducerFor(String var1) throws FabricConnectionException;

    public boolean hasBoundEventIds() throws FabricConnectionException;

    public boolean isBoundEventId(String var1) throws FabricConnectionException;

    public List<String> listBoundEventIds() throws FabricConnectionException;

    public ExceptionStrategy getExceptionStrategy() throws FabricConnectionException;

    public void setExceptionStrategy(ExceptionStrategy var1) throws FabricConnectionException;

    public DomainConstraint createDomainConstraint(String var1, String var2, Set<Object> var3) throws FabricConnectionException, FabricEventDispatcherException;

    public void dropDomainConstraint(String var1) throws FabricConnectionException, FabricEventDispatcherException;

    public DomainConstraint getDomainConstraint(String var1) throws FabricConnectionException, FabricEventDispatcherException;

    public void setDomainConstraint(DomainConstraint var1) throws FabricConnectionException, FabricEventDispatcherException;

    public RangeConstraint createRangeConstraint(String var1, String var2, Object var3, Object var4) throws FabricConnectionException, FabricEventDispatcherException;

    public void dropRangeConstraint(String var1) throws FabricConnectionException, FabricEventDispatcherException;

    public RangeConstraint getRangeConstraint(String var1) throws FabricConnectionException, FabricEventDispatcherException;

    public void setRangeConstraint(RangeConstraint var1) throws FabricConnectionException, FabricEventDispatcherException;

    public FabricGroupManager getGroupManager() throws FabricConnectionException;

    public FabricGroupLink joinGroup(String var1) throws FabricConnectionException, FabricGroupManagerException;

    public void leaveGroup(String var1) throws FabricConnectionException, FabricGroupManagerException;

    public FabricGroupLink getGroupLink(String var1) throws FabricConnectionException;

    public List<String> listGroups() throws FabricConnectionException;

    public void setExceptionListener(FabricEventListener var1) throws FabricConnectionException, FabricEventDispatcherException;

    public FabricEventListener getExceptionListener();

    public void exportExtensionArchive(File var1) throws FabricConnectionException, RepositoryException;

    public void importExtensionArchive(String var1) throws FabricConnectionException, RepositoryException, ArchiveException;

    public void importPackage(String var1) throws FabricConnectionException, NamingException, RepositoryException, ArchiveException;

    public void exportSemanticType(String var1) throws FabricConnectionException, SemanticTypeFactoryException;

    public void importSemanticType(String var1) throws FabricConnectionException, SemanticTypeFactoryException, ArchiveException;

    public void exportEventPrototype(String var1) throws FabricConnectionException, DatagramFactoryException;

    public void importEventPrototype(String var1) throws FabricConnectionException, DatagramFactoryException, ArchiveException;

    public TimeZone getHostTimezone() throws FabricConnectionException;

    public TimeZone getNodeTimezone() throws FabricConnectionException;

    public Charset getCCSID() throws FabricConnectionException;

    public long nextGlobalCount() throws FabricConnectionException;

    public long showGlobalCounter() throws FabricConnectionException;

    public long resetGlobalCounter() throws FabricConnectionException;
}

