/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.cli.tlp;

import com.streamscape.cli.tlp.FabricConnectionException;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.sdo.CloneableDataObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClientId
extends CloneableDataObject {
    private String name;
    private String domain;
    private String organizationUnit;
    private String resource;
    private Map<String, String> values = new HashMap<String, String>();
    private static final String OU = "ou";
    private static final String RESOURCE = "resource";

    public ClientId() {
    }

    public ClientId(String stringForm) throws FabricConnectionException {
        if (stringForm == null || stringForm.length() == 0) {
            throw new FabricConnectionException(1004, "Invalid string form: null or empty.");
        }
        stringForm = this.replaceDots(stringForm);
        for (String item : StringUtils.split(stringForm, ',')) {
            List<String> pairsColon;
            List<String> pairs = StringUtils.split(item, '=');
            if (pairs.size() == 1 && (pairsColon = StringUtils.split(item, ':')).size() == 2) {
                pairs = pairsColon;
            }
            if (pairs.size() == 1) {
                this.name = pairs.get(0);
                ClientId.checkItem(!this.name.equalsIgnoreCase(OU) && !this.name.equalsIgnoreCase(RESOURCE), item, "value");
                int index = this.name.indexOf(64);
                if (index == -1) continue;
                this.domain = this.name.substring(index + 1);
                this.name = this.name.substring(0, index);
                ClientId.checkItem(this.name, item, "name");
                continue;
            }
            if (pairs.size() == 2) {
                String name = pairs.get(0);
                String value = pairs.get(1);
                ClientId.checkItem(name, item, "name");
                ClientId.checkItem(value, item, "value");
                if (name.equalsIgnoreCase(OU)) {
                    this.organizationUnit = value;
                    continue;
                }
                if (name.equalsIgnoreCase(RESOURCE)) {
                    this.resource = value;
                    continue;
                }
                this.add(name, value);
                continue;
            }
            throw new FabricConnectionException(1008, "Invalid item '" + item + "': too many '='.");
        }
    }

    private static void checkItem(boolean condition, String item, String itemPartType) throws FabricConnectionException {
        if (!condition) {
            throw new FabricConnectionException(1008, "Invalid item '" + item + "': " + itemPartType + " is missing.");
        }
    }

    private static void checkItem(String itemPart, String item, String itemPartType) throws FabricConnectionException {
        ClientId.checkItem(itemPart.length() != 0, item, itemPartType);
    }

    public void setName(String name) {
        this.name = this.replaceDots(name);
    }

    public String getName() {
        return this.name;
    }

    public void setDomain(String domain) {
        this.domain = this.replaceDots(domain);
    }

    public String getDomain() {
        return this.domain;
    }

    public void setOrganizationUnit(String organizationUnit) {
        this.organizationUnit = this.replaceDots(organizationUnit);
    }

    public String getOrganizationUnit() {
        return this.organizationUnit;
    }

    public void setResource(String resource) {
        this.resource = this.replaceDots(resource);
    }

    public String getResource() {
        return this.resource;
    }

    public void add(String name, String value) {
        if (name != null && name.length() != 0 && value != null && value.length() != 0) {
            this.values.put(name, this.replaceDots(value));
        }
    }

    public void remove(String name) {
        if (name != null) {
            this.values.remove(name);
        }
    }

    public String get(String name) {
        return name != null ? this.values.get(name) : null;
    }

    public List<String> listNames() {
        return this.values != null ? new ArrayList<String>(this.values.keySet()) : new ArrayList();
    }

    public void clear() {
        this.name = null;
        this.domain = null;
        this.organizationUnit = null;
        this.resource = null;
        this.values.clear();
    }

    public String toString(String equalsSign) {
        StringBuilder builder = new StringBuilder();
        boolean needsComma = false;
        if (this.name != null) {
            builder.append(this.replaceDots(this.name));
            if (this.domain != null) {
                builder.append("@").append(this.replaceDots(this.domain));
            }
            needsComma = true;
        }
        if (this.organizationUnit != null) {
            builder.append(needsComma ? "," : "").append(OU).append(equalsSign).append(this.replaceDots(this.organizationUnit));
            needsComma = true;
        }
        if (this.resource != null) {
            builder.append(needsComma ? "," : "").append(RESOURCE).append(equalsSign).append(this.replaceDots(this.resource));
            needsComma = true;
        }
        for (Map.Entry<String, String> entry : this.values.entrySet()) {
            builder.append(needsComma ? "," : "").append(entry.getKey()).append(equalsSign).append(this.replaceDots(entry.getValue()));
            needsComma = true;
        }
        return builder.toString();
    }

    public String toString() {
        return this.toString("=");
    }

    private String replaceDots(String value) {
        return value != null ? value.replace('.', '_') : value;
    }
}

