/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.cli.http;

import com.streamscape.cli.http.HTTPFabricConnection;
import com.streamscape.cli.http.HTTPFabricException;
import com.streamscape.cli.http.HTTPSLSession;
import com.streamscape.cli.service.ServiceAccessor;
import com.streamscape.ds.stable.rplmethod.RPLMethodsCache;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.enums.RequestDistributionStrategy;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.utils.EIMObject;
import com.streamscape.sef.EventTriggerCompileException;
import com.streamscape.sef.EventTriggerState;
import com.streamscape.sef.IllegalTriggerStateException;
import com.streamscape.sef.accessor.FabricComponentAccessorException;
import com.streamscape.sef.accessor.FabricComponentAccessorStateListener;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.evtrigger.EventTriggerDefinition;
import com.streamscape.sef.evtrigger.TriggerActionTime;
import com.streamscape.sef.moderator.AccessorSessionReference;
import com.streamscape.sef.moderator.ComponentModel;
import com.streamscape.sef.network.http.server.fabric.HTTPFabricConnectionRemoteCall;
import com.streamscape.sef.network.http.server.fabric.RemoteMethodCall;
import com.streamscape.service.osf.config.ActiveEvent;
import com.streamscape.service.osf.config.EventTriggerData;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.service.osf.evh.EventHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

class HTTPServiceAccessor
implements ServiceAccessor {
    private HTTPFabricConnection connection;
    private String nodeName;
    private String serviceType;
    private String serviceName;
    private Boolean autoSwitching = null;
    private long requestTimeout = -2L;
    private Object[] getServiceAccessorArgs;
    private String uniqueAccessorName;
    private HTTPFabricConnection.HTTPClientWrapper wrapper = null;
    private static AtomicLong accessorId = new AtomicLong(0L);

    HTTPServiceAccessor(String nodeName, String serviceType, String serviceName, HTTPFabricConnection connection) {
        this.nodeName = nodeName;
        this.serviceType = serviceType;
        this.serviceName = serviceName;
        this.connection = connection;
        this.uniqueAccessorName = "fabricconnection_" + accessorId.incrementAndGet();
        this.getServiceAccessorArgs = new Object[1];
        this.getServiceAccessorArgs[0] = this.uniqueAccessorName;
        this.open();
    }

    protected void open() {
        if (this.wrapper != null) {
            this.wrapper.closeQuiet();
        }
        this.wrapper = this.connection.createHttpClientWrapper();
        Object[] createServiceAccessorArgs = new Object[]{this.nodeName, this.serviceType, this.serviceName, this.uniqueAccessorName};
        byte[] data = this.connection.invoke("createServiceAccessor", createServiceAccessorArgs, null);
        if (data != null) {
            this.connection.checkException(data);
        }
        this.connection.serviceAccessors.put(this.uniqueAccessorName, this);
        if (this.autoSwitching != null) {
            this.connection.reopenAction(() -> this.setAutoSwitching(this.autoSwitching));
        }
        if (this.requestTimeout != -2L) {
            this.connection.reopenAction(() -> this.setRequestTimeout(this.requestTimeout));
        }
    }

    @Override
    public void close() {
        Object[] args = new Object[]{};
        try {
            this.invoke("close", args);
        }
        finally {
            this.connection.serviceAccessors.remove(this.uniqueAccessorName);
            if (this.wrapper != null) {
                this.wrapper.closeQuiet();
                this.wrapper = null;
            }
        }
    }

    @Override
    public boolean isAvailable() {
        Object[] args = new Object[]{};
        Object result = this.invoke("isAvailable", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public String getActualNodeName() {
        Object[] args = new Object[]{};
        Object result = this.invoke("getActualNodeName", args);
        HTTPFabricConnection.processServerAnswer(result, String.class);
        return (String)result;
    }

    @Override
    public AccessorSessionReference getSession() {
        Object[] args = new Object[]{};
        Object result = this.invoke("getSession", args);
        HTTPFabricConnection.processServerAnswer(result, String.class);
        return (AccessorSessionReference)result;
    }

    @Override
    public void setStateListener(FabricComponentAccessorStateListener listener) {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public void setStateListener(FabricComponentAccessorStateListener listener, long repeatInterval) {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public String getComponentName() {
        Object[] args = new Object[]{};
        Object result = this.invoke("getComponentName", args);
        HTTPFabricConnection.processServerAnswer(result, String.class);
        return (String)result;
    }

    @Override
    public String getComponentType() {
        Object[] args = new Object[]{};
        Object result = this.invoke("getComponentType", args);
        HTTPFabricConnection.processServerAnswer(result, String.class);
        return (String)result;
    }

    @Override
    public ComponentModel getComponentModel() {
        Object[] args = new Object[]{};
        Object result = this.invoke("getComponentModel", args);
        HTTPFabricConnection.processServerAnswer(result, ComponentModel.class);
        return (ComponentModel)((Object)result);
    }

    @Override
    public String getAccessorName() {
        Object[] args = new Object[]{};
        Object result = this.invoke("getAccessorName", args);
        HTTPFabricConnection.processServerAnswer(result, String.class);
        return (String)result;
    }

    @Override
    public String getName() {
        Object[] args = new Object[]{};
        Object result = this.invoke("getName", args);
        HTTPFabricConnection.processServerAnswer(result, String.class);
        return (String)result;
    }

    @Override
    public EventScope getEventScope() {
        Object[] args = new Object[]{};
        Object result = this.invoke("getEventScope", args);
        HTTPFabricConnection.processServerAnswer(result, EventScope.class);
        return (EventScope)((Object)result);
    }

    @Override
    public String getNodeName() {
        Object[] args = new Object[]{};
        Object result = this.invoke("getNodeName", args);
        HTTPFabricConnection.processServerAnswer(result, String.class);
        return (String)result;
    }

    @Override
    public long getRequestTimeout() {
        Object[] args = new Object[]{};
        Object result = this.invoke("getRequestTimeout", args);
        HTTPFabricConnection.processServerAnswer(result, Number.class);
        return ((Number)result).longValue();
    }

    @Override
    public boolean autoSwitching() {
        Object[] args = new Object[]{};
        Object result = this.invoke("autoSwitching", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public void setAutoSwitching(boolean autoSwitching) {
        Object[] args = new Object[]{autoSwitching};
        this.invoke("setAutoSwitching", args);
        this.autoSwitching = autoSwitching;
    }

    @Override
    public boolean switchComponent() throws FabricComponentAccessorException {
        Object[] args = new Object[]{};
        Object result = this.invoke("switchComponent", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public boolean resync() throws FabricComponentAccessorException {
        Object[] args = new Object[]{};
        Object result = this.invoke("resync", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public SLResponse invokeLanguageRequest(SLStatement statement) throws FabricComponentAccessorException {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public SLResponse invokeLanguageRequest(SLStatement statement, long timeout) throws FabricComponentAccessorException {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public SLResponse invokeLanguageRequest(String statement) throws FabricComponentAccessorException {
        Object[] args = new Object[]{statement};
        Object result = this.invoke("invokeLanguageRequest", args, HTTPSLSession.calculateHttpTimeout(-1L, this.requestTimeout));
        HTTPFabricConnection.processServerAnswer(result, SLResponse.class);
        return (SLResponse)result;
    }

    @Override
    public SLResponse invokeLanguageRequest(String statement, long timeout) throws FabricComponentAccessorException {
        Object[] args = new Object[]{statement, HTTPSLSession.calculateSlangTimeout(this.connection, timeout, this.requestTimeout)};
        Object result = this.invoke("invokeLanguageRequest", args, HTTPSLSession.calculateHttpTimeout(timeout, this.requestTimeout));
        HTTPFabricConnection.processServerAnswer(result, SLResponse.class);
        return (SLResponse)result;
    }

    @Override
    public SLResponse invokeInterruptRequest(String command) throws FabricComponentAccessorException {
        Object[] args = new Object[]{command};
        Object result = this.invoke("invokeInterruptRequest", args, HTTPSLSession.calculateHttpTimeout(-1L, this.requestTimeout));
        HTTPFabricConnection.processServerAnswer(result, SLResponse.class);
        return (SLResponse)result;
    }

    @Override
    public SLResponse invokeCompleteRequest(String statement) throws FabricComponentAccessorException {
        Object[] args = new Object[]{statement};
        Object result = this.invoke("invokeCompleteRequest", args, HTTPSLSession.calculateHttpTimeout(-1L, this.requestTimeout));
        HTTPFabricConnection.processServerAnswer(result, SLResponse.class);
        return (SLResponse)result;
    }

    @Override
    public SLResponse invokeCompleteRequest(String statement, long timeout) throws FabricComponentAccessorException {
        Object[] args = new Object[]{statement, HTTPSLSession.calculateSlangTimeout(this.connection, timeout, this.requestTimeout)};
        Object result = this.invoke("invokeCompleteRequest", args, HTTPSLSession.calculateHttpTimeout(timeout, this.requestTimeout));
        HTTPFabricConnection.processServerAnswer(result, SLResponse.class);
        return (SLResponse)result;
    }

    @Override
    public boolean isOpened() {
        if (!this.connection.isOpened()) {
            return false;
        }
        Object[] args = new Object[]{};
        Object result = this.invoke("isOpened", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public void setRequestTimeout(long timeout) {
        Object[] args = new Object[]{timeout};
        this.invoke("setRequestTimeout", args);
        this.requestTimeout = timeout;
    }

    @Override
    public boolean hasSinkEvents() {
        Object[] args = new Object[]{};
        Object result = this.invoke("hasSinkEvents", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public List<String> listSinkEvents() {
        Object[] array;
        Object[] args = new Object[]{};
        Object result = this.invoke("listSinkEvents", args);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<String> list = new ArrayList<String>();
        for (Object obj : array = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(obj, String.class);
            list.add((String)obj);
        }
        return list;
    }

    @Override
    public boolean existsActionableEvent(String eventId) {
        Object[] args = new Object[]{eventId};
        Object result = this.invoke("existsActionableEvent", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    public boolean existsActionableEventGroup(String groupName) {
        Object[] args = new Object[]{groupName};
        Object result = this.invoke("existsActionableEventGroup", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    public boolean hasActionableEventGroups() {
        Object[] args = new Object[]{};
        Object result = this.invoke("hasActionableEventGroups", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public boolean hasActionableEvents() {
        Object[] args = new Object[]{};
        Object result = this.invoke("hasActionableEvents", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    public List<String> listActionableEventGroups() {
        Object[] array;
        Object[] args = new Object[]{};
        Object result = this.invoke("listActionableEventGroups", args);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<String> list = new ArrayList<String>();
        for (Object obj : array = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(obj, String.class);
            list.add((String)obj);
        }
        return list;
    }

    @Override
    public List<String> listActionableEvents() {
        Object[] array;
        Object[] args = new Object[]{};
        Object result = this.invoke("listActionableEvents", args);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<String> list = new ArrayList<String>();
        for (Object obj : array = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(obj, String.class);
            list.add((String)obj);
        }
        return list;
    }

    @Override
    public void compileEventTrigger(String triggerName) throws EventTriggerCompileException, IllegalTriggerStateException {
        Object[] args = new Object[]{triggerName};
        this.invoke("compileEventTrigger", args);
    }

    @Override
    public void disableEventTrigger(String triggerName) {
        Object[] args = new Object[]{triggerName};
        this.invoke("disableEventTrigger", args);
    }

    @Override
    public void enableEventTrigger(String triggerName) {
        Object[] args = new Object[]{triggerName};
        this.invoke("enableEventTrigger", args);
    }

    @Override
    public EventTriggerDefinition getEventTriggerDefinition(String triggerName) throws ServiceConfigurationException {
        Object[] args = new Object[]{triggerName};
        Object result = this.invoke("getEventTriggerDefinition", args);
        HTTPFabricConnection.processServerAnswer(result, EventTriggerDefinition.class);
        return (EventTriggerDefinition)result;
    }

    @Override
    public String getLastError(String triggerName) {
        Object[] args = new Object[]{triggerName};
        Object result = this.invoke("getLastError", args);
        HTTPFabricConnection.processServerAnswer(result, String.class);
        return (String)result;
    }

    @Override
    public TriggerActionTime getTriggerActionTime(String triggerName) {
        Object result = this.invoke("getTriggerActionTime", new Object[]{triggerName});
        HTTPFabricConnection.processServerAnswer(result, TriggerActionTime.class);
        return (TriggerActionTime)((Object)result);
    }

    @Override
    public EventTriggerState getTriggerState(String triggerName) {
        Object result = this.invoke("getTriggerState", new Object[]{triggerName});
        HTTPFabricConnection.processServerAnswer(result, EventTriggerState.class);
        return (EventTriggerState)((Object)result);
    }

    @Override
    public void removeAllEventTriggers() throws ServiceConfigurationException, IllegalTriggerStateException {
        Object[] args = new Object[]{};
        this.invoke("removeAllEventTriggers", args);
    }

    @Override
    public void removeEventTrigger(String triggerName) throws ServiceConfigurationException {
        Object[] args = new Object[]{triggerName};
        this.invoke("removeEventTrigger", args);
    }

    @Override
    public boolean existsEventTrigger(String triggerName) {
        Object[] args = new Object[]{triggerName};
        Object result = this.invoke("existsEventTrigger", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public List<EventTriggerDefinition> getEventTriggerDefinitions() {
        Object[] definitions;
        Object[] args = new Object[]{};
        Object result = this.invoke("getEventTriggerDefinitions", args);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<EventTriggerDefinition> list = new ArrayList<EventTriggerDefinition>();
        for (Object obj : definitions = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(obj, EventTriggerDefinition.class);
            list.add((EventTriggerDefinition)obj);
        }
        return list;
    }

    @Override
    public boolean hasEventTriggers() {
        Object[] args = new Object[]{};
        Object result = this.invoke("hasEventTriggers", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public List<String> listEventTriggers() {
        Object[] triggers;
        Object[] args = new Object[]{};
        Object result = this.invoke("listEventTriggers", args);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<String> list = new ArrayList<String>();
        for (Object obj : triggers = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(obj, String.class);
            list.add((String)obj);
        }
        return list;
    }

    protected Object invoke(String methodName, Object[] args) throws HTTPFabricException {
        return this.invoke(methodName, args, -1L);
    }

    protected Object invoke(String methodName, Object[] args, long timeout) throws HTTPFabricException {
        HTTPFabricConnectionRemoteCall call = new HTTPFabricConnectionRemoteCall();
        call.pushMethodCall(new RemoteMethodCall("getServiceAccessor", this.getServiceAccessorArgs));
        call.pushMethodCall(new RemoteMethodCall(methodName, args));
        return this.connection.invokeRemoteCall(this.wrapper, call, null, timeout);
    }

    @Override
    public ImmutableEventDatagram invokeServiceRequest(ImmutableEventDatagram request) throws HTTPFabricException {
        Object[] args = new Object[]{request};
        Object result = this.invoke("invokeServiceRequest", args, HTTPSLSession.calculateHttpTimeout(-1L, this.requestTimeout));
        HTTPFabricConnection.processServerAnswer(result, ImmutableEventDatagram.class);
        return (ImmutableEventDatagram)result;
    }

    @Override
    public ImmutableEventDatagram invokeServiceRequest(ImmutableEventDatagram request, long timeout) throws HTTPFabricException {
        Object[] args = new Object[]{request, HTTPSLSession.calculateSlangTimeout(this.connection, timeout, this.requestTimeout)};
        Object result = this.invoke("invokeServiceRequest", args, HTTPSLSession.calculateHttpTimeout(timeout, this.requestTimeout));
        HTTPFabricConnection.processServerAnswer(result, ImmutableEventDatagram.class);
        return (ImmutableEventDatagram)result;
    }

    @Override
    public Object invokeServiceRequest(String eventHandler, Object data) {
        Object result = this.invoke("invokeServiceRequest", new Object[]{eventHandler, data}, HTTPSLSession.calculateHttpTimeout(-1L, this.requestTimeout));
        HTTPFabricConnection.processServerAnswer(result, Object.class);
        return result;
    }

    @Override
    public Object invokeServiceRequest(String eventHandler, Object data, long timeout) {
        Object result = this.invoke("invokeServiceRequest", new Object[]{eventHandler, data, HTTPSLSession.calculateSlangTimeout(this.connection, timeout, this.requestTimeout)}, HTTPSLSession.calculateHttpTimeout(timeout, this.requestTimeout));
        HTTPFabricConnection.processServerAnswer(result, Object.class);
        return result;
    }

    @Override
    public Object invokeServiceRequest(String eventHandler, Object data, Map<String, Object> properties, long timeout) {
        Object result = this.invoke("invokeServiceRequest", new Object[]{eventHandler, data, properties, HTTPSLSession.calculateSlangTimeout(this.connection, timeout, this.requestTimeout)}, HTTPSLSession.calculateHttpTimeout(timeout, this.requestTimeout));
        HTTPFabricConnection.processServerAnswer(result, Object.class);
        return result;
    }

    @Override
    public Object invokeServiceRequest(String eventHandler, EIMObject eimData, Object data) {
        Object result = this.invoke("invokeServiceRequest", new Object[]{eventHandler, eimData, data}, HTTPSLSession.calculateHttpTimeout(-1L, this.requestTimeout));
        HTTPFabricConnection.processServerAnswer(result, Object.class);
        return result;
    }

    @Override
    public Object invokeServiceRequest(String eventHandler, EIMObject eimData, Object data, long timeout) {
        Object result = this.invoke("invokeServiceRequest", new Object[]{eventHandler, eimData, data, HTTPSLSession.calculateSlangTimeout(this.connection, timeout, this.requestTimeout)}, HTTPSLSession.calculateHttpTimeout(timeout, this.requestTimeout));
        HTTPFabricConnection.processServerAnswer(result, Object.class);
        return result;
    }

    @Override
    public ImmutableEventDatagram invokeServiceRequest(EventDatagram request, RequestDistributionStrategy strategy) throws HTTPFabricException {
        Object[] args = new Object[]{request, strategy};
        Object result = this.invoke("invokeServiceRequest", args, HTTPSLSession.calculateHttpTimeout(-1L, this.requestTimeout));
        HTTPFabricConnection.processServerAnswer(result, ImmutableEventDatagram.class);
        return (ImmutableEventDatagram)result;
    }

    @Override
    public ImmutableEventDatagram invokeServiceRequest(EventDatagram request, RequestDistributionStrategy strategy, long timeout) throws HTTPFabricException {
        Object[] args = new Object[]{request, strategy, HTTPSLSession.calculateSlangTimeout(this.connection, timeout, this.requestTimeout)};
        Object result = this.invoke("invokeServiceRequest", args, HTTPSLSession.calculateHttpTimeout(timeout, this.requestTimeout));
        HTTPFabricConnection.processServerAnswer(result, ImmutableEventDatagram.class);
        return (ImmutableEventDatagram)result;
    }

    @Override
    public void invokeAsyncServiceRequest(ImmutableEventDatagram request) throws HTTPFabricException {
        Object[] args = new Object[]{request};
        this.invoke("invokeAsyncServiceRequest", args);
    }

    @Override
    public EventHandler lookupEventHandler(String handlerName) {
        Object result = this.invoke("lookupEventHandler", new Object[]{handlerName});
        HTTPFabricConnection.processServerAnswer(result, EventHandler.class);
        return (EventHandler)result;
    }

    @Override
    public EventHandler lookupEventHandlerByMethod(String methodName) {
        Object result = this.invoke("lookupEventHandlerByMethod", new Object[]{methodName});
        HTTPFabricConnection.processServerAnswer(result, EventHandler.class);
        return (EventHandler)result;
    }

    @Override
    public boolean isEventHandlerValid(String handlerName) throws FabricComponentAccessorException {
        Object result = this.invoke("isEventHandlerValid", new Object[]{handlerName});
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public List<EventHandler> getEventHandlers() {
        Object[] definitions;
        Object[] args = new Object[]{};
        Object result = this.invoke("getEventHandlers", args);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<EventHandler> list = new ArrayList<EventHandler>();
        for (Object obj : definitions = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(obj, EventHandler.class);
            list.add((EventHandler)obj);
        }
        return list;
    }

    @Override
    public List<String> listEventHandlers() {
        Object[] definitions;
        Object[] args = new Object[]{};
        Object result = this.invoke("listEventHandlers", args);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<String> list = new ArrayList<String>();
        for (Object obj : definitions = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(obj, String.class);
            list.add((String)obj);
        }
        return list;
    }

    @Override
    public List<ActiveEvent> listActiveEvents() throws FabricComponentAccessorException {
        Object[] activeEvents;
        Object[] args = new Object[]{};
        Object result = this.invoke("listActiveEvents", args);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<ActiveEvent> list = new ArrayList<ActiveEvent>();
        for (Object activeEvent : activeEvents = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(activeEvent, ActiveEvent.class);
            list.add((ActiveEvent)activeEvent);
        }
        return list;
    }

    @Override
    public String getEventHandlerParameterName(String handlerName) throws FabricComponentAccessorException {
        Object result = this.invoke("getEventHandlerParameterName", new Object[]{handlerName});
        HTTPFabricConnection.processServerAnswer(result, String.class);
        return (String)result;
    }

    @Override
    public RPLMethodsCache.RPLMethodInfo getEventHandlerRPLMethodInfo(String handlerName) throws FabricComponentAccessorException {
        Object result = this.invoke("getEventHandlerRPLMethodInfo", new Object[]{handlerName});
        HTTPFabricConnection.processServerAnswer(result, RPLMethodsCache.RPLMethodInfo.class);
        return (RPLMethodsCache.RPLMethodInfo)result;
    }

    @Override
    public void addEventTrigger(String triggerSyntax) throws ServiceConfigurationException {
        this.invoke("addEventTrigger", new Object[]{triggerSyntax});
    }

    @Override
    public void alterEventTrigger(String triggerSyntax) throws ServiceConfigurationException {
        this.invoke("alterEventTrigger", new Object[]{triggerSyntax});
    }

    @Override
    public String getEventTriggerSyntax(String triggerName) throws ServiceConfigurationException {
        Object result = this.invoke("getEventTriggerSyntax", new Object[]{triggerName});
        HTTPFabricConnection.processServerAnswer(result, String.class);
        return (String)result;
    }

    @Override
    public EventTriggerData getEventTriggerData(String triggerName) throws ServiceConfigurationException {
        Object result = this.invoke("getEventTriggerData", new Object[]{triggerName});
        HTTPFabricConnection.processServerAnswer(result, EventTriggerData.class);
        return (EventTriggerData)result;
    }

    @Override
    public boolean isEventTriggerAutoEnable(String triggerName) throws IllegalTriggerStateException {
        Object result = this.invoke("isEventTriggerAutoEnable", new Object[]{triggerName});
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public void setEventTriggerAutoEnable(String triggerName, boolean autoEnable) throws IllegalTriggerStateException, ServiceConfigurationException {
        this.invoke("setEventTriggerAutoEnable", new Object[]{triggerName, autoEnable});
    }
}

