/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.cli.http;

import com.streamscape.cli.http.HTTPFabricConnection;
import com.streamscape.cli.http.HTTPFabricException;
import com.streamscape.sdo.vcard.vCard;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.network.http.server.fabric.HTTPFabricConnectionRemoteCall;
import com.streamscape.sef.network.http.server.fabric.RemoteMethodCall;
import com.streamscape.sef.security.AccessControlList;
import com.streamscape.sef.security.AccessControlOperation;
import com.streamscape.sef.security.Group;
import com.streamscape.sef.security.Organization;
import com.streamscape.sef.security.SecurityContext;
import com.streamscape.sef.security.SecurityManager;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.sef.security.User;
import java.util.ArrayList;
import java.util.List;

class HTTPSecurityManager
implements SecurityManager {
    protected HTTPFabricConnection connection;

    HTTPSecurityManager(HTTPFabricConnection fabricConnection) {
        this.connection = fabricConnection;
    }

    @Override
    public void addUserToGroup(String userName, String groupName) throws SecurityManagerException {
        Object[] args = new Object[]{userName, groupName};
        this.invoke("addUserToGroup", args);
    }

    @Override
    public Group createGroup(String name, String description) throws SecurityManagerException {
        Object[] args = new Object[]{name, description};
        Object result = this.invoke("createGroup", args);
        HTTPFabricConnection.processServerAnswer(result, Group.class);
        return (Group)result;
    }

    @Override
    public Organization createOrganization(String name, String description) throws SecurityManagerException {
        Object[] args = new Object[]{name, description};
        Object result = this.invoke("createOrganization", args);
        HTTPFabricConnection.processServerAnswer(result, Organization.class);
        return (Organization)result;
    }

    @Override
    public User createUser(String name, String password, String description) throws SecurityManagerException {
        Object[] args = new Object[]{name, password, description};
        Object result = this.invoke("createUser", args);
        HTTPFabricConnection.processServerAnswer(result, User.class);
        return (User)result;
    }

    @Override
    public User createUser(String name, String password, String description, vCard vcard) throws SecurityManagerException {
        Object[] args = new Object[]{name, password, description, vcard};
        Object result = this.invoke("createUser", args);
        HTTPFabricConnection.processServerAnswer(result, User.class);
        return (User)result;
    }

    @Override
    public void disableUser(String name) throws SecurityManagerException {
        Object[] args = new Object[]{name};
        this.invoke("disableUser", args);
    }

    @Override
    public void dropGroup(String name) throws SecurityManagerException {
        Object[] args = new Object[]{name};
        this.invoke("dropGroup", args);
    }

    @Override
    public void dropOrganization(String name) throws SecurityManagerException {
        Object[] args = new Object[]{name};
        this.invoke("dropOrganization", args);
    }

    @Override
    public void dropUser(String name) throws SecurityManagerException {
        Object[] args = new Object[]{name};
        this.invoke("dropUser", args);
    }

    @Override
    public void enableUser(String name) throws SecurityManagerException {
        Object[] args = new Object[]{name};
        this.invoke("enableUser", args);
    }

    @Override
    public boolean existsGroup(String name) throws SecurityManagerException {
        Object[] args = new Object[]{name};
        Object result = this.invoke("existsGroup", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public boolean existsOrganization(String name) throws SecurityManagerException {
        Object[] args = new Object[]{name};
        Object result = this.invoke("existsOrganization", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public boolean existsUser(String name) throws SecurityManagerException {
        Object[] args = new Object[]{name};
        Object result = this.invoke("existsUser", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public SecurityContext getSecurityContext() {
        Object[] args = new Object[]{};
        Object result = this.invoke("getSecurityContext", args);
        HTTPFabricConnection.processServerAnswer(result, SecurityContext.class);
        return (SecurityContext)result;
    }

    @Override
    public List<Group> getGroups() throws SecurityManagerException {
        Object[] array;
        Object[] args = new Object[]{};
        Object result = this.invoke("getGroups", args);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<Group> list = new ArrayList<Group>();
        for (Object obj : array = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(obj, Group.class);
            list.add((Group)obj);
        }
        return list;
    }

    @Override
    public List<Organization> getOrganizations() throws SecurityManagerException {
        Object[] array;
        Object[] args = new Object[]{};
        Object result = this.invoke("getOrganizations", args);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<Organization> list = new ArrayList<Organization>();
        for (Object obj : array = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(obj, Organization.class);
            list.add((Organization)obj);
        }
        return list;
    }

    @Override
    public List<User> getUsers() throws SecurityManagerException {
        Object[] array;
        Object[] args = new Object[]{};
        Object result = this.invoke("getUsers", args);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<User> list = new ArrayList<User>();
        for (Object obj : array = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(obj, User.class);
            list.add((User)obj);
        }
        return list;
    }

    @Override
    public vCard getVCard(String userName) throws SecurityManagerException {
        Object[] args = new Object[]{userName};
        Object result = this.invoke("getVCard", args);
        HTTPFabricConnection.processServerAnswer(result, vCard.class);
        return (vCard)result;
    }

    @Override
    public List<String> listGroups() throws SecurityManagerException {
        Object[] array;
        Object[] args = new Object[]{};
        Object result = this.invoke("listGroups", args);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<String> vector = new ArrayList<String>();
        for (Object obj : array = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(obj, String.class);
            vector.add((String)obj);
        }
        return vector;
    }

    @Override
    public List<String> listOrganizations() throws SecurityManagerException {
        Object[] array;
        Object[] args = new Object[]{};
        Object result = this.invoke("listOrganizations", args);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<String> vector = new ArrayList<String>();
        for (Object obj : array = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(obj, String.class);
            vector.add((String)obj);
        }
        return vector;
    }

    @Override
    public List<String> listUsers() throws SecurityManagerException {
        Object[] array;
        Object[] args = new Object[]{};
        Object result = this.invoke("listUsers", args);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<String> vector = new ArrayList<String>();
        for (Object obj : array = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(obj, String.class);
            vector.add((String)obj);
        }
        return vector;
    }

    @Override
    public void addUserPermission(String userName, AccessControlOperation operation) throws SecurityManagerException {
        Object[] args = new Object[]{userName, operation};
        this.invoke("addUserPermission", args);
    }

    @Override
    public void removeUserPermission(String userName, AccessControlOperation operation) throws SecurityManagerException {
        Object[] args = new Object[]{userName, operation};
        this.invoke("removeUserPermission", args);
    }

    @Override
    public void resetUserPermissions(String userName) throws SecurityManagerException {
        Object[] args = new Object[]{userName};
        this.invoke("resetUserPermissions", args);
    }

    @Override
    public AccessControlList getUserPermissions(String userName) throws SecurityManagerException {
        Object[] args = new Object[]{userName};
        Object result = this.invoke("getUserPermissions", args);
        HTTPFabricConnection.processServerAnswer(result, AccessControlList.class);
        return (AccessControlList)result;
    }

    @Override
    public void addGroupPermission(String groupName, AccessControlOperation operation) throws SecurityManagerException {
        Object[] args = new Object[]{groupName, operation};
        this.invoke("addGroupPermission", args);
    }

    @Override
    public void removeGroupPermission(String groupName, AccessControlOperation operation) throws SecurityManagerException {
        Object[] args = new Object[]{groupName, operation};
        this.invoke("removeGroupPermission", args);
    }

    @Override
    public AccessControlList getGroupPermissions(String groupName) throws SecurityManagerException {
        Object[] args = new Object[]{groupName};
        Object result = this.invoke("getGroupPermissions", args);
        HTTPFabricConnection.processServerAnswer(result, AccessControlList.class);
        return (AccessControlList)result;
    }

    @Override
    public Group lookupGroup(String name) throws SecurityManagerException {
        Object[] args = new Object[]{name};
        Object result = this.invoke("lookupGroup", args);
        HTTPFabricConnection.processServerAnswer(result, Group.class);
        return (Group)result;
    }

    @Override
    public Organization lookupOrganization(String name) throws SecurityManagerException {
        Object[] args = new Object[]{name};
        Object result = this.invoke("lookupOrganization", args);
        HTTPFabricConnection.processServerAnswer(result, Organization.class);
        return (Organization)result;
    }

    @Override
    public User lookupUser(String name) throws SecurityManagerException {
        Object[] args = new Object[]{name};
        Object result = this.invoke("lookupUser", args);
        HTTPFabricConnection.processServerAnswer(result, User.class);
        return (User)result;
    }

    @Override
    public void removeUserFromGroup(String userName, String groupName) throws SecurityManagerException {
        Object[] args = new Object[]{userName, groupName};
        this.invoke("removeUserFromGroup", args);
    }

    @Override
    public void setGroupOrganization(String groupName, String organizationName) throws SecurityManagerException {
        Object[] args = new Object[]{groupName, organizationName};
        this.invoke("setGroupOrganization", args);
    }

    @Override
    public void setOrganizationDomain(String organizationName, String domain) throws SecurityManagerException {
        Object[] args = new Object[]{organizationName, domain};
        this.invoke("setOrganizationDomain", args);
    }

    @Override
    public void setUserOrganization(String userName, String organizationName) throws SecurityManagerException {
        Object[] args = new Object[]{userName, organizationName};
        this.invoke("setUserOrganization", args);
    }

    @Override
    public void setVCard(String userName, vCard vcard) throws SecurityManagerException {
        Object[] args = new Object[]{userName, vcard};
        this.invoke("setVCard", args);
    }

    @Override
    public void updateGroup(Group group) throws SecurityManagerException {
        Object[] args = new Object[]{group};
        this.invoke("updateGroup", args);
    }

    @Override
    public void updateOrganization(Organization organization) throws SecurityManagerException {
        Object[] args = new Object[]{organization};
        this.invoke("updateOrganization", args);
    }

    @Override
    public void updateUser(User user) throws SecurityManagerException {
        Object[] args = new Object[]{user};
        this.invoke("updateUser", args);
    }

    @Override
    public String resetPassword(String userName) throws SecurityManagerException {
        Object[] args = new Object[]{userName};
        Object result = this.invoke("resetPassword", args);
        HTTPFabricConnection.processServerAnswer(result, String.class);
        return (String)result;
    }

    @Override
    public void changePassword(String userName, String oldPassword, String newPassword) throws SecurityManagerException {
        Object[] args = new Object[]{userName, oldPassword, newPassword};
        this.invoke("changePassword", args);
    }

    @Override
    public List<ComponentReference> listBoundComponents(String ownerName, boolean inSysplex) throws SecurityManagerException {
        Object[] array;
        Object[] args = new Object[]{ownerName, inSysplex};
        Object result = this.invoke("listBoundComponents", args);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<ComponentReference> vector = new ArrayList<ComponentReference>();
        for (Object obj : array = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(obj, ComponentReference.class);
            vector.add((ComponentReference)obj);
        }
        return vector;
    }

    protected Object invoke(String methodName, Object[] args) throws HTTPFabricException {
        HTTPFabricConnectionRemoteCall call = new HTTPFabricConnectionRemoteCall();
        Object[] securityArgs = new Object[]{};
        call.pushMethodCall(new RemoteMethodCall("getSecurityManager", securityArgs));
        call.pushMethodCall(new RemoteMethodCall(methodName, args));
        return this.connection.invokeRemoteCall(call, null);
    }
}

