/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.cli.http;

import com.streamscape.cli.http.HTTPSLSession;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.AbstractDSLProvider;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.completion.SuggestionGroup;
import com.streamscape.slex.lang.parameter.IntegerParameter;

public class HTTPSLSessionDSLProvider
extends AbstractDSLProvider<HTTPSLSession> {
    public HTTPSLSessionDSLProvider(HTTPSLSession callable) {
        super("HTTPSLSessionDSLProvider", callable, SuggestionGroup.SESSION_OPERATIONS);
        this.registerOperation(new HTTPSLSessionSetSessionTimeoutOperation());
        this.registerOperation(new HTTPSLSessionGetSessionTimeoutOperation());
        this.activate(callable);
    }

    static class HTTPSLSessionSetSessionTimeoutOperation
    extends AbstractDSLOperation<HTTPSLSession> {
        private static final String NAME = "set session timeout";

        HTTPSLSessionSetSessionTimeoutOperation() {
            this.createDSLSyntax(NAME);
            this.syntax.setAction("SET SESSION TIMEOUT").addActionParameter(new IntegerParameter("timeout"));
            this.syntax.setDescription("Sets session timeout in seconds.");
            this.syntax.addTag(OperationTag.session);
        }

        @Override
        public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
            ((HTTPSLSession)this.callable).setSessionTimeout(((Definition)statement).timeout * 1000);
            return new SLResponse();
        }

        @Override
        public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
            return new Definition(statement.getParameter("timeout").getValue(0));
        }

        static class Definition
        extends AbstractSLStatement {
            private final int timeout;

            Definition(int timeout) {
                super(HTTPSLSessionSetSessionTimeoutOperation.NAME);
                this.timeout = timeout;
            }
        }
    }

    static class HTTPSLSessionGetSessionTimeoutOperation
    extends AbstractDSLOperation<HTTPSLSession> {
        private static final String NAME = "get session timeout";

        HTTPSLSessionGetSessionTimeoutOperation() {
            this.createDSLSyntax(NAME);
            this.syntax.setAction("GET SESSION TIMEOUT");
            this.syntax.setDescription("Returns session timeout in seconds.");
            this.syntax.addTag(OperationTag.session);
        }

        @Override
        public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
            return new SLResponse("" + (int)(((HTTPSLSession)this.callable).getSessionTimeout() / 1000L));
        }

        @Override
        public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
            return new Definition();
        }

        static class Definition
        extends AbstractSLStatement {
            Definition() {
                super(HTTPSLSessionGetSessionTimeoutOperation.NAME);
            }
        }
    }
}

