/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.cli.http;

import com.streamscape.cli.ClientState;
import com.streamscape.cli.http.HTTPDataspaceAccessor;
import com.streamscape.cli.http.HTTPFabricConnection;
import com.streamscape.cli.http.HTTPFabricException;
import com.streamscape.cli.http.HTTPSLSessionDSLProvider;
import com.streamscape.runtime.RuntimeState;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.event.OpaqueEvent;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.PromptSLResponse;
import com.streamscape.sdo.operation.SLCallable;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AccessibleObjectComponent;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.network.http.server.fabric.HTTPFabricConnectionRemoteCall;
import com.streamscape.sef.network.http.server.fabric.RemoteMethodCall;
import com.streamscape.sef.network.http.server.fabric.RemoteMethodCallPostprocessor;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.UnsupportedRequestException;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.slang.SLMessageListener;
import com.streamscape.slex.slang.SLSession;
import com.streamscape.tools.console.autocompletion.Completer;
import com.streamscape.tools.console.autocompletion.CompleterCondition;
import com.streamscape.tools.console.autocompletion.CompoundCompleter;

class HTTPSLSession
implements SLSession,
AccessibleObjectComponent,
SLCallable {
    protected String name;
    protected HTTPFabricConnection connection;
    protected String nodeName;
    protected Object[] getSLSessionArgs;
    protected SLMessageListener slMessageListener;
    protected int fetchSize = -2;
    protected PromptSLResponse prompt = null;
    protected HTTPFabricConnection.HTTPClientWrapper wrapper = null;
    private long sessionTimeout = 30000L;
    private HTTPSLSessionDSLProvider sessionDSLProvider;
    private InternalMFSession internalMFSession;
    private CompoundCompleter compoundCompleter;

    HTTPSLSession(HTTPFabricConnection fabricConnection) {
        this(fabricConnection, null);
    }

    HTTPSLSession(HTTPFabricConnection fabricConnection, String nodeName) {
        this.connection = fabricConnection;
        this.nodeName = nodeName;
        this.sessionDSLProvider = new HTTPSLSessionDSLProvider(this);
        this.internalMFSession = new InternalMFSession();
        this.compoundCompleter = new CompoundCompleter();
        this.compoundCompleter.addCompleter(this.sessionDSLProvider);
        this.compoundCompleter.addCompleter(new HTTPSLSessionCompleter());
        this.open();
    }

    protected void open() {
        if (this.wrapper != null) {
            this.wrapper.closeQuiet();
        }
        this.wrapper = this.connection.createHttpClientWrapper();
        HTTPFabricConnectionRemoteCall call = new HTTPFabricConnectionRemoteCall();
        Object[] createSLSessionArgs = this.nodeName != null ? new Object[]{this.nodeName} : new Object[]{};
        call.pushMethodCall(new RemoteMethodCall("createSLSession", createSLSessionArgs));
        call.setPostprocessorMethodCall(RemoteMethodCallPostprocessor.GET_NAME_IF_NOT_NULL);
        Object result = this.connection.invokeRemoteCall(call, null);
        HTTPFabricConnection.processServerAnswer(result, String.class);
        if (result == null) {
            throw new HTTPFabricException("Creation of SLSession failed.");
        }
        this.getSLSessionArgs = new Object[1];
        this.getSLSessionArgs[0] = result;
        this.connection.putSLSession(this.getName(), this);
    }

    protected void reopen() {
        this.open();
        if (this.fetchSize != -2) {
            this.connection.reopenAction(() -> this.setFetchSize(this.fetchSize));
        }
        if (this.prompt != null) {
            Object useTo = "";
            if (this.prompt.getNodeName() != null && !this.prompt.getNodeName().equals(this.nodeName)) {
                useTo = this.prompt.getNodeName();
            }
            if (this.prompt.getComponentType() != null) {
                if (((String)useTo).length() > 0) {
                    useTo = (String)useTo + "://";
                }
                useTo = (String)useTo + this.prompt.getComponentType();
                useTo = (String)useTo + ".";
                useTo = (String)useTo + this.prompt.getComponentName();
            }
            if (((String)useTo).length() > 0) {
                String command = "use " + (String)useTo;
                this.connection.reopenAction(() -> this.slangRequest(command, 10000L));
            }
        }
    }

    @Override
    public void close() {
        try {
            this.getName();
            Object[] args = new Object[]{};
            this.invoke("close", args);
        }
        finally {
            if (this.name != null) {
                this.connection.removeSLSession(this.name);
            }
            if (this.getSLSessionArgs != null && this.getSLSessionArgs.length == 1) {
                this.connection.closeSLFiles((String)this.getSLSessionArgs[0]);
                this.connection.closeSLAudio((String)this.getSLSessionArgs[0]);
            }
            if (this.wrapper != null) {
                this.wrapper.closeQuiet();
                this.wrapper = null;
            }
        }
    }

    @Override
    public String getName() {
        if (this.name == null) {
            Object[] args = new Object[]{};
            Object result = this.invoke("getName", args);
            HTTPFabricConnection.processServerAnswer(result, String.class);
            this.name = (String)result;
        }
        return this.name;
    }

    @Override
    public String getNodeName() {
        Object[] args = new Object[]{};
        Object result = this.invoke("getNodeName", args);
        HTTPFabricConnection.processServerAnswer(result, String.class);
        return (String)result;
    }

    @Override
    public String getComponentType() {
        Object[] args = new Object[]{};
        Object result = this.invoke("getComponentType", args);
        HTTPFabricConnection.processServerAnswer(result, String.class);
        return (String)result;
    }

    @Override
    public String getComponentName() {
        Object[] args = new Object[]{};
        Object result = this.invoke("getComponentName", args);
        HTTPFabricConnection.processServerAnswer(result, String.class);
        return (String)result;
    }

    @Override
    public String getUserName() {
        Object[] args = new Object[]{};
        Object result = this.invoke("getUserName", args);
        HTTPFabricConnection.processServerAnswer(result, String.class);
        return (String)result;
    }

    @Override
    public SLResponse slangRequest(SLStatement request, long timeout) throws HTTPFabricException {
        Object[] args = new Object[]{request, HTTPSLSession.calculateSlangTimeout(this.connection, timeout, -1L)};
        Object result = this.invoke("slangRequest", args, HTTPSLSession.calculateHttpTimeout(timeout, -1L));
        HTTPFabricConnection.processServerAnswer(result, SLResponse.class);
        if (result instanceof PromptSLResponse) {
            this.prompt = (PromptSLResponse)result;
        }
        return (SLResponse)result;
    }

    @Override
    public SLResponse slangRequest(String request, long timeout) throws HTTPFabricException {
        ParsingException sessionProviderException;
        block6: {
            sessionProviderException = null;
            try {
                DSLStatement statement = this.sessionDSLProvider.parseDsl(request, this.internalMFSession);
                if (statement == null) break block6;
                SLResponse response = this.sessionDSLProvider.invoke(statement, this.internalMFSession);
                if (response.getException() instanceof ParsingException) {
                    sessionProviderException = (ParsingException)response.getException();
                    break block6;
                }
                return response;
            }
            catch (ParsingException exception) {
                if (exception.getOperation() != null) {
                    return new SLResponse(exception);
                }
                sessionProviderException = exception;
            }
        }
        Object[] args = new Object[]{request, HTTPSLSession.calculateSlangTimeout(this.connection, timeout, -1L)};
        Object result = this.invoke("slangRequest", args, HTTPSLSession.calculateHttpTimeout(timeout, -1L));
        HTTPFabricConnection.processServerAnswer(result, SLResponse.class);
        if (result instanceof PromptSLResponse) {
            this.prompt = (PromptSLResponse)result;
        }
        SLResponse response = (SLResponse)result;
        if (sessionProviderException != null && response.getException() instanceof UnsupportedRequestException) {
            response = new SLResponse(sessionProviderException);
        }
        return response;
    }

    @Override
    public SLResponse completeRequest(String request) throws HTTPFabricException {
        return new SLResponse().setObject(this.compoundCompleter.completeDsl(request));
    }

    @Override
    public SLResponse completeRequest(String request, long timeout) throws HTTPFabricException {
        return new SLResponse().setObject(this.compoundCompleter.completeDsl(request));
    }

    @Override
    public boolean isOpened() {
        return this.isAvailableOrClosed("isOpened");
    }

    @Override
    public boolean isAvailable() {
        return this.isAvailableOrClosed("isAvailable");
    }

    private boolean isAvailableOrClosed(String methodName) {
        if (!this.connection.isOpened()) {
            return false;
        }
        try {
            Object result = this.invoke(methodName, new Object[0]);
            HTTPFabricConnection.processServerAnswer(result, Boolean.class);
            return (Boolean)result;
        }
        catch (HTTPFabricException exception) {
            if (exception.getMessage().equals("Session is closed.")) {
                return false;
            }
            throw exception;
        }
    }

    protected Object invoke(String methodName, Object[] args) throws HTTPFabricException {
        return this.invoke(methodName, args, -1L);
    }

    protected Object invoke(String methodName, Object[] args, long timeout) throws HTTPFabricException {
        HTTPFabricConnectionRemoteCall call = new HTTPFabricConnectionRemoteCall();
        call.pushMethodCall(new RemoteMethodCall("getSLSession", this.getSLSessionArgs));
        call.pushMethodCall(new RemoteMethodCall(methodName, args));
        Object response = this.connection.invokeRemoteCall(this.wrapper, call, null, timeout);
        HTTPDataspaceAccessor.processAccessibleObjects(response, this);
        return response;
    }

    @Override
    public void setSLMessageListener(SLMessageListener listener) throws HTTPFabricException {
        this.invoke("setSLMessageListener", new Object[]{null});
        this.slMessageListener = listener;
    }

    public int getFetchSize() {
        Object[] args = new Object[]{};
        Object result = this.invoke("getFetchSize", args);
        HTTPFabricConnection.processServerAnswer(result, Number.class);
        return ((Number)result).intValue();
    }

    public void setFetchSize(int fetchSize) {
        Object[] args = new Object[]{fetchSize};
        this.invoke("setFetchSize", args);
        this.fetchSize = fetchSize;
    }

    static long calculateHttpTimeout(long timeout, long defaultTimeout) {
        if (timeout > 0L) {
            timeout += 5000L;
        } else if (timeout == 0L) {
            timeout = 0L;
        } else if (defaultTimeout > 0L) {
            timeout = defaultTimeout + 5000L;
        }
        return timeout;
    }

    static long calculateSlangTimeout(HTTPFabricConnection connection, long timeout, long defaultTimeout) {
        if (timeout < 0L && defaultTimeout > 0L) {
            timeout = defaultTimeout;
        }
        if (timeout < 0L && (timeout = connection.getHttpTimeout()) > 3000L) {
            timeout -= 3000L;
        }
        return timeout;
    }

    @Override
    public String getComponentFullNameWithNode() {
        throw new HTTPFabricException("getComponentFullNameWithNode not supported for HTTP slang sessions.");
    }

    @Override
    public FabricNodeReference lookupFabricNode(String name) {
        throw new HTTPFabricException("lookupFabricNode not supported for HTTP slang sessions.");
    }

    @Override
    public String getActualNodeName() {
        throw new HTTPFabricException("getActualNodeName not supported for HTTP slang sessions.");
    }

    @Override
    public long getRequestTimeout() {
        Object[] args = new Object[]{};
        Object result = this.invoke("getRequestTimeout", args);
        HTTPFabricConnection.processServerAnswer(result, Number.class);
        return ((Number)result).longValue();
    }

    @Override
    public ImmutableEventDatagram raiseSystemRequest(ImmutableEventDatagram request, long timeout) throws Exception {
        Object[] args = new Object[]{request, HTTPSLSession.calculateSlangTimeout(this.connection, timeout, -1L)};
        Object result = this.invoke("raiseSystemRequestInDataspaceAccessor", args, HTTPSLSession.calculateHttpTimeout(timeout, -1L));
        HTTPFabricConnection.processServerAnswer(result, ImmutableEventDatagram.class);
        return (ImmutableEventDatagram)result;
    }

    @Override
    public OpaqueEvent createOpaqueEvent(String eventId, Object data) throws Exception {
        if (RuntimeState.isActive() || ClientState.isActive()) {
            return AccessibleObjectComponent.super.createOpaqueEvent(eventId, data);
        }
        OpaqueEvent opaqueEvent = (OpaqueEvent)this.connection.getEventFactory().createOpaqueEvent(eventId);
        opaqueEvent.setData(data);
        return opaqueEvent;
    }

    @Override
    public void setSessionTimeout(long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    @Override
    public long getSessionTimeout() {
        return this.sessionTimeout;
    }

    @Override
    public boolean isNativeContext(MFSession session) {
        return true;
    }

    static class InternalMFSession
    extends AbstractMFSession {
        InternalMFSession() {
            super("Internal", "HTTPSLSession", null, false, null, null);
        }

        @Override
        public boolean isFromSlangTool() {
            return false;
        }
    }

    private class HTTPSLSessionCompleter
    implements Completer {
        private HTTPSLSessionCompleter() {
        }

        @Override
        public DSLCompletion completeDsl(String command) {
            return this.completeDsl(command, null);
        }

        @Override
        public DSLCompletion completeDsl(String command, CompleterCondition condition) {
            Object[] args = new Object[]{command};
            Object result = HTTPSLSession.this.invoke("completeRequest", args);
            HTTPFabricConnection.processServerAnswer(result, SLResponse.class);
            return (DSLCompletion)((SLResponse)result).getObject();
        }
    }
}

