/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.cli.http;

import com.streamscape.cli.http.HTTPFabricConnectionFactory;
import com.streamscape.cli.http.HTTPSFabricConnection;
import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.cli.tlp.FabricConnectionException;
import com.streamscape.cli.tlp.FabricConnectionFactory;
import com.streamscape.cli.tlp.FabricConnectionFactoryException;
import com.streamscape.lib.http.SSLContextFactory;

public class HTTPSFabricConnectionFactory
extends FabricConnectionFactory {
    public static final String HTTPS_LOCAL_URL = "https://localhost:443";
    public static final String HTTPS_CLIENT_TYPE_NAME = "Client_HTTPS";
    public static final int DEFAULT_PORT_HTTPS = 443;
    private SSLContextFactory sslContextFactory = null;

    public HTTPSFabricConnectionFactory() throws FabricConnectionFactoryException {
        this.addURL(HTTPS_LOCAL_URL);
        this.setType(HTTPS_CLIENT_TYPE_NAME);
        this.setDescription("HTTPS Connection");
    }

    public HTTPSFabricConnectionFactory(String url) throws FabricConnectionFactoryException {
        super(url);
        this.setType(HTTPS_CLIENT_TYPE_NAME);
        this.setDescription("HTTPS Connection");
    }

    @Override
    public void addURL(String url) throws FabricConnectionFactoryException {
        url = HTTPFabricConnectionFactory.formatUrlWithDefaultPortAndSchema(url, true, 443);
        super.addURL(url);
    }

    @Override
    public HTTPSFabricConnection createConnection() throws FabricConnectionFactoryException {
        HTTPSFabricConnection connection = (HTTPSFabricConnection)super.createConnection();
        connection.setSSLContextFactory(this.sslContextFactory);
        return connection;
    }

    @Override
    public HTTPSFabricConnection createConnection(String userName, String password) throws FabricConnectionFactoryException {
        HTTPSFabricConnection connection = (HTTPSFabricConnection)super.createConnection(userName, password);
        connection.setSSLContextFactory(this.sslContextFactory);
        return connection;
    }

    @Override
    public HTTPSFabricConnection createConnection(String securityToken) throws FabricConnectionFactoryException {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    protected void initBasicConnectionParameters(FabricConnection connection) throws FabricConnectionException {
        this.doInitBasicConnectionParameters(connection);
    }

    @Override
    public void setSecurityToken(String securityToken) {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    public void setSSLContextFactory(SSLContextFactory sslContextFactory) {
        this.sslContextFactory = sslContextFactory;
    }

    @Override
    protected FabricConnection createConnectionInstance() {
        return new HTTPSFabricConnection(HTTPSFabricConnectionFactory.getContext(), this.getType());
    }
}

