/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.cli.http;

import com.streamscape.cli.http.HTTPFabricConnection;
import com.streamscape.cli.http.HTTPFabricException;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.repository.RepositoryException;
import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.repository.cli.RepositoryAccessorException;
import com.streamscape.repository.enums.PackageType;
import com.streamscape.repository.filesystem.FSFile;
import com.streamscape.repository.object.Binding;
import com.streamscape.repository.object.ReferenceContext;
import com.streamscape.repository.pkg.Package;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.RuntimeState;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.sys.SysId;
import com.streamscape.sef.network.http.server.fabric.HTTPFabricConnectionRemoteCall;
import com.streamscape.sef.network.http.server.fabric.RemoteMethodCall;
import com.streamscape.service.osf.clients.ClientFactory;
import com.streamscape.service.osf.jdbc.JDBCFactory;
import com.streamscape.service.osf.transports.TransportFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;

public class HTTPRepositoryAccessor
implements RepositoryAccessor {
    protected HTTPFabricConnection connection;
    protected String nodeName = null;

    HTTPRepositoryAccessor(String nodeName, HTTPFabricConnection connection) {
        this.nodeName = nodeName;
        this.connection = connection;
    }

    protected Object invoke(String methodName, Object[] args) throws HTTPFabricException {
        return this.invoke(methodName, args, null);
    }

    protected Object invoke(String methodName, Object[] args, Class<?> resultClazz) throws HTTPFabricException {
        HTTPFabricConnectionRemoteCall call = new HTTPFabricConnectionRemoteCall();
        call.pushMethodCall(new RemoteMethodCall("getRepositoryAccessor", new Object[]{this.nodeName}));
        call.pushMethodCall(new RemoteMethodCall(methodName, args));
        return this.connection.invokeRemoteCall(call, null, resultClazz);
    }

    @Override
    public String getNodeName() {
        Object[] args = new Object[]{};
        Object result = this.invoke("getNodeName", args);
        HTTPFabricConnection.processServerAnswer(result, String.class);
        return (String)result;
    }

    @Override
    public boolean isOpened() {
        if (!this.connection.isOpened()) {
            return false;
        }
        Object[] args = new Object[]{};
        Object result = this.invoke("isOpened", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public SysId getSystemId() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("getSystemId", args);
        HTTPFabricConnection.processServerAnswer(result, SysId.class);
        return (SysId)result;
    }

    @Override
    public String getProviderClass() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("getProviderClass", args);
        HTTPFabricConnection.processServerAnswer(result, String.class);
        return (String)result;
    }

    @Override
    public String getVendor() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("getVendor", args);
        HTTPFabricConnection.processServerAnswer(result, String.class);
        return (String)result;
    }

    @Override
    public String getInstallRoot() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("getInstallRoot", args);
        HTTPFabricConnection.processServerAnswer(result, String.class);
        if (result == null) {
            result = "";
        }
        return (String)result;
    }

    @Override
    public boolean isTypeResolutionCapable() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("isTypeResolutionCapable", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public boolean isObjectReferenceCapable() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("isObjectReferenceCapable", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public boolean isGlobalsCapable() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("isGlobalsCapable", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public boolean isTransactionCapable() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("isTransactionCapable", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public Map<String, Object> getEnvironment() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("getEnvironment", args);
        HTTPFabricConnection.processServerAnswer(result, Map.class);
        return (Map)result;
    }

    @Override
    public Object addEnvironmentVariable(String name, Object value) throws HTTPFabricException {
        Object[] args = new Object[]{name, value};
        Object result = this.invoke("addEnvironmentVariable", args);
        HTTPFabricConnection.processServerAnswer(result, Object.class);
        return result;
    }

    @Override
    public Object removeEnvironmentVariable(String name) throws HTTPFabricException {
        Object[] args = new Object[]{name};
        Object result = this.invoke("removeEnvironmentVariable", args);
        HTTPFabricConnection.processServerAnswer(result, Object.class);
        return result;
    }

    @Override
    public boolean inXact() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("inXact", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public FSFile getRootDirectory() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("getRootDirectory", args);
        HTTPFabricConnection.processServerAnswer(result, FSFile.class);
        return (FSFile)result;
    }

    @Override
    public void createDirectory(FSFile baseDirectory, String subDirectoryName) throws HTTPFabricException {
        Object[] args = new Object[]{baseDirectory, subDirectoryName};
        this.invoke("createDirectory", args);
    }

    @Override
    public FSFile createDirectory(String path) throws HTTPFabricException {
        Object[] args = new Object[]{path};
        Object result = this.invoke("createDirectory", args);
        HTTPFabricConnection.processServerAnswer(result, FSFile.class);
        return (FSFile)result;
    }

    @Override
    public void createFile(String path, byte[] content, long expiration) throws HTTPFabricException {
        Object[] args = new Object[]{path, content, expiration};
        this.invoke("createFile", args);
    }

    @Override
    public void createFile(String path, File contentFile, long expiration) throws HTTPFabricException {
        if (!contentFile.exists()) {
            throw new HTTPFabricException("File '" + contentFile.getAbsolutePath() + "' doesn't exist.");
        }
        try {
            byte[] content = FileIOUtils.getFileContent(contentFile);
            Object[] args = new Object[]{path, content, expiration};
            this.invoke("createFile", args);
        }
        catch (UtilitiesException exception) {
            throw new HTTPFabricException("Failed to get file content. Cause: " + exception.getMessage());
        }
    }

    @Override
    public void createFile(String path, InputStream stream, int size, long expiration) throws HTTPFabricException {
        try {
            byte[] content = FileIOUtils.getStreamContent(stream, size);
            Object[] args = new Object[]{path, content, expiration};
            this.invoke("createFile", args);
        }
        catch (UtilitiesException exception) {
            throw new HTTPFabricException("Failed to get stream content. Cause: " + exception.getMessage());
        }
    }

    @Override
    public void deleteDirectory(String path, boolean isRecursive) throws HTTPFabricException {
        Object[] args = new Object[]{path, isRecursive};
        this.invoke("deleteDirectory", args);
    }

    @Override
    public void deleteFile(String path) throws HTTPFabricException {
        Object[] args = new Object[]{path};
        this.invoke("deleteFile", args);
    }

    @Override
    public boolean existsFile(String path) throws HTTPFabricException {
        Object[] args = new Object[]{path};
        Object result = this.invoke("existsFile", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public String getFileContent(String path) throws HTTPFabricException {
        Object[] args = new Object[]{path};
        Object result = this.invoke("getFileContent", args);
        HTTPFabricConnection.processServerAnswer(result, String.class);
        if (result == null) {
            result = "";
        }
        return (String)result;
    }

    @Override
    public byte[] getFileContentBytes(String path) throws HTTPFabricException {
        Object[] args = new Object[]{path};
        Object result = this.invoke("getFileContentBytes", args);
        result = HTTPFabricConnection.processServerByteArrayAnswer(result);
        return (byte[])result;
    }

    @Override
    public void getFileContent(String path, OutputStream stream) throws HTTPFabricException {
        try {
            stream.write(this.getFileContentBytes(path));
        }
        catch (IOException exception) {
            throw new HTTPFabricException(exception);
        }
    }

    @Override
    public FSFile getDetails(String path) throws HTTPFabricException {
        Object[] args = new Object[]{path};
        Object result = this.invoke("getDetails", args);
        HTTPFabricConnection.processServerAnswer(result, FSFile.class);
        return (FSFile)result;
    }

    @Override
    public List<FSFile> getDetails(Collection<String> paths) throws HTTPFabricException {
        Object[] args = new Object[]{paths};
        Object result = this.invoke("getDetails", args);
        return this.objectsArrayToArrayList(result, FSFile.class);
    }

    @Override
    public boolean isDirectory(String path) throws HTTPFabricException {
        Object[] args = new Object[]{path};
        Object result = this.invoke("isDirectory", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public boolean isFile(String path) throws HTTPFabricException {
        Object[] args = new Object[]{path};
        Object result = this.invoke("isFile", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public List<String> listFiles(String path) throws HTTPFabricException {
        Object[] args = new Object[]{path};
        Object result = this.invoke("listFiles", args);
        return this.objectsArrayToArrayList(result, String.class);
    }

    @Override
    public List<String> listDirectories(String path) throws HTTPFabricException {
        Object[] args = new Object[]{path};
        Object result = this.invoke("listDirectories", args);
        return this.objectsArrayToArrayList(result, String.class);
    }

    @Override
    public List<String> listAllArtifacts(String path) throws HTTPFabricException {
        Object[] args = new Object[]{path};
        Object result = this.invoke("listAllArtifacts", args);
        return this.objectsArrayToArrayList(result, String.class);
    }

    @Override
    public List<FSFile> getFilesDetails(String path) throws HTTPFabricException {
        Object[] args = new Object[]{path};
        Object result = this.invoke("getFilesDetails", args);
        return this.objectsArrayToArrayList(result, FSFile.class);
    }

    @Override
    public List<FSFile> getDirectoriesDetails(String path) throws HTTPFabricException {
        Object[] args = new Object[]{path};
        Object result = this.invoke("getDirectoriesDetails", args);
        return this.objectsArrayToArrayList(result, FSFile.class);
    }

    @Override
    public List<FSFile> getAllArtifactsDetails(String path) throws HTTPFabricException {
        Object[] args = new Object[]{path};
        Object result = this.invoke("getAllArtifactsDetails", args);
        return this.objectsArrayToArrayList(result, FSFile.class);
    }

    @Override
    public FSFile renameArtifact(FSFile oldFile, String newName) throws HTTPFabricException {
        Object[] args = new Object[]{oldFile, newName};
        Object result = this.invoke("renameArtifact", args);
        HTTPFabricConnection.processServerAnswer(result, FSFile.class);
        return (FSFile)result;
    }

    @Override
    public void renameArtifact(String oldPath, String newName) throws HTTPFabricException {
        Object[] args = new Object[]{oldPath, newName};
        this.invoke("renameArtifact", args);
    }

    @Override
    public void updateFile(String path, byte[] content) throws HTTPFabricException {
        Object[] args = new Object[]{path, content};
        this.invoke("updateFile", args);
    }

    @Override
    public void updateFile(String path, File contentFile) throws HTTPFabricException {
        if (!contentFile.exists()) {
            throw new HTTPFabricException("File '" + contentFile.getAbsolutePath() + "' doesn't exist.");
        }
        try {
            byte[] content = FileIOUtils.getFileContent(contentFile);
            Object[] args = new Object[]{path, content};
            this.invoke("updateFile", args);
        }
        catch (UtilitiesException exception) {
            throw new HTTPFabricException("Failed to get file content. Cause: " + exception.getMessage());
        }
    }

    @Override
    public void updateFile(String path, InputStream stream, int size) throws HTTPFabricException {
        try {
            byte[] content = FileIOUtils.getStreamContent(stream, size);
            Object[] args = new Object[]{path, content};
            this.invoke("updateFile", args);
        }
        catch (UtilitiesException exception) {
            throw new HTTPFabricException("Failed to get stream content. Cause: " + exception.getMessage());
        }
    }

    @Override
    public void setFileExpiration(String path, long expiration) throws HTTPFabricException {
        Object[] args = new Object[]{path, expiration};
        this.invoke("setFileExpiration", args);
    }

    @Override
    public void appendFile(String path, byte[] content) throws HTTPFabricException {
        Object[] args = new Object[]{path, content};
        this.invoke("appendFile", args);
    }

    @Override
    public void appendFile(String path, File contentFile) throws HTTPFabricException {
        if (!contentFile.exists()) {
            throw new HTTPFabricException("File '" + contentFile.getAbsolutePath() + "' doesn't exist.");
        }
        try {
            byte[] content = FileIOUtils.getFileContent(contentFile);
            Object[] args = new Object[]{path, content};
            this.invoke("appendFile", args);
        }
        catch (UtilitiesException exception) {
            throw new HTTPFabricException("Failed to get file content. Cause: " + exception.getMessage());
        }
    }

    @Override
    public void appendFile(String path, InputStream stream, int size) throws HTTPFabricException {
        try {
            byte[] content = FileIOUtils.getStreamContent(stream, size);
            Object[] args = new Object[]{path, content};
            this.invoke("appendFile", args);
        }
        catch (UtilitiesException exception) {
            throw new HTTPFabricException("Failed to get stream content. Cause: " + exception.getMessage());
        }
    }

    @Override
    public void saveServiceConfiguration(ServiceConfigurationObject sco) throws HTTPFabricException {
        Object[] args = new Object[]{sco};
        this.invoke("saveServiceConfiguration", args);
    }

    @Override
    public ServiceConfigurationObject loadServiceConfiguration(String serviceName, String serviceType) throws HTTPFabricException {
        Object[] args = new Object[]{serviceName, serviceType};
        Object result = this.invoke("loadServiceConfiguration", args);
        HTTPFabricConnection.processServerAnswer(result, ServiceConfigurationObject.class);
        return (ServiceConfigurationObject)result;
    }

    @Override
    public void removeServiceConfiguration(String serviceName, String serviceType) throws HTTPFabricException {
        Object[] args = new Object[]{serviceName, serviceType};
        this.invoke("removeServiceConfiguration", args);
    }

    @Override
    public boolean existsServiceConfiguration(String serviceName, String serviceType) throws HTTPFabricException {
        Object[] args = new Object[]{serviceName, serviceType};
        Object result = this.invoke("existsServiceConfiguration", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public List<String> listServiceTypes() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("listServiceTypes", args);
        return this.objectsArrayToArrayList(result, String.class);
    }

    @Override
    public List<String> listServiceNames() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("listServiceNames", args);
        return this.objectsArrayToArrayList(result, String.class);
    }

    @Override
    public List<String> listServicesByType(String serviceType) throws HTTPFabricException {
        Object[] args = new Object[]{serviceType};
        Object result = this.invoke("listServicesByType", args);
        return this.objectsArrayToArrayList(result, String.class);
    }

    @Override
    public void importServiceConfiguration(String directory, String serviceName, String serviceType, boolean validate) throws HTTPFabricException {
        Object[] args = new Object[]{directory, serviceName, serviceType, validate};
        this.invoke("importServiceConfiguration", args);
    }

    @Override
    public void exportServiceConfiguration(String directory, String serviceName, String serviceType) throws HTTPFabricException {
        Object[] args = new Object[]{directory, serviceName, serviceType};
        this.invoke("exportServiceConfiguration", args);
    }

    @Override
    public String resolveSemanticType(String typeName) throws HTTPFabricException {
        Object[] args = new Object[]{typeName};
        Object result = this.invoke("resolveSemanticType", args);
        HTTPFabricConnection.processServerAnswer(result, String.class);
        return (String)result;
    }

    @Override
    public String resolveSemanticClass(String className) throws HTTPFabricException {
        Object[] args = new Object[]{className};
        Object result = this.invoke("resolveSemanticClass", args);
        HTTPFabricConnection.processServerAnswer(result, String.class);
        return (String)result;
    }

    @Override
    public SemanticType getSemanticType(String typeName) throws HTTPFabricException {
        Object[] args = new Object[]{typeName};
        Object result = this.invoke("getSemanticType", args);
        HTTPFabricConnection.processServerAnswer(result, SemanticType.class);
        return (SemanticType)result;
    }

    @Override
    public boolean existsSemanticType(String typeName) throws HTTPFabricException {
        Object[] args = new Object[]{typeName};
        Object result = this.invoke("existsSemanticType", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public List<String> listSemanticTypes() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("listSemanticTypes", args);
        return this.objectsArrayToArrayList(result, String.class);
    }

    @Override
    public List<SemanticType> getSemanticTypes() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("getSemanticTypes", args);
        return this.objectsArrayToArrayList(result, SemanticType.class);
    }

    @Override
    public ReferenceContext getRootContext() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("getRootContext", args);
        HTTPFabricConnection.processServerAnswer(result, ReferenceContext.class);
        return (ReferenceContext)result;
    }

    @Override
    public ReferenceContext createReferenceContext(String namespace) throws HTTPFabricException {
        Object[] args = new Object[]{namespace};
        Object result = this.invoke("createReferenceContext", args);
        HTTPFabricConnection.processServerAnswer(result, ReferenceContext.class);
        return (ReferenceContext)result;
    }

    @Override
    public ReferenceContext createReferenceContext(ReferenceContext parentContext, String namespace) throws HTTPFabricException {
        Object[] args = new Object[]{parentContext, namespace};
        Object result = this.invoke("createReferenceContext", args);
        HTTPFabricConnection.processServerAnswer(result, ReferenceContext.class);
        return (ReferenceContext)result;
    }

    @Override
    public void destroyReferenceContext(ReferenceContext context) throws HTTPFabricException {
        Object[] args = new Object[]{context};
        this.invoke("destroyReferenceContext", args);
    }

    @Override
    public void setReferenceContext(ReferenceContext context) throws HTTPFabricException {
        Object[] args = new Object[]{context};
        this.invoke("setReferenceContext", args);
    }

    @Override
    public void resetReferenceContext() throws RepositoryAccessorException, NamingException, RepositoryException {
        this.invoke("resetReferenceContext", new Object[0]);
    }

    @Override
    public ReferenceContext getReferenceContext() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("getReferenceContext", args);
        HTTPFabricConnection.processServerAnswer(result, ReferenceContext.class);
        return (ReferenceContext)result;
    }

    @Override
    public ReferenceContext lookupReferenceContext(String namespace) throws HTTPFabricException {
        Object[] args = new Object[]{namespace};
        Object result = this.invoke("lookupReferenceContext", args);
        HTTPFabricConnection.processServerAnswer(result, ReferenceContext.class);
        return (ReferenceContext)result;
    }

    @Override
    public boolean existsReferenceContext(String namespace) throws HTTPFabricException {
        Object[] args = new Object[]{namespace};
        Object result = this.invoke("existsReferenceContext", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public List<String> listReferenceContexts() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("listReferenceContexts", args);
        return this.objectsArrayToArrayList(result, String.class);
    }

    @Override
    public void bindObject(String name, Object object) throws HTTPFabricException {
        Object[] args = new Object[]{name, object};
        this.invoke("bindObject", args);
    }

    @Override
    public void rebindObject(String name, Object object) throws HTTPFabricException {
        Object[] args = new Object[]{name, object};
        this.invoke("rebindObject", args);
    }

    @Override
    public void unbindObject(String name) throws HTTPFabricException {
        Object[] args = new Object[]{name};
        this.invoke("unbindObject", args);
    }

    @Override
    public void renameObject(String oldName, String newName) throws HTTPFabricException {
        Object[] args = new Object[]{oldName, newName};
        this.invoke("renameObject", args);
    }

    @Override
    public Object lookupObject(String name) throws HTTPFabricException {
        Object[] args = new Object[]{name};
        Object result = this.invoke("lookupObject", args);
        HTTPFabricConnection.processServerAnswer(result, Object.class);
        return result;
    }

    @Override
    public Object lookupObject(String namespace, String objectName) throws HTTPFabricException {
        Object[] args = new Object[]{namespace, objectName};
        Object result = this.invoke("lookupObject", args);
        HTTPFabricConnection.processServerAnswer(result, Object.class);
        return result;
    }

    @Override
    public Object lookupObject(ReferenceContext context, String objectName) throws RepositoryAccessorException, NamingException, RepositoryException {
        Object[] args = new Object[]{context, objectName};
        Object result = this.invoke("lookupObject", args);
        HTTPFabricConnection.processServerAnswer(result, Object.class);
        return result;
    }

    @Override
    public boolean existsObject(String name) throws HTTPFabricException {
        Object[] args = new Object[]{name};
        Object result = this.invoke("existsObject", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public List<String> listQualifiedObjectNames() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("listQualifiedObjectNames", args);
        return this.objectsArrayToArrayList(result, String.class);
    }

    @Override
    public List<String> listQualifiedObjectNames(ReferenceContext context) throws HTTPFabricException {
        Object[] args = new Object[]{context};
        Object result = this.invoke("listQualifiedObjectNames", args);
        return this.objectsArrayToArrayList(result, String.class);
    }

    @Override
    public List<String> listObjectNames(String objectType) throws HTTPFabricException {
        Object[] args = new Object[]{objectType};
        Object result = this.invoke("listObjectNames", args);
        return this.objectsArrayToArrayList(result, String.class);
    }

    @Override
    public List<String> listObjectNames(ReferenceContext context, String objectType) throws HTTPFabricException {
        Object[] args = new Object[]{context, objectType};
        Object result = this.invoke("listObjectNames", args);
        return this.objectsArrayToArrayList(result, String.class);
    }

    @Override
    public List<Binding> listBindings() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("listBindings", args);
        return this.objectsArrayToArrayList(result, Binding.class);
    }

    @Override
    public List<Binding> listBindings(ReferenceContext context) throws HTTPFabricException {
        Object[] args = new Object[]{context};
        Object result = this.invoke("listBindings", args);
        return this.objectsArrayToArrayList(result, Binding.class);
    }

    @Override
    public void addPackage(Package pkg) throws HTTPFabricException {
        Object[] args = new Object[]{pkg};
        this.invoke("addPackage", args);
    }

    @Override
    public void addPackage(Package pkg, File[] jars) throws HTTPFabricException {
        throw new HTTPFabricException("Operation is not supported.");
    }

    @Override
    public Package getPackage(PackageType type, String name) throws HTTPFabricException {
        Object[] args = new Object[]{type, name};
        Object result = this.invoke("getPackage", args);
        HTTPFabricConnection.processServerAnswer(result, Package.class);
        return (Package)result;
    }

    @Override
    public Package getPackage(String fullName) throws HTTPFabricException {
        Object[] args = new Object[]{fullName};
        Object result = this.invoke("getPackage", args);
        HTTPFabricConnection.processServerAnswer(result, Package.class);
        return (Package)result;
    }

    @Override
    public Package getPackageByArchive(String jarName) throws HTTPFabricException {
        Object[] args = new Object[]{jarName};
        Object result = this.invoke("getPackageByArchive", args);
        HTTPFabricConnection.processServerAnswer(result, Package.class);
        return (Package)result;
    }

    @Override
    public void removePackage(PackageType type, String name, boolean withJars) throws HTTPFabricException {
        Object[] args = new Object[]{type, name, withJars};
        this.invoke("removePackage", args);
    }

    @Override
    public void removePackage(String fullName, boolean withJars) throws HTTPFabricException {
        Object[] args = new Object[]{fullName, withJars};
        this.invoke("removePackage", args);
    }

    @Override
    public boolean existsPackage(PackageType type, String name) throws HTTPFabricException {
        Object[] args = new Object[]{type, name};
        Object result = this.invoke("existsPackage", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public boolean existsPackage(String fullName) throws HTTPFabricException {
        Object[] args = new Object[]{fullName};
        Object result = this.invoke("existsPackage", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public void updatePackage(Package pkg) throws HTTPFabricException {
        Object[] args = new Object[]{pkg};
        this.invoke("updatePackage", args);
    }

    @Override
    public void importPackage(String directory, PackageType type, String name) throws HTTPFabricException {
        Object[] args = new Object[]{directory, type, name};
        this.invoke("importPackage", args);
    }

    @Override
    public void importPackage(String directory, String fullName) throws HTTPFabricException {
        Object[] args = new Object[]{directory, fullName};
        this.invoke("importPackage", args);
    }

    @Override
    public void exportPackage(String directory, PackageType type, String name) throws HTTPFabricException {
        Object[] args = new Object[]{directory, type, name};
        this.invoke("exportPackage", args);
    }

    @Override
    public void exportPackage(String directory, String fullName) throws HTTPFabricException {
        Object[] args = new Object[]{directory, fullName};
        this.invoke("exportPackage", args);
    }

    @Override
    public List<String> listPackages() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("listPackages", args);
        return this.objectsArrayToArrayList(result, String.class);
    }

    @Override
    public List<String> listPackagesByType(PackageType type) throws HTTPFabricException {
        Object[] args = new Object[]{type};
        Object result = this.invoke("listPackagesByType", args);
        return this.objectsArrayToArrayList(result, String.class);
    }

    @Override
    public void addArchive(File jar) throws HTTPFabricException {
        byte[] jarContent;
        try {
            jarContent = FileIOUtils.getFileContent(jar);
        }
        catch (Exception exception) {
            throw new HTTPFabricException("Reading jar '" + jar.getAbsolutePath() + "' content failed.");
        }
        this.addArchive(jar.getName(), jarContent);
    }

    @Override
    public void addArchive(String jarName, byte[] jarContent) throws HTTPFabricException {
        Object[] args = new Object[]{jarName, jarContent};
        this.invoke("addArchive", args);
    }

    @Override
    public void removeArchive(String jarName) throws HTTPFabricException {
        Object[] args = new Object[]{jarName};
        this.invoke("removeArchive", args);
    }

    @Override
    public boolean existsArchive(String jarName) throws HTTPFabricException {
        Object[] args = new Object[]{jarName};
        Object result = this.invoke("existsArchive", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public byte[] getArchive(String jarName) throws HTTPFabricException {
        Object[] args = new Object[]{jarName};
        Object result = this.invoke("getArchive", args);
        return HTTPFabricConnection.processServerByteArrayAnswer(result);
    }

    @Override
    public InputStream getArchiveStream(String jarName) throws HTTPFabricException {
        if (RuntimeState.isActive() && (this.nodeName == null || RuntimeContext.getInstance().getName().equals(this.nodeName))) {
            Object[] args = new Object[]{jarName};
            Object result = this.invoke("getArchiveStream", args, InputStream.class);
            HTTPFabricConnection.processServerAnswer(result, InputStream.class);
            return (InputStream)result;
        }
        throw new HTTPFabricException("Operation is not supported.");
    }

    @Override
    public URL getArchiveURL(String jarName) throws HTTPFabricException {
        if (RuntimeState.isActive() && (this.nodeName == null || RuntimeContext.getInstance().getName().equals(this.nodeName))) {
            Object[] args = new Object[]{jarName};
            Object result = this.invoke("getArchiveURL", args, URL.class);
            HTTPFabricConnection.processServerAnswer(result, URL.class);
            return (URL)result;
        }
        throw new HTTPFabricException("Operation is not supported.");
    }

    @Override
    public List<URL> getArchiveURLs() throws HTTPFabricException {
        if (RuntimeState.isActive() && (this.nodeName == null || RuntimeContext.getInstance().getName().equals(this.nodeName))) {
            Object[] args = new Object[]{};
            Object result = this.invoke("getArchiveURLs", args, URL[].class);
            return this.objectsArrayToArrayList(result, URL.class);
        }
        throw new HTTPFabricException("Operation is not supported.");
    }

    @Override
    public List<String> listArchives() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("listArchives", args);
        return this.objectsArrayToArrayList(result, String.class);
    }

    @Override
    public void addExtensionArchive(File jar) throws HTTPFabricException {
        byte[] jarContent;
        try {
            jarContent = FileIOUtils.getFileContent(jar);
        }
        catch (Exception exception) {
            throw new HTTPFabricException("Failed to read jar file content.");
        }
        this.addExtensionArchive(jar.getName(), jarContent);
    }

    @Override
    public void addExtensionArchive(String jarName, byte[] jarContent) throws HTTPFabricException {
        Object[] args = new Object[]{jarName, jarContent};
        this.invoke("addExtensionArchive", args);
    }

    @Override
    public void removeExtensionArchive(String jarName, boolean force) throws HTTPFabricException {
        Object[] args = new Object[]{jarName, force};
        this.invoke("removeExtensionArchive", args);
    }

    @Override
    public boolean existsExtensionArchive(String jarName) throws HTTPFabricException {
        Object[] args = new Object[]{jarName};
        Object result = this.invoke("existsExtensionArchive", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public byte[] getExtensionArchive(String jarName) throws HTTPFabricException {
        Object[] args = new Object[]{jarName};
        Object result = this.invoke("getExtensionArchive", args);
        return HTTPFabricConnection.processServerByteArrayAnswer(result);
    }

    @Override
    public URL getExtensionArchiveURL(String jarName) throws HTTPFabricException {
        Object[] args = new Object[]{jarName};
        Object result = this.invoke("getExtensionArchiveURL", args);
        HTTPFabricConnection.processServerAnswer(result, URL.class);
        return (URL)result;
    }

    @Override
    public List<URL> getExtensionArchiveURLs() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("getExtensionArchiveURLs", args);
        return this.objectsArrayToArrayList(result, URL.class);
    }

    @Override
    public List<String> listExtensionArchives() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("listExtensionArchives", args);
        return this.objectsArrayToArrayList(result, String.class);
    }

    @Override
    public void saveTransportFactory(TransportFactory factory) throws HTTPFabricException {
        Object[] args = new Object[]{factory};
        this.invoke("saveTransportFactory", args);
    }

    @Override
    public TransportFactory loadTransportFactory(String factoryName, String factoryType) throws HTTPFabricException {
        Object[] args = new Object[]{factoryName, factoryType};
        Object result = this.invoke("loadTransportFactory", args);
        return HTTPFabricConnection.processServerAnswer(result, TransportFactory.class);
    }

    @Override
    public void removeTransportFactory(String factoryName, String factoryType) throws HTTPFabricException {
        Object[] args = new Object[]{factoryName, factoryType};
        this.invoke("removeTransportFactory", args);
    }

    @Override
    public boolean existsTransportFactory(String factoryName, String factoryType) throws HTTPFabricException {
        Object[] args = new Object[]{factoryName, factoryType};
        Object result = this.invoke("existsTransportFactory", args);
        return HTTPFabricConnection.processServerAnswer(result, Boolean.class);
    }

    @Override
    public List<String> listTransportFactoryNames() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("listTransportFactoryNames", args);
        return this.objectsArrayToArrayList(result, String.class);
    }

    @Override
    public List<String> listTransportFactoryTypes() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("listTransportFactoryTypes", args);
        return this.objectsArrayToArrayList(result, String.class);
    }

    @Override
    public List<String> listTransportFactoriesByType(String factoryType) throws HTTPFabricException {
        Object[] args = new Object[]{factoryType};
        Object result = this.invoke("listTransportFactoriesByType", args);
        return this.objectsArrayToArrayList(result, String.class);
    }

    @Override
    public void importTransportFactory(String directory, String factoryName, String factoryType) throws HTTPFabricException {
        Object[] args = new Object[]{directory, factoryName, factoryType};
        this.invoke("importTransportFactory", args);
    }

    @Override
    public void exportTransportFactory(String directory, String factoryName, String factoryType) throws HTTPFabricException {
        Object[] args = new Object[]{directory, factoryName, factoryType};
        this.invoke("exportTransportFactory", args);
    }

    @Override
    public void saveJDBCFactory(JDBCFactory factory) throws HTTPFabricException {
        Object[] args = new Object[]{factory};
        this.invoke("saveJDBCFactory", args);
    }

    @Override
    public JDBCFactory loadJDBCFactory(String factoryName, String factoryType) throws HTTPFabricException {
        Object[] args = new Object[]{factoryName, factoryType};
        Object result = this.invoke("loadJDBCFactory", args);
        return HTTPFabricConnection.processServerAnswer(result, JDBCFactory.class);
    }

    @Override
    public void removeJDBCFactory(String factoryName, String factoryType) throws HTTPFabricException {
        Object[] args = new Object[]{factoryName, factoryType};
        this.invoke("removeJDBCFactory", args);
    }

    @Override
    public boolean existsJDBCFactory(String factoryName, String factoryType) throws HTTPFabricException {
        Object[] args = new Object[]{factoryName, factoryType};
        Object result = this.invoke("existsJDBCFactory", args);
        return HTTPFabricConnection.processServerAnswer(result, Boolean.class);
    }

    @Override
    public List<String> listJDBCFactoryNames() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("listJDBCFactoryNames", args);
        return this.objectsArrayToArrayList(result, String.class);
    }

    @Override
    public List<String> listJDBCFactoryTypes() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("listJDBCFactoryTypes", args);
        return this.objectsArrayToArrayList(result, String.class);
    }

    @Override
    public List<String> listJDBCFactoriesByType(String factoryType) throws HTTPFabricException {
        Object[] args = new Object[]{factoryType};
        Object result = this.invoke("listJDBCFactoriesByType", args);
        return this.objectsArrayToArrayList(result, String.class);
    }

    @Override
    public void importJDBCFactory(String directory, String factoryName, String factoryType) throws HTTPFabricException {
        Object[] args = new Object[]{directory, factoryName, factoryType};
        this.invoke("importJDBCFactory", args);
    }

    @Override
    public void exportJDBCFactory(String directory, String factoryName, String factoryType) throws HTTPFabricException {
        Object[] args = new Object[]{directory, factoryName, factoryType};
        this.invoke("exportJDBCFactory", args);
    }

    @Override
    public void saveClientFactory(ClientFactory factory) throws HTTPFabricException {
        Object[] args = new Object[]{factory};
        this.invoke("saveClientFactory", args);
    }

    @Override
    public ClientFactory loadClientFactory(String factoryName, String factoryType) throws HTTPFabricException {
        Object[] args = new Object[]{factoryName, factoryType};
        Object result = this.invoke("loadClientFactory", args);
        return HTTPFabricConnection.processServerAnswer(result, ClientFactory.class);
    }

    @Override
    public void removeClientFactory(String factoryName, String factoryType) throws HTTPFabricException {
        Object[] args = new Object[]{factoryName, factoryType};
        this.invoke("removeClientFactory", args);
    }

    @Override
    public boolean existsClientFactory(String factoryName, String factoryType) throws HTTPFabricException {
        Object[] args = new Object[]{factoryName, factoryType};
        Object result = this.invoke("existsClientFactory", args);
        return HTTPFabricConnection.processServerAnswer(result, Boolean.class);
    }

    @Override
    public List<String> listClientFactoryNames() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("listClientFactoryNames", args);
        return this.objectsArrayToArrayList(result, String.class);
    }

    @Override
    public List<String> listClientFactoryTypes() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("listClientFactoryTypes", args);
        return this.objectsArrayToArrayList(result, String.class);
    }

    @Override
    public List<String> listClientFactoriesByType(String factoryType) throws HTTPFabricException {
        Object[] args = new Object[]{factoryType};
        Object result = this.invoke("listClientFactoriesByType", args);
        return this.objectsArrayToArrayList(result, String.class);
    }

    @Override
    public void importClientFactory(String directory, String factoryName, String factoryType) throws HTTPFabricException {
        Object[] args = new Object[]{directory, factoryName, factoryType};
        this.invoke("importClientFactory", args);
    }

    @Override
    public void exportClientFactory(String directory, String factoryName, String factoryType) throws HTTPFabricException {
        Object[] args = new Object[]{directory, factoryName, factoryType};
        this.invoke("exportClientFactory", args);
    }

    private <T> List<T> objectsArrayToArrayList(Object objects, Class<T> clazz) {
        Object[] array;
        HTTPFabricConnection.processServerAnswer(objects, Object[].class);
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object obj : array = (Object[])objects) {
            HTTPFabricConnection.processServerAnswer(obj, clazz);
            list.add(obj);
        }
        return list;
    }
}

